!
! $Id: $
!
SUBROUTINE phyredem (ngrid,filename,    &
                         phystep,pday,                    &
                         time,tsurf,tsoil,emis,q2,qsurf,      &
                         cloudfrac,totcloudfrac,hice)
!! creates the physics (re-)start file "restartfi.nc"
USE dimphy
USE mod_grid_phy_lmdz
USE mod_phys_lmdz_para
USE iophy
!      USE phys_state_var_mod ! not used in generic model (yet?!) field passed as input arguments
USE iostart, only : open_restartphy,close_restartphy, & 
                          put_var,put_field
USE infotrac, only: nqtot
USE comgeomphy,  only: rlatd,rlond,airephy
USE control_mod, only: raz_date
USE comsoil_h, only: mlayer,inertiedat,volcapa
USE surfdat_h, only: albedodat,phisfi,albedice,emisice,emissiv,iceradius,dtemisice, &
                     zmea,zstd,zsig,zgam,zthe
USE tracer_h, only: noms
implicit none

!======================================================================
#include "dimensions.h"
#include "netcdf.inc"
!!#include "dimsoil.h"
!!#include "clesphys.h"
!!#include "tabcontrol.h"
#include "temps.h"
#include "comcstfi.h"
#include "planete.h"
!======================================================================
integer,intent(in) :: ngrid
character(len=*),intent(in) :: filename
!real,intent(in) :: latfi(ngrid), lonfi(ngrid)
!integer,intent(in) :: nsoil,nq
real,intent(in) :: phystep,pday,time
real,intent(in) :: tsurf(ngrid)
real,intent(in) :: tsoil(ngrid,nsoil),emis(ngrid)
real,intent(in) :: q2(ngrid,klev+1),qsurf(ngrid,nqtot)
!real,intent(in) :: airefi(ngrid)
!real,intent(in) :: alb(ngrid),ith(ngrid,nsoil)
!real,intent(in) :: pzmea(ngrid),pzstd(ngrid)
!real,intent(in) :: pzsig(ngrid),pzgam(ngrid),pzthe(ngrid)
REAL,intent(in) :: hice(ngrid),cloudfrac(ngrid,klev)
REAL,intent(in) :: totcloudfrac(ngrid)
!character(len=*),intent(in) :: nametrac(nqtot)   ! name of the tracer

! local variables
integer :: iq
integer,parameter :: length=100
real :: tab_cntrl(length)

!
! open file
      CALL open_restartphy(filename)

! tab_cntrl() contains run parameters
      tab_cntrl(:)=0 ! initialization
!cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
! Fill control array tab_cntrl(:) with paramleters for this run
!cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
! Informations on the physics grid
      tab_cntrl(1) = float(klon_glo)  ! number of nodes on physics grid
      tab_cntrl(2) = float(klev) ! number of atmospheric layers
      tab_cntrl(3) = pday + int(time)         ! initial day 
      tab_cntrl(4) = time -int(time)            ! initiale time of day

! Informations about Mars, used by dynamics and physics
      tab_cntrl(5) = rad      ! radius of Mars (m) ~3397200
      tab_cntrl(6) = omeg     ! rotation rate (rad.s-1)
      tab_cntrl(7) = g        ! gravity (m.s-2) ~3.72
      tab_cntrl(8) = mugaz    ! Molar mass of the atmosphere (g.mol-1) ~43.49
      tab_cntrl(9) = rcp      !  = r/cp  ~0.256793 (=kappa dans dynamique)
      tab_cntrl(10) = daysec  ! length of a sol (s)  ~88775

      tab_cntrl(11) = phystep  ! time step in the physics
      tab_cntrl(12) = 0.
      tab_cntrl(13) = 0.

! Informations about Mars, only for physics
      tab_cntrl(14) = year_day  ! length of year (sols) ~668.6
      tab_cntrl(15) = periastr  ! min. star-planet distance (AU)
      tab_cntrl(16) = apoastr   ! max. star-planet distance (AU) 
      tab_cntrl(17) = peri_day  ! date of periastron (sols since N. spring)
      tab_cntrl(18) = obliquit  ! Obliquity of the planet (deg) ~23.98

! Boundary layer and turbulence
      tab_cntrl(19) = z0        ! surface roughness (m) ~0.01
      tab_cntrl(20) = lmixmin   ! mixing length ~100
      tab_cntrl(21) = emin_turb ! minimal energy ~1.e-8

! Optical properties of polar caps and ground emissivity
      tab_cntrl(22) = albedice(1)  ! Albedo of northern cap ~0.5
      tab_cntrl(23) = albedice(2)  ! Albedo of southern cap ~0.5
      tab_cntrl(24) = emisice(1)   ! Emissivity of northern cap ~0.95
      tab_cntrl(25) = emisice(2)   ! Emissivity of southern cap ~0.95
      tab_cntrl(26) = emissiv      ! Emissivity of martian soil ~.95
      tab_cntrl(31) = iceradius(1) ! mean scat radius of CO2 snow (north)
      tab_cntrl(32) = iceradius(2) ! mean scat radius of CO2 snow (south)
      tab_cntrl(33) = dtemisice(1) ! time scale for snow metamorphism (north)
      tab_cntrl(34) = dtemisice(2) ! time scale for snow metamorphism (south)

      tab_cntrl(28) = 0. 
      tab_cntrl(29) = 0.
      tab_cntrl(30) = 0.

! Soil properties:
      tab_cntrl(35) = volcapa ! soil volumetric heat capacity
      
      CALL put_var("controle","Control parameters",tab_cntrl)

! coordinates

      CALL put_var("soildepth","Soil mid-layer depth",mlayer)
      CALL put_field("longitude", &
                     "Longitudes of physics grid",rlond)
      CALL put_field("latitude","Latitudes of physics grid",rlatd)

! variables

      CALL put_field("area","Mesh area",airephy)
      CALL put_field("phisfi","Geopotential at the surface",phisfi)
      CALL put_field("albedodat","Albedo of bare ground",albedodat)

! F. Lott GW parametrizations
      CALL put_field("ZMEA","Relief: mean relief",zmea)
      CALL put_field("ZSTD","Relief: standard deviation",zstd)
      CALL put_field("ZSIG","Relief: sigma parameter",zsig)
      CALL put_field("ZGAM","Relief: gamma parameter",zgam)
      CALL put_field("ZTHE","Relief: theta parameter",zthe)

! Sub-surface variables
      CALL put_field("inertiedat","Soil thermal inertia",inertiedat)
      CALL put_field("tsurf","Surface temperature",tsurf)
      CALL put_field("tsoil","Soil temperature",tsoil)
      CALL put_field("emis","Surface emissivity",emis)

! PBL:
      CALL put_field("q2","pbl wind variance",q2)

! cloud fraction and sea ice (NB: these should be optional... to be improved)
      CALL put_field("cloudfrac","Cloud fraction",cloudfrac)
      CALL put_field("totcloudfrac","Total fraction",totcloudfrac)
      CALL put_field("hice","Height of oceanic ice",hice)

! tracers
      if (nqtot>0) then
        do iq=1,nqtot
          CALL put_field(noms(iq),"tracer on surface",qsurf(:,iq))
        enddo
      endif ! of if (nqtot>0)

! close file
      CALL close_restartphy
!$OMP BARRIER

      END SUBROUTINE phyredem
