# Registry file, EM
#                                               
# At the present time this file is managed manually and edited by hand.                                         
#                                               
################################################################################
# Dimension specifications
#
# This section of the Registry file is used to specify the dimensions
# that will be used to define arrays. Dim is the one-letter name of the
# dimension.  How defined can either be "standard_domain", which means
# that the dimension (1) is one of the three spatial dimensions and (2)
# it will be set using the standard namelist mechanism and domain data
# structure dimension fields (e.g. sd31,ed31,sd32...).
#
# Order refers to which of the three sets of just-mentioned internal
# dimension variables the dimension is referred to by in the driver.
# That is, is it the first, second, or third dimension.  The registry
# infers the mapping of its internal dimensions according to the
# combination of Order and Coord-axis that are specified in this table.
# Note that it is all right to more than one dimension name for, say, the
# x dimension.  However, the Order and Coord-axis relationship must be
# consistent throughout.
# 
# Note: these entries do not enforce storage order on a particular field.
# That is determined by the dimension strings for each field. But it does
# relate the dimspec to the internal data structures that the driver uses
# to maintain the three physical domain dimensions.
# 
# "How defined" can also specify the name of a namelist variable from which
# the definition for the dimension will come; this is specified as
# "namelist=<variable name>".  The namelist variable must have been
# defined as an integer and with only one entry in the rconfig table. Or
# a constant can be specified.  The coordinate axis for the dimension is
# either X, Y, Z, or C (for "not a spatial dimension").  The Dimname is
# the descriptive name of the dimension that will be included in the
# metadata in data sets.  Note that the b, f, and t modifiers that appear
# as the last characters of dimension strings used # in state and # i1
# registry definitions are not dimensions and do not need to be declared
# here.
#

# Available characters for dimspec: 0123456789@%+=|?.!&[{}]

#<Table>  <Dim>  <Order> <How defined>         <Coord-axis>  <Dimname in Datasets>
dimspec    i      1     standard_domain              x          west_east
dimspec    j      3     standard_domain              y          south_north
dimspec    k      2     standard_domain              z          bottom_top
dimspec    l      2     namelist=num_soil_layers     z          soil_layers
dimspec    u      2     namelist=num_land_cat        z          land_cat
dimspec    s      2     namelist=num_soil_cat        z          soil_cat
dimspec    p      -     constant=7501                c          microphysics_rstrt_state
dimspec    w      -     namelist=spec_bdy_width      c          spec_bdy_width
dimspec    e      3     namelist=ensdim              z          ensemble dimension
dimspec    n      1     namelist=dfi_time_dim        c          dfi time dimension
dimspec    z      -     namelist=max_obs          c          max_obs
dimspec    h      -     namelist=nobs_err_flds    c          nobs_err_flds
dimspec    r      -     namelist=nobs_ndg_vars    c          nobs_ndg_vars
dimspec    g      2     namelist=num_metgrid_levels  z          num_metgrid_levels
dimspec    m      2     constant=12                  z          months_per_year
dimspec    a      -     namelist=cam_abs_dim1     c          cam_abs_dim1
dimspec    c      -     namelist=cam_abs_dim2     z          cam_abs_dim2
dimspec    q      2     namelist=levsiz           z          levsiz
dimspec    d      2     namelist=paerlev          z          paerlev
dimspec    ?      -     namelist=ts_buf_size      c          ts_buf_size
dimspec    !      -     namelist=max_ts_locs      c          max_ts_locs
dimspec    v      -     constant=1                z          one


################################################################################
################################################################################
################################################################################


####MARS MARS MARS MARS MARS
####MARS MARS MARS MARS MARS
#### 
#### variables physiques ecrites dans les fichiers WRF
#### - h indique l'ecriture
#### - en commentaire, les variables physiques dans physiq.F
#### - utiliser le script automatique Registry.bash
####
#### YOU CAN OUTPUT ANY 2D OR 3D VARIABLE THAT IS AVAILABLE IN MESO_PHYSIQ.F
#### --- please indicate #SAVEMARS2 for 2D fields and #SAVEMARS3 for 3D fields
####
#### !!!! WARNING !!!! WARNING !!!! WARNING !!!! WARNING !!!! WARNING !!!!
####         THIS HAS TO BE CONSISTENT WITH $MMM/SRC/WRFV2/Registry/Registry.EM
#### !!!! WARNING !!!! WARNING !!!! WARNING !!!! WARNING !!!! WARNING !!!!
####
############ name in WRF !!!!! ############# name in NETCDF !!!! ############################################## name in meso_physiq !!!!!
state  real  TSURF     ij   misc  1  -  rhd  "TSURF"     "SURF TEMPERATURE"                "K"       #SAVEMARS2 tsurf
state  real  CO2ICE    ij   misc  1  -  rd   "CO2ICE"    "CO2 GROUND ICE"                  "kg"      #SAVEMARS2 co2ice
state  real  EMISSIV   ij   misc  1  -  rd   "EMISSIV"   "EMISSIVITY"                      ""        #SAVEMARS2 emis
state  real  THETA     ij   misc  1  -  rd   "THETA"     "SLOPE INCLINATION"               "deg"     #SAVEMARS2 theta_sl
state  real  PSI       ij   misc  1  -  rd   "PSI"       "SLOPE ORIENTATION"               "deg"     #SAVEMARS2 psi_sl
state  real  TAU_DUST  ij   misc  1  -  rd   "TAU_DUST"  "REFERENCE VISIBLE DUST OPACITY"  ""        #SAVEMARS2 tauref
state  real  SWDOWNZ   ij   misc  1  -  rhd  "SWDOWNZ"   "DOWNWARD SW FLUX AT SURFACE"     "W m-2"   #SAVEMARS2 fluxsurf_sw_tot      
state  real  LWDOWNZ   ij   misc  1  -  rhd  "LWDOWNZ"   "DOWNWARD LW FLUX AT SURFACE"     "W m-2"   #SAVEMARS2 fluxsurf_lw
state  real  SWUP      ij   misc  1  -  rd   "SWUP"      "UPWARD SW FLUX AT TOP"           "W m-2"   #SAVEMARS2 fluxtop_sw_tot    
state  real  LWUP      ij   misc  1  -  rd   "LWUP"      "UPWARD LW FLUX AT TOP"           "W m-2"   #SAVEMARS2 fluxtop_lw
state  real  MTOT      ij   misc  1  -  rd   "MTOT"      "TOTAL MASS WATER VAPOR"          "kg m-2"  #SAVEMARS2 mtot
state  real  ICETOT    ij   misc  1  -  rd   "ICETOT"    "TOTAL MASS WATER ICE"            "kg m-2"  #SAVEMARS2 icetot
state  real  RAVE      ij   misc  1  -  rd   "RAVE"      "MEAN ICE RADIUS"                 "m"       #SAVEMARS2 rave
state  real  RICE      ikj  misc  1  -  rd   "RICE"      "ICE RADIUS"                      "m"       #SAVEMARS3 rice
####
####
####MARS MARS MARS MARS MARS
####MARS MARS MARS MARS MARS

####MARS MARS MARS MARS MARS
####MARS MARS MARS MARS MARS
####
####
#### TRACEURS: POUR L'INSTANT NE PAS CHANGER L'ORDRE (>> mais l'ordre n'est-il pas defini plus bas ? dans les options mars ?)
#### - effacer le h si l'on veut eviter les sorties
####
state  real  -         ikjftb  scalar  1  -  -                         -
state  real  QH2O      ikjftb  scalar  1  -  i01rhusdf=(bdy_interp:dt) "QH2O"       "Water vapor mixing ratio"   "kg kg-1"
state  real  QH2O_ICE  ikjftb  scalar  1  -  i01rhusdf=(bdy_interp:dt) "QH2O_ICE"   "Water ice mixing ratio"     "kg kg-1"
state  real  QDUST     ikjftb  scalar  1  -  i01rhusdf=(bdy_interp:dt) "QDUST"      "Dust mixing ratio"          "kg kg-1"
####
####
####MARS MARS MARS MARS MARS
####MARS MARS MARS MARS MARS







#state    real   floob       ikjb     dyn_em      1         -    
#state    real   floob_x     ikjx     dyn_em      1         -     
#state    real   floob_y     ikjy     dyn_em      1         - 
#xpose FLOOB dyn_em floob,floob_x,floob_y

#state real xxx ijk misc 2 - h6ud
#halo  HALO_FLOOB dyn_em  4:xxx_2

# Lines that start with the word 'state' form a table that is                                           
# used by the script use_registry to generate module_state_descript.F                                           
# and other files.  Also see documentation in use_registry.                                             
#                                               
# table entries are of the form                                         
#<Table> <Type> <Sym>         <Dims>   <Use>   <NumTLev> <Stagger> <IO>     <DNAME>             <DESCRIP>     <UNITS>   
#

# It is required that LU_INDEX appears before any variable that is
# interpolated with a mask, as lu_index supplies that mask.
# this next 1 is for the HFSoLE/PET demo; writing these to auxhist1 output over MCEL for coupling
# with wave model, only if compiled with -DMCELIO, JM 2003/05/29
state    real  LU_INDEX         ij      misc        1         -     i02r01d=(interp_fcnm)u=(copy_fcnm)   "LU_INDEX"              "LAND USE CATEGORY"         ""
state    real  LU_MASK          ij      misc        1         -     i3h1     "LU_MASK"              "0 land 1 water"         ""

# znw, znu, dzs, and zs must be listed before any 3-d fields
# in order for the grib output module to work correctly.  The grib output
# module retrieves the vertical levels from these parameters.  If znw, znu
# dzs, and zs are not listed first, vertical level will not be encoded at 
# time 0.

state    real    znu            k       dyn_em      1         -     irh       "znu"  "eta values on half (mass) levels"  ""
state    real    znw            k       dyn_em      1         Z     i01rh     "znw"  "eta values on full (w) levels"  ""
state    real   ZS              l        misc      -         Z     ir       "ZS"                    "DEPTHS OF CENTERS OF SOIL LAYERS"         "m"
state    real   DZS             l        misc      -         Z     ir       "DZS"                   "THICKNESSES OF SOIL LAYERS"               "m"

#
# Variables from WPS
#
state    real   u_gc           igj      dyn_em      1        XZ    i1  "UU"     "x-wind component"    "m s-1"
state    real   v_gc           igj      dyn_em      1        YZ    i1  "VV"     "y-wind component"    "m s-1"
state    real   t_gc           igj      dyn_em      1        Z     i1  "TT"     "temperature"         "K"
state    real   rh_gc          igj      dyn_em      1        Z     i1  "RH"    "relative humidity"   "%"
state    real   ght_gc         igj      dyn_em      1        Z     i1  "GHT"   "geopotential height" "m"
state    real   p_gc           igj      dyn_em      1        Z     i1  "PRES"   "pressure"            "Pa"
state    real   xlat_gc        ij       dyn_em      1        -     i1  "XLAT_M" "latitude, positive north" "degrees"
state    real   xlong_gc       ij       dyn_em      1        -     i1  "XLONG_M" "longitude, positive east" "degrees"
state    real   ht_gc          ij       dyn_em      1        -     i1  "HGT_M" "topography elevation" "m"
state    real   tsk_gc         ij       dyn_em      1        -     i1  "SKINTEMP"  "skin temperature"  "K"
state    real   tavgsfc        ij       dyn_em      1        -     i1  "TAVGSFC"  "daily mean of surface air temperature"  "K"
state    real   tmn_gc         ij       dyn_em      1        -     i1  "SOILTEMP"  "annual mean deep soil temperature"  "K"
state    real   pslv_gc        ij       dyn_em      1        -     i1  "PMSL"  "sea level pressure"  "Pa"
state    real   greenfrac      imj      dyn_em      1        Z     i1  "GREENFRAC" "monthly greenness fraction" "0 - 1 fraction"
state    real   albedo12m      imj      dyn_em      1        Z     i1  "ALBEDO12M" "background albedo" "0 - 1 fraction"
state    real   pd_gc          igj      dyn_em      1        Z     -   "PD"    "dry pressure"        "Pa"
state    real   psfc_gc        ij       dyn_em      1        -      -  "PSFC_GC"     "surface pressure"            "Pa"
state    real   intq_gc        ij       dyn_em      1        -     -   "INTQ"  "integrated mixing ratio" "Pa"
state    real   pdhs           ij       dyn_em      1        -     -   "PDHS"  "hydrostatic dry surface pressure" "Pa"
state    real   qv_gc          igj      dyn_em      1        Z     i1  "QV"     "mixing ratio"        "kg kg-1"
ifdef RUC_CLOUD
state    real   qr_gc          igj      dyn_em      1        Z     i1  "QR"    "rain water mixing ratio"   "kg kg-1"
state    real   qc_gc          igj      dyn_em      1        Z     i1  "QC"    "cloud water mixing ratio"   "kg kg-1"
state    real   qs_gc          igj      dyn_em      1        Z     i1  "QS"    "snow mixing ratio"   "kg kg-1"
state    real   qi_gc          igj      dyn_em      1        Z     i1  "QI"    "cloud ice mixing ratio"   "kg kg-1"
state    real   qg_gc          igj      dyn_em      1        Z     i1  "QG"    "graupel mixing ratio"   "kg kg-1"
state    real   qni_gc         igj      dyn_em      1        Z     i1  "QNI"   "ice no concentration"   "m-3"
endif

####MARS MARS MARS MARS MARS
####MARS MARS MARS MARS MARS     
####
#### INITIALISATION
####
#### variables dans real
####
state  real   albedo_gcm_gc   ij   dyn_em  1  -  i1  "ALBEDO_GCM"       "albedo of naked ground"  "0 - 1 fraction"
state  real   therm_inert_gc  ij   dyn_em  1  -  i1  "THERMAL_INERTIA"  "thermal inertia"         "J/m2/K/s0.5"
state  real   slpx_gc         ij   dyn_em  1  -  i1  "SLPX"             "slope x direction"       "rad"
state  real   slpy_gc         ij   dyn_em  1  -  i1  "SLPY"             "slope y direction"       "rad"
state  real   hv_gc          igj   dyn_em  1  Z  i1  "HV"               "water vapor"             "kg/kg" 
state  real   hi_gc          igj   dyn_em  1  Z  i1  "HI"               "water ice"               "kg/kg"
state  real   tsoil_gc       igj   dyn_em  1  Z  i1  "TSOIL"            "soil temperatures"       "K"
state  real   isoil_gc       igj   dyn_em  1  Z  i1  "ISOIL"            "soil thermal inertia"    "tiu"
state  real   dsoil_gc       igj   dyn_em  1  Z  i1  "DSOIL"            "soil depths"             "m"
####
#### variables dans wrf
####
state  real   albedo_gcm      ij   misc  1  -  i012rd  "MARS_ALB"    "albedo of naked ground"  "0 - 1 fraction"
state  real   therm_inert     ij   misc  1  -  i012rd  "MARS_TI"     "thermal inertia"         "J/m2/K/s0.5"
state  real   slpx            ij   misc  1  -  i012rd  "SLOPEX"      "slope x direction"       "rad"
state  real   slpy            ij   misc  1  -  i012rd  "SLOPEY"      "slope y direction"       "rad"
state  real   mars_emiss      ij   misc  1  -  i012rd  "MARS_EMISS"  "emissivity"              "0 - 1 fraction"
state  real   mars_cice       ij   misc  1  -  i012rd  "MARS_CICE"   "co2 ice"                 "kg"
state  real   mars_wice       ij   misc  1  -  i012rd  "MARS_WICE"   "h2o ice"                 "kg/m2"
state  real   mars_tsoil     ilj   misc  1  -  i012rd  "MARS_TSOIL"  "soil temperatures"       "K"
state  real   mars_isoil     ilj   misc  1  -  i012rd  "MARS_ISOIL"  "soil thermal inertia"    "tiu"
state  real   mars_dsoil     ilj   misc  1  -  i012rd  "MARS_DSOIL"  "soil depths"             "m"
state  real   mars_gw        ilj   misc  1  -  i012rd  "MARS_GW"     "gwparam"                 " "
####
####
####MARS MARS MARS MARS MARS
####MARS MARS MARS MARS MARS



#-----------------------------------------------------------------------------------------------------------------------------------------------------------------
#                                               
# Variables for Eulerian mass coordinate dynamics                                            
#                                               

# Velocities
#
# U Vel
state    real   u              ikjb     dyn_em      2         X     \
     i01rhusdf=(bdy_interp:dt)       "U"                      "x-wind component"   "m s-1"
state    real   ru             ikj     dyn_em      1         X      -        "MU_U"        "mu-coupled u"   "Pa m s-1"
state    real   ru_m           ikj     dyn_em      1         X      -        "ru_m"        ""   ""
state    real   ru_tend        ikj     dyn_em      1         X      -        "ru_tend"        ""   ""                                   
i1       real   ru_tendf       ikj     dyn_em      1         X                                          
state    real   u_save         ikj     dyn_em      1         X      -        "u_save"
#                                               
# V Vel
state    real   v              ikjb     dyn_em      2         Y     \
     i01rhusdf=(bdy_interp:dt)        "V"                     "y-wind component"   "m s-1"
state    real   rv             ikj     dyn_em      1         Y      -        "MU_V"        "mu-coupled v"   "Pa m s-1"
state    real   rv_m           ikj     dyn_em      1         Y      -        "rv_m"
state    real   rv_tend        ikj     dyn_em      1         Y      -        "rv_tend"
i1       real   rv_tendf       ikj     dyn_em      1         Y                                          
state    real   v_save         ikj     dyn_em      1         Y      -        "v_save"                   
#                                               
# Vertical Vel                                          
state    real   w              ikjb     dyn_em      2         Z     \
        irhusdf=(bdy_interp:dt)  "w"                          "z-wind component"   "m s-1"
state    real   ww             ikj     dyn_em      1         Z      r         "ww"   "mu-coupled eta-dot"    "Pa s-1"
state    real   rw             ikj     dyn_em      1         Z      -         "rw"   "mu-coupled w"          "Pa m s-1"
i1       real   ww1            ikj     dyn_em      1         Z                                          
state    real   ww_m           ikj     dyn_em      1         Z      r         "ww_m"   "time-avg mu-coupled eta-dot"    "Pa s-1"
i1       real   wwp            ikj     dyn_em      1         Z                                          
i1       real   rw_tend        ikj     dyn_em      1         Z                                          
i1       real   rw_tendf       ikj     dyn_em      1         Z                                          
i1       real   w_save         ikj     dyn_em      1         Z                                          

# Geopotential
state    real   ph             ikjb     dyn_em      2         Z     \
       irusdf=(bdy_interp:dt)   "ph"   "perturbation geopotential"  "m2 s-2"
state    real   phb            ikj     dyn_em      1         Z     irdus  "phb"  "base-state geopotential"  "m2 s-2"
state    real   phb_fine       ikj     dyn_em      1         Z      -     "phb_fine"  "for nesting, temp holding interpolated coarse grid phb"  "m2 s-2"
state    real   ph0            ikj     dyn_em      1         Z      r     "ph0"  "initial geopotential"     "m2 s-2"
state    real   php            ikj     dyn_em      1         Z      r     "php"  "geopotential"             "m2 s-2"
i1       real   ph_tend        ikj     dyn_em      1         Z 
i1       real   ph_tendf       ikj     dyn_em      1         Z 
i1       real   ph_save        ikj     dyn_em      1         Z 
##
## MARS: TO GET LIGHTER HISTORY FILES
##
state    real   phtot          ikj     dyn_em      1         Z     irh       "PHTOT"        "total geopotential"      "m2 s-2"

# Potential Temperature
state    real   t              ikjb     dyn_em      2         -     \
       i01rhusdf=(bdy_interp:dt)   "t"      "perturbation potential temperature (theta-t0)" "K"

state    real   t_init         ikj     dyn_em      1         -      ir       "t_init" "initial potential temperature" "K"
i1       real   t_tend         ikj     dyn_em      1         -  
i1       real   t_tendf        ikj     dyn_em      1         -  
state    real   tp             ikj     dyn_em      2         -  
i1       real   t_2save        ikj     dyn_em      1         -   
state    real   t_save         ikj     dyn_em      1         -               "t_save"
#                                               


# Mass
state    real   mu              ijb     dyn_em      2         -     \
     irusdf=(bdy_interp:dt)   "mu"  "perturbation dry air mass in column" "Pa"
state    real   mub             ij     dyn_em      1         -     irdus        "mub" "base state dry air mass in column" "Pa"
state    real   mub_fine        ij     dyn_em      1         -      -           "mub_fine" "nest temp, holds interpolated coarse grid mub" "Pa"
state    real   mub_save        ij     dyn_em      1         -      -           "mub_save" "nest temp, holds orig fine grid mub" "Pa"
state    real   mu0             ij     dyn_em      1         -     i01rdu       "mu0" "initial dry mass in column" "Pa"
state    real   mudf            ij     dyn_em      1         -      -           "mudf" "" ""
state    real   muu             ij     dyn_em      1          -                 "muu"
i1       real   muus            ij     dyn_em      1          -     
state    real   muv             ij     dyn_em      1          -                 "muv"
i1       real   muvs            ij     dyn_em      1          -     
state    real   mut             ij     dyn_em      1          -                 "mut"
state    real   muts            ij     dyn_em      1          -                 "muts"
i1       real   muave           ij     dyn_em      1          -     
i1       real   mu_save         ij     dyn_em      1          -     
i1       real   mu_tend         ij     dyn_em      1          -     
i1       real   mu_tendf        ij     dyn_em      1          -     

#diagnostic for looking at nest position in output. A mungy version of terrain height.
state    real   nest_pos        ij     misc        1   -   ru=(mark_domain)  "NEST_POS"
state    real   nest_mask       ij     misc        1   -   ru=(mark_domain)   "NEST_MASK"     "LOCATION OF NEST IF ANY"
state    real   ht_coarse       ij     misc        1   -     r                -              "STORAGE FOR LOW-RES TERRAIN"


# TKE
state    real   tke            ikj     dyn_em      2         -       r        "tke"          "TURBULENCE KINETIC ENERGY"     "m2 s-2"
i1       real   tke_tend       ikj     dyn_em      1         -      

# Pressure and Density
state    real   p              ikj     dyn_em      1         -      r         "p"           "perturbation pressure"         "Pa"
state    real   al             ikj     dyn_em      1         -      r         "al"          "inverse perturbation density"  "m3 kg-1"
state    real   alt            ikj     dyn_em      1         -      r         "alt"         "inverse density"               "m3 kg-1"
state    real   alb            ikj     dyn_em      1         -      rdus      "alb"         "inverse base density"          "m3 kg-1"
state    real   zx             ikj     dyn_em      1         X      -         " "  " "  " "    
state    real   zy             ikj     dyn_em      1         Y      -         " "  " "  " "   
state    real   rdz            ikj     dyn_em      1         Z      -         " "  " "  " "   
state    real   rdzw           ikj     dyn_em      1         Z       -        " "  " "  " "   
state    real   pb             ikj     dyn_em      1         -      rdus      "pb"          "BASE STATE PRESSURE "          "Pa"
##
## MARS: TO GET LIGHTER HISTORY FILES
##
state    real   ptot           ikj     dyn_em      1         -      irh       "PTOT"        "total pressure"      "Pa"
####### if you choose h here, you will probably want not to output u,v,w,t,etc...
state    real   uave           ikj     dyn_em      1         -      ir       "UAVE"        "average zonal wind"  "m/s"
state    real   ustd           ikj     dyn_em      1         -      ir       "USTD"        "std dev zonal wind"  "m/s"
state    real   vave           ikj     dyn_em      1         -      ir       "VAVE"        "average meridional wind"  "m/s"
state    real   vstd           ikj     dyn_em      1         -      ir       "VSTD"        "std dev meridional wind"  "m/s"
state    real   wave           ikj     dyn_em      1         -      ir       "WAVE"        "average vertical wind"  "m/s"
state    real   wstd           ikj     dyn_em      1         -      ir       "WSTD"        "std dev vertical wind"  "m/s"
state    real   tave           ikj     dyn_em      1         -      ir       "TAVE"        "average pert. potential temperature"  "K"
state    real   tstd           ikj     dyn_em      1         -      ir       "TSTD"        "std dev pert. potential temperature"  "K"
#######
## ajouter tk, ptot, phtot ??? les deux derniers sont assez smooth...

#                                               
# Other dyn                                             
#                                               
i1       real   advect_tend    ikj     dyn_em      1         -                                          
i1       real   alpha          ikj     dyn_em      1         -                                                  
i1       real   a              ikj     dyn_em      1         -                                                  
i1       real   gamma          ikj     dyn_em      1         -                                                  
i1       real   c2a            ikj     dyn_em      1         -     -
i1       real   rho            ikj     dyn_em      1         -     -
i1       real   phm            ikj     dyn_em      1         -     -
i1       real   cqu            ikj     dyn_em      1         -     -
i1       real   cqv            ikj     dyn_em      1         -     -
i1       real   cqw            ikj     dyn_em      1         -     -
i1       real   pm1            ikj     dyn_em      1         -     -
state    real   sr             ij      dyn_em      1         -      ir         "sr" "fraction of frozen precipitation"
state    real   potevp         ij      dyn_em      1         -       r         "potevp" "accumulated potential evaporation" "W m-2"
state    real   snopcx         ij      dyn_em      1         -       r         "snopcx" "snow phase change heat flux" "W m-2"
state    real   soiltb         ij      dyn_em      1         -       -         "soiltb" "bottom soil temperature" "K"
state    real    fnm            k       dyn_em      1         -     ir       "fnm"  "upper weight for vertical stretching"  ""
state    real    fnp            k       dyn_em      1         -     ir       "fnp"  "lower weight for vertical stretching"  ""
state    real    rdnw           k       dyn_em      1         -     ir       "rdnw"  "inverse d(eta) values between full (w) levels"   ""
state    real    rdn            k       dyn_em      1         -     ir       "rdn"  "inverse d(eta) values between half (mass) levels"   ""
state    real    dnw            k       dyn_em      1         -     ir       "dnw" "d(eta) values between full (w) levels"   ""
state    real    dn             k       dyn_em      1         -     ir       "dn " "d(eta) values between half (mass) levels"   ""
state    real    t_base         k       dyn_em      1         -     ir        "t_base"               "BASE STATE T IN IDEALIZED CASES"         "K"      
state    real    z              ikj     dyn_em      1         -     -         " " " " " "
i1       real    mu_3d          ikj     dyn_em      1         -                                          
i1       real    z_at_w         ikj     dyn_em      1         Z 
state    real    cfn            -       misc      -         -     ir       "cfn"    "extrapolation constant"  ""
state    real    cfn1           -       misc      -         -     ir       "cfn1"   "extrapolation constant"  ""
state    integer step_number    -       misc      -         -     ir        "step_number"  ""

# 2m and 10m output diagnostics
state    real   Q2               ij     misc        1         -     ird      "Q2"                   "QV at 2 M"         "kg kg-1"
state    real   T2               ij     misc        1         -     ird      "T2"                   "TEMP at 2 M"       "K"
state    real   TH2              ij     misc        1         -     ird      "TH2"                  "POT TEMP at 2 M"   "K"
state    real   PSFC             ij     misc        1         -     i01rhd    "PSFC"                 "SFC PRESSURE"      "Pa"

# these next 2 are for the HFSoLE/PET demo; writing these to auxhist1 output over MCEL for coupling
# with wave model, only if compiled with -DMCELIO, JM 2003/05/29
state    real   U10              ij     misc        1         -     ir01d      "U10"                "U at 10 M"         "m s-1"
state    real   V10              ij     misc        1         -     ir01d      "V10"                "V at 10 M"         "m s-1"

# these next 4 are for observational nudging
state    real   uratx           ij      misc        1         -      r          "URATX"            "Ratio of U over U10 on mass points "         "dimensionless"
state    real   vratx           ij      misc        1         -      r          "VRATX"            "Ratio of V over V10 on mass points "         "dimensionless"   
state    real   tratx           ij      misc        1         -      r          "TRATX"            "Ratio of T over TH2 on mass points "         "dimensionless"   
state    real   obs_savwt      hikj     dyn_em      1         X      -       "OBS_SAVWT"

# Other
state   real    rdx            -        misc      -         -     ir       "rdx"                   "INVERSE X GRID LENGTH"         ""      
state   real    rdy            -        misc      -         -     ir       "rdy"                   "INVERSE Y GRID LENGTH"         ""      
state   real    dts            -        misc      -         -     ir        "dts"                   "SMALL TIMESTEP"         ""      
state   real    dtseps         -        misc      -         -     ir        "dtseps"                "TIME WEIGHT CONSTANT FOR SMALL STEPS"         ""      
state   real    resm           -        misc      -         -     ir       "resm"                  "TIME WEIGHT CONSTANT FOR SMALL STEPS"         ""      
state   real    zetatop        -        misc      -         -     ir       "zetatop"               "ZETA AT MODEL TOP"         ""      
state   real    cf1            -        misc      -         -     ir       "cf1"                   "2nd order extrapolation constant"         ""      
state   real    cf2            -        misc      -         -     ir       "cf2"                   "2nd order extrapolation constant"         ""      
state   real    cf3            -        misc      -         -     ir       "cf3"                   "2nd order extrapolation constant"         ""      
state   integer number_at_same_level    -        -          -         -     -        "number_at_same_level"  ""         ""      

# State for derived time quantities.  
state   integer itimestep      -        -          -         -     r         "itimestep"             ""         ""      
state   real    xtime          -        -          -         -     r         "xtime"                 "minutes since simulation start"         ""      
state   real    julian         -        -          -         -     -          "julian"                "day of year, 0.0 at 0Z on 1 Jan."         "days"      


# input file descriptor for lbcs on parent domain                                               
state   integer lbc_fid        -        -          -         -     -         "lbc_fid"               ""         ""      
# indicates if tiling has been computed                                         
state   logical tiled          -        -          -         -     -         "tiled"                 ""         ""      
# indicates if patches have been computed                                               
state   logical patched        -        -          -         -     -         "patched"               ""         ""      
# indicates whether to read input from file or generate                                         
#state   logical input_from_file        -        -          -         -     -         "input_from_file"         ""         ""    
# indicates whether to recompute mu                                                             
state   logical press_adj      -        -          -         -     -         "press_adj"         "T/F flag adjust mu"         ""    

# Mask for moving nest interpolations
state    integer imask_nostag         ij      misc     1     -
state    integer imask_xstag          ij      misc     1     X
state    integer imask_ystag          ij      misc     1     Y
state    integer imask_xystag         ij      misc     1     XY 
# vortex center indices; need for restarts of moving nests
state    real    xi                   -       misc     -     -    r
state    real    xj                   -       misc     -     -    r
state    real    vc_i                 -       misc     -     -    r
state    real    vc_j                 -       misc     -     -    r

#-----------------------------------------------------------------------------------------------------------------------------------------------------------------
# Scalar (4D) arrays

# Moist Scalars
#                                               
# The first line ensures that there will be identifiers named moist and                                         
# moist_tend even if there are not any moist scalars (so the essentially                                                
# dry code will will still link properly)                                               
#                                               
state   real    -              ikjftb   moist       1         -     -    -
state   real    qv             ikjftb   moist       1         -     \
   i01rusdf=(bdy_interp:dt)  "QVAPOR"           "Water vapor mixing ratio"      "kg kg-1"
state   real    qc             ikjftb   moist       1         -     \
   i01rusdf=(bdy_interp:dt)  "QCLOUD"           "Cloud water mixing ratio"      "kg kg-1"
state   real    qr             ikjftb   moist       1         -     \
   i01rusdf=(bdy_interp:dt)  "QRAIN"            "Rain water mixing ratio"       "kg kg-1"
state   real    qi             ikjftb   moist       1         -     \
   i01rusdf=(bdy_interp:dt)  "QICE"             "Ice mixing ratio"              "kg kg-1"
state   real    qs             ikjftb   moist       1         -     \
   i01rusdf=(bdy_interp:dt)  "QSNOW"            "Snow mixing ratio"             "kg kg-1"
state   real    qg             ikjftb   moist       1         -     \
   i01rusdf=(bdy_interp:dt)  "QGRAUP"           "Graupel mixing ratio"          "kg kg-1"
state   real    -              ikjftb   dfi_moist       1         -     -    -
state   real    dfi_qv         ikjftb   dfi_moist       1         -     \
   rusdf=(bdy_interp:dt)  "DFI_QVAPOR"       "Water vapor mixing ratio"      "kg kg-1"
state   real    dfi_qc         ikjftb   dfi_moist       1         -     \
   rusdf=(bdy_interp:dt)  "DFI_QCLOUD"       "Cloud water mixing ratio"      "kg kg-1"
state   real    dfi_qr         ikjftb   dfi_moist       1         -     \
   rusdf=(bdy_interp:dt)  "DFI_QRAIN"        "Rain water mixing ratio"       "kg kg-1"
state   real    dfi_qi         ikjftb   dfi_moist       1         -     \
   rusdf=(bdy_interp:dt)  "DFI_QICE"         "Ice mixing ratio"              "kg kg-1"
state   real    dfi_qs         ikjftb   dfi_moist       1         -     \
   rusdf=(bdy_interp:dt)  "DFI_QSNOW"        "Snow mixing ratio"             "kg kg-1"
state   real    dfi_qg         ikjftb   dfi_moist       1         -     \
   rusdf=(bdy_interp:dt)  "DFI_QGRAUP"       "Graupel mixing ratio"          "kg kg-1"


# Chem Scalars
state   real    -              ikjftb   chem        1         -     -    -                                       

# Other Scalars
state   real    -              ikjftb  scalar      1         -     -   -
state   real    qndrop         ikjftb  scalar      1         -     \
   i01rusdf=(bdy_interp:dt)    "QNDROP"        "Droplet number mixing ratio"        "# kg-1"
state   real    qni            ikjftb  scalar      1         -     \
   i01rusdf=(bdy_interp:dt)    "QNICE"         "Ice Number concentration" "# kg-1"
state   real    qt             ikjftb  scalar      1         -     \
   i01rusdf=(bdy_interp:dt)    "CWM"           "Total condensate mixing ratio"      "kg kg-1"
state   real    qns            ikjftb  scalar      1         -     \
   i01rusdf=(bdy_interp:dt)    "QNSNOW"         "Snow Number concentration"   "# kg(-1)"
state   real    qnr            ikjftb  scalar      1         -     \
   i01rusdf=(bdy_interp:dt)    "QNRAIN"        "Rain Number concentration"   "# kg(-1)"
state   real    qng            ikjftb  scalar      1         -     \
   i01rusdf=(bdy_interp:dt)    "QNGRAUPEL"     "Graupel Number concentration" "# kg(-1)"
state   real    -              ikjftb  dfi_scalar      1         -     -   -
state   real    dfi_qndrop     ikjftb  dfi_scalar      1         -     \
   rusdf=(bdy_interp:dt)    "DFI_QNDROP"    "Droplet number mixing ratio"        "# kg-1"
state   real    dfi_qni        ikjftb  dfi_scalar      1         -     \
   rusdf=(bdy_interp:dt)    "DFI_QNICE"     "Ice Number concentration" "# kg-1"
state   real    dfi_qt         ikjftb  dfi_scalar      1         -     \
   rusdf=(bdy_interp:dt)    "DFI_CWM"       "Total condensate mixing ratio"      "kg kg-1"
state   real    dfi_qns        ikjftb  dfi_scalar      1         -     \
   rusdf=(bdy_interp:dt)    "DFI_QNSNOW"    "Snow Number concentration"   "# kg(-1)"
state   real    dfi_qnr        ikjftb  dfi_scalar      1         -     \
   rusdf=(bdy_interp:dt)    "DFI_QNRAIN"    "Rain Number concentration"   "# kg(-1)"
state   real    dfi_qng        ikjftb  dfi_scalar      1         -     \
   rusdf=(bdy_interp:dt)    "DFI_QNGRAUPEL" "Graupel Number concentration" "# kg(-1)"

#-----------------------------------------------------------------------------------------------------------------------------------------------------------------

# Arrays for Specified LBCs  (lbc arrays REMOVED; Boundary arrays are now specified with the state array; see above, 20050413 JM )

state    real   fcx            w         misc     -         -      ir       "fcx"                  "RELAXATION TERM FOR BOUNDARY ZONE"         ""
state    real   gcx            w         misc     -         -      ir       "gcx"                  "2ND RELAXATION TERM FOR BOUNDARY ZONE"         ""
state    real   dtbc            -        misc     -         -      ir       "dtbc"                 "TIME SINCE BOUNDARY READ"         ""

#-------------------------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------------
# Physics Related State Varibles

#-------------------------------------------------------------------------------------------------------------------------------------------
# SI - start variables from netCDF format from Standard Initialization, most eventually for use in LSM schemes
#-------------------------------------------------------------------------------------------------------------------------------------------

state   real   sm000007            ij    misc          1     -     i1      "SM000007"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   sm007028            ij    misc          1     -     i1      "SM007028"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   sm028100            ij    misc          1     -     i1      "SM028100"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   sm100255            ij    misc          1     -     i1      "SM100255"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   st000007            ij    misc          1     -     i1      "ST000007"      "LAYER SOIL TEMPERATURE" "K"
state   real   st007028            ij    misc          1     -     i1      "ST007028"      "LAYER SOIL TEMPERATURE" "K"
state   real   st028100            ij    misc          1     -     i1      "ST028100"      "LAYER SOIL TEMPERATURE" "K"
state   real   st100255            ij    misc          1     -     i1      "ST100255"      "LAYER SOIL TEMPERATURE" "K"
state   real   sm000010            ij    misc          1     -     i1      "SM000010"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   sm010040            ij    misc          1     -     i1      "SM010040 "     "LAYER SOIL MOISTURE" "m3 m-3"
state   real   sm040100            ij    misc          1     -     i1      "SM040100 "     "LAYER SOIL MOISTURE" "m3 m-3"
state   real   sm100200            ij    misc          1     -     i1      "SM100200 "     "LAYER SOIL MOISTURE" "m3 m-3"
state   real   sm010200            ij    misc          1     -     i1      "SM010200"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   soilm000            ij    misc          1     -     i1      "SOILM000"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   soilm005            ij    misc          1     -     i1      "SOILM005"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   soilm020            ij    misc          1     -     i1      "SOILM020"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   soilm040            ij    misc          1     -     i1      "SOILM040"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   soilm160            ij    misc          1     -     i1      "SOILM160"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   soilm300            ij    misc          1     -     i1      "SOILM300"      "LAYER SOIL MOISTURE" "m3 m-3"
state   real   sw000010            ij    misc          1     -     i1      "SW000010"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   sw010040            ij    misc          1     -     i1      "SW010040"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   sw040100            ij    misc          1     -     i1      "SW040100"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   sw100200            ij    misc          1     -     i1      "SW100200"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   sw010200            ij    misc          1     -     i1      "SW010200"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   soilw000            ij    misc          1     -     i1      "SOILW000"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   soilw005            ij    misc          1     -     i1      "SOILW005"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   soilw020            ij    misc          1     -     i1      "SOILW020"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   soilw040            ij    misc          1     -     i1      "SOILW040"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   soilw160            ij    misc          1     -     i1      "SOILW160"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   soilw300            ij    misc          1     -     i1      "SOILW300"      "LAYER SOIL LIQUID" "m3 m-3"
state   real   st000010            ij    misc          1     -     i1      "ST000010"      "LAYER SOIL TEMPERATURE" "K"
state   real   st010040            ij    misc          1     -     i1      "ST010040"      "LAYER SOIL TEMPERATURE" "K"
state   real   st040100            ij    misc          1     -     i1      "ST040100"      "LAYER SOIL TEMPERATURE" "K"
state   real   st100200            ij    misc          1     -     i1      "ST100200"      "LAYER SOIL TEMPERATURE" "K"
state   real   st010200            ij    misc          1     -     i1      "ST010200"      "LAYER SOIL TEMPERATURE" "K"
state   real   soilt000            ij    misc          1     -     i1      "SOILT000"      "LAYER SOIL TEMPERATURE" "K"
state   real   soilt005            ij    misc          1     -     i1      "SOILT005"      "LAYER SOIL TEMPERATURE" "K"
state   real   soilt020            ij    misc          1     -     i1      "SOILT020"      "LAYER SOIL TEMPERATURE" "K"
state   real   soilt040            ij    misc          1     -     i1      "SOILT040"      "LAYER SOIL TEMPERATURE" "K"
state   real   soilt160            ij    misc          1     -     i1      "SOILT160"      "LAYER SOIL TEMPERATURE" "K"
state   real   soilt300            ij    misc          1     -     i1      "SOILT300"      "LAYER SOIL TEMPERATURE" "K"
state   real   landmask            ij    misc          1     -     i012rd=(interp_fcnm)u=(copy_fcnm)   "LANDMASK"      "LAND MASK (1 FOR LAND, 0 FOR WATER)"  ""
state   real   topostdv            ij    misc          1     -     i12     "TOPOSTDV"      "ELEVATION STD DEV"  "m"
state   real   toposlpx            ij    misc          1     -     i12     "TOPOSLPX"      "ELEVATION X SLOPE"  ""
state   real   toposlpy            ij    misc          1     -     i12     "TOPOSLPY"      "ELEVATION Y SLOPE"  ""
state   real   shdmax              ij    misc          1     -     i012r   "SHDMAX"        "ANNUAL MAX VEG FRACTION" ""
state   real   shdmin              ij    misc          1     -     i012r   "SHDMIN"        "ANNUAL MIN VEG FRACTION" ""
state   real   snoalb              ij    misc          1     -     i012r   "SNOALB"        "ANNUAL MAX SNOW ALBEDO IN FRACTION" ""
state   real   slopecat            ij    misc          1     -     i12     "SLOPECAT"      "SLOPE CATEGORY"  ""
state   real   toposoil            ij    misc          1     -     i12     "SOILHGT"       "ELEVATION OF LSM DATA"  "m"
state   real   landusef            iuj   misc          1     Z     i012r   "LANDUSEF"      "LANDUSE FRACTION BY CATEGORY"  ""
state   real   soilctop            isj   misc          1     Z     i012    "SOILCTOP"      "SOIL CAT FRACTION (TOP)"  ""
state   real   soilcbot            isj   misc          1     Z     i012    "SOILCBOT"      "SOIL CAT FRACTION (BOTTOM)"  ""
state   real   soilcat             ij    misc          1     -     i12     "SOILCAT"       "SOIL CAT DOMINANT TYPE" ""
state   real   vegcat              ij    misc          1     -     i12     "VEGCAT"        "VEGETATION CAT DOMINANT TYPE" ""

#---------------------------------------------------------------------------------------------------------------------------------------
# SI - end variables from netCDF format from Standard Initialization
#---------------------------------------------------------------------------------------------------------------------------------------

# soil model variables  (Note that they are marked as staggered in the vertical dimension
# because they are "fully dimensioned" -- they use every element in that dim
state    real   TSLB           ilj       misc      1         Z     i02rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)           "TSLB"     "SOIL TEMPERATURE"   "K"

# Time series variables
state    real   ts_hour         ?!       misc      -         -      r        "TS_HOUR"        "Model integration time, hours"
state    real   ts_u            ?!       misc      -         -      r        "TS_U"           "Surface wind U-component, earth-relative"
state    real   ts_v            ?!       misc      -         -      r        "TS_V"           "Surface wind V-component, earth-relative"
state    real   ts_q            ?!       misc      -         -      r        "TS_Q"           "Surface mixing ratio"
state    real   ts_t            ?!       misc      -         -      r        "TS_T"           "Surface temperature"
state    real   ts_psfc         ?!       misc      -         -      r        "TS_PSFC"        "Surface pressure"
state    real   ts_glw          ?!       misc      -         -      r        "TS_GLW"         "Downward long wave flux at surface"
state    real   ts_gsw          ?!       misc      -         -      r        "TS_GSW"         "Net short wave flux at surface"
state    real   ts_hfx          ?!       misc      -         -      r        "TS_HFX"         "Upward heat flux at surface"
state    real   ts_lh           ?!       misc      -         -      r        "TS_LH"          "Upward moisture flux at surface"
state    real   ts_tsk          ?!       misc      -         -      r        "TS_TSK"         "Skin temperature"
state    real   ts_tslb         ?!       misc      -         -      r        "TS_TSLB"        "Soil temperature"
state    real   ts_clw          ?!       misc      -         -      r        "TS_CLW"         "Column integrated cloud water"
state    real   ts_rainc        ?!       misc      -         -      r        "TS_RAINC"       "Cumulus precip"
state    real   ts_rainnc       ?!       misc      -         -      r        "TS_RAINNC"      "Grid-scale precip"

# urban model variables
state    real   DZR             l        em      -            Z     r        "DZR"            "THICKNESSES OF ROOF LAYERS"                      "m"
state    real   DZB             l        em      -            Z     r        "DZB"            "THICKNESSES OF WALL LAYERS"                      "m"
state    real   DZG             l        em      -            Z     r        "DZG"            "THICKNESSES OF ROAD LAYERS"                      "m"

# lsm State Variables

state    real   SMOIS            ilj     -          1         Z     i02rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)    "SMOIS"            "SOIL MOISTURE"     "m3 m-3"
state    real   SH2O             ilj     -          1         Z     i02rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)    "SH2O"             "SOIL LIQUID WATER" "m3 m-3"
state    real   XICE             ij     misc        1         -     i0124rd=(interp_mask_water_field:lu_index)u=(copy_fcnm)  "SEAICE"             "SEA ICE FLAG"  ""
state    real   XICEM            ij     misc        1         -     rd=(interp_mask_water_field:lu_index)u=(copy_fcnm)  "XICEM"             "SEA ICE FLAG (PREVIOUS STEP)"  ""
state    real   SMSTAV           ij     misc        1         -      rd=(interp_mask_land_field:lu_index)       "SMSTAV"           "MOISTURE AVAILABILITY" ""
state    real   SMSTOT           ij     misc        1         -      r                                          "SMSTOT"           "TOTAL SOIL MOISTURE" "m3 m-3"

state    real   SFCRUNOFF        ij     misc        1         -      rd=(interp_mask_land_field:lu_index)      "SFROFF"           "SURFACE RUNOFF"     "mm"
state    real   UDRUNOFF         ij     misc        1         -      rd=(interp_mask_land_field:lu_index)      "UDROFF"           "UNDERGROUND RUNOFF" "mm"
state  integer  IVGTYP           ij     misc        1         -     i02rd=(interp_fcni)u=(copy_fcni)            "IVGTYP"           "DOMINANT VEGETATION CATEGORY" ""
state  integer  ISLTYP           ij     misc        1         -     i02rd=(interp_fcni)u=(copy_fcni)            "ISLTYP"           "DOMINANT SOIL CATEGORY"       ""
state    real   VEGFRA           ij     misc        1         -     i0124rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)   "VEGFRA"           "VEGETATION FRACTION" ""
state    real   SFCEVP           ij     misc        1         -      r                                          "SFCEVP"           "SURFACE EVAPORATION" "kg m-2"
state    real   GRDFLX           ij     misc        1         -      r                                          "GRDFLX"           "GROUND HEAT FLUX" "W m-2"
state    real   SFCEXC           ij     misc        1         -      r                                          "SFCEXC "          "SURFACE EXCHANGE COEFFICIENT"   "m s-1"

state    real   ACSNOW           ij     misc        1         -      rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)       "ACSNOW"           "ACCUMULATED SNOW"         "kg m-2"
state    real   ACSNOM           ij     misc        1         -      rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)       "ACSNOM"           "ACCUMULATED MELTED SNOW"  "kg m-2"
state    real   SNOW             ij     misc        1         -     i012rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)    "SNOW"             "SNOW WATER EQUIVALENT"    "kg m-2"
state    real   SNOWH            ij     misc        1         -     i012rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)    "SNOWH"            "PHYSICAL SNOW DEPTH"      "m"
state    real   RHOSN            ij     misc        1         -     i012rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)    "RHOSN"            " SNOW DENSITY"      "kg m-3" 
state    real   CANWAT           ij     misc        1         -     i012rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)    "CANWAT"           "CANOPY WATER"             "kg m-2"
state    real   SST              ij     misc        1         -     i0124rd=(interp_mask_water_field:lu_index)   "SST"              "SEA SURFACE TEMPERATURE" "K"
state  integer  IFNDSNOWH        -      misc        1         -     i         "FNDSNOWH" "SNOWH_LOGICAL"
state  integer  IFNDSOILW        -      misc        1         -     i         "FNDSOILW" "SOILW_LOGICAL"

# DFI variables
state   real   hcoeff           n    misc        1         -     -    "HCOEFF"               "initialization weights"
state   real   hcoeff_tot       -    misc        1         -     -    "HCOEFF_TOT"               "initialization weights"
state   real   dfi_p           ikj   misc        1         -     r    "P_DFI"           "perturbation pressure"         "Pa"
state   real   dfi_al          ikj   misc        1         -     r    "AL_DFI"          "inverse perturbation density"  "m3 kg-1"
state   real   dfi_mu          ij    misc        1         -     r    "MU_DFI"  "perturbation dry air mass in column" "Pa"
state   real   dfi_phb         ikj   misc        1         Z     r    "PHB_DFI"  "base-state geopotential"  "m2 s-2"
state   real   dfi_ph0         ikj   misc        1         Z     r    "PH0_DFI"  "initial geopotential"     "m2 s-2"
state   real   dfi_php         ikj   misc        1         Z     r    "PHP_DFI"  "geopotential"             "m2 s-2"
state   real   dfi_u           ikj   misc        1         -     r    "U_DFI"               "u accumulation array"          "   "
state   real   dfi_v           ikj   misc        1         -     r    "V_DFI"               "v accumulation array"          "   "
state   real   dfi_w           ikj   misc        1         -     r    "W_DFI"               "w accumulation array"          "   "
state   real   dfi_ww          ikj   misc        1         Z     r    "WW_DFI"              "mu-coupled eta-dot"    "Pa s-1"
state   real   dfi_t           ikj   misc        1         -     r    "TT_DFI"               "t accumulation array"          "   "
state   real   dfi_ph          ikj   misc        1         -     r    "PH_DFI"               "p accumulation array"          "   "
state   real   dfi_pb          ikj   misc        1         -     r    "PB_DFI"               "pb accumulation array"          "   "
state   real   dfi_alt         ikj   misc        1         -     r    "ALT_DFI"             "1/rho accumulation array"          "   "
state   real   dfi_tke         ikj   misc        1         -     r    "TKE_DFI"          "TURBULENCE KINETIC ENERGY"     "m2 s-2"

state    real  dfi_TSLB        ilj   misc        1         Z     r    "TSLB_dfi"         "SOIL TEMPERATURE"   "K"
state    real  dfi_SMOIS       ilj    -          1         Z     r    "SMOIS_dfi"        "SOIL MOISTURE"     "m3 m-3"
state    real  dfi_SNOW        ij    misc        1         -     r    "SNOW_dfi"         "SNOW WATER EQUIVALENT"    "kg m-2"
state    real  dfi_SNOWH       ij    misc        1         -     r    "SNOWH_dfi"        "PHYSICAL SNOW DEPTH"      "m"
state    real  dfi_CANWAT      ij    misc        1         -     r    "CANWAT_dfi"       "CANOPY WATER"             "kg m-2"
state    real  dfi_SMFR3D      ilj   misc        1         Z     r    "SMFR3D_dfi"           "SOIL ICE" ""
state    real  dfi_KEEPFR3DFLAG ilj  misc        1         Z     r    "KEEPFR3DFLAG_dfi"     "FLAG - 1. FROZEN SOIL YES, 0 - NO"             ""

# urban state variables
state    real   TR_URB2D         ij     misc        1         -     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)     "TR_URB"              "URBAN ROOF SKIN TEMPERATURE"        "K"
state    real   TB_URB2D         ij     misc        1         -     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)     "TB_URB"              "URBAN WALL SKIN TEMPERATURE"        "K" 
state    real   TG_URB2D         ij     misc        1         -     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)     "TG_URB"              "URBAN ROAD SKIN TEMPERATURE"        "K" 
state    real   TC_URB2D         ij     misc        1         -     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)     "TC_URB"              "URBAN CANOPY TEMPERATURE"           "K"
state    real   QC_URB2D         ij     misc        1         -     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)     "QC_URB"              "URBAN CANOPY HUMIDITY"          "kg kg{-1}"
state    real   UC_URB2D         ij     misc        1         -     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)     "UC_URB"              "URBAN CANOPY WIND"          "m s{-1}"
state    real   XXXR_URB2D       ij     misc        1         -     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)      "XXXR_URB" "M-O LENGTH ABOVE URBAN ROOF"   "dimensionless"
state    real   XXXB_URB2D       ij    misc        1         -      rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)      "XXXB_URB" "M-O LENGTH ABOVE URBAN WALL"   "dimensionless"
state    real   XXXG_URB2D       ij    misc        1         -      rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)       "XXXG_URB" "M-O LENGTH ABOVE URBAN ROAD"   "dimensionless"
state    real   XXXC_URB2D       ij    misc        1         -      rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)       "XXXC_URB" "M-O LENGTH ABOVE URBAN CANOPY" "dimensionless"
state    real   TRL_URB3D        ilj    misc        1         Z     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)      "TRL_URB" "ROOF LAYER TEMPERATURE"          "K"
state    real   TBL_URB3D        ilj    misc        1         Z     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)      "TBL_URB" "WALL LAYER TEMPERATURE"          "K"
state    real   TGL_URB3D        ilj    misc        1         Z     rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)      "TGL_URB" "ROAD LAYER TEMPERATURE"          "K"
state    real   SH_URB2D        ij    misc        1         -     r       "SH_URB"  "SENSIBLE HEAT FLUX FROM URBAN SFC"  "W m{-2}"
state    real   LH_URB2D        ij    misc        1         -     r       "LH_URB"  "LATENT HEAT FLUX FROM URBAN SFC"    "W m{-2}"
state    real   G_URB2D         ij    misc        1         -     r        "G_URB"  "GROUND HEAT FLUX INTO URBAN"        "W m{-2}"
state    real   RN_URB2D        ij    misc        1         -     r       "RN_URB"  "NET RADIATION ON URBAN SFC"         "W m{-2}"
state    real   TS_URB2D        ij    misc        1         -     r       "TS_URB"  "SKIN TEMPERATURE"          "K"
state    real   FRC_URB2D       ij    misc        1         -     rd=(interp_fcnm)u=(copy_fcnm)       "FRC_URB"  "URBAN FRACTION"         "dimensionless"
state    integer   UTYPE_URB2D  ij    misc        1         -     rd=(interp_fcnm)u=(copy_fcnm)       "UTYPE_URB"  "URBAN TYPE"         "dimensionless"


# urban variables from radiation model
state    real   COSZ_URB2D       ij     misc        1         -      r       "COSZ_URB"  "COS of SOLAR ZENITH ANGLE"         "dimensionless"
state    real   OMG_URB2D        ij     misc        1         -      r       "OMG_URB"   "SOLAR HOUR ANGLE"         "dimensionless"
state    real   DECLIN_URB       -     misc        1         -       r       "DECLIN_URB"  "SOLAR DECLINATION"         "dimensionless"


# RUC LSM
state    real   SMFR3D           ilj    misc        1         Z      r        "SMFR3D"               "SOIL ICE" ""
state    real   KEEPFR3DFLAG     ilj    misc        1         Z      r        "KEEPFR3DFLAG"          "FLAG - 1. FROZEN SOIL YES, 0 - NO"             ""

# Additional for P-X PBL and LSM
state    real   RA               ij     misc        1         -      r        "RA"           "AERODYNAMIC RESISTANCE"   "s m-1"
state    real   RS               ij     misc        1         -      r        "RS"           "SURFACE RESISTANCE"       "s m-1"
state    real   LAI              ij     misc        1         -      r        "LAI"          "Leaf area index"          "area/area"
state    real   VEGF_PX          ij     misc        1         -      r        "VEGF_PX"      "Vegetation Fraction for PX LSM"    "area/area"
state    real   T2OBS            ij     misc        1         -      r        "T2OBS"        "2-m temperature from analysis "          "K"
state    real   Q2OBS            ij     misc        1         -      r        "Q2OBS"        "2-m mixing ratio from analysis "         "kg/kg"

# MRF PBL variables
i1      real   PSIM           ij     misc        1         -     -         "PSIM"                "SIMILARITY FUNCTION FOR MOMENTUM"     ""
i1      real   PSIH           ij     misc        1         -     -         "PSIH"                "SIMILARITY FUNCTION FOR HEAT"         ""
i1      real   WSPD           ij     misc        1         -     -         "WSPD"                "Wind speed"                           "m s-1"
i1      real   GZ1OZ0         ij     misc        1         -     -         "GZ1OZ0"              "LOG OF Z1 over Z0"                     ""
i1      real   BR             ij     misc        1         -     -         "BR"                  "Bulk Richardson"                       ""

# MYJ PBL variables
state    real   tke_myj        ikj     misc        1         -      r        "tke_myj"               "TKE FROM MELLOR-YAMADA-JANJIC"      "m2 s-2"
state    real   EL_MYJ          ikj     misc        1         -     -        "el_myj"                "MIXING LENGTH FROM MELLOR-YAMADA-JANJIC"     "m"
state    real   EXCH_H          ikj     misc        1         -     r          "EXCH_H"               "EXCHANGE COEFFICIENTS "
state    real  CT              ij      misc        1         -      r        "CT"                    "COUNTERGRADIENT TERM"    "K"
state   real   THZ0             ij     misc        1         -      r        "THZ0"                  "POTENTIAL TEMPERATURE AT ZNT"                 "K"
state    real  Z0               ij     misc        1         -      r        "Z0"                    "Background ROUGHNESS LENGTH"                  "m"
state   real   QZ0              ij     misc        1         -      r        "QZ0"                   "SPECIFIC HUMIDITY AT ZNT"                     "kg kg-1"
state   real   UZ0              ij     misc        1         -      r        "UZ0"                   "U WIND COMPONENT AT ZNT"                      "m s-1"
state   real   VZ0              ij     misc        1         -      r        "VZ0"                   "V WIND COMPONENT AT ZNT"                      "m s-1"
state   real   QSFC             ij     misc        1         -      r        "QSFC"                  "SPECIFIC HUMIDITY AT LOWER BOUNDARY"          "kg kg-1"
state   real   AKHS             ij     misc        1         -      r        "AKHS"                  "SFC EXCH COEFF FOR HEAT"                      "m s-1"    
state   real   AKMS             ij     misc        1         -      r        "AKMS"                  "SFC EXCH COEFF FOR MOMENTUM"                  "m s-1"    
state   integer KPBL            ij     misc        1         -     r         "KPBL"                  "LEVEL OF PBL TOP"                             ""
state   real   TSHLTR           ij     misc        1         -     ir        "TSHLTR"                "SHELTER THETA FROM MYJ"                       "K"
state   real   QSHLTR           ij     misc        1         -     ir        "QSHLTR"                "SHELTER SPECIFIC HUMIDITY FROM MYJ"           "kg kg-1"
state   real   PSHLTR           ij     misc        1         -     ir        "PSHLTR"                "SHELTER PRESSURE FROM MYJ"           "Pa"
state   real   TH10             ij     misc        1         -     ir        "TH10"                  "10-M THETA FROM MYJ"                          "K"
state   real   Q10              ij     misc        1         -     ir        "Q10"                   "10-M SPECIFIC HUMIDITY FROM MYJ"              "kg kg-1"
i1      real   CHKLOWQ          ij     misc        1         -     -         "CHKLOWQ"               "SURFACE SATURATION FLAG"        ""

# gfdl (eta) radiation State Variables
state    real    HTOP            ij     misc        1         -      r        "HTOP"                 "TOP OF CONVECTION LEVEL"         ""
state    real    HBOT            ij     misc        1         -      r        "HBOT"                 "BOT OF CONVECTION LEVEL"         ""
state    real    HTOPR           ij     misc        1         -      r        "HTOPR"                "TOP OF CONVECTION LEVEL FOR RADIATION"    ""
state    real    HBOTR           ij     misc        1         -      r        "HBOTR"                "BOT OF CONVECTION LEVEL FOR RADIATION"    ""
state    real    CUTOP           ij     misc        1         -      r        "CUTOP"                "TOP OF CONVECTION LEVEL FROM CUMULUS PAR"    ""
state    real    CUBOT           ij     misc        1         -      r        "CUBOT"                "BOT OF CONVECTION LEVEL FROM CUMULUS PAR"    ""
state    REAL      CUPPT         ij     misc        1         -      r        "CUPPT"                "ACCUMULATED CONVECTIVE RAIN SINC LAST CALL TO THE RADIATION"         ""
state  real   rswtoa    ij    misc        1    -    i
state  real   rlwtoa    ij    misc        1    -    i
state  real   czmean    ij    misc      1    -     i
state  real   cfracl    ij    misc      1    -     i
state  real   cfracm    ij    misc      1    -     i
state  real   cfrach    ij    misc      1    -     i
state  real   acfrst    ij    misc        1    -    i
state integer ncfrst    ij    misc        1    -    i
state  real   acfrcv    ij    misc        1    -    i
state integer ncfrcv    ij    misc        1    -    i

# cam radiation variables
state  real    -       iqjf ozmixm      1    -   -     -
state  real   mth01    iqjf ozmixm      1    -   -     -
state  real   mth02    iqjf ozmixm      1    -   -     -
state  real   mth03    iqjf ozmixm      1    -   -     -
state  real   mth04    iqjf ozmixm      1    -   -     -
state  real   mth05    iqjf ozmixm      1    -   -     -
state  real   mth06    iqjf ozmixm      1    -   -     -
state  real   mth07    iqjf ozmixm      1    -   -     -
state  real   mth08    iqjf ozmixm      1    -   -     -
state  real   mth09    iqjf ozmixm      1    -   -     -
state  real   mth10    iqjf ozmixm      1    -   -     -
state  real   mth11    iqjf ozmixm      1    -   -     -
state  real   mth12    iqjf ozmixm      1    -   -     -
state  real   pin       q     misc      1    -   -      "PIN"             "PRESSURE LEVEL OF OZONE MIXING RATIO"  "millibar"
state  real   m_ps       ij   misc      2    -   -      "m_ps"            "PS from MATCH on WRF grids"
state  real    -       idjf aerosolc    2    -   -       -
state  real   SUL      idjf aerosolc    2    -   -     "SUL"        "SUL aerosol concentration"
state  real   SSLT     idjf aerosolc    2    -   -     "SSLT"        "SSLT aerosol concentration"
state  real   DUST1    idjf aerosolc    2    -   -     "DUST1"        "DUST1 aerosol concentration"
state  real   DUST2    idjf aerosolc    2    -   -     "DUST2"        "DUST2 aerosol concentration"
state  real   DUST3    idjf aerosolc    2    -   -     "DUST3"        "DUST3 aerosol concentration"
state  real   DUST4    idjf aerosolc    2    -   -     "DUST4"        "DUST4 aerosol concentration"
state  real   OCPHO    idjf aerosolc    2    -   -     "OCPHO"        "OCPHO aerosol concentration"
state  real   BCPHO    idjf aerosolc    2    -   -     "BCPHO"        "BCPHO aerosol concentration"
state  real   OCPHI    idjf aerosolc    2    -   -     "OCPHI"        "OCPHI aerosol concentration"
state  real   BCPHI    idjf aerosolc    2    -   -     "BCPHI"        "BCPHI aerosol concentration"
state  real   BG       idjf aerosolc    2    -   -     "BG"        "BG aerosol concentration"
state  real   VOLC     idjf aerosolc    2    -   -     "VOLC"        "VOLC aerosol concentration"
state  real   m_hybi    d     misc      1    -   -     "m_hybi"         "MATCH hybi"

# new eta microphpysics State Variables
state    real    F_ICE_PHY       ikj    misc        1         -      rdu      "F_ICE_PHY"            "FRACTION OF ICE"         ""
state    real    F_RAIN_PHY      ikj    misc        1         -      rdu      "F_RAIN_PHY"           "FRACTION OF RAIN "         ""
state    real    F_RIMEF_PHY     ikj    misc        1         -      rdu      "F_RIMEF_PHY"          "MASS RATIO OF RIMED ICE "         ""
state    real    qndropsource    ikj    misc        1         -      -        "qndropsource"         "Droplet number source"   "#/kg/s"

# Other Misc State Variables                                            
state   real    h_diabatic     ikj     misc         1         -      rdu      "h_diabatic"            "PREVIOUS TIMESTEP CONDENSATIONAL HEATING"         "K s-1"      
state   real    msft           ij      misc         1         -     i012rdu=(copy_fcnm)    "MAPFAC_M"         "Map scale factor on mass grid" ""
state   real    msfu           ij      misc         1         X     i012rdu=(copy_fcnm)    "MAPFAC_U"         "Map scale factor on u-grid" ""
state   real    msfv           ij      misc         1         Y     i012rdu=(copy_fcnm)    "MAPFAC_V"         "Map scale factor on v-grid" ""
state   real    msftx          ij      misc         1         -     i012rdu=(copy_fcnm)    "MAPFAC_MX"         "Map scale factor on mass grid, x direction" ""
state   real    msfty          ij      misc         1         -     i012rdu=(copy_fcnm)    "MAPFAC_MY"         "Map scale factor on mass grid, y direction" ""
state   real    msfux          ij      misc         1         X     i012rdu=(copy_fcnm)    "MAPFAC_UX"         "Map scale factor on u-grid, x direction" ""
state   real    msfuy          ij      misc         1         X     i012rdu=(copy_fcnm)    "MAPFAC_UY"         "Map scale factor on u-grid, y direction" ""
state   real    msfvx          ij      misc         1         Y     i012rdu=(copy_fcnm)    "MAPFAC_VX"         "Map scale factor on v-grid, x direction" ""
state   real    msfvx_inv      ij      misc         1         Y     i012rdu=(copy_fcnm)    "MF_VX_INV"         "Inverse map scale factor on v-grid, x direction" ""
state   real    msfvy          ij      misc         1         Y     i012rdu=(copy_fcnm)    "MAPFAC_VY"         "Map scale factor on v-grid, y direction" ""

state   real    f              ij      misc         1         -     i012rdu=(copy_fcnm)    "f"                "Coriolis sine latitude term"  "s-1"
state   real    e              ij      misc         1         -     i012rdu=(copy_fcnm)    "e"                "Coriolis cosine latitude term"  "s-1"
state   real    sina           ij      misc         1         -     i012rdu=(copy_fcnm)    "SINALPHA"         "Local sine of map rotation"   ""
state   real    cosa           ij      misc         1         -     i012rdu=(copy_fcnm)    "COSALPHA"         "Local cosine of map rotation"  ""
state   real    ht             ij      misc         1         -     i012rdus  "HGT"              "Terrain Height"   "m"
state   real    ht_fine        ij      misc         1         -     -          "HGT_FINE"         "Fine Terrain Height"   "m"
state   real    ht_int         ij      misc         1         -     -          "HGT_INT"          "Terrain Height Horizontally Interpolated"   "m"
state   real    ht_input       ij      misc         1         -     -          "HGT_INPUT"        "Terrain Height from FG Input File"   "m"
state   real    ht_shad        ijb     misc         1         -     df=(bdy_interp:dt)         "HGT_SHAD"        "Height of orographic shadow"   "m"
i1      real    ht_loc         ij      misc         1         -     - 
i1      integer  shadowmask    ij      misc         1         -     - 
state   integer min_ptchsz     -       misc         1         -     r

state   real    TSK            ij      misc         1         -     i012rdu=(copy_fcnm)    "TSK"                   "SURFACE SKIN TEMPERATURE"                  "K"
state   real    dfi_TSK        ij      misc         1         -     r                       "TSK_dfi"               "saved SURFACE SKIN TEMPERATURE"
state   real    TSK_SAVE       ij      misc         1         -     -         "TSK_SAVE" "SURFACE SKIN TEMPERATURE, EXTRA COPY FOR SEA ICE TESTS in REAL"       "K"
state   real    u_base         k       misc         1         -     ir        "u_base"                "BASE STATE X WIND IN IDEALIZED CASES"         ""      
state   real    v_base         k       misc         1         -     ir        "v_base"                "BASE STATE Y WIND IN IDEALIZED CASES"         ""      
state   real    qv_base        k       misc         1         -     ir        "qv_base"               "BASE STATE QV IN IDEALIZED CASES"         ""      
state   real    z_base         k       misc         1         -     ir        "z_base"                "BASE STATE HEIGHT IN IDEALIZED CASES"         ""      
state   real    u_frame        -       misc         1         -     ir        "u_frame"               "FRAME X WIND"         "m s-1"      
state   real    v_frame        -       misc         1         -     ir        "v_frame"               "FRAME Y WIND"         "m s-1"      
# p_top appears as metadata between SI and real but as a state variable in real and WRF
# since it is a scalar and a constant, it makes sense to have it as metadata -- there
# are, however, probably post-processing programs that expect to see it as an I/O record
# another problem: share/input_wrf tries to read this as metadata (fine for real reading
# SI, but with model reading real output, it generates a warning when debug is > 0 in
# namelist and causes repeated questions from users.  A third problem is the potential
# collision between a metadata name and a field record in the I/O data
# resolve this how?  Have the real program throw a switch to tell the code to get it
# from the metadata?  Otherwise it's a field?
state   real    p_top          -       misc         -         -     ir       "p_top"                 "PRESSURE TOP OF THE MODEL"  "Pa"
state   real    max_msftx      -       misc         -         -      r       "max_mstfx"             "Max map factor in domain"  ""
state   real    max_msfty      -       misc         -         -      r       "max_mstfy"             "Max map factor in domain"  ""
                                                
# Other physics variables
                                                
state    real  RTHCUTEN        ikj      misc        1         -      r        "RTHCUTEN"              "COUPLED THETA TENDENCY DUE TO CUMULUS SCHEME"     "Pa K s-1"
state    real  RQVCUTEN        ikj      misc        1         -      r        "RQVCUTEN"              "COUPLED Q_V TENDENCY DUE TO CUMULUS SCHEME"       "Pa kg kg-1 s-1"
state    real  RQRCUTEN        ikj      misc        1         -      r        "RQRCUTEN"              "COUPLED Q_R TENDENCY DUE TO CUMULUS SCHEME"       "Pa kg kg-1 s-1"
state    real  RQCCUTEN        ikj      misc        1         -      r        "RQCCUTEN"              "COUPLED Q_C TENDENCY DUE TO CUMULUS SCHEME"       "Pa kg kg-1 s-1"
state    real  RQSCUTEN        ikj      misc        1         -      r        "RQSCUTEN"              "COUPLED Q_S TENDENCY DUE TO CUMULUS SCHEME"       "Pa kg kg-1 s-1"
state    real  RQICUTEN        ikj      misc        1         -      r        "RQICUTEN"              "COUPLED Q_I TENDENCY DUE TO CUMULUS SCHEME"       "Pa kg kg-1 s-1"
state    real  W0AVG           ikj      misc        1         -      r        "W0AVG"                 "AVERAGE VERTICAL VELOCITY FOR KF CUMULUS SCHEME"         "m s-1"
                                                
state    real  RAINC            ij      misc        1         -      rdu     "RAINC"                 "ACCUMULATED TOTAL CUMULUS PRECIPITATION"                 "mm"      
state    real  RAINNC           ij      misc        1         -      rdu     "RAINNC"                "ACCUMULATED TOTAL GRID SCALE PRECIPITATION"              "mm"      
state    real  PRATEC           ij      misc        1         -      r       "PRATEC"                "PRECIP RATE FROM CUMULUS SCHEME"                         "mm s-1"
state    real  RAINCV           ij      misc        1         -      r       "RAINCV"                "TIME-STEP CUMULUS PRECIPITATION"                         "mm"      
state    real  RAINNCV          ij      misc        1         -      r        "RAINNCV"               "TIME-STEP NONCONVECTIVE PRECIPITATION"                   "mm"
state    real  RAINBL           ij      misc        1         -      r        "RAINBL"                "PBL TIME-STEP TOTAL PRECIPITATION"                       "mm"      
state    real  SNOWNC           ij      misc        1         -      rdu     "SNOWNC"                "ACCUMULATED TOTAL GRID SCALE SNOW AND ICE"               "mm"
state    real  GRAUPELNC        ij      misc        1         -      rdu     "GRAUPELNC"             "ACCUMULATED TOTAL GRID SCALE GRAUPEL"                    "mm"
state    real  SNOWNCV          ij      misc        1         -      r        "SNOWNCV"               "TIME-STEP NONCONVECTIVE SNOW AND ICE"                    "mm"
state    real  GRAUPELNCV       ij      misc        1         -      r        "GRAUPELNCV"            "TIME-STEP NONCONVECTIVE GRAUPEL"                      "mm"
state    real  NCA              ij      misc        1         -      r        "NCA"                   "COUNTER OF THE CLOUD RELAXATION TIME IN KF CUMULUS SCHEME"    ""      
state    integer  LOWLYR        ij      misc        1         -     -         "LOWLYR"                "INDEX OF LOWEST MODEL LAYER ABOVE THE GROUND IN BMJ SCHEME"   ""      
state    real  MASS_FLUX        ij      misc        1         -      r        "MASS_FLUX"             "DOWNDRAFT MASS FLUX FOR IN GRELL CUMULUS SCHEME"  "mb hour-1"
state    real  apr_gr           ij      misc        1         -      r       "APR_GR"                "PRECIP FROM CLOSURE OLD_GRELL"   "mm hour-1"
state    real  apr_w            ij      misc        1         -      r       "APR_W"                 "PRECIP FROM CLOSURE W"           "mm hour-1"
state    real  apr_mc           ij      misc        1         -      r       "APR_MC"                "PRECIP FROM CLOSURE KRISH MV"    "mm hour-1"
state    real  apr_st           ij      misc        1         -      r       "APR_ST"                "PRECIP FROM CLOSURE STABILITY"   "mm hour-1"
state    real  apr_as           ij      misc        1         -      r       "APR_AS"                "PRECIP FROM CLOSURE AS-TYPE"     "mm hour-1"
state    real  apr_capma        ij      misc        1         -      r       "APR_CAPMA"             "PRECIP FROM MAX CAP"             "mm hour-1"
state    real  apr_capme        ij      misc        1         -      r       "APR_CAPME"             "PRECIP FROM MEAN CAP"            "mm hour-1"
state    real  apr_capmi        ij      misc        1         -      r       "APR_CAPMI"             "PRECIP FROM MIN CAP"             "mm hour-1"
state    real  edt_out          ij      misc        1         -      -        "EDT_OUT"             "EDT FROM GD SCHEME"             ""
state    real  xf_ens           ije     misc        1         Z      r        "XF_ENS"                "MASS FLUX PDF IN GRELL CUMULUS SCHEME"     "mb hour-1"
state    real  pr_ens           ije     misc        1         Z      r        "PR_ENS"                "PRECIP RATE PDF IN GRELL CUMULUS SCHEME"    "mb hour-1"
state    real  cugd_tten        ikj     misc        1         -      h        "CUGD_TTEN"             "INITIAL TTENDENCY OUT OFF GRELL CUMULUS SCHEME"  "K s-1"
state    real  cugd_qvten       ikj     misc        1         -      h        "CUGD_QVTEN"            "INITIAL QTENDENCY OUT OFF GRELL CUMULUS SCHEME"  "K s-1"
state    real  cugd_ttens       ikj     misc        1         -      h        "CUGD_TTENS"            "INITIAL SUBSIDENCE TTENDENCY OUT OFF GRELL CUMULUS SCHEME"  "K s-1"
state    real  cugd_qvtens      ikj     misc        1         -      h        "CUGD_QVTENS"           "INITIAL SUBSIDNCE QTENDENCY OUT OFF GRELL CUMULUS SCHEME"  "K s-1"
state    real  cugd_qcten       ikj     misc        1         -      h        "CUGD_QCTEN"            "INITIAL TEMPERATURE TENDENCY OUT OFF GRELL CUMULUS SCHEME"  "K s-1"
#state    real  ACLWUPTC         ij      misc       1         -      rhdu     "ACLWUPTC"              "ACCUMULATED UPWELLING CLEAR SKY LONGWAVE FLUX AT TOP" "J m-2"
state    real  RTHFTEN          ikj     misc        1         -      r        "RTHFTEN"               "TEMPERATURE TENDENCY USED IN GRELL CUMULUS SCHEME"  "K s-1"      
state    real  RQVFTEN          ikj     misc        1         -      r        "RQVFTEN"               "MOISTURE TENDENCY USED IN GRELL CUMULUS SCHEME"     "kg s-1"

state integer  STEPCU          -        misc        1         -      r        "STEPCU"                "NUMBER OF FUNDAMENTAL TIMESTEPS BETWEEN CONVECTION CALLS"  ""
                                                
state    real  RTHRATEN        ikj      misc        1         -      rd       "RTHRATEN"              "COUPLED THETA TENDENCY DUE TO RADIATION"              "Pa K s-1"
state    real  RTHRATENLW      ikj      misc        1         -      r        "RTHRATLW"              "UNCOUPLED THETA TENDENCY DUE TO LONG WAVE RADIATION"    "K s-1"
state    real  RTHRATENSW      ikj      misc        1         -      r        "RTHRATSW"              "UNCOUPLED THETA TENDENCY DUE TO SHORT WAVE RADIATION"   "K s-1"
state    real  CLDFRA          ikj      misc        1         -      r        "CLDFRA"                "CLOUD FRACTION"                                       ""

state    real  SWDOWN           ij      misc        1         -      rd      "SWDOWN"                "DOWNWARD SHORT WAVE FLUX AT GROUND SURFACE"           "W m-2"      
state    real  SWDOWNC          ij      misc        1         -      -        "SWDOWNC"               "DOWNWARD CLEAR-SKY SHORT WAVE FLUX AT GROUND SURFACE"           "W m-2"      
state    real  GSW              ij      misc        1         -      rd       "GSW"                   "NET SHORT WAVE FLUX AT GROUND SURFACE"           "W m-2"      
state    real  GLW              ij      misc        1         -      rd      "GLW"                   "DOWNWARD LONG WAVE FLUX AT GROUND SURFACE"            "W m-2"      

# upward and downward clearsky and total diagnostic fluxes for CAM radiation
#state    real  ACSWUPT          ij      misc        1         -      rhdu     "ACSWUPT"               "ACCUMULATED UPWELLING SHORTWAVE FLUX AT TOP"          "J m-2"
#state    real  ACSWUPTC         ij      misc        1         -      rhdu     "ACSWUPTC"              "ACCUMULATED UPWELLING CLEAR SKY SHORTWAVE FLUX AT TOP" "J m-2"
#state    real  ACSWDNT          ij      misc        1         -      rhdu     "ACSWDNT"               "ACCUMULATED DOWNWELLING SHORTWAVE FLUX AT TOP"          "J m-2"
#state    real  ACSWDNTC         ij      misc        1         -      rhdu     "ACSWDNTC"              "ACCUMULATED DOWNWELLING CLEAR SKY SHORTWAVE FLUX AT TOP" "J m-2"
#state    real  ACSWUPB          ij      misc        1         -      rhdu     "ACSWUPB"               "ACCUMULATED UPWELLING SHORTWAVE FLUX AT BOTTOM"          "J m-2"
#state    real  ACSWUPBC         ij      misc        1         -      rhdu     "ACSWUPBC"              "ACCUMULATED UPWELLING CLEAR SKY SHORTWAVE FLUX AT BOTTOM" "J m-2"
#state    real  ACSWDNB          ij      misc        1         -      rhdu     "ACSWDNB"               "ACCUMULATED DOWNWELLING SHORTWAVE FLUX AT BOTTOM"          "J m-2"
#state    real  ACSWDNBC         ij      misc        1         -      rhdu     "ACSWDNBC"              "ACCUMULATED DOWNWELLING CLEAR SKY SHORTWAVE FLUX AT BOTTOM" "J m-2"
#state    real  ACLWUPT          ij      misc        1         -      rhdu     "ACLWUPT"               "ACCUMULATED UPWELLING LONGWAVE FLUX AT TOP"          "J m-2"
#state    real  ACLWUPTC         ij      misc        1         -      rhdu     "ACLWUPTC"              "ACCUMULATED UPWELLING CLEAR SKY LONGWAVE FLUX AT TOP" "J m-2"
#state    real  ACLWDNT          ij      misc        1         -      rhdu     "ACLWDNT"               "ACCUMULATED DOWNWELLING LONGWAVE FLUX AT TOP"          "J m-2"
#state    real  ACLWDNTC         ij      misc        1         -      rhdu     "ACLWDNTC"              "ACCUMULATED DOWNWELLING CLEAR SKY LONGWAVE FLUX AT TOP" "J m-2"
#state    real  ACLWUPB          ij      misc        1         -      rhdu     "ACLWUPB"               "ACCUMULATED UPWELLING LONGWAVE FLUX AT BOTTOM"          "J m-2"
#state    real  ACLWUPBC         ij      misc        1         -      rhdu     "ACLWUPBC"              "ACCUMULATED UPWELLING CLEAR SKY LONGWAVE FLUX AT BOTTOM" "J m-2"
#state    real  ACLWDNB          ij      misc        1         -      rhdu     "ACLWDNB"               "ACCUMULATED DOWNWELLING LONGWAVE FLUX AT BOTTOM"          "J m-2"
#state    real  ACLWDNBC         ij      misc        1         -      rhdu     "ACLWDNBC"              "ACCUMULATED DOWNWELLING CLEAR SKY LONGWAVE FLUX AT BOTTOM" "J m-2"
#state    real  SWUPT            ij      misc        1         -      rhdu     "SWUPT"                 "INSTANTANEOUS UPWELLING SHORTWAVE FLUX AT TOP"          "J m-2"
#state    real  SWUPTC           ij      misc        1         -      rhdu     "SWUPTC"                "INSTANTANEOUS UPWELLING CLEAR SKY SHORTWAVE FLUX AT TOP" "J m-2"
#state    real  SWDNT            ij      misc        1         -      rhdu     "SWDNT"                 "INSTANTANEOUS DOWNWELLING SHORTWAVE FLUX AT TOP"          "J m-2"
#state    real  SWDNTC           ij      misc        1         -      rhdu     "SWDNTC"                "INSTANTANEOUS DOWNWELLING CLEAR SKY SHORTWAVE FLUX AT TOP" "J m-2"
#state    real  SWUPB            ij      misc        1         -      rhdu     "SWUPB"                 "INSTANTANEOUS UPWELLING SHORTWAVE FLUX AT BOTTOM"          "J m-2"
#state    real  SWUPBC           ij      misc        1         -      rhdu     "SWUPBC"                "INSTANTANEOUS UPWELLING CLEAR SKY SHORTWAVE FLUX AT BOTTOM" "J m-2"
#state    real  SWDNB            ij      misc        1         -      rhdu     "SWDNB"                 "INSTANTANEOUS DOWNWELLING SHORTWAVE FLUX AT BOTTOM"          "J m-2"
#state    real  SWDNBC           ij      misc        1         -      rhdu     "SWDNBC"                "INSTANTANEOUS DOWNWELLING CLEAR SKY SHORTWAVE FLUX AT BOTTOM" "J m-2"
#state    real  LWUPT            ij      misc        1         -      rhdu     "LWUPT"                 "INSTANTANEOUS UPWELLING LONGWAVE FLUX AT TOP"          "J m-2"
#state    real  LWUPTC           ij      misc        1         -      rhdu     "LWUPTC"                "INSTANTANEOUS UPWELLING CLEAR SKY LONGWAVE FLUX AT TOP" "J m-2"
#state    real  LWDNT            ij      misc        1         -      rhdu     "LWDNT"                 "INSTANTANEOUS DOWNWELLING LONGWAVE FLUX AT TOP"          "J m-2"
#state    real  LWDNTC           ij      misc        1         -      rhdu     "LWDNTC"                "INSTANTANEOUS DOWNWELLING CLEAR SKY LONGWAVE FLUX AT TOP" "J m-2"
#state    real  LWUPB            ij      misc        1         -      rhdu     "LWUPB"                 "INSTANTANEOUS UPWELLING LONGWAVE FLUX AT BOTTOM"          "J m-2"
#state    real  LWUPBC           ij      misc        1         -      rhdu     "LWUPBC"                "INSTANTANEOUS UPWELLING CLEAR SKY LONGWAVE FLUX AT BOTTOM" "J m-2"
#state    real  LWDNB            ij      misc        1         -      rhdu     "LWDNB"                 "INSTANTANEOUS DOWNWELLING LONGWAVE FLUX AT BOTTOM"          "J m-2"
#state    real  LWDNBC           ij      misc        1         -      rhdu     "LWDNBC"                "INSTANTANEOUS DOWNWELLING CLEAR SKY LONGWAVE FLUX AT BOTTOM" "J m-2"

state    real  SWCF             ij      misc        1         -      r         "SWCF"                  "SHORT WAVE CLOUD FORCING AT TOA"                     "W m-2"
state    real  LWCF             ij      misc        1         -      r         "LWCF"                  "LONG WAVE CLOUD FORCING AT TOA"                      "W m-2"
state    real  OLR              ij      misc        1         -      r        "OLR"                   "TOA OUTGOING LONG WAVE"                              "W m-2"

# these next 2 are for the HFSoLE/PET demo; writing these to auxhist1 output over MCEL for coupling
# with wave model, only if compiled with -DMCELIO, JM 2003/05/29
state    real  XLAT             ij      misc        1         -     i0123r01du=(copy_fcnm)      "XLAT"                "LATITUDE, SOUTH IS NEGATIVE"                                          "degree_north"
state    real  XLONG            ij      misc        1         -     i0123r01du=(copy_fcnm)      "XLONG"               "LONGITUDE, WEST IS NEGATIVE"                                          "degree_east"
state    real  XLAT_U           ij      dyn_em      1         X     i012r01du=(copy_fcnm)       "XLAT_U"              "LATITUDE, SOUTH IS NEGATIVE"                                          "degree_north"
state    real  XLONG_U          ij      dyn_em      1         X     i012r01du=(copy_fcnm)       "XLONG_U"             "LONGITUDE, WEST IS NEGATIVE"                                          "degree_east"
state    real  XLAT_V           ij      dyn_em      1         Y     i012r01du=(copy_fcnm)       "XLAT_V"              "LATITUDE, SOUTH IS NEGATIVE"                                          "degree_north"
state    real  XLONG_V          ij      dyn_em      1         Y     i012r01du=(copy_fcnm)       "XLONG_V"             "LONGITUDE, WEST IS NEGATIVE"                                          "degree_east"
state    real  ALBEDO           ij      misc        1         -      r          "ALBEDO"                   "ALBEDO"
state    real  CLAT             ij      misc        1         -     i012rdu=(copy_fcnm)          "CLAT"                "COMPUTATIONAL GRID LATITUDE, SOUTH IS NEGATIVE"                       "degree_north"
state    real  CLONG            ij      misc        1         -     i012rdu=(copy_fcnm)          "CLONG"               "COMPUTATIONAL GRID LONGITUDE, WEST IS NEGATIVE"                       "degree_east"
state    real  ALBBCK           ij      misc        1         -     i0124r   "ALBBCK"                "BACKGROUND ALBEDO"        ""
state    real  EMBCK            ij      misc        1         -      r        "EMBCK"                 "BACKGROUND EMISSIVITY"         ""
state    real  EMISS            ij      misc        1         -      r       "EMISS"                 "SURFACE EMISSIVITY"         "" 

state    real  CLDEFI           ij      misc        1         -      r        "CLDEFI"                "precipitation efficiency in BMJ SCHEME"    ""      
state integer  STEPRA          -        misc        1         -      r        "STEPRA"                "NUMBER OF FUNDAMENTAL TIMESTEPS BETWEEN RADIATION CALLS"        ""
                                                
state    real  RUBLTEN         ikj      misc        1         -      r        "RUBLTEN"               "COUPLED X WIND TENDENCY DUE TO PBL PARAMETERIZATION"  "Pa m s-2"
state    real  RVBLTEN         ikj      misc        1         -      r        "RVBLTEN"               "COUPLED Y WIND TENDENCY DUE TO PBL PARAMETERIZATION"  "Pa m s-2"
state    real  RTHBLTEN        ikj      misc        1         -      r        "RTHBLTEN"              "COUPLED THETA TENDENCY DUE TO PBL PARAMETERIZATION"   "Pa K s-1"
state    real  RQVBLTEN        ikj      misc        1         -      r        "RQVBLTEN"              "COUPLED Q_V TENDENCY DUE TO PBL PARAMETERIZATION"     "Pa kg kg-1 s-1"
state    real  RQCBLTEN        ikj      misc        1         -      r        "RQCBLTEN"              "COUPLED Q_C TENDENCY DUE TO PBL PARAMETERIZATION"     "Pa kg kg-1 s-1"
state    real  RQIBLTEN        ikj      misc        1         -      r        "RQIBLTEN"              "COUPLED Q_I TENDENCY DUE TO PBL PARAMETERIZATION"     "Pa kg kg-1 s-1"      

# State vector for etampnew microphysics. Must be declared state because it is not read-once and is needed for restarting.
state    real  mp_restart_state   p      misc        1         -      r       "MP_RESTART_STATE"       "STATE VECTOR FOR MICROPHYSICS RESTARTS"
state    real  tbpvs_state        p      misc        1         -      r        "TBPVS_STATE"           "STATE FOR ETAMPNEW MICROPHYSICS"
state    real  tbpvs0_state       p      misc        1         -      r        "TBPVS0_STATE"          "STATE FOR ETAMPNEW MICROPHYSICS"

# State variables for landuse_init, Must be declared state because they are read in and needed for restarts. Had been SAVE vars in
# landuse_init (phys/module_physics_init.F)
state    integer  landuse_isice   -      misc       -          -     r
state    integer  landuse_lucats  -      misc       -          -     r
state    integer  landuse_luseas  -      misc       -          -     r
state    integer  landuse_isn     -      misc       -          -     r
state    real     lu_state        p      misc       -          -     r

i1       real  th_phy          ikj      misc        1         -                                          
i1       real  pi_phy          ikj      misc        1         -                                          
i1       real  p_phy           ikj      misc        1         -                                          
i1       real  t_phy           ikj      misc        1         -                                          
i1       real  u_phy           ikj      misc        1         -                                          
i1       real  v_phy           ikj      misc        1         -                                          
i1       real  dz8w            ikj      misc        1         Z                                          
i1       real  p8w             ikj      misc        1         Z                                          
i1       real  t8w             ikj      misc        1         Z                                          
i1       real  rho_phy         ikj      misc        1         -                                          
i1    logical  CU_ACT_FLAG     ij       misc        1         -

                                                
state    real  TMN              ij      misc        1         -     i012rd=(interp_mask_land_field:lu_index)u=(copy_fcnm)     "TMN"                   "SOIL TEMPERATURE AT LOWER BOUNDARY"           "K"
state    real  XLAND            ij      misc        1         -     i02rd=(interp_fcnm)u=(copy_fcnm)       "XLAND"                 "LAND MASK (1 FOR LAND, 2 FOR WATER)"          ""      
state    real  ZNT              ij      misc        1         -      i3r      "ZNT"                   "TIME-VARYING ROUGHNESS LENGTH"                "m"      
state    real  CK               ij      misc        1         -      r        "CK"                    "ENTHALPY EXCHANGE COEFF AT 10 m"                      ""
state    real  CKA              ij      misc        1         -      r        "CKA"                   "ENTHALPY EXCHANGE COEFF AT LOWEST MODEL LVL"          ""
state    real  CD               ij      misc        1         -      r        "CD"                    "DRAG COEFF AT 10m"                      ""
state    real  CDA              ij      misc        1         -      r        "CDA"                   "DRAG COEFF AT LOWEST MODEL LVL"                      ""
state    real  UST              ij      misc        1         -      r        "UST"                   "U* IN SIMILARITY THEORY"                      "m s-1"    
state    real  USTM             ij      misc        1         -      rh       "USTM"                  "U* IN SIMILARITY THEORY WITHOUT VCONV"        "m s-1"    #SAVEMARS2 ust
i1       real  HOL              ij      misc        1         -      -        "HOL"                   "PBL HEIGHT OVER MONIN-OBUKHOV LENGTH"         ""
state    real  RMOL             ij      misc        1         -      r        "RMOL"                  "1./Monin Ob. Length"                      ""
state    real  MOL              ij      misc        1         -      r        "MOL"                   "T* IN SIMILARITY THEORY"                      "K"      
state    real  PBLH             ij      misc        1         -      r       "PBLH"                  "PBL HEIGHT"         "m"      
state    real  CAPG             ij      misc        1         -      r        "CAPG"                  "HEAT CAPACITY FOR SOIL"                       "J K-1 m-3"      
state    real  THC              ij      misc        1         -      r        "THC"                   "THERMAL INERTIA"                              "Cal cm-1 K-1 s-0.5"      
state    real  HFX              ij      misc        1         -      rh       "HFX"                   "UPWARD HEAT FLUX AT THE SURFACE"              "W m-2"     #SAVEMARS2 hfx
state    real  QFX              ij      misc        1         -      r       "QFX"                   "UPWARD MOISTURE FLUX AT THE SURFACE"          "kg m-2 s-1"      
state    real  LH               ij      misc        1         -      r       "LH"                    "LATENT HEAT FLUX AT THE SURFACE"              "W m-2"
state    real  FLHC             ij      misc        1         -      r        "FLHC"                  "SURFACE EXCHANGE COEFFICIENT FOR HEAT"       ""
state    real  FLQC             ij      misc        1         -      r        "FLQC"                  "SURFACE EXCHANGE COEFFICIENT FOR MOISTURE"   ""
state    real  QSG              ij      misc        1         -      r        "QSG"                   "SURFACE SATURATION WATER VAPOR MIXING RATIO"   "kg kg-1"
state    real  QVG              ij      misc        1         -      r        "QVG"                   "WATER VAPOR MIXING RATIO AT THE SURFACE"      "kg kg-1"
state    real  dfi_QVG          ij      misc        1         -      r        "QVG_dfi"               "WATER VAPOR MIXING RATIO AT THE SURFACE"      "kg kg-1"
state    real  QCG              ij      misc        1         -      r        "QCG"                   "CLOUD WATER MIXING RATIO AT THE SURFACE"      "kg kg-1"
state    real  SOILT1           ij      misc        1         -      r        "SOILT1"                "TEMPERATURE INSIDE SNOW "    "K"
state    real  dfi_SOILT1       ij      misc        1         -      r        "SOILT1_dfi"            "TEMPERATURE INSIDE SNOW "    "K"
state    real  TSNAV            ij      misc        1         -      r        "TSNAV"                 "AVERAGE SNOW TEMPERATURE "                    "C"
state    real  dfi_TSNAV        ij      misc        1         -      r        "TSNAV_dfi"             "AVERAGE SNOW TEMPERATURE "                    "C"
state    real  REGIME           ij      misc        1         -      r        "REGIME"  "FLAGS: 1=Night/Stable, 2=Mechanical Turbulent, 3=Forced Conv, 4=Free Conv" ""
state    real  SNOWC            ij      misc        1         -     ird=(interp_mask_land_field:lu_index)u=(copy_fcnm)      "SNOWC"                 "FLAG INDICATING SNOW COVERAGE (1 FOR SNOW COVER)"         ""
state    real  dfi_SNOWC        ij      misc        1         -      r        "SNOWC_dfi"             "FLAG INDICATING SNOW COVERAGE (1 FOR SNOW COVER)"         ""
state    real  MAVAIL           ij      misc        1         -      r        "MAVAIL"                "SURFACE MOISTURE AVAILABILITY"                ""
                                                
state   real   tkesfcf          ij      misc        1         -      r        "tkesfcf"               "TKE AT THE SURFACE"                           "m2 s-2"      
                                                
state integer  STEPBL          -        misc        1         -      r        "STEPBL"                "NUMBER OF FUNDAMENTAL TIMESTEPS BETWEEN PBL CALLS" ""      
state    real  taucldi         ikj      misc        1         -      r        "TAUCLDI"               "CLOUD OPTICAL THICKNESS FOR ICE"              ""
state    real  taucldc         ikj      misc        1         -      r        "TAUCLDC"               "CLOUD OPTICAL THICKNESS FOR WATER"            ""
                                                
state   real  defor11          ikj      misc        1         -     r         "defor11"               "DEFORMATION 11"              "s-1"      
state   real  defor22          ikj      misc        1         -     r         "defor22"               "DEFORMATION 22"              "s-1"      
state   real  defor12          ikj      misc        1         -     r         "defor12"               "DEFORMATION 12"              "s-1"      
state   real  defor33          ikj      misc        1         z     r         "defor33"               "DEFORMATION 33"              "s-1"      
state   real  defor13          ikj      misc        1         z     r         "defor13"               "DEFORMATION 13"              "s-1"      
state   real  defor23          ikj      misc        1         z     r         "defor23"               "DEFORMATION 23"              "s-1"      
state   real   xkmv            ikj      misc        1         -     r         "xkmv"                  "VERTICAL EDDY VISCOSITY"     "m2 s-1"      
state   real   xkmh            ikj      misc        1         -     r         "xkmh"                  "HORIZONTAL EDDY VISCOSITY"   "m2 s-1"      
state   real   xkhv            ikj      misc        1         -     r         "xkhv"                  "VERTICAL EDDY DIFFUSIVITY OF HEAT"                               "m2 s-1"      
state   real   xkhh            ikj      misc        1         -     r         "xkhh"                  "HORIZONTAL EDDY DIFFUSIVITY OF HEAT"                             "m2 s-1"      
state   real    div            ikj      misc        1         -     r         "div"                   "DIVERGENCE"                                                      "s-1"
state   real    BN2            ikj      misc        1         -     r         "BN2"                   "BRUNT-VAISALA FREQUENCY"                                         "s-2"
state  logical warm_rain        -       misc        1         -     -         "warm_rain"              "WARM_RAIN_LOGICAL"
state  logical adv_moist_cond   -       misc        1         -     -         "adv_moist_cond"         "ADVECT MOIST CONDENSATES LOGICAL"

## FDDA variables

state integer  STEPFG            -        misc        1         -      r        "STEPFG"                "NUMBER OF FUNDAMENTAL TIMESTEPS BETWEEN FDDA GRID CALLS" ""
state    real  RUNDGDTEN         ikj      misc        1         X      r        "RUNDGDTEN"               "COUPLED X WIND TENDENCY DUE TO FDDA GRID NUDGING"  "Pa m s-2"
state    real  RVNDGDTEN         ikj      misc        1         Y      r        "RVNDGDTEN"               "COUPLED Y WIND TENDENCY DUE TO FDDA GRID NUDGING"  "Pa m s-2"
state    real  RTHNDGDTEN        ikj      misc        1         -      r        "RTHNDGDTEN"              "COUPLED THETA TENDENCY DUE TO FDDA GRID NUDGING"   "Pa K s-1"
state    real  RQVNDGDTEN        ikj      misc        1         -      r        "RQVNDGDTEN"              "COUPLED Q_V TENDENCY DUE TO FDDA GRID NUDGING"     "Pa kg kg-1 s-1"
state    real  RMUNDGDTEN        ij       misc        1         -      r        "RMUNDGDTEN"              "MU TENDENCY DUE TO FDDA GRID NUDGING"     "Pa s-1"
state    real    -               ikjf     fdda3d      1         -     -    -
state    real  U_NDG_NEW         ikjf     fdda3d      1         X      igr      "U_NDG_NEW"               "NEW X WIND FOR FDDA GRID NUDGING"  "m s-1"
state    real  V_NDG_NEW         ikjf     fdda3d      1         Y      igr      "V_NDG_NEW"               "NEW Y WIND FOR FDDA GRID NUDGING"  "m s-1"
state    real  T_NDG_NEW         ikjf     fdda3d      1         -      igr      "T_NDG_NEW"               "NEW PERT POT TEMP FOR FDDA GRID NUDGING"  "K"
state    real  Q_NDG_NEW         ikjf     fdda3d      1         -      igr      "Q_NDG_NEW"               "NEW WATER VAPOR MIX RATIO FOR FDDA GRID NUDGING"  "kg/kg"
state    real  PH_NDG_NEW        ikjf     fdda3d      1         Z      igr      "PH_NDG_NEW"              "NEW PERT GEOPOTENTIAL FOR FDDA GRID NUDGING"  "kg/kg"
state    real  U_NDG_OLD         ikjf     fdda3d      1         X      igr      "U_NDG_OLD"               "OLD X WIND FOR FDDA GRID NUDGING"  "m s-1"
state    real  V_NDG_OLD         ikjf     fdda3d      1         Y      igr      "V_NDG_OLD"               "OLD Y WIND FOR FDDA GRID NUDGING"  "m s-1"
state    real  T_NDG_OLD         ikjf     fdda3d      1         -      igr      "T_NDG_OLD"               "OLD PERT POT TEMP FOR FDDA GRID NUDGING"  "K"
state    real  Q_NDG_OLD         ikjf     fdda3d      1         -      igr      "Q_NDG_OLD"               "OLD WATER VAPOR MIX RATIO FOR FDDA GRID NUDGING"  "kg/kg"
state    real  PH_NDG_OLD        ikjf     fdda3d      1         Z      igr      "PH_NDG_OLD"              "OLD PERT GEOPOTENTIAL FOR FDDA GRID NUDGING"  "kg/kg"
state    real    -               ivjf     fdda2d      1         Z     -    -
state    real  MU_NDG_NEW        ivjf     fdda2d      1         Z      igr      "MU_NDG_NEW"              "NEW PERT COLUMN DRY MASS FOR FDDA GRID NUDGING"  "Pa"
state    real  T2_NDG_NEW        ivjf     fdda2d      1         -      igr      "T2_NDG_NEW"               "NEW 2m TEMP FOR PX LSM "  "K"
state    real  Q2_NDG_NEW        ivjf     fdda2d      1         -      igr      "Q2_NDG_NEW"               "NEW 2m WATER VAPOR MIX RATIO FOR PX LSM "  "kg/kg"
state    real  MU_NDG_OLD        ivjf     fdda2d      1         Z      igr      "MU_NDG_OLD"              "OLD PERT COLUMN DRY MASS FOR FDDA GRID NUDGING"  "Pa"
state    real  T2_NDG_OLD        ivjf     fdda2d      1         -      igr      "T2_NDG_OLD"               "OLD 2m TEMP F FOR PX LSM"  "K"
state    real  Q2_NDG_OLD        ivjf     fdda2d      1         -      igr      "Q2_NDG_OLD"               "OLD 2m WATER VAPOR MIX RATIO  FOR PX LSM"  "kg/kg"
state    real  SN_NDG_NEW        ivjf     fdda2d      1         -      igr      "SN_NDG_NEW"               "NEW Snow Depth "  "m"
state    real  SN_NDG_OLD        ivjf     fdda2d      1         -      igr      "SN_NDG_OLD"               "OLD Snow Depth"  "m"


# flag for nest movement
state  logical moved            -       misc        1         -     -          

# special cam radiation restart arrays
state  real   abstot   ikcj   misc      1    Z   -     ""   ""  " "
state  real   absnxt   ikaj   misc      1    -   -     ""   ""  " "
state  real   emstot   ikj    misc      1    Z   -     ""   ""  " "

# model diagnostics
state   real  dpsdt            ij       misc        1         -     -         "dpsdt"           "surface pressure tendency"                         "Pa/sec"
state   real  dmudt            ij       misc        1         -     -         "dmudt"           "mu tendency"                                       "Pa/sec"
state   real  pk1m             ij       misc        1         -     -         "pk1m"            "surface pressure at previous step"                 "Pa"
state   real  mu_2m            ij       misc        1         -     -         "mu_2m"           "mu_2 at previous step"                             "Pa"

state   real    max_cfl         -       misc        1         -     -       "max_cfl"           "maximum CFL value in grid at a time" "-"

# Ocean Mixed-Layer State Variables
state   real    TML            ij      misc         1         -     rd=(interp_mask_water_field:lu_index)u=(copy_fcnm)    "TML"    "OCEAN MIXED-LAYER TEMPERATURE"   "K"
state   real    T0ML           ij      misc         1         -     rd=(interp_mask_water_field:lu_index)u=(copy_fcnm)    "T0ML"   "INITIAL OCEAN MIXED-LAYER TEMPERATURE"   "K"
state   real    HML            ij      misc         1         -     rd=(interp_mask_water_field:lu_index)u=(copy_fcnm)    "HML"    "OCEAN MIXED-LAYER DEPTH"   "m"
state   real    H0ML           ij      misc         1         -     rd=(interp_mask_water_field:lu_index)u=(copy_fcnm)    "H0ML"   "INITIAL OCEAN MIXED-LAYER DEPTH"   "m"
state   real    HUML           ij      misc         1         -     rd=(interp_mask_water_field:lu_index)u=(copy_fcnm)    "HUML"   "OCEAN MIXED-LAYER DEPTH * U-CURRENT"  " m2s-1 "
state   real    HVML           ij      misc         1         -     rd=(interp_mask_water_field:lu_index)u=(copy_fcnm)    "HVML"   "OCEAN MIXED-LAYER DEPTH * V-CURRENT"  " m2s-1 " 
#
#---------------------------------------------------------------------------------------------------------------------------------------
#                                               

######                                          
#                                               
# Variables that are set at run-time to control configuration  (namelist-settable)                                              
#                                               
#<Table>  <Type>  <Sym>                   <How set>          <Nentries>   <Default>                                             


# Time Control
rconfig   integer run_days                namelist,time_control		1             0       irh   "run_days"              "NUMBER OF DAYS TO RUN"
rconfig   integer run_hours               namelist,time_control		1             0       irh   "run_hours"             "NUMBER OF HOURS TO RUN"
rconfig   integer run_minutes             namelist,time_control		1             0       irh   "run_minutes"           "NUMBER OF MINUTES TO RUN"
rconfig   integer run_seconds             namelist,time_control		1             0       irh   "run_seconds"           "NUMBER OF SECONDS TO RUN"
rconfig   integer start_year              namelist,time_control 	max_domains    2024   irh   "start_year"            "4 DIGIT YEAR OF START OF MODEL" "YEARS"
rconfig   integer start_month             namelist,time_control		max_domains      01    irh   "start_month"           "2 DIGIT MONTH OF THE YEAR OF START OF MODEL, 1-12" "MONTHS"
rconfig   integer start_day               namelist,time_control		max_domains      01    irh   "start_day"             "2 DIGIT DAY OF THE MONTH OF START OF MODEL, 1-31" "DAYS"
rconfig   integer start_hour              namelist,time_control		max_domains      00    irh   "start_hour"            "2 DIGIT HOUR OF THE DAY OF START OF MODEL, 0-23" "HOURS"
rconfig   integer start_minute            namelist,time_control		max_domains      00    irh   "start_minute"          "2 DIGIT MINUTE OF THE HOUR OF START OF MODEL, 0-59" "MINUTES"
rconfig   integer start_second            namelist,time_control		max_domains      00    irh   "start_second"          "2 DIGIT SECOND OF THE MINUTE OF START OF MODEL, 0-59" "SECONDS"
rconfig   integer end_year                namelist,time_control		max_domains    2024    irh   "end_year"              "4 DIGIT YEAR OF END OF MODEL" "YEARS"
rconfig   integer end_month               namelist,time_control		max_domains      01    irh   "end_month"             "2 DIGIT MONTH OF THE YEAR OF END OF MODEL, 1-12" "MONTHS"
rconfig   integer end_day                 namelist,time_control		max_domains      02    irh   "end_day"               "2 DIGIT DAY OF THE MONTH OF END OF MODEL, 1-31" "DAYS"
rconfig   integer end_hour                namelist,time_control		max_domains      00    irh   "end_hour"              "2 DIGIT HOUR OF THE DAY OF END OF MODEL, 0-23" "HOURS"
rconfig   integer end_minute              namelist,time_control		max_domains      00    irh   "end_minute"            "2 DIGIT MINUTE OF THE HOUR OF END OF MODEL, 0-59" "MINUTES"
rconfig   integer end_second              namelist,time_control		max_domains      00    irh   "end_second"            "2 DIGIT SECOND OF THE MINUTE OF END OF MODEL, 0-59" "SECONDS"
rconfig   integer interval_seconds        namelist,time_control		1             43200    irh   "interval_seconds"      "SECONDS BETWEEN ANALYSIS AND BOUNDARY PERIODS" "SECONDS"
rconfig   logical input_from_file         namelist,time_control		max_domains    .false. irh    "input_from_file"      "T/F INPUT FOR THIS DOMAIN FROM A SEPARATE INPUT FILE"  ""
rconfig   integer fine_input_stream       namelist,time_control		max_domains    0       irh    "fine_input_stream"      "0 THROUGH 11, WHAT INPUT STREAM IS FINE GRID IC FROM"  ""
rconfig   logical input_from_hires        namelist,time_control		max_domains    .false. irh    "input_from_hires"     "T/F INPUT FOR THIS DOMAIN FROM USGS HI RES TERRAIN"  ""
rconfig   character rsmas_data_path       namelist,time_control		1              "."     -    "rsmas_data_path"      ""  ""
rconfig   logical all_ic_times            namelist,time_control		1              .false. irh    "all_ic_times"     "T/F WRITE ALL IC TIME PERIODS"  ""

include registry.io_boilerplate

rconfig   integer JULYR                   namelist,time_control		max_domains    0       h    "JULYR"                 ""      ""
rconfig   integer JULDAY                  namelist,time_control		max_domains    1       h    "JULDAY"                ""      ""
rconfig   real    GMT                     namelist,time_control		max_domains    0.      h    "GMT"           ""      ""
rconfig   character  input_inname      namelist,time_control		1  "wrfinput_d<domain>"          -     "name of input   infile"   ""      ""
rconfig   character  input_outname     namelist,time_control		1  "wrfinput_d<domain>"          -     "name of input   outfile"  ""      ""
rconfig   character  bdy_inname        namelist,time_control		1  "wrfbdy_d<domain>"            -     "name of boundary infile"  ""      ""
rconfig   character  bdy_outname       namelist,time_control		1  "wrfbdy_d<domain>"            -     "name of boundary outfile" ""      ""
rconfig   character  rst_inname        namelist,time_control		1  "wrfrst_d<domain>_<date>"     -     "name of restrt infile"    ""      ""
rconfig   character  rst_outname       namelist,time_control		1  "wrfrst_d<domain>_<date>"     -     "name of restrt outfile"   ""      ""
rconfig   logical write_input             namelist,time_control		1             .false. -    "write input data for 3dvar etc."              ""      ""
rconfig   logical write_restart_at_0h     namelist,time_control		1             .false. h    "write_restart_at_0h"              ""      ""
rconfig   logical adjust_output_times     namelist,time_control         1             .false. -    "adjust_output_times"
rconfig   logical adjust_input_times      namelist,time_control         1             .false. -    "adjust_input_times"

rconfig   integer diag_print              namelist,time_control         1              0      -    "print out time series of model diagnostics"
rconfig   logical nocolons                namelist,time_control         1             .false. -    "nocolons"

# DFI namelist
rconfig   integer dfi_opt                namelist,dfi_control   1       0     rh   "dfi_opt"                ""      ""
rconfig   integer dfi_nfilter            namelist,dfi_control   1       7     rh   "dfi_nfilter"                "Digital filter type"      ""
rconfig   logical dfi_write_filtered_input  namelist,dfi_control  1  .true.   rh   "dfi_write_filtered_input"                "Write a wrfinput_filtered_d0n file?"      ""
rconfig   logical dfi_write_dfi_history  namelist,dfi_control   1   .false.   rh   "dfi_write_dfi_history"    "Write history files during filtering?"      ""
rconfig   integer dfi_cutoff_seconds     namelist,dfi_control   1    3600     rh   "dfi_cutoff_seconds"       "Digital filter cutoff time"      ""
rconfig   integer dfi_time_dim           namelist,dfi_control   1    1000     rh   "dfi_time_dim"             "MAX DIMENSION FOR HCOEFF"
rconfig   integer dfi_fwdstop_year       namelist,dfi_control   1    2004     rh   "dfi_fwdstop_year"         "4 DIGIT YEAR OF START OF DFI" "YEARS"
rconfig   integer dfi_fwdstop_month      namelist,dfi_control   1      03     rh   "dfi_fwdstop_month"        "2 DIGIT MONTH OF THE YEAR OF START OF DFI" "MONTHS"
rconfig   integer dfi_fwdstop_day        namelist,dfi_control   1      13     rh   "dfi_fwdstop_day"          "2 DIGIT DAY OF THE MONTH OF START OF DFI" "DAYS"
rconfig   integer dfi_fwdstop_hour       namelist,dfi_control   1      12     rh   "dfi_fwdstop_hour"         "2 DIGIT HOUR OF THE DAY OF START OF DFI" "HOURS"
rconfig   integer dfi_fwdstop_minute     namelist,dfi_control   1      00     rh   "dfi_fwdstop_minute"       "2 DIGIT MINUTE OF THE HOUR OF START OF DFI" "MINUTES"
rconfig   integer dfi_fwdstop_second     namelist,dfi_control   1      00     rh   "dfi_fwdstop_second"       "2 DIGIT SECOND OF THE MINUTE OF START OF DFI" "SECONDS"
rconfig   integer dfi_bckstop_year       namelist,dfi_control   1    2004     rh   "dfi_bckstop_year"         "4 DIGIT YEAR OF END OF DFI" "YEARS"
rconfig   integer dfi_bckstop_month      namelist,dfi_control   1      03     rh   "dfi_bckstop_month"        "2 DIGIT MONTH OF THE YEAR OF END OF DFI" "MONTHS"
rconfig   integer dfi_bckstop_day        namelist,dfi_control   1      14     rh   "dfi_bckstop_day"          "2 DIGIT DAY OF THE MONTH OF END OF DFI" "DAYS"
rconfig   integer dfi_bckstop_hour       namelist,dfi_control   1      12     rh   "dfi_bckstop_hour"         "2 DIGIT HOUR OF THE DAY OF END OF DFI" "HOURS"
rconfig   integer dfi_bckstop_minute     namelist,dfi_control   1      00     rh   "dfi_bckstop_minute"       "2 DIGIT MINUTE OF THE HOUR OF END OF DFI" "MINUTES"
rconfig   integer dfi_bckstop_second     namelist,dfi_control   1      00     rh   "dfi_bckstop_second"       "2 DIGIT SECOND OF THE MINUTE OF END OF DFI" "SECONDS"

# Domains
rconfig   integer time_step               namelist,domains	1             -       ih   "time_step"     
rconfig   integer time_step_fract_num     namelist,domains	1             0       ih   "time_step_fract_num"     
rconfig   integer time_step_fract_den     namelist,domains	1             1       ih   "time_step_fract_den"     

rconfig   integer min_time_step           namelist,domains      max_domains   -1      h    "min_time_step"
rconfig   integer max_time_step           namelist,domains      max_domains   -1      h    "max_time_step"
rconfig   real    target_cfl              namelist,domains      max_domains  1.2      h    "target_cfl"
rconfig   integer max_step_increase_pct   namelist,domains      max_domains    5      h    "max_step_increase_pct"
rconfig   integer starting_time_step      namelist,domains      max_domains   -1      h    "starting_time_step"
rconfig   logical step_to_output_time     namelist,domains      1         .true.      h    "step_to_output_time"
rconfig   logical use_adaptive_time_step  namelist,domains      1         .false.     h    "use_adaptive_time_step"

rconfig   integer max_dom                 namelist,domains	1             1       irh  "max_dom"               ""      ""
rconfig   integer s_we                    namelist,domains	max_domains    1       irh    "s_we"          ""      ""
rconfig   integer e_we                    namelist,domains	max_domains    32      irh    "e_we"          ""      ""
rconfig   integer s_sn                    namelist,domains	max_domains    1       irh    "s_sn"          ""      ""
rconfig   integer e_sn                    namelist,domains	max_domains    32      irh    "e_sn"          ""      ""
rconfig   integer s_vert                  namelist,domains	max_domains    1       irh    "s_vert"                ""      ""
rconfig   integer e_vert                  namelist,domains	max_domains    31      irh    "e_vert"                ""      ""
rconfig   integer num_metgrid_levels      namelist,domains	1              27      irh    "num_metgrid_levels"                ""      ""
rconfig   real    p_top_requested         namelist,domains      1              5000    irh    "p_top_requested" "Pa"      ""
rconfig   integer interp_type             namelist,domains	1              2       irh    "interp_type"  "1=interp in pressure, 2=interp in LOG pressure"  ""
rconfig   integer extrap_type             namelist,domains	1              2       irh    "extrap_type"  "1= use 2 lowest levels, 2=constant"  ""
rconfig   integer t_extrap_type           namelist,domains	1              2       irh    "t_extrap_type"  "1=isothermal, 2=6.5 K/km, 3=adiabatic"   ""
rconfig   logical lowest_lev_from_sfc     namelist,domains	1             .false.  irh    "lowest_lev_from_sfc"                ""      ""
rconfig   logical use_levels_below_ground namelist,domains	1             .true.   irh    "use_levels_below_ground"   "T/F: use input data levels below input sfc pres" ""
rconfig   logical use_surface             namelist,domains	1             .true.   irh    "use_surface"   "T/F: use input surface level in interpolation" ""
rconfig   integer lagrange_order          namelist,domains	1              1       irh    "lagrange_order"   "1=linear, 2=quadratic vertical interpolation"      ""
rconfig   integer force_sfc_in_vinterp    namelist,domains	1              1       irh    "force_sfc_in_vinterp"   "number of eta levels forced to use sfc in vert interp"      ""
rconfig   real    zap_close_levels        namelist,domains	1              500     irh    "zap_close_levels"   "delta p where level is removed in vert interp"      "Pa"
rconfig   logical sfcp_to_sfcp            namelist,domains	1              .false. irh    "sfcp_to_sfcp"   "T/F use incoming sfc pres to compute new sfc pres"      "flag"
rconfig   logical adjust_heights          namelist,domains	1              .false. irh    "adjust_heights"   "T/F adjust pressure level input to match 500 mb height"      "flag"
rconfig   logical smooth_cg_topo          namelist,domains	1              .false. irh    "smooth_cg_topo"   "T/F smooth CG topo on boundarries" "flag"
rconfig   real    dx                      namelist,domains     max_domains    200     h     "dx"        "X HORIZONTAL RESOLUTION"   "METERS"
rconfig   real    dy                      namelist,domains   	max_domains    200     h     "dy"        "Y HORIZONTAL RESOLUTION"   "METERS"
rconfig   integer grid_id                 namelist,domains	max_domains    1       irh    "id"            ""      ""
rconfig   logical grid_allowed            namelist,domains	max_domains    .true.  irh    "allowed"            ""      ""
rconfig   integer parent_id               namelist,domains	max_domains    0       h     "parent_id"             ""      ""
rconfig   integer i_parent_start          namelist,domains	max_domains    1       rh     "i_parent_start"                ""      ""
rconfig   integer j_parent_start          namelist,domains	max_domains    1       rh     "j_parent_start"                ""      ""
rconfig   integer parent_grid_ratio       namelist,domains	max_domains    1       h     "parent_grid_ratio"             ""      ""
rconfig   integer parent_time_step_ratio  namelist,domains	max_domains    1       h     "parent_time_step_ratio"                ""      ""
rconfig   integer feedback                namelist,domains	1    1       h     "feedback"          ""      ""
rconfig   integer smooth_option           namelist,domains	1    2       h     "smooth_option"          ""      ""
rconfig   integer blend_width             namelist,domains	1    5       h     "blend_width"  "width of cg fg terrain blended zone"      ""
rconfig   real    ztop                    namelist,domains	max_domains    15000.  h    "ztop"          ""      ""
rconfig   integer moad_grid_ratio         namelist,domains	max_domains    1       h     "moad_grid_ratio"               ""      ""
rconfig   integer moad_time_step_ratio    namelist,domains	max_domains    1       h     "moad_time_step_ratio"          ""      ""
rconfig   integer shw                     namelist,domains	max_domains    2       h     "stencil_half_width"   "HORIZONTAL INTERPOLATION STENCIL HALF-WIDTH"  "GRID POINTS"
rconfig   integer tile_sz_x               namelist,domains	1             0       -      "tile_sz_x"             ""      ""
rconfig   integer tile_sz_y               namelist,domains	1             0       -      "tile_sz_y"             ""      ""
rconfig   integer numtiles                namelist,domains	1             1       -      "numtiles"              ""      ""
rconfig   integer nproc_x                 namelist,domains	1             -1       -      "nproc_x"              "-1 means not set"      ""
rconfig   integer nproc_y		  namelist,domains	1             -1       -      "nproc_y"              "-1 means not set"      ""
rconfig   integer irand                   namelist,domains	1             0       -      "irand"           ""      ""
rconfig   real    dt                      derived              max_domains    2.      h     "dt"        "TEMPORAL RESOLUTION"      "SECONDS"
rconfig   integer   num_moves       namelist,domains    1                0
rconfig   integer   ts_buf_size     namelist,domains    1                200          -       "ts_buf_size"   "Size of time series buffer"
rconfig   integer   max_ts_locs     namelist,domains    1                5            -       "max_ts_locs"   "Maximum number of time series locations"
rconfig   integer   vortex_interval  namelist,domains   max_domains      15  -  "" "" "minutes"
rconfig   integer   max_vortex_speed namelist,domains   max_domains      40  -  "" "" "meters per second"
rconfig   integer   corral_dist     namelist,domains    max_domains      8
rconfig   integer   track_level     namelist,domains    1                50000
rconfig   integer   move_id         namelist,domains    max_moves        0
rconfig   integer   move_interval   namelist,domains    max_moves        999999999
rconfig   integer   move_cd_x       namelist,domains    max_moves        0
rconfig   integer   move_cd_y       namelist,domains    max_moves        0
rconfig   logical   swap_x          namelist,domains    max_domains    .false. rh    "swap_x"            ""      ""
rconfig   logical   swap_y          namelist,domains    max_domains    .false. rh    "swap_y"            ""      ""
rconfig   logical   cycle_x         namelist,domains    max_domains    .false. rh    "cycle_x"            ""      ""
rconfig   logical   cycle_y         namelist,domains    max_domains    .false. rh    "cycle_y"            ""      ""
rconfig   logical   reorder_mesh    namelist,domains    1              .false. rh    "reorder_mesh"       ""      ""
rconfig   logical   perturb_input   namelist,domains    1              .false. h     "" "" ""
rconfig   real      eta_levels      namelist,domains    max_eta        -1.
rconfig   real      max_dz          namelist,domains    1               1000.

# Physics
######
###### MARS SPECIFIC NAMELIST ENTRIES
######
rconfig  integer  mars      namelist,physics  max_domains  0        rh   "mars"      "model mode"              ""
rconfig  real     init_TI   namelist,physics  max_domains  0        irh  "init_TI"   "thermal inertia"         ""
rconfig  real     init_AL   namelist,physics  max_domains  0        irh  "init_AL"   "albedo"                  ""
rconfig  real     init_U    namelist,physics  max_domains  0        irh  "init_U"    "zonal wind"              ""
rconfig  real     init_V    namelist,physics  max_domains  0        irh  "init_V"    "meridional wind"         ""
rconfig  integer  init_WX   namelist,physics  max_domains  0        irh  "init_WX"   "x coord"                 ""
rconfig  integer  init_WY   namelist,physics  max_domains  0        irh  "init_WY"   "y coord"                 ""
rconfig  real     init_MU   namelist,physics  max_domains  0        irh  "init_MU"   "zonal wind mult."        ""
rconfig  real     init_MV   namelist,physics  max_domains  0        irh  "init_MV"   "meridional wind mult."   ""
rconfig  logical  init_LES  namelist,physics  max_domains  .false.  irh  "init_LES"  "LES mode"                ""
rconfig  logical  modif_wrf namelist,physics  max_domains  .true.   ir   "modif_wrf" "true if tweaked WRF"     ""
#######
####### MARS SPECIFIC NAMELIST ENTRIES
#######
rconfig   integer     mp_physics          namelist,physics	max_domains    0       rh       "mp_physics"            ""      ""
rconfig   integer     gsfcgce_hail        namelist,physics      1              0       rh       "gsfcgce select hail/graupel"  ""      ""
rconfig   integer     gsfcgce_2ice        namelist,physics      1              0       rh       "gsfcgce select 2ice/3ice"  ""      ""
rconfig   integer     progn               namelist,physics      max_domains    0       rh       "progn"                 ""      ""
rconfig   integer     ra_lw_physics       namelist,physics	max_domains    0       rh       "ra_lw_physics"         ""      ""
rconfig   integer     ra_sw_physics       namelist,physics	max_domains    0       rh       "ra_sw_physics"         ""      ""
rconfig   real    radt                    namelist,physics	max_domains    1       h    "RADT"          ""      ""
rconfig   real    naer                    namelist,physics      max_domains    1e9     rh   "NAER"          ""      ""
rconfig   integer     sf_sfclay_physics   namelist,physics	max_domains    0       rh       "sf_sfclay_physics"             ""      ""
rconfig   integer     sf_surface_physics  namelist,physics	max_domains    0       rh       "sf_surface_physics"            ""      ""
rconfig   integer     bl_pbl_physics      namelist,physics	max_domains    0       rh       "bl_pbl_physics"                ""      ""
rconfig   real    BLDT                    namelist,physics	max_domains    0       h    "BLDT"          ""      ""
rconfig   integer     cu_physics          namelist,physics	max_domains    0       rh       "cu_physics"            ""      ""
rconfig   real    CUDT                    namelist,physics	max_domains    0       h    "CUDT"          ""      ""
rconfig   real    GSMDT                   namelist,physics	max_domains    0       h    "GSMDT"          ""      ""
rconfig   integer ISFFLX                  namelist,physics 	1             1       irh    "ISFFLX"                        ""      ""
rconfig   integer IFSNOW                  namelist,physics	1             0       irh    "IFSNOW"                        ""      ""
rconfig   integer ICLOUD                  namelist,physics	1             1       irh    "ICLOUD"                        ""      ""
rconfig   real    swrad_scat              namelist,physics	1             1       irh    "SWRAD_SCAT" "SCATTERING FACTOR IN SWRAD"      ""
rconfig   integer surface_input_source    namelist,physics	1             1       irh    "surface_input_source"          "1=static (fractional), 2=time dependent (dominant), 3=hybrid (not yet implemented)"      ""
rconfig   integer num_soil_layers         namelist,physics	1            10       irh    "num_soil_layers"               ""      ""
rconfig   integer num_months              namelist,physics      1            12       irh    "num_months"               ""      ""
rconfig   integer maxiens                 namelist,physics	1             1       irh    "maxiens"                    ""      ""
rconfig   integer maxens                  namelist,physics	1             3       irh    "maxens"                    ""      ""
rconfig   integer maxens2                 namelist,physics	1             3       irh    "maxens2"                    ""      ""
rconfig   integer maxens3                 namelist,physics	1            16       irh    "maxens3"                    ""      ""
rconfig   integer ensdim                  namelist,physics	1            144      irh    "ensdim"                    ""      ""
rconfig   integer cugd_avedx              namelist,physics      1            1      irh    "cugd_avedx"                    ""      ""
rconfig   integer clos_choice             namelist,physics      1             0       rh    "clos_choice"                    ""      ""
rconfig   integer imomentum               namelist,physics      1             0       rh    "imomentum"                    "momentum transport in G3 scheme"      ""
rconfig   integer     chem_opt            namelist,physics	max_domains    0       rh       "chem_opt"              ""      ""
rconfig   integer num_land_cat            namelist,physics	1            24       -      "num_land_cat"                  ""      ""
rconfig   integer num_soil_cat            namelist,physics	1            16       -      "num_soil_cat"                  ""      ""
rconfig   integer mp_zero_out             namelist,physics	1             0       -      "mp_zero_out"  "microphysics fields set to zero  0=no action taken, 1=all fields but Qv, 2=all fields including Qv"      "flag"
rconfig   real mp_zero_out_thresh         namelist,physics	1          1.e-8      -      "mp_zero_out_thresh"  "minimum threshold for non-Qv moist fields, below are set to zero"  "kg/kg"
rconfig   real    seaice_threshold        namelist,physics	1            271       h    "seaice_threshold"  "tsk below which which water points are set to sea ice for slab scheme"   "K"
rconfig   integer sst_update              namelist,physics	1            0         h    "sst_update"  "update sst from wrflowinp file  0=no, 1=yes"   ""
rconfig   integer ucmcall                 namelist,physics      max_domains  0         h    "ucmcall"     "activate urban model  0=no, 1=yes"   ""
rconfig   logical usemonalb               namelist,physics      1            .false.   h    "usemonalb"   "use 2d field vs table values  false=table, True=2d"   ""
rconfig   integer co2tf                   namelist,physics	1            1         -    "co2tf" "GFDL radiation co2 flag" ""
rconfig   integer ra_call_offset          namelist,physics	1            0         -    "ra_call_offset" "radiation call offset in timesteps (-1=old, 0=new offset)" ""
rconfig   real    cam_abs_freq_s          namelist,physics      1         21600.      -      "cam_abs_freq_s" "CAM radiation frequency for clear-sky longwave calculations" "s"
rconfig   integer levsiz                  namelist,physics      1             1       -      "levsiz" "Number of ozone data levels for CAM radiation (59)"  ""
rconfig   integer paerlev                 namelist,physics      1             1       -      "paerlev" "Number of aerosol data levels for CAM radiation (29)"  ""
rconfig   integer cam_abs_dim1            namelist,physics      1             1       -      "cam_abs_dim1" "dimension for absnxt in CAM radiation"  ""
rconfig   integer cam_abs_dim2            namelist,physics      1             1       -      "cam_abs_dim2" "dimension for abstot in CAM radiation"  ""
rconfig   logical cu_rad_feedback         namelist,physics      max_domains   .false.  -     "feedback cumulus to radiation"  ""
rconfig   integer pxlsm_smois_init           namelist,physics  max_domains   1       irh    "PXLSM_SMOIS_INIT"    "Soil moisture initialization option 0-From analysis 1-From MAVAIL"      ""
rconfig   integer omlcall                 namelist,physics      1            0         h     "omlcall"     "activate simple ocean mixed layer model  0=no, 1=yes"   ""
rconfig   real    oml_hml0                namelist,physics      1            50        h     "oml_hml0"    "oml initial mixed layer depth value"   "m"
rconfig   real    oml_gamma               namelist,physics      1            0.14      h     "oml_gamma"   "oml deep water lapse rate"   "K m-1"
rconfig   integer isftcflx                namelist,physics      1            0         h     "isftcflx"    "switch to control sfc fluxes"   ""
rconfig   real    shadlen                 namelist,physics      1            25000.    -     "shadow_length" "maximum length of orographic shadow" "m"
rconfig   integer slope_rad               namelist,physics      max_domains    0       -     "slope_rad"  "1: use slope-dependent radiation, 0:not" ""
rconfig   integer topo_shading            namelist,physics      max_domains    0       -     "topo_shading" "1: apply topographic shading to radiation, 0:not" ""
rconfig   integer no_mp_heating           namelist,physics      1              0       -     "no_mp_heating" "switch to turn of latent heating in mp schemes"   ""

#FDDA namelist parameters
rconfig   real    FGDT                    namelist,fdda         max_domains    0       h        "FGDT"          ""      ""
rconfig   integer  grid_fdda              namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   integer  if_no_pbl_nudging_uv   namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   integer  if_no_pbl_nudging_t    namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   integer  if_no_pbl_nudging_q    namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   integer  if_zfac_uv             namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   integer   k_zfac_uv             namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   integer  if_zfac_t              namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   integer   k_zfac_t              namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   integer  if_zfac_q              namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   integer   k_zfac_q              namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   real        guv                 namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   real        gt                  namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   real        gq                  namelist,fdda         max_domains    0       rh       "grid_fdda"            ""      ""
rconfig   real    dtramp_min              namelist,fdda         1              0       h        "grid_fdda"            ""      ""
rconfig   integer if_ramping              namelist,fdda         1              0       h        "grid_fdda"            ""      ""

#Observational Nudging
rconfig   integer     obs_nudge_opt       namelist,fdda            max_domains    0       rh       "obs_nudge_opt"     "Obs-nudging flag for domain"          ""
rconfig   integer     max_obs             namelist,fdda            1              0       h        "max_obs"           "Maximum number of observations"       ""
rconfig   real        fdda_start          namelist,fdda            max_domains    0       rh       "fdda_start"        "Nudging start time for domain"        "min"
rconfig   real        fdda_end            namelist,fdda            max_domains    0       rh       "fdda_end"          "Nudging end time for domain"          "min"
rconfig   integer     obs_nudge_wind      namelist,fdda            max_domains    0       rh       "obs_nudge_wind"    "Wind-nudging flag for domain"         ""
rconfig   real        obs_coef_wind       namelist,fdda            max_domains    0       rh       "obs_coef_wind"     "Wind-nudging coeficient for domain"   "s-1"
rconfig   integer     obs_nudge_temp      namelist,fdda            max_domains    0       rh       "obs_nudge_temp"    "Temperature-nudging flag for domain"  ""
rconfig   real        obs_coef_temp       namelist,fdda            max_domains    0       rh       "obs_coef_temp"     "Temperature-nudging coef for domain"  "s-1"
rconfig   integer     obs_nudge_mois      namelist,fdda            max_domains    0       rh       "obs_nudge_mois"    "Moisture-nudging flag for domain"     ""
rconfig   real        obs_coef_mois       namelist,fdda            max_domains    0       rh       "obs_coef_mois"     "Moisture-nudging coef for domain"     "s-1"
rconfig   integer     obs_nudge_pstr      namelist,fdda            max_domains    0       rh       "obs_nudge_pstr"    "Not used"                             ""
rconfig   real        obs_coef_pstr       namelist,fdda            max_domains    0       rh       "obs_coef_pstr"     "Not used"                             ""
rconfig   real        obs_rinxy           namelist,fdda            max_domains    0       rh       "obs_rinxy"         "Horizontal radius of influence"       "km"
rconfig   real        obs_rinsig          namelist,fdda            1              0       h        "obs_rinsig"        "Vertical radius of influence"         "sigma"
rconfig   real        obs_twindo          namelist,fdda            max_domains    0       rh       "obs_twindo"        "Half-period time window for nudging"  "hrs"
rconfig   integer     obs_npfi            namelist,fdda            1              0       h        "obs_npfi"          "Freq in cg timesteps for diag print"  ""
rconfig   integer     obs_ionf            namelist,fdda            max_domains    1       rh       "obs_ionf"          "Freq in cg timesteps for obs input and error calc"   ""
rconfig   integer     obs_idynin          namelist,fdda            1              0       h        "obs_idynin"        "Flag for dynamic initialization"      ""
rconfig   real        obs_dtramp          namelist,fdda            1              0       h        "obs_dtramp"        "Time period for ramping (idynin)"     "min"
rconfig   integer     obs_nobs_prt        namelist,fdda            max_domains    0       rh       "obs_nobs_prt"      "Number of current obs to print grid coord. info."   ""
rconfig   logical     obs_ipf_in4dob      namelist,fdda            1              .false. h        "obs_ipf_in4dob"    "Print obs input diagnostics"   ""
rconfig   logical     obs_ipf_errob       namelist,fdda            1              .false. h        "obs_ipf_errob"     "Print obs error diagnostics"   ""
rconfig   logical     obs_ipf_nudob       namelist,fdda            1              .false. h        "obs_ipf_nudob"     "Print obs nudge diagnostics"   ""
rconfig   logical     obs_ipf_init        namelist,fdda            1              .true.  h        "obs_ipf_init"      "Enable obs init warning messages"   ""


# Dynamics
# dynamics option (see package definitions, below)
rconfig   integer rk_ord                  namelist,dynamics	1             3       irh   "rk_order"               ""      ""
rconfig   integer w_damping               namelist,dynamics	1             0       irh    "w_damping"             ""      ""
# diff_opt 1=old diffusion, 2=new
rconfig   integer diff_opt                namelist,dynamics	1             1       irh    "diff_opt"              ""      ""
# km_opt   1=old coefs, 2=tke, 3=Smagorinksy
rconfig   integer km_opt                  namelist,dynamics	1             1       irh    "km_opt"                ""      ""
# km_opt_dfi is needed for backward integration in dfi
rconfig   integer km_opt_dfi              namelist,dynamics	1             1       irh    "km_opt_dfi"                ""      ""
rconfig   integer damp_opt                namelist,dynamics	1             0       irh    "damp_opt"              ""      ""
rconfig   real    zdamp                   namelist,dynamics	max_domains    5000.   h    "zdamp"         ""      ""
rconfig   real    dampcoef                namelist,dynamics     max_domains    0.      h    "dampcoef"              ""      ""
rconfig   real    khdif                   namelist,dynamics	max_domains    0       h    "khdif"         ""      ""
rconfig   real    kvdif                   namelist,dynamics	max_domains    0       h    "kvdif"         ""      ""
rconfig   real    diff_6th_factor         namelist,dynamics     max_domains    0.2     h    "diff_6th_factor" "factor that controls rate of 6th-order numerical diffusion"
rconfig   integer diff_6th_opt            namelist,dynamics     max_domains    2      irh   "diff_6th_opt" "switch for 6th-order numerical diffusion"
rconfig   real    c_s                     namelist,dynamics	max_domains    0.25    h    "c_s"         "Smagorinsky coeff"      ""
rconfig   real    c_k                     namelist,dynamics	max_domains    0.15    h    "c_k"         "TKE coeff"      ""
rconfig   real    smdiv                   namelist,dynamics	max_domains    0.1     h    "smdiv"         ""      ""
rconfig   real    emdiv                   namelist,dynamics	max_domains    0.01    h    "emdiv"         ""      ""
rconfig   real    epssm                   namelist,dynamics	max_domains    0.1     h    "epssm"         ""      ""
rconfig   logical non_hydrostatic         namelist,dynamics	max_domains  .true.   irh  "non_hydrostatic"    ""   ""
rconfig   integer time_step_sound         namelist,dynamics	max_domains    6       h     "time_step_sound"               ""      ""
rconfig   integer     h_mom_adv_order     namelist,dynamics	max_domains    5       rh       "h_mom_adv_order"               ""      ""
rconfig   integer     v_mom_adv_order     namelist,dynamics	max_domains    3       rh       "v_mom_adv_order"               ""      ""
rconfig   integer     h_sca_adv_order     namelist,dynamics	max_domains    5       rh       "h_sca_adv_order"               ""      ""
rconfig   integer     v_sca_adv_order     namelist,dynamics	max_domains    3       rh       "v_sca_adv_order"               ""      ""
rconfig   logical     pd_moist            namelist,dynamics	max_domains    .false.  rh    "pd_moist"         "positive-definite RK3 transport switch"      ""
rconfig   logical     pd_moist_dfi        namelist,dynamics	max_domains    .false.  rh    "pd_moist_dfi"    "positive-definite RK3 transport switch"      ""
rconfig   logical     pd_chem             namelist,dynamics	max_domains    .false. rh    "pd_chem"          "positive-definite RK3 transport switch"      ""
rconfig   logical     pd_scalar           namelist,dynamics	max_domains    .false. rh    "pd_scalar"        "positive-definite RK3 transport switch"      ""
rconfig   logical     pd_tke              namelist,dynamics	max_domains    .false. rh    "pd_tke"           "positive-definite RK3 transport switch"      ""
rconfig   logical top_radiation           namelist,dynamics	max_domains    .false. rh    "top_radiation"         ""      ""
rconfig   integer mix_isotropic           namelist,dynamics	max_domains    0       h    "mix_isotropic"            "0=anistropic, 1=isotropic"      ""
rconfig   real    mix_upper_bound         namelist,dynamics	max_domains    0.1     h    "mix_upper_bound"          "non-dimensional limit"      ""
rconfig   logical top_lid                 namelist,dynamics     max_domains    .false. rh    "top_lid"               ""      ""
rconfig   real    tke_upper_bound         namelist,dynamics	max_domains    1000.   h    "tke_upper_bound"            ""      ""
rconfig   real    tke_drag_coefficient    namelist,dynamics	max_domains    0.      h    "tke_drag_coefficient"       ""      "dimensionless"
rconfig   real    tke_heat_flux           namelist,dynamics	max_domains    0.      h    "tke_heat_flux"              ""      "K m s-1"
rconfig   logical pert_coriolis           namelist,dynamics	max_domains  .false.  irh  "pert_coriolis"    ""   ""
rconfig   logical coriolis2d              namelist,dynamics	max_domains  .false.  irh  "coriolis2d"    ""   ""
rconfig   logical mix_full_fields         namelist,dynamics     max_domains  .false.  irh  "mix_full_field"   ""   ""
rconfig   real    base_pres               namelist,dynamics	1          100000.     h    "base_pres"  "Base state pressure - do not change (10^5 Pa), real only"      "Pa"
rconfig   real    base_temp               namelist,dynamics	1             290.     h    "base_temp"  "Base state sea level temperature, real only"      "K"
rconfig   real    base_lapse              namelist,dynamics	1              50.     h    "base_lapse" "Base state temperature difference between base pres and 1/e of atm depth - do not change, real only"      "K"
rconfig   real    fft_filter_lat          namelist,dynamics     1              45.     h    "fft_filter_lat"   ""   "grid latitude to start polar filter"
rconfig   logical rotated_pole            namelist,dynamics     1            .false.  irh   "rotated_pole"    ""   ""
rconfig   logical do_coriolis             namelist,dynamics	max_domains  .true.   irh  "do_coriolis"    ""   ""
rconfig   logical do_curvature            namelist,dynamics	max_domains  .true.   irh  "do_curvature"   ""   ""
rconfig   logical do_gradp                namelist,dynamics	max_domains  .true.   irh  "do_gradp"    ""   ""


# Bdy_control
rconfig   integer spec_bdy_width          namelist,bdy_control		1             5       irh    "spec_bdy_width"                ""      ""
rconfig   integer spec_zone               namelist,bdy_control		1             1       irh    "spec_zone"                     ""      ""
rconfig   integer relax_zone              namelist,bdy_control		1             4       irh    "relax_zone"                    ""      ""
rconfig   logical specified               namelist,bdy_control	max_domains    .false. rh    "specified"             ""      ""
rconfig   logical periodic_x              namelist,bdy_control	max_domains    .false. rh    "periodic_x"            ""      ""
rconfig   logical symmetric_xs            namelist,bdy_control	max_domains    .false. rh    "symmetric_xs"          ""      ""
rconfig   logical symmetric_xe            namelist,bdy_control	max_domains    .false. rh    "symmetric_xe"          ""      ""
rconfig   logical open_xs                 namelist,bdy_control	max_domains    .false. rh    "open_xs"               ""      ""
rconfig   logical open_xe                 namelist,bdy_control	max_domains    .false. rh    "open_xe"               ""      ""
rconfig   logical periodic_y              namelist,bdy_control	max_domains    .false. rh    "periodic_y"            ""      ""
rconfig   logical symmetric_ys            namelist,bdy_control	max_domains    .false. rh    "symmetric_ys"          ""      ""
rconfig   logical symmetric_ye            namelist,bdy_control	max_domains    .false. rh    "symmetric_ye"          ""      ""
rconfig   logical open_ys                 namelist,bdy_control	max_domains    .false. rh    "open_ys"               ""      ""
rconfig   logical open_ye                 namelist,bdy_control	max_domains    .false. rh    "open_ye"               ""      ""
rconfig   logical polar                   namelist,bdy_control	max_domains    .false. rh    "polar"                 ""      ""
rconfig   logical nested                  namelist,bdy_control	max_domains    .false. rh    "nested"                ""      ""
rconfig   real    spec_exp                namelist,bdy_control          1     0.      irh    "spec_exp"              ""      ""
rconfig   integer real_data_init_type     namelist,bdy_control		1                 1    irh   "real_data_init_type"   "REAL DATA INITIALIZATION OPTIONS: 1=SI, 2=MM5, 3=GENERIC" "PRE-PROCESSOR TYPES"

rconfig   integer background_proc_id      namelist,grib2 	        1     255    rh    "background_proc_id"    "Background processing id for grib2"  ""
rconfig   integer forecast_proc_id        namelist,grib2 	        1     255    rh    "forecast_proc_id"      "Analysis and forecast processing id for grib2"  ""
rconfig   integer production_status       namelist,grib2 	        1     255    rh    "production_status"     "Background processing id for grib2"  ""
rconfig   integer compression             namelist,grib2 	        1      40    rh    "compression"           "grib2 compression, 40 for JPEG2000 or 41 for PNG"  ""

# NAMELIST DERIVED
rconfig   integer nobs_ndg_vars           derived                       1         5       -        "num_ndg_vars"         "Number of nudging variables"          ""
rconfig   integer nobs_err_flds           derived                       1         9       -        "num_err_flds"         "Number of error fields"               ""
rconfig   real    cen_lat                 derived                  max_domains    0       -        "cen_lat"              "center latitude"      "degrees, negative is south"
rconfig   real    cen_lon                 derived                  max_domains    0       -        "cen_lon"              "central longitude"      "degrees, negative is west"
rconfig   real    truelat1                derived                  max_domains    0       -        "true_lat1"             "first standard parallel"      "degrees, negative is south"
rconfig   real    truelat2                derived                  max_domains    0       -        "true_lat2"             "second standard parallel"      "degrees, negative is south"
rconfig   real    moad_cen_lat            derived                  max_domains    0       -        "moad_cen_lat"             "center latitude of the most coarse grid"      "degrees, negative is south"
rconfig   real    stand_lon               derived                  max_domains    0       -        "stand_lon"             "standard longitude, parallel to j-direction, perpendicular to i-direction "      "degrees, negative is west"
rconfig   real    bdyfrq                  derived                  max_domains    0       -        "bdyfrq"               "lateral boundary input frequency"      "seconds"
rconfig   integer iswater                 derived                  max_domains    0       -        "iswater"              "land use index of water"      "index category"
rconfig   integer isice                   derived                  max_domains    0       -        "isice"                "land use index of ice"        "index category"
rconfig   integer isurban                 derived                  max_domains    0       -        "isurban"              "land use index for 'urban and built-up"     "index category"
rconfig   integer isoilwater              derived                  max_domains    0       -        "isoilwater"           "land use index of water for soil"        "index category"
rconfig   integer map_proj                derived                  max_domains    0       -        "map_proj"             "domain map projection"      "0=none (Cylindrical), 1=Lambert, 2=polar, 3=Mercator"
rconfig   integer use_wps_input           derived                       1         0       -        "use_wps_input"        "0/1 flag, using wps input"      "0=no, 1=yes"
rconfig   integer dfi_stage               derived                       1         3       -        "dfi_stage"            "current stage of DFI processing"      "0=DFI setup, 1=DFI backward integration, 2=DFI forward integration, 3=WRF forecast"
rconfig   integer mp_physics_dfi          derived                  max_domains   -1       -        "mp_physics_dfi"       ""      "-1 = no DFI and so no need to allocate DFI moist and scalar variables, >0 = running with DFI, so allocate DFI moist and scalar variables appropriate for selected microphysics package"

#
# Single dummy declaration to define a nodyn dyn option
state integer nodyn_dummy - dyn_nodyn -  -  -  "" "" ""      

#
#---------------------------------------------------------------------------------------------------------------------------------------
# Package Declarations
#                                               

#key      package       associated                package          associated 4d scalars
#         name          namelist choice           state vars


##### MARS OPTIONS
##### MARS OPTIONS
##### MARS OPTIONS
##
## CHANGING THE OPTION CHANGE THE NUMBER OF TRACERS WITHOUT ANY NEED TO RECOMPILE ENTIRELY WRF
## HOWEVER, YOU STILL NEED TO RECOMPILE THE PHYSICS BEFORE CHANGING THE OPTION
## JUST USE THE COMPILE_ALL SCRIPT FOR A FAST RECOMPILATION 
## -------
## ONE REMAINING PROBLEM IS THE FACT THAT YOU NEED TO RECOMPILE
## ENTIRELY IF YOU DO NOT WANT TO OUTPUT THE TRACERS
## (FOR EXAMPLE, IF THEY ARE TURNED OFF ...)
## -------
##
##
package   nowater      mars==0                      -              moist:qv
package   water        mars==1                      -              moist:qv;scalar:qh2o,qh2o_ice
package   dust         mars==2                      -              moist:qv;scalar:qdust
##### MARS OPTIONS
##### MARS OPTIONS
##### MARS OPTIONS




#package   passivec1     chem_opt==0                  -             
package   passiveqv     mp_physics==0                -             moist:qv
package   kesslerscheme mp_physics==1                -             moist:qv,qc,qr
package   linscheme     mp_physics==2                -             moist:qv,qc,qr,qi,qs,qg
package   wsm3scheme    mp_physics==3                -             moist:qv,qc,qr
package   wsm5scheme    mp_physics==4                -             moist:qv,qc,qr,qi,qs
package   etampnew      mp_physics==5                -             moist:qv,qc,qr,qi,qs,qg;scalar:qt
package   wsm6scheme    mp_physics==6                -             moist:qv,qc,qr,qi,qs,qg
package   gsfcgcescheme mp_physics==7                -             moist:qv,qc,qr,qi,qs,qg
package   thompson       mp_physics==8               -             moist:qv,qc,qr,qi,qs,qg;scalar:qni
package   morr_two_moment  mp_physics==10            -             moist:qv,qc,qr,qi,qs,qg;scalar:qni,qns,qnr,qng

package   nodfimoist        mp_physics_dfi==-1       -             -
package   passiveqv_dfi     mp_physics_dfi==0        -             dfi_moist:dfi_qv
package   kesslerscheme_dfi mp_physics_dfi==1        -             dfi_moist:dfi_qv,dfi_qc,dfi_qr
package   linscheme_dfi     mp_physics_dfi==2        -             dfi_moist:dfi_qv,dfi_qc,dfi_qr,dfi_qi,dfi_qs,dfi_qg
package   wsm3scheme_dfi    mp_physics_dfi==3        -             dfi_moist:dfi_qv,dfi_qc,dfi_qr
package   wsm5scheme_dfi    mp_physics_dfi==4        -             dfi_moist:dfi_qv,dfi_qc,dfi_qr,dfi_qi,dfi_qs
package   etampnew_dfi      mp_physics_dfi==5        -             dfi_moist:dfi_qv,dfi_qc,dfi_qr,dfi_qi,dfi_qs,dfi_qg;dfi_scalar:dfi_qt
package   wsm6scheme_dfi    mp_physics_dfi==6        -             dfi_moist:dfi_qv,dfi_qc,dfi_qr,dfi_qi,dfi_qs,dfi_qg
package   gsfcgcescheme_dfi mp_physics_dfi==7        -             dfi_moist:dfi_qv,dfi_qc,dfi_qr,dfi_qi,dfi_qs,dfi_qg
package   thompson_dfi      mp_physics_dfi==8        -             dfi_moist:dfi_qv,dfi_qc,dfi_qr,dfi_qi,dfi_qs,dfi_qg;dfi_scalar:dfi_qni
package   morr_two_moment_dfi  mp_physics_dfi==10    -             dfi_moist:dfi_qv,dfi_qc,dfi_qr,dfi_qi,dfi_qs,dfi_qg;dfi_scalar:dfi_qni,dfi_qns,dfi_qnr,dfi_qng

package   noprogn       progn==0                     -             -
package   progndrop     progn==1                     -             scalar:qndrop;dfi_scalar:dfi_qndrop

package   rrtmscheme    ra_lw_physics==1             -             -
package   camlwscheme   ra_lw_physics==3             -             ozmixm:mth01,mth02,mth03,mth04,mth05,mth06,mth07,mth08,mth09,mth10,mth11,mth12;aerosolc:sul,sslt,dust1,dust2,dust3,dust4,ocpho,bcpho,ocphi,bcphi,bg,volc
package   gfdllwscheme  ra_lw_physics==99            -             -
package   heldsuarez    ra_lw_physics==31            -             -

package   swradscheme   ra_sw_physics==1             -             -
package   gsfcswscheme  ra_sw_physics==2             -             -
package   camswscheme   ra_sw_physics==3             -             ozmixm:mth01,mth02,mth03,mth04,mth05,mth06,mth07,mth08,mth09,mth10,mth11,mth12;aerosolc:sul,sslt,dust1,dust2,dust3,dust4,ocpho,bcpho,ocphi,bcphi,bg,volc
package   gfdlswscheme  ra_sw_physics==99            -             -

package   sfclayscheme   sf_sfclay_physics==1        -             state:regime
package   myjsfcscheme   sf_sfclay_physics==2        -             -
package   gfssfcscheme   sf_sfclay_physics==3        -             -
package   pxsfcscheme    sf_sfclay_physics==7        -             state:regime

package   slabscheme     sf_surface_physics==1       -             -
package   lsmscheme      sf_surface_physics==2       -             -
package   ruclsmscheme   sf_surface_physics==3       -             -
package   pxlsmscheme    sf_surface_physics==7       -             fdda2d:t2_ndg_new,q2_ndg_new,t2_ndg_old,q2_ndg_old

package   ysuscheme      bl_pbl_physics==1           -             state:regime
package   myjpblscheme   bl_pbl_physics==2           -             -
package   gfsscheme      bl_pbl_physics==3           -             -
package   acmpblscheme   bl_pbl_physics==7           -             state:regime
package   mrfscheme      bl_pbl_physics==99          -             state:regime

package   kfetascheme    cu_physics==1               -             -
package   bmjscheme      cu_physics==2               -             -
package   gdscheme       cu_physics==3               -             -
package   sasscheme      cu_physics==4               -             -
package   g3scheme       cu_physics==5               -             state:cugd_qvten,cugd_tten,cugd_qvtens,cugd_ttens,cugd_qcten
package   kfscheme       cu_physics==99              -             -

package   psufddagd      grid_fdda==1                -             fdda3d:u_ndg_old,v_ndg_old,t_ndg_old,q_ndg_old,ph_ndg_old,u_ndg_new,v_ndg_new,t_ndg_new,q_ndg_new,ph_ndg_new;fdda2d:mu_ndg_old,mu_ndg_new,t2_ndg_new,q2_ndg_new,t2_ndg_old,q2_ndg_old,sn_ndg_new,sn_ndg_old;state:rundgdten,rvndgdten,rthndgdten,rqvndgdten,rmundgdten

package   restofwrf      use_wps_input==0            -             -

package   dfi_setup      dfi_stage==0                -             -
package   dfi_bck        dfi_stage==1                -             -
package   dfi_fwd        dfi_stage==2                -             -
package   dfi_fst        dfi_stage==3                -             -

#package   digifilter     dfi_opt==1                  -             dfi_moist:dfi_qv,dfi_qc,dfi_qr,dfi_qi,dfi_qs,dfi_qg;dfi_scalar:dfi_qndrop,dfi_qni,dfi_qt,dfi_qns,dfi_qnr,dfi_qng;state:dfi_u,dfi_v,dfi_w,dfi_ph,dfi_phb,dfi_ph0,dfi_php,dfi_t,dfi_p,dfi_ww,dfi_mu,dfi_tke,dfi_pb,dfi_al,dfi_alt
package   dfi_nodfi     dfi_opt==0                  -             -
package   dfi_dfl       dfi_opt==1                  -             state:dfi_u,dfi_v,dfi_w,dfi_ph,dfi_phb,dfi_ph0,dfi_php,dfi_t,dfi_p,dfi_ww,dfi_mu,dfi_tke,dfi_pb,dfi_al,dfi_alt,dfi_TSLB,dfi_SMOIS,dfi_SNOW,dfi_SNOWH,dfi_CANWAT,dfi_SMFR3D,dfi_KEEPFR3DFLAG,dfi_TSK,dfi_SOILT1,dfi_TSNAV,dfi_SNOWC,dfi_QVG
package   dfi_ddfi      dfi_opt==2                  -             state:dfi_u,dfi_v,dfi_w,dfi_ph,dfi_phb,dfi_ph0,dfi_php,dfi_t,dfi_p,dfi_ww,dfi_mu,dfi_tke,dfi_pb,dfi_al,dfi_alt,dfi_TSLB,dfi_SMOIS,dfi_SNOW,dfi_SNOWH,dfi_CANWAT,dfi_SMFR3D,dfi_KEEPFR3DFLAG,dfi_TSK,dfi_SOILT1,dfi_TSNAV,dfi_SNOWC,dfi_QVG
package   dfi_tdfi      dfi_opt==3                  -             state:dfi_u,dfi_v,dfi_w,dfi_ph,dfi_phb,dfi_ph0,dfi_php,dfi_t,dfi_p,dfi_ww,dfi_mu,dfi_tke,dfi_pb,dfi_al,dfi_alt,dfi_TSLB,dfi_SMOIS,dfi_SNOW,dfi_SNOWH,dfi_CANWAT,dfi_SMFR3D,dfi_KEEPFR3DFLAG,dfi_TSK,dfi_SOILT1,dfi_TSNAV,dfi_SNOWC,dfi_QVG
ifdef RUC_CLOUD
package   realonly       use_wps_input==1            -             state:u_gc,v_gc,t_gc,rh_gc,ght_gc,p_gc,xlat_gc,xlong_gc,ht_gc,tsk_gc,tavgsfc,tmn_gc,pslv_gc,greenfrac,albedo12m,pd_gc,psfc_gc,intq_gc,pdhs,qv_gc,qr_gc,qc_gc,qs_gc,qi_gc,qg_gc,qni_gc
endif
ifndef RUC_CLOUD
package   realonly       use_wps_input==1            -             state:u_gc,v_gc,t_gc,rh_gc,ght_gc,p_gc,xlat_gc,xlong_gc,ht_gc,tsk_gc,tavgsfc,tmn_gc,pslv_gc,greenfrac,albedo12m,pd_gc,psfc_gc,intq_gc,pdhs,qv_gc
endif


# only need to specify these once; not for every io_form* variable
package   io_intio    io_form_restart==1                     -             -
package   io_netcdf   io_form_restart==2                     -             -
# Placeholders for additional packages (we can go beyond zzz
# but that will entail modifying frame/module_io.F and frame/md_calls.m4)
# Please note these are placeholders; HDF has not been implemented yet.
package   io_hdf      io_form_restart==3                     -             -
package   io_phdf5    io_form_restart==4                     -             -
package   io_grib1    io_form_restart==5                     -             -
package   io_mcel     io_form_restart==6                     -             -
package   io_esmf     io_form_restart==7                     -             -
package   io_yyy      io_form_restart==8                     -             -
package   io_zzz      io_form_restart==9                     -             -
package   io_grib2    io_form_restart==10                    -             -
package   io_pnetcdf  io_form_restart==11                     -             -
                                                
#---------------------------------------------------------------------------------------------------------------------------------------
## communications                                               

### 8. Edit the Registry file and create a halo-exchange for x_1.

# Halo Update Communications

halo      HALO_EM_INIT_1 dyn_em 48:u_1,u_2,v_1,v_2,w_1,w_2,ph_1,ph_2
halo      HALO_EM_INIT_2 dyn_em 48:t_1,t_2,mu_1,mu_2,tke_1,tke_2,ww,phb
halo      HALO_EM_INIT_3 dyn_em 48:ph0,php,t_init,mub,mu0,p,al,alt,alb
halo      HALO_EM_INIT_4 dyn_em 48:pb,h_diabatic,msftx,msfty,msfux,msfuy,msfvx,msfvy,msfvx_inv,f,e,sina,cosa,ht,potevp,snopcx,soiltb,xlat,xlong,xlat_u,xlat_v,xlong_u,xlong_v,clat,clong
halo      HALO_EM_INIT_5 dyn_em 48:moist,chem,scalar
halo      HALO_EM_VINTERP_UV_1 dyn_em 8:pd_gc,pb
halo      HALO_EM_A dyn_em  8:ru,rv,rw,ww,php,alt,al,p,muu,muv,mut
halo      HALO_EM_PHYS_A  dyn_em 4:u_2,v_2
halo      HALO_EM_PHYS_PBL dyn_em        4:rublten,rvblten
halo      HALO_EM_FDDA dyn_em            4:rundgdten,rvndgdten
halo      HALO_EM_PHYS_DIFFUSION dyn_em  4:defor11,defor22,defor12,defor13,defor23,div,xkmv,xkmh,xkhv,xkhh,tke_1,tke_2
halo      HALO_EM_TKE_ADVECT_3 dyn_em 24:tke_2
halo      HALO_EM_TKE_ADVECT_5 dyn_em 48:tke_2
halo      HALO_EM_TKE_A dyn_em 4:ph_2,phb
halo      HALO_EM_TKE_B dyn_em 4:z,rdz,rdzw,zx,zy
halo      HALO_EM_TKE_C dyn_em 8:u_2,v_2,z,zx,zy,rdz,rdzw,ustm
halo      HALO_EM_TKE_D dyn_em 8:defor11,defor22,defor33,defor12,defor13,defor23,div
halo      HALO_EM_TKE_E dyn_em 8:xkmv,xkmh,xkhv,xkhh,BN2,moist
halo      HALO_EM_TKE_3 dyn_em   24:tke_1,tke_2
halo      HALO_EM_TKE_5 dyn_em   48:tke_1,tke_2
halo      HALO_EM_TKE_7 dyn_em   80:tke_1,tke_2
halo      HALO_EM_TKE_F dyn_em   48:tke_1,tke_2
halo      HALO_EM_TKE_OLD_E_5 dyn_em   48:tke_1
halo      HALO_EM_TKE_OLD_E_7 dyn_em   80:tke_1
halo      HALO_EM_B dyn_em 4:ph_2,al,p,t_1,t_save,u_save,v_save,mu_1,mu_2,mudf,php,alt,pb
halo      HALO_EM_B2 dyn_em 4:ru_tend,rv_tend
halo      HALO_EM_C dyn_em    4:u_2,v_2
halo      HALO_EM_C2 dyn_em    4:ph_2,al,p,mu_2,muts,mudf
halo      HALO_EM_D dyn_em    24:ru_m,rv_m,ww_m,mut
halo      HALO_EM_D2_3 dyn_em 24:u_2,v_2,w_2,t_2,ph_2;24:moist,chem,scalar;4:mu_2,al
halo      HALO_EM_D2_5 dyn_em 48:u_2,v_2,w_2,t_2,ph_2;24:moist,chem,scalar;4:mu_2,al
halo      HALO_EM_D3_3 dyn_em 24:u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_1,ph_2,tke_1,tke_2,moist,chem,scalar;4:mu_1,mu_2
halo      HALO_EM_D3_5 dyn_em 48:u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_1,ph_2,tke_1,tke_2,moist,chem,scalar;4:mu_1,mu_2
halo      HALO_EM_E_3 dyn_em 24:u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_1,ph_2,tke_1,tke_2,;4:mu_1,mu_2
halo      HALO_EM_E_5 dyn_em 48:u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_1,ph_2,tke_1,tke_2,;4:mu_1,mu_2
halo      HALO_EM_MOIST_E_3 dyn_em 24:moist
halo      HALO_EM_MOIST_E_5 dyn_em 48:moist
halo      HALO_EM_MOIST_E_7 dyn_em 80:moist
halo      HALO_CUP_G3_IN dyn_em 24:RTHFTEN,RQVFTEN,w_2
halo      HALO_CUP_G3_OUT dyn_em 48:cugd_tten,cugd_qvten,cugd_ttens,cugd_qvtens,raincv
halo      HALO_EM_CHEM_E_3 dyn_em 24:chem
halo      HALO_EM_CHEM_E_5 dyn_em 48:chem
halo      HALO_EM_CHEM_E_7 dyn_em 80:chem
halo      HALO_EM_SCALAR_E_3 dyn_em 24:scalar
halo      HALO_EM_SCALAR_E_5 dyn_em 48:scalar
halo      HALO_EM_SCALAR_E_7 dyn_em 80:scalar
halo      HALO_TOPOSHAD phys 24:ht_shad

halo      HALO_EM_MOIST_OLD_E_3 dyn_em 24:moist_old
halo      HALO_EM_MOIST_OLD_E_5 dyn_em 48:moist_old
halo      HALO_EM_MOIST_OLD_E_7 dyn_em 80:moist_old
halo      HALO_EM_CHEM_OLD_E_3 dyn_em 24:chem_old
halo      HALO_EM_CHEM_OLD_E_5 dyn_em 48:chem_old
halo      HALO_EM_CHEM_OLD_E_7 dyn_em 80:chem_old
halo      HALO_EM_SCALAR_OLD_E_3 dyn_em 24:scalar_old
halo      HALO_EM_SCALAR_OLD_E_5 dyn_em 48:scalar_old
halo      HALO_EM_SCALAR_OLD_E_7 dyn_em 80:scalar_old

halo      HALO_EM_FEEDBACK   dyn_em 48:ht
halo      HALO_EM_HYDRO_UV   dyn_em 8:u_2,v_2

halo      HALO_EM_COUPLE_A   dyn_em 24:mub,mu_1,mu_2
period    PERIOD_EM_COUPLE_A dyn_em 2:mub,mu_1,mu_2
halo      HALO_EM_COUPLE_B   dyn_em 48:ph_1,ph_2,w_1,w_2,t_1,t_2,u_1,u_2,v_1,v_2,\
                                       moist,chem,scalar
period    PERIOD_EM_COUPLE_B dyn_em 3:ph_1,ph_2,w_1,w_2,t_1,t_2,u_1,u_2,v_1,v_2,\
                                       moist,chem,scalar

# For moving nests
halo      em_shift_halo_y  dyn_em 48:imask_nostag,imask_xstag,imask_ystag,imask_xystag,u_2,v_2,t_2
halo      em_shift_halo_x  dyn_em 48:imask_nostag,imask_xstag,imask_ystag,imask_xystag,u_2,v_2,t_2

# For observational nudging
halo      HALO_OBS_NUDGE dyn_em 24:pb,p,uratx,vratx,tratx

# Periodic Boundary Communications

period    PERIOD_BDY_EM_INIT dyn_em 3:u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_1,ph_2,t_init,phb,ph0,php,pb,al,alt,alb,mu_1,mu_2,mub,mu0,ht,msftx,msfty,msfux,msfuy,msfvx,msfvy,msfvx_inv,sina,cosa,e,f
period    PERIOD_BDY_EM_MOIST dyn_em 3:moist
period    PERIOD_BDY_EM_CHEM dyn_em 3:chem
period    PERIOD_BDY_EM_SCALAR dyn_em 3:scalar
period    PERIOD_BDY_EM_MOIST2 dyn_em 3:moist
period    PERIOD_BDY_EM_CHEM2 dyn_em 3:chem
period    PERIOD_BDY_EM_SCALAR2 dyn_em 3:scalar
period    PERIOD_BDY_EM_MOIST_OLD dyn_em 3:moist_old
period    PERIOD_BDY_EM_CHEM_OLD dyn_em 3:chem_old
period    PERIOD_BDY_EM_SCALAR_OLD dyn_em 3:scalar_old
period    PERIOD_BDY_EM_TKE_OLD dyn_em 3:tke_1
period    PERIOD_EM_HYDRO_UV dyn_em 1:u_2,v_2
period    PERIOD_BDY_EM_A dyn_em 2:ru,rv,rw,ww,php,alt,p,muu,muv,mut,ph_2,al
period    PERIOD_BDY_EM_A1  dyn_em 3:rdzw,rdz,z,zx,zy,ustm
period    PERIOD_BDY_EM_PHY_BC dyn_em 2:rublten,rvblten,xkmh,xkmv,xkhh,xkhv,div,defor11,defor22,defor12,defor13,defor23,defor33,tke_2
period    PERIOD_BDY_EM_FDDA_BC dyn_em 2:rundgdten,rvndgdten
period    PERIOD_BDY_EM_B dyn_em 2:ru_tend,rv_tend,ph_2,al,p,t_1,t_save,u_save,v_save,mu_1,mu_2,mudf,php,alt,pb
period    PERIOD_BDY_EM_B3 dyn_em 2:ph_2,al,p,mu_2,muts,mudf
period    PERIOD_BDY_EM_B2 dyn_em 2:ru_tend,rv_tend
period    PERIOD_BDY_EM_C dyn_em 2:u_2,u_save,v_2,v_save,t_2,t_save,muv,msfvx,msfvy,muu,msfux,msfuy,msfvx_inv
period    PERIOD_BDY_EM_D dyn_em 3:u_2,v_2,w_2,t_2,ph_2,mu_2,tke_2
period    PERIOD_BDY_EM_D3 dyn_em 3:u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_1,ph_2,tke_1,tke_2,mu_1,mu_2

#
#swap SWAP_ETAMP_NEW  dyn_em 1:dz8w,p_phy,pi_phy,rho,th_phy,moist,F_ICE_PHY,F_RAIN_PHY,F_RIMEF_PHY,RAINNC,RAINNCV,SR,LOWLYR
#swap SWAP_WSM3       dyn_em 1:th_phy,moist,w_2,rho,pi_phy,p_phy,dz8w,rainnc,rainncv
#cycle CYCLE_TEST       dyn_em 1:xlong

##

# FDDA (Observational-nudging) Variables
typedef fdob_type integer domain_tot   # total number of domains to apply obs-nudging
typedef fdob_type integer IEODI        # end of obs data flag for current model step
typedef fdob_type integer IWTSIG       # flag for nudging on pressure surfaces
typedef fdob_type integer NSTAT        # number of obs stations used to nudge current model step
typedef fdob_type integer NSTAW        # number of obs stations within current time window
typedef fdob_type integer KTAUR        # restart model step
typedef fdob_type integer SN_MAXCG     # coarse domain grid dimension in south-north coordinate
typedef fdob_type integer WE_MAXCG     # coarse domain grid dimension in west-east coordinate
typedef fdob_type integer SN_END       # ending north-south grid index
typedef fdob_type integer LEVIDN(max_domains)   # level of nest
typedef fdob_type real    WINDOW       # time window half-period for nudging (in minutes) 
typedef fdob_type real    RTLAST       # time in hours of last obs used in current model step
typedef fdob_type real    DATEND       # time in minutes after which data are asuumed to have ended
typedef fdob_type real    RINFMN       # minimum radius of influence
typedef fdob_type real    RINFMX       # maximum radius of influence
typedef fdob_type real    PFREE        # pressure level (cb) where terrain effect becomes small
typedef fdob_type real    DCON         # 1/DPSMX
typedef fdob_type real    DPSMX        # max pres change (cb) allowed within infl range of surf obs 
typedef fdob_type real    TFACI        # scale factor used for ramp-down in dynamic initialization
typedef fdob_type real    KNOWN_LAT    # Latitude  of origin point (i,j)=(1,1)
typedef fdob_type real    KNOWN_LON    # Longitude of origin point (i,j)=(1,1)

# table entries are of the form
#      <Table>  <Type>  <Sym>                <Dims>   <Use>   <NumTLev> <Stagger> <IO>     <DNAME>             <DESCRIP>     <UNITS>
#Grid variables
typedef fdob_type real    varobs               rz       -         1        -       -       "varobs"          "observational values in each variable"
typedef fdob_type real    errf                 hz       -         1        -       -       "errf"            "errors between model and obs values"
typedef fdob_type real    timeob               z        -         1        -       -       "timeob"          "model times for each observation"          "hours"
typedef fdob_type real    nlevs_ob             z        -         1        -       -       "nlevs_ob"        "numbers of levels in sounding obs"
typedef fdob_type real    lev_in_ob            z        -         1        -       -       "lev_in_ob"       "level in sounding-type obs"
typedef fdob_type real    plfo                 z        -         1        -       -       "plfo"            "index for type of obs-platform"
typedef fdob_type real    elevob               z        -         1        -       -       "elevob"          "elevation of observation"                  "meters"
typedef fdob_type real    rio                  z        -         1        -       -       "rio"             "west-east grid coordinate"
typedef fdob_type real    rjo                  z        -         1        -       -       "rjo"             "south-north grid coordinate"
typedef fdob_type real    rko                  z        -         1        -       -       "rko"             "vertical grid coordinate"

state fdob_type fdob - -

# xpose variables for polar fft
state    real   t_xxx          ikjx    -           1        -
state    real   u_xxx          ikjx    -           1        X
state    real   ru_xxx         ikjx    -           1        X
state    real   v_xxx          ikjx    -           1        Y
state    real   rv_xxx         ikjx    -           1        Y
state    real   w_xxx          ikjx    -           1        Z
state    real   ww_xxx         ikjx    -           1        Z
state    real   ph_xxx         ikjx    -           1        Z
state    real   dum_yyy        ikjy    -           1        -
state    real   fourd_xxx      ikjx    -           1        -
state    real   clat_xxx       ijx     -           1        -
state    real   ht_xxx         ijx     -           1        -
state    real   mf_xxx         ijx     -           1        -

xpose XPOSE_POLAR_FILTER_TOPO dyn_em t_init,t_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_T  dyn_em t_2,t_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_U  dyn_em u_2,u_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_RU dyn_em ru_m,ru_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_V  dyn_em v_2,v_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_RV dyn_em rv_m,rv_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_W  dyn_em w_2,w_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_WW dyn_em ww_m,ww_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_PH dyn_em ph_2,ph_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_MOIST dyn_em moist,fourd_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_CHEM dyn_em chem,fourd_xxx,dum_yyy
xpose XPOSE_POLAR_FILTER_SCALAR dyn_em scalar,fourd_xxx,dum_yyy

##
