      subroutine bilinearbig(x_arr,y_arr,f2d_arr,x_in,y_in,f,a)

!     Necessary for interpolation of continuum data
!     optimized by A. Spiga 01/2013 

      implicit none

      integer nX,nY,i,j,a,b
      parameter(nX=2428)
      parameter(nY=10)

      real*8 x_in,y_in,x1,x2,y1,y2
      real*8 f,f11,f12,f21,f22,fA,fB
      real*8 x_arr(nX)
      real*8 y_arr(nY)
      real*8 f2d_arr(nX,nY)
      real*8,save :: x,y

      integer strlen
      character*100 label
      label='subroutine bilinear'

      x=x_in
      y=y_in


   !! AS: important to optimize here because the array is quite large
   !! ... and actually calculations only need to be done once
   !! --> Case 1 : we have not calculated yet
   if ( a == -9999) then
      !1st check we're within the wavenumber range
      if ((x.lt.x_arr(2)).or.(x.gt.x_arr(nX-2))) then
         f=0.0D+0
         a=-1
      else
        i=1
        x2=x_arr(i)
        do while ( x2 .le. x )
          x1=x2
          i=i+1
          x2=x_arr(i)
          a=i-1
        end do
      endif
   !! --> case 2 : we already saw we are out of wavenumber range
   else if ( a == -1) then 
      f=0.0D+0
      return
   !! --> case 3 : we already determined a -- so we just proceed
   else
      x1=x_arr(a)
      x2=x_arr(a+1)
   endif

!     ... and for y within the temperature range
      if ((y.lt.y_arr(1)).or.(y.gt.y_arr(nY))) then
         write(*,*) 'Warning from bilinearH2H2:'
         write(*,*) 'Outside continuum temperature range!'
         if(y.lt.y_arr(1))then
            y=y_arr(1)+0.01
         endif
         if(y.gt.y_arr(nY))then
            y=y_arr(nY)-0.01
         endif
      else
        j=1
        y2=y_arr(j)
        do while ( y2 .le. y )
          y1=y2
          j=j+1
          y2=y_arr(j)
          b=j-1
        end do
      endif

      f11=f2d_arr(a,b)
      f21=f2d_arr(a+1,b)
      f12=f2d_arr(a,b+1)
      f22=f2d_arr(a+1,b+1)

      call bilinear(f,f11,f21,f12,f22,x,x1,x2,y,y1,y2)

      return
    end subroutine bilinearbig
