      SUBROUTINE surfini(ngrid,nq,qsurf,psolaralb)

      USE surfdat_h
      USE tracer_h

      IMPLICIT NONE
c=======================================================================
c
c   creation des calottes pour l'etat initial
c
c=======================================================================
c-----------------------------------------------------------------------
c   Declarations:
c   -------------
#include "dimensions.h"
#include "dimphys.h"
#include "callkeys.h"
c
      INTEGER ngrid,ig,icap
      INTEGER nq
      REAL  piceco2(ngrid),psolaralb(ngrid)
      REAL qsurf(ngrid,nq) !tracer on surface (kg/m2)

      EXTERNAL ISMIN,ISMAX
      INTEGER ISMIN,ISMAX
c
c=======================================================================

c
c     calcul de piceco2 (kg/m2) a l'etat initial
c     ------------------------------------------

      DO ig=1,ngrid
         psolaralb(ig)=albedodat(ig)
!         psolaralb(ig,2)=albedodat(ig)
      ENDDO

      PRINT*,'surfini: minimum des donnees albedo',
     s     albedodat(ISMIN(ngrid,albedodat,1))
      PRINT*,'surfini: maximum des donnees albedo',
     s     albedodat(ISMAX(ngrid,albedodat,1))

c      calcul de psolaralb 
c      -------------------
!      DO ig=1,ngrid
c	 IF (water) THEN 
c	   if (qsurf(ig,nq).gt.0.005) then
c             psolaralb(ig,1) = 0.4
c             psolaralb(ig,2) = 0.4 
c           endif 
c         ENDIF
!      ENDDO ! of DO ig=1,ngrid     
c IF there is more than 5 pr. um of h2o ice but no C02 ice, surface albedo is set to 0.4. 

      if (igcm_co2_ice.ne.0) then
! Change Albedo if there is CO2 ice on the surface
        DO ig=1,ngrid
          IF (qsurf(ig,igcm_co2_ice) .GT. 0.) THEN
             !!!! no good in parallel
             IF(ig.GT.ngrid/2+1) THEN
                icap=2
             ELSE
                icap=1
             ENDIF
             psolaralb(ig) = albedice(icap)
!             psolaralb(ig,2) =  albedice(icap)
          END IF
        ENDDO ! of DO ig=1,ngrid     
      else
        write(*,*) "surfini: No CO2 ice tracer on surface  ..."
        write(*,*) "         and therefore no albedo change."
      endif

      PRINT*,'surfini: minimum des donnees albedo',
     s     psolaralb(ISMIN(ngrid,psolaralb,1))
      PRINT*,'surfini: maximum des donnees albedo',
     s     psolaralb(ISMAX(ngrid,psolaralb,1))

      RETURN
      END
