      SUBROUTINE FLOTT_GWD_RAN(NLON,NLEV,DTIME, pp, pn2,  &
                  tt,uu,vv,zustr,zvstr,d_t, d_u, d_v)

    !----------------------------------------------------------------------
    ! Parametrization of the momentum flux deposition due to a discrete
    ! number of gravity waves. 
    ! F. Lott (version 9: 16 February, 2012), reproduce v3 but with only
    !         two waves present at each time step
    ! LMDz model online version      
    ! ADAPTED FOR VENUS
    !---------------------------------------------------------------------

      use dimphy
      implicit none

#include "dimensions.h"
#include "paramet.h"

#include "YOEGWD.h"
#include "YOMCST.h"

    ! 0. DECLARATIONS:

    ! 0.1 INPUTS
    INTEGER, intent(in):: NLON, NLEV 
    REAL, intent(in):: DTIME ! Time step of the Physics
    REAL, intent(in):: pp(NLON, NLEV)   ! Pressure at full levels
! VENUS ATTENTION: CP VARIABLE PN2 CALCULE EN AMONT DES PARAMETRISATIONS
    REAL, intent(in):: pn2(NLON,NLEV)   ! N2 (BV^2) at 1/2 levels
    REAL, intent(in):: TT(NLON, NLEV)   ! Temp at full levels 

    REAL, intent(in):: UU(NLON, NLEV) , VV(NLON, NLEV)
    ! Hor winds at full levels

    ! 0.2 OUTPUTS
    REAL, intent(out):: zustr(NLON), zvstr(NLON) ! Surface Stresses
    REAL, intent(inout):: d_t(NLON, NLEV)        ! Tendency on Temp.

    REAL, intent(inout):: d_u(NLON, NLEV), d_v(NLON, NLEV)
    ! Tendencies on winds

    ! O.3 INTERNAL ARRAYS

    INTEGER II, LL, IEQ

    ! 0.3.0 TIME SCALE OF THE LIFE CYCLE OF THE WAVES PARAMETERIZED

    REAL DELTAT

    ! 0.3.1 GRAVITY-WAVES SPECIFICATIONS

!VENUS INTEGER, PARAMETER:: NK = 4, NP = 4, NO = 4, NW = NK * NP * NO
    !Online output: change NO
    INTEGER, PARAMETER:: NK = 1, NP = 2, NO = 10, NW = NK * NP * NO
    INTEGER JK, JP, JO, JW
    REAL KMIN, KMAX ! Min and Max horizontal wavenumbers
    REAL CMIN, CMAX ! Min and Max absolute ph. vel.
    REAL CPHA ! absolute PHASE VELOCITY frequency
    REAL ZK(NW, KLON) ! Horizontal wavenumber amplitude
    REAL ZP(NW)       ! Horizontal wavenumber angle        
    REAL ZO(NW, KLON) ! Absolute frequency      !

    ! Waves Intr. freq. at the 1/2 lev surrounding the full level
    REAL ZOM(NW, KLON), ZOP(NW, KLON)

    ! Wave vertical velocities at the 2 1/2 lev surrounding the full level
    REAL WWM(NW, KLON), WWP(NW, KLON)

    REAL RUW0(NW, KLON) ! Fluxes at launching level

    REAL RUWP(NW, KLON), RVWP(NW, KLON)
    ! Fluxes X and Y for each waves at 1/2 Levels

    INTEGER LAUNCH   ! Launching altitude

    REAL RUWMAX,SAT  ! saturation parameter
    REAL XLAUNCH     ! Controle the launching altitude
    REAL RUW(KLON, KLEV + 1) ! Flux x at semi levels
    REAL RVW(KLON, KLEV + 1) ! Flux y at semi levels

    ! 0.3.2 PARAMETERS OF WAVES DISSIPATIONS

    REAL RDISS, ZOISEC ! COEFF DE DISSIPATION, SECURITY FOR INTRINSIC FREQ

    ! 0.3.3 BACKGROUND FLOW AT 1/2 LEVELS AND VERTICAL COORDINATE

    REAL H0(KLON, KLEV)     ! Characteristic Height of the atmosphere
    REAL PR ! Reference Pressure 

    REAL ZH(KLON, KLEV + 1) ! Log-pressure altitude

    REAL UH(KLON, KLEV + 1), VH(KLON, KLEV + 1) ! Winds at 1/2 levels
    REAL PH(KLON, KLEV + 1) ! Pressure at 1/2 levels
    REAL PSEC ! Security to avoid division by 0 pressure
    REAL BV(KLON, KLEV + 1) ! Brunt Vaisala freq. (BVF) at 1/2 levels
    REAL BVSEC ! Security to avoid negative BVF

! COSMETICS TO DIAGNOSE EACH WAVES CONTRIBUTION.
    logical output
    data output/.false./
  ! CAUTION ! IF output is .true. THEN change NO to 10 at least !
    character*14 outform
    character*2  str2

! ON CONSERVE LA MEMOIRE un certain temps AVEC UN SAVE
    real,save,allocatable :: d_u_sav(:,:),d_v_sav(:,:)
    LOGICAL firstcall
    SAVE firstcall
    DATA firstcall/.true./

    !-----------------------------------------------------------------
    !  1. INITIALISATIONS

      IF (firstcall) THEN
        allocate(d_u_sav(NLON,NLEV),d_v_sav(NLON,NLEV))
        firstcall=.false.
      ENDIF
    
    !    1.1 Basic parameter

    !  PARAMETERS CORRESPONDING TO V3:
    RUWMAX = 0.005      ! Max EP-Flux at Launch altitude
    SAT    = 0.85       ! Saturation parameter: Sc in (12)
    RDISS  = 10.        ! Diffusion parameter 

    DELTAT=24.*3600.    ! Time scale of the waves (first introduced in 9b)

    KMIN = 1.E-6        ! Min horizontal wavenumber
    KMAX = 2.E-5        ! Max horizontal wavenumber
    !Online output: one value only
    if (output) then
      KMIN = 1.3E-5
      KMAX = 1.3E-5
    endif
    CMIN = 1.           ! Min phase velocity
    CMAX = 60.          ! Max phase speed velocity
    XLAUNCH=0.6         ! Parameter that control launching altitude

    PR = 9.2e6          ! Reference pressure    ! VENUS!!

    BVSEC  = 1.E-5      ! Security to avoid negative BVF  
    PSEC   = 1.E-6      ! Security to avoid division by 0 pressure
    ZOISEC = 1.E-6      ! Security FOR 0 INTRINSIC FREQ

    IF(DELTAT.LT.DTIME)THEN
       PRINT *,'GWD RANDO: DELTAT LT DTIME!'
       STOP
    ENDIF


    IF (NLEV < NW) THEN
       PRINT *, 'YOU WILL HAVE PROBLEM WITH RANDOM NUMBERS'
       PRINT *, 'FLOTT GWD STOP'
       STOP 1
    ENDIF

    ! 1.2 WAVES CHARACTERISTICS CHOSEN RANDOMLY
    !-------------------------------------------

    ! The mod function of here a weird arguments
    ! are used to produce the waves characteristics
    ! in a stochastic way

    JW = 0
    DO JP = 1, NP
       DO JK = 1, NK
          DO JO = 1, NO
             JW = JW + 1
             !  Angle
             ZP(JW) = 2. * RPI * REAL(JP - 1) / REAL(NP) 
             DO II = 1, KLON
                ! Horizontal wavenumber amplitude
                ZK(JW, II) = KMIN + (KMAX - KMIN) * MOD(TT(II, JW) * 100., 1.)
                ! Horizontal phase speed
                CPHA = CMIN + (CMAX - CMIN) * MOD(TT(II, JW)**2, 1.)
       !Online output: linear
                if (output) CPHA = CMIN + (CMAX - CMIN) * JO/NO
                ! Intrinsic frequency
                ZO(JW, II) = CPHA * ZK(JW, II)
                ! Momentum flux at launch lev 
                ! RUW0(JW, II) = RUWMAX / REAL(NW) &
                RUW0(JW, II) = RUWMAX &
                     * MOD(100. * (UU(II, JW)**2 + VV(II, JW)**2), 1.)
             ENDDO
          end DO
       end DO
    end DO

    !  2. EVALUATION OF THE BACKGROUND FLOW AT SEMI-LEVELS
    !-------------------------------------------------------------

    IEQ = KLON / 2
    !Online output
    if (output) OPEN(11,file="impact-gwno.dat")

    ! Pressure and Inv of pressure, Temperature / at 1/2 level
    DO LL = 2, KLEV
       PH(:, LL) = EXP((LOG(PP(:, LL)) + LOG(PP(:, LL - 1))) / 2.)
    end DO

    PH(:, KLEV + 1) = 0. 
    PH(:, 1) = 2. * PP(:, 1) - PH(:, 2)

    ! Launching altitude

    DO LL = 1, NLEV
       IF (PH(IEQ, LL) / PH(IEQ, 1) > XLAUNCH) LAUNCH = LL
    ENDDO

    ! Log pressure vert. coordinate (altitude above surface) 
    ZH(:,1) = 0.    
    DO LL = 2, KLEV + 1 
       H0(:, LL-1) = RD * TT(:, LL-1) / RG 
       ZH(:, LL) = ZH(:, LL-1) + H0(:, LL-1)*(PH(:, LL-1)-PH(:,LL))/PP(:, LL-1)
    end DO

    ! Winds and BV frequency
    DO LL = 2, KLEV
       UH(:, LL) = 0.5 * (UU(:, LL) + UU(:, LL - 1)) ! Zonal wind
       VH(:, LL) = 0.5 * (VV(:, LL) + VV(:, LL - 1)) ! Meridional wind
       ! BVSEC: BV Frequency
! VENUS ATTENTION: CP VARIABLE PSTAB CALCULE EN AMONT DES PARAMETRISATIONS
       BV(:, LL) = SQRT(MAX(BVSEC,pn2(:,LL)))
    end DO
    BV(:, 1) = BV(:, 2)
    UH(:, 1) = 0.
    VH(:, 1) = 0.
    BV(:, KLEV + 1) = BV(:, KLEV)
    UH(:, KLEV + 1) = UU(:, KLEV)
    VH(:, KLEV + 1) = VV(:, KLEV)


    ! 3. COMPUTE THE FLUXES
    !--------------------------

    !  3.1  Vertical velocity at launching altitude to ensure 
    !       the correct value to the imposed fluxes.
    !
    DO JW = 1, NW

       ! Evaluate intrinsic frequency at launching altitude:
       ZOP(JW, :) = ZO(JW, :) &
            - ZK(JW, :) * COS(ZP(JW)) * UH(:, LAUNCH) &
            - ZK(JW, :) * SIN(ZP(JW)) * VH(:, LAUNCH) 
       ! Vertical velocity at launch level, value to ensure the imposed
       ! mom flux:
       WWP(JW, :) = SQRT(ABS(ZOP(JW, :)) / MAX(BV(:, LAUNCH),BVSEC) &
            * RUW0(JW,:))
       RUWP(JW, :) = COS(ZP(JW)) * SIGN(1., ZOP(JW, :)) * RUW0(JW, :)
       RVWP(JW, :) = SIN(ZP(JW)) * SIGN(1., ZOP(JW, :)) * RUW0(JW, :)

    end DO

    !  3.2 Uniform values below the launching altitude

    DO LL = 1, LAUNCH
       RUW(:, LL) = 0
       RVW(:, LL) = 0
       DO JW = 1, NW
          RUW(:, LL) = RUW(:, LL) + RUWP(JW, :)
          RVW(:, LL) = RVW(:, LL) + RVWP(JW, :)
       end DO
    end DO

    !  3.3 Loop over altitudes, with passage from one level to the
    !      next done by i) conserving the EP flux, ii) dissipating
    !      a little, iii) testing critical levels, and vi) testing
    !      the breaking.

    !Online output
    write(str2,'(i2)') NW+1
    outform="("//str2//"(E12.4,1X))"
    if (output) WRITE(11,outform) ZH(IEQ, 1) / 1000., (ZO(JW, IEQ)/ZK(JW, IEQ)*COS(ZP(JW)), JW = 1, NW)

    DO LL = LAUNCH, KLEV - 1


       !  W(KB)ARNING: ALL THE PHYSICS IS HERE (PASSAGE FROM ONE LEVEL
       ! TO THE NEXT)
       DO JW = 1, NW
          ZOM(JW, :) = ZOP(JW, :)
          WWM(JW, :) = WWP(JW, :)
          ! Intrinsic Frequency
          ZOP(JW, :) = ZO(JW, :) - ZK(JW, :) * COS(ZP(JW)) * UH(:, LL + 1) &
               - ZK(JW, :) * SIN(ZP(JW)) * VH(:, LL + 1) 

          WWP(JW, :) = MIN( & 
               ! No breaking (Eq.6)
               WWM(JW, :) & 
               * SQRT(BV(:, LL ) / BV(:, LL+1) &
               * ABS(ZOP(JW, :)) / MAX(ABS(ZOM(JW, :)), ZOISEC)) &
               ! Dissipation (Eq. 8):
               * EXP(- RDISS * PR / (PH(:, LL + 1) + PH(:, LL)) &
               * ((BV(:, LL + 1) + BV(:, LL)) / 2.)**3 &
               / MAX(ABS(ZOP(JW, :) + ZOM(JW, :)) / 2., ZOISEC)**4 &
               * ZK(JW, :)**3 * (ZH(:, LL + 1) - ZH(:, LL))), &
               ! Critical levels (forced to zero if intrinsic
               ! frequency changes sign)
               MAX(0., SIGN(1., ZOP(JW, :) * ZOM(JW, :))) &
               ! Saturation (Eq. 12)
               * ZOP(JW, :)**2 / ZK(JW, :)/BV(:, LL+1) & 
               * EXP(-ZH(:, LL + 1)/2./H0(:,LL)) * SAT)
       end DO

       ! END OF W(KB)ARNING
       ! Evaluate EP-flux from Eq. 7 and 
       ! Give the right orientation to the stress

       DO JW = 1, NW
          RUWP(JW, :) = ZOP(JW, :)/MAX(ABS(ZOP(JW, :)), ZOISEC)**2 &
               *BV(:,LL+1)&
               * COS(ZP(JW)) *  MAX(WWP(JW, :),1e-30)**2
          RVWP(JW, :) = ZOP(JW, :)/MAX(ABS(ZOP(JW, :)), ZOISEC)**2 &
               *BV(:,LL+1)&
               * SIN(ZP(JW)) *  MAX(WWP(JW, :),1e-30)**2
       end DO
       !
       RUW(:, LL + 1) = 0.
       RVW(:, LL + 1) = 0.

       DO JW = 1, NW
          RUW(:, LL + 1) = RUW(:, LL + 1) + RUWP(JW, :) 
          RVW(:, LL + 1) = RVW(:, LL + 1) + RVWP(JW, :) 
       end DO
       !Online output
        if (output)  WRITE(11,outform) ZH(IEQ, LL + 1) / 1000., (RUWP(JW, IEQ), JW = 1, NW)

    end DO

    !Online output
    if (output) then 
       CLOSE(11)
       stop
    endif

    ! 4 CALCUL DES TENDANCES:
    !------------------------

    ! 4.1 Rectification des flux au sommet et dans les basses couches:

    RUW(:, KLEV + 1) = 0.
    RVW(:, KLEV + 1) = 0.
    RUW(:, 1) = RUW(:, LAUNCH)
    RVW(:, 1) = RVW(:, LAUNCH)
    DO LL = 2, LAUNCH
       RUW(:, LL) = RUW(:, LL - 1) + (RUW(:, LAUNCH + 1) - RUW(:, 1)) * &
            (PH(:, LL) - PH(:, LL - 1)) / (PH(:, LAUNCH + 1) - PH(:, 1))
       RVW(:, LL) = RVW(:, LL - 1) + (RVW(:, LAUNCH + 1) - RVW(:, 1)) * &
            (PH(:, LL) - PH(:, LL - 1)) / (PH(:, LAUNCH + 1) - PH(:, 1))
    end DO

    ! AR-1 RECURSIVE FORMULA (13) IN VERSION 4
    DO LL = 1, KLEV
       d_u(:, LL) = RG * (RUW(:, LL + 1) - RUW(:, LL)) &
            / (PH(:, LL + 1) - PH(:, LL)) * DTIME
       d_v(:, LL) = RG * (RVW(:, LL + 1) - RVW(:, LL)) &
            / (PH(:, LL + 1) - PH(:, LL)) * DTIME
    ENDDO
    ! ON CONSERVE LA MEMOIRE un certain temps AVEC UN SAVE
        d_u = DTIME/DELTAT/REAL(NW) * d_u + (1.-DTIME/DELTAT) * d_u_sav
        d_v = DTIME/DELTAT/REAL(NW) * d_v + (1.-DTIME/DELTAT) * d_v_sav
	d_u_sav = d_u
	d_v_sav = d_v

    ! Cosmetic: evaluation of the cumulated stress

    ZUSTR(:) = 0.
    ZVSTR(:) = 0.
    DO LL = 1, KLEV
       ZUSTR(:) = ZUSTR(:) + D_U(:, LL) / RG * (PH(:, LL + 1) - PH(:, LL))
       ZVSTR(:) = ZVSTR(:) + D_V(:, LL) / RG * (PH(:, LL + 1) - PH(:, LL))
    ENDDO

  END SUBROUTINE FLOTT_GWD_RAN
