      subroutine thermcell_dqup(ngrid,nlayer,ptimestep,fm0,entr0,  &
     &    alpha,masse0,q_therm,dq_therm,charvar,zdz)
      implicit none

! #include "iniprint.h"
!=======================================================================
!
!   Calcul du transport verticale dans la couche limite en presence
!   de "thermiques" explicitement representes
!   calcul du dq/dt une fois qu'on connait les ascendances
!   Version modifiee pour prendre les downdrafts a la place de la 
!   subsidence compensatoire
!=======================================================================

#include "dimensions.h"
#include "dimphys.h"

! ============================ INPUTS ============================

      INTEGER, INTENT(IN) :: ngrid,nlayer
      REAL, INTENT(IN) :: ptimestep
      REAL, INTENT(IN) :: fm0(ngridmx,nlayermx+1)
      REAL, INTENT(IN) ::entr0(ngridmx,nlayermx)
      REAL, INTENT(IN) :: q_therm(ngridmx,nlayermx)
      CHARACTER (LEN=20), INTENT(IN) :: charvar
      REAL, INTENT(IN) :: masse0(ngridmx,nlayermx)
      REAL, INTENT(IN) :: zdz(ngridmx,nlayermx)
      REAL, INTENT(IN) :: alpha(ngridmx,nlayermx+1)

! ============================ OUTPUTS ===========================

      REAL, INTENT(OUT) :: dq_therm(ngridmx,nlayermx)  ! dq/dt -> derivative

! ============================ LOCAL =============================

      REAL q(ngridmx,nlayermx)
      REAL qa(ngridmx,nlayermx)
      REAL qd(ngridmx,nlayermx)
      INTEGER ig,k
      REAL gammaf(ngridmx,nlayermx),fmid(ngridmx,nlayermx)
      REAL gammae(ngridmx,nlayermx)
      REAL alphamid(ngridmx,nlayermx)
      REAL Z(2,2,ngridmx,nlayermx)
      REAL X(2,1,ngridmx,nlayermx)
! =========== Init ==============================================

      qa(:,:)=q_therm(:,:)
      q(:,:)=q_therm(:,:)

      do ig=1,ngridmx
         do k=1, nlayermx
            if (fm0(ig,k)+entr0(ig,k) .gt. 0.) then
              gammaf(ig,k)=fm0(ig,k)/(fm0(ig,k)+entr0(ig,k))
            else
              gammaf(ig,k)=0.
            endif
            if (fm0(ig,k+1) .gt. 0.) then
              gammae(ig,k)=(fm0(ig,k)+entr0(ig,k))/fm0(ig,k+1)
            else
              gammae(ig,k)=1.
            endif
         enddo
      enddo
      do k=1,nlayermx
        do ig=1, ngridmx
          Z(1,1,ig,k)=1.
          Z(1,2,ig,k)=0.
          Z(2,1,ig,k)=0.
          Z(2,2,ig,k)=1.          
        enddo
      enddo
      do k=2,nlayermx
        do ig=1, ngridmx
          if (gammaf(ig,k) .gt. 0.) then
          Z(1,1,ig,k)=1./gammae(ig,k-1) + (gammaf(ig,k)-1.)*            &
     &               (1.-gammae(ig,k-1))/(gammae(ig,k-1)*gammaf(ig,k))
          Z(1,2,ig,k)=-(1.-gammae(ig,k-1))                              &
     &                        /(gammae(ig,k-1)*gammaf(ig,k))
          Z(2,1,ig,k)=(gammaf(ig,k)-1.)/gammaf(ig,k)
          Z(2,2,ig,k)=1./gammaf(ig,k)
          else
          Z(1,1,ig,k)=1./gammae(ig,k-1) -1.
          Z(1,2,ig,k)=1.
          Z(2,:,ig,k)=0.
          endif

        enddo
      enddo

      X(1,1,:,:)=q_therm(:,:)
      X(2,1,:,:)=q_therm(:,:)

      do k=nlayermx,2,-1
        do ig=1, ngridmx
       X(:,1,ig,k-1)=MATMUL(Z(:,:,ig,k),X(:,1,ig,k))

        enddo
      enddo

      q(:,:)=X(1,1,:,:)
      qa(:,:)=X(2,1,:,:)

      dq_therm(:,:)=0.
      fmid(:,:)=0.
      alphamid(:,:)=0.

        do ig=1, ngridmx
           do k=1,nlayermx
              fmid(ig,k) = 0.5*(fm0(ig,k)+fm0(ig,k+1))
              alphamid(ig,k) = 0.5*(alpha(ig,k)+alpha(ig,k+1))
           enddo
        enddo

        do ig=1, ngridmx
           do k=1,nlayermx-1
              dq_therm(ig,k)=-(1./masse0(ig,k))*(  &
     &   (1.-alphamid(ig,k+1))*fmid(ig,k+1)*(qa(ig,k+1)-q(ig,k+1)) -   &
     &   (1.-alphamid(ig,k))*fmid(ig,k)*(qa(ig,k)-q(ig,k))          ) &
     &       /zdz(ig,k)

           enddo
        enddo
      return
      end
