c****************************************************************************
c
c       Merging of different common blocks used in the new NLTE 15um param
c
c       jan 2012    fgg+malv
c****************************************************************************
c *** Old nlte_atm.h ***
c Subgrid atmosphere interpolated 
c
        common /atm_nl/ zl, t, pl, sh, nt, co2, n2, co, o3p, o2, h2, ar,
     @    co2vmr, n2vmr, covmr, o3pvmr,hrkday_factor

        real zl(nl), t(nl), pl(nl), nt(nl),  sh(nl),
     @    co2(nl), n2(nl), co(nl), o3p(nl), o2(nl), h2(nl), ar(nl),
     @    co2vmr(nl),n2vmr(nl),covmr(nl),o3pvmr(nl),hrkday_factor(nl)

c Subgrid atmosphere obtained from the input atmosphere and limited to the
c NLTE grid. Only used for computing transmitances. 
c
        common /atm_ny/ zy, ty, py, nty, co2y, coy
        real zy(nzy), ty(nzy), py(nzy), nty(nzy), co2y(nzy), coy(nzy)

c
	common/deltazetas/ deltaz, deltazy, 
     @        jlowerboundary, jtopboundary
	real    deltaz, deltazy
	integer jlowerboundary, jtopboundary


c *** Old nlte_results.h ***
c Next common: parameter that decides which level populations 
c are already known and therefore are read and used in this program.
	common/input_avilable_from/ input_cza, input_czb, input_czc, 
     @                              input_czco
	integer input_cza, input_czb, input_czc, input_czco

c temperatura vibracional de entrada:
	common/temp626/ v626t1,v626t2,v626t3,v626t4, 
     @   		v626t5,v626t6,v626t7,v626t8
	common/temp628/ v628t1, v628t2, v628t3, v628t4
	common/temp636/ v636t1, v636t2, v636t3, v636t4 
	common/temp627/ v627t1, v627t2, v627t3, v627t4 
	common/tempco/ vcot1, vcot2, vcot3, vcot4, v63t1,v63t2,v63t3
	real*8 v626t4(nl), v628t4(nl), v636t4(nl), v627t4(nl)
	real*8 v626t1(nl), v626t2(nl), v626t3(nl) 
	real*8 v626t5(nl), v626t6(nl), v626t7(nl), v626t8(nl)
	real*8 v628t1(nl), v628t2(nl), v628t3(nl) 
	real*8 v636t1(nl), v636t2(nl), v636t3(nl) 
	real*8 v627t1(nl), v627t2(nl), v627t3(nl) 
	real*8 vcot1(nl), vcot2(nl), vcot3(nl), vcot4(nl)
	real*8 v63t1(nl), v63t2(nl), v63t3(nl)

c output de cza.for
	common /tv15um/	vt11, vt12, vt13,
     @      		vt21, vt22, vt23,
     @      		vt31, vt32, vt33,
     @      		vt41, vt42, vt43
	real*8  vt11(nl), vt12(nl), vt13(nl),
     @      	vt21(nl), vt22(nl), vt23(nl),
     @      	vt31(nl), vt32(nl), vt33(nl),
     @      	vt41(nl), vt42(nl), vt43(nl)

	common /hr15um/	hr110,hr210,hr310,hr410,
     @      		hr121,hr221,hr321,hr421,
     @      		hr132,hr232,hr332,hr432
	real*8  hr110(nl),hr121(nl),hr132(nl),
     @      	hr210(nl),hr310(nl),hr410(nl),
     @      	hr221(nl),hr232(nl),hr321(nl),
     @      	hr332(nl),hr421(nl),hr432(nl)

        common/sf15um/ el11,el12,el13, el21,el22,el23,
     @ 		el31,el32,el33, el41,el42,el43
        real*8 el11(nl), el12(nl), el13(nl)
        real*8 el21(nl), el22(nl), el23(nl)
        real*8 el31(nl), el32(nl), el33(nl)
        real*8 el41(nl), el42(nl), el43(nl)

        common/sl15um/ sl110,sl121,sl132, sl210,sl221,sl232,
     @          sl310,sl321,sl332, sl410,sl421,sl432 
        real*8 sl110(nl), sl121(nl), sl132(nl)
        real*8 sl210(nl), sl221(nl), sl232(nl)
        real*8 sl310(nl), sl321(nl), sl332(nl)
        real*8 sl410(nl), sl421(nl), sl432(nl)


c *** Old nlte_matrix.h***
c curtis matrix de cza:
	common/curtis_matrixes_15um/ c110,c121, c210,
     @  	c310, c410,
     @  	vc110,vc121, vc210,
     @  	vc310, vc410
	real*8 c110(nl,nl), c121(nl,nl)
	real*8 c210(nl,nl)
	real*8 c310(nl,nl)
	real*8 c410(nl,nl)
	real*8 vc110(nl), vc121(nl)
	real*8 vc210(nl), vc310(nl), vc410(nl)
 
	common/curtis_matr_up_15um/ 
     @          cup110,cup121
	real*8 cup110(nl,nl), cup121(nl,nl)

	common/curtis_matr_dw_15um/ 
     @          cdw110,cdw121
	real*8 cdw110(nl,nl), cdw121(nl,nl)

        common/curtis_matr_taugr_15um/
     @  	taugr110,taugr121
        real*8 taugr110(nl), taugr121(nl)
        
! for the new flux formulation:
!
!
        common/tauinf_15um/ tauinf121,
     @  	tauinf210,tauinf310,tauinf410,tauinf110
        real*8 tauinf121(nl)
        real*8 tauinf210(nl), tauinf310(nl), tauinf410(nl)
        real*8 tauinf110(nl)

! for the cool-to-space formulation:
!
	common/taustar_15um/ taustar11, taustar21, taustar31, 
     @         taustar41, taustar12
	real*8 taustar11(nl), taustar21(nl), taustar31(nl)
	real*8 taustar41(nl), taustar12(nl)

	common/tauii_15um/ tauii110, tauii210, tauii310, 
     @         tauii410, tauii121
	real*8 tauii110(nl), tauii210(nl), tauii310(nl)
	real*8 tauii410(nl), tauii121(nl)

! for the name of the C.Matrix files
!
	common/cm_names/ fileroot
	character        fileroot*3


c *** Old nlte_rates.h ***
	common/rates_vt/ k7a(4),k7b(4), k7ap(4),k7bp(4), 
     @      	k3aa(4),k3ab(4),k3ac(4), k3aap(4),k3abp(4),k3acp(4),
     @      	k3ba(4),k3bb(4),k3bc(4), k3bap(4),k3bbp(4),k3bcp(4),
     @      	k19aa(4),k19ab(4),k19ac(4), k19aap(4),k19abp(4),k19acp(4),
     @      	k19ba(4),k19bb(4),k19bc(4), k19bap(4),k19bbp(4),k19bcp(4),
     @      	k19ca(4),k19cb(4),k19cc(4), k19cap(4),k19cbp(4),k19ccp(4),
     @      	k20a(4),k20b(4),k20c(4), k20ap(4),k20bp(4),k20cp(4),
     @      	k27a,k27b,k27c, k27ap,k27bp,k27cp

	real*8 k7a,k7b, k7ap,k7bp 
	real*8 k3aa,k3ab,k3ac, k3aap,k3abp,k3acp
	real*8 k3ba,k3bb,k3bc, k3bap,k3bbp,k3bcp
	real*8 k19aa,k19ab,k19ac, k19aap,k19abp,k19acp
	real*8 k19ba,k19bb,k19bc, k19bap,k19bbp,k19bcp
	real*8 k19ca,k19cb,k19cc, k19cap,k19cbp,k19ccp
	real*8 k20a,k20b,k20c, k20ap,k20bp,k20cp
	real*8 k27a,k27b,k27c, k27ap,k27bp,k27cp

        common/rates_vv/ k1(4),k1p(4), 
     @      	k2a,k2b, k2x,k2y,k2z, k2xp,k2yp,k2zp,
     @      	k6,k6p, k6a(2:4),k6b(2:4), k6ap(2:4),k6bp(2:4),
     @      	k21a,k21ap, k21a1(2:4),k21a2(2:4), k21a1p(2:4),k21a2p(2:4),
     @      	k21b(4),k21c(4), k21bp(4),k21cp(4),
     @      	k31,k32,
     @      	k33a1,k33a2,k33b1,k33b2,k33c, 
     @      	k33a1p(2:4),k33a2p(2:4),k33b1p(2:4),k33b2p(2:4),k33cp(2:4),
     @      	k28a,k28b,k28c, k28ap,k28bp,k28cp,
     @      	k26a,k26b,k26c,k26d, k26ap(4),k26bp(4),k26cp(4),k26dp(4), 
     @      	k41p_taylor, k41p_shved, k41p_starr_hannock, 
     @      	k41_1,k41p_1, k41_2,k41p_2, k42,k42p

	real*8 k1,k1p
	real*8 k2a,k2b, k2x,k2y,k2z, k2xp,k2yp,k2zp
	real*8 k6,k6p, k6a,k6b, k6ap,k6bp
	real*8 k21a,k21ap, k21a1,k21a2, k21a1p,k21a2p
	real*8 k21b,k21c, k21bp,k21cp
	real*8 k31,k32
	real*8 k33a1,k33a2,k33b1,k33b2,k33c
	real*8 k33a1p,k33a2p,k33b1p,k33b2p,k33cp
	real*8 k28a,k28b,k28c, k28ap,k28bp,k28cp
	real*8 k26a,k26b,k26c,k26d, k26ap,k26bp,k26cp,k26dp
	real*8 k41p_taylor, k41p_shved, k41p_starr_hannock 
	real*8 k41_1,k41p_1, k41_2,k41p_2, k42,k42p 


	common/rates_k26isot/ k26a21,k26c21,k26d21, 
     @     k26a22,k26c22,k26d22, k26a23,k26c23,k26d23, 
     @     k26a24,k26c24,k26d24, 
     @     k26a32,k26c32,k26d32, k26a33,k26c33,k26d33, 
     @     k26a31,k26c31,k26d31, 
     @     k26a34,k26c34,k26d34, k26a42,k26c42,k26d42, 
     @     k26a41,k26c41,k26d41, 
     @     k26a43,k26c43,k26d43, k26a44,k26c44,k26d44 

	real*8 k26a21,k26c21,k26d21, 
     @     k26a22,k26c22,k26d22, k26a23,k26c23,k26d23, 
     @     k26a24,k26c24,k26d24, 
     @     k26a32,k26c32,k26d32, k26a33,k26c33,k26d33, 
     @     k26a31,k26c31,k26d31, 
     @     k26a34,k26c34,k26d34, k26a42,k26c42,k26d42, 
     @     k26a41,k26c41,k26d41, 
     @     k26a43,k26c43,k26d43, k26a44,k26c44,k26d44


	common/rates_last/ k23k21c, k24k21c, k34k21c, 
     @      	k23k21cp, k24k21cp, k34k21cp, k43,k43p, k_vthcl

	real*8 k23k21c,k24k21c,k34k21c, k23k21cp,k24k21cp,k34k21cp 
	real*8 k43,k43p, k_vthcl

	common/rates_V09/ k41_3,k41p_3, k41_4,k41p_4, k41iso_1,k41iso_1p, 
     @                    k41iso_2,k41iso_2p, k41iso_3,k41iso_3p, 
     @                    k42b, k42c, k42bp, k42cp, k43iso,k43isop, 
     @                    k44a,k44b,k44c,k44d, k44ap,k44bp,k44cp,k44dp, 
     @                    k42iso,k42isop, k42isob,k42isobp
        real*8  k41_3,k41p_3, k41_4,k41p_4, k41iso_1,k41iso_1p
	real*8  k41iso_2,k41iso_2p, k41iso_3,k41iso_3p
        real*8  k42b, k42c, k42bp, k42cp, k43iso,k43isop
	real*8  k44a,k44b,k44c,k44d, k44ap,k44bp,k44cp,k44dp
	real*8  k42iso,k42isop, k42isob,k42isobp


c *** Old nlte_curtis.h ***


	common/block1/s,alsa,alna,alda,ka,kr
	real*8 ka(nbox_max),alsa(nbox_max),alna(nbox_max),alda(nbox_max)
     &,s
	integer kr

	common/block2/hisfile, hfile1
	character hisfile*75, hfile1*3

	common/block3/sl_ua,ua,pt,pp,ta,w, icls
	real*8 sl_ua,ua(nbox_max),pt,pp,ta(nbox_max),w
	integer	icls

	common/block4/no,sk1,xls1,xln1,xld1,thist,dist, nbox
	real*8	sk1(nhist,nbox_max)	! line intensity
	real*8  xls1(nhist,nbox_max)	! Lorentz half width (self-col.)
	real*8	xln1(nhist,nbox_max)	! Lorentz half width
	real*8 	xld1(nhist,nbox_max)	! Doppler half width
	real*8	thist(nhist)		! temperatures in the histogram
	real*8	no(nbox_max)		! number of lines in box
	real*8  dist(nbox_max)		! mean distance between lines in box
	integer nbox		! actual number of boxes

	common/block5/eqw, aa, bb, cc, dd, ddbox, ccbox
	real*8 eqw, aa, bb, cc, dd
	real*8 ddbox(nbox_max), ccbox(nbox_max)

	common/block7/ mr, p
	real*8  mr(nzy), p(nzy)

	common/block8/ tmin,tmax, mm
	real*8 tmin,tmax
	integer mm

	common/block9/ w_strongLor_prev
	real*8 w_strongLor_prev(nbox_max)

        common/block10/no_c1,no_c2,no_c3,no_c4,no_c5,no_c6,no_c7
	real*8	no_c1(nbox_max)
	real*8	no_c2(nbox_max)
	real*8	no_c3(nbox_max)
	real*8	no_c4(nbox_max)
	real*8	no_c5(nbox_max)
	real*8	no_c6(nbox_max)
	real*8	no_c7(nbox_max)

	common/block11/nbox_c1,nbox_c2,nbox_c3,nbox_c4,
     $     nbox_c5,nbox_c6,nbox_c7
	integer nbox_c1
	integer nbox_c2
	integer nbox_c3
	integer nbox_c4
	integer nbox_c5
	integer nbox_c6
	integer nbox_c7

	common/block12/thist_c1,thist_c2,thist_c3,thist_c4,thist_c5,
     $    thist_c6,thist_c7
	real*8	thist_c1(nhist)
	real*8	thist_c2(nhist)
	real*8	thist_c3(nhist)
	real*8	thist_c4(nhist)
	real*8	thist_c5(nhist)
	real*8	thist_c6(nhist)
	real*8	thist_c7(nhist)

	common/block13/dist_c1,dist_c2,dist_c3,dist_c4,dist_c5,
     $    dist_c6,dist_c7
	real*8  dist_c1(nbox_max)
	real*8  dist_c2(nbox_max)
	real*8  dist_c3(nbox_max)
	real*8  dist_c4(nbox_max)
	real*8  dist_c5(nbox_max)
	real*8  dist_c6(nbox_max)
	real*8  dist_c7(nbox_max)

	common/block14/sk1_c1,sk1_c2,sk1_c3,sk1_c4,sk1_c5,sk1_c6,sk1_c7
	real*8	sk1_c1(nhist,nbox_max)
	real*8	sk1_c2(nhist,nbox_max)
	real*8	sk1_c3(nhist,nbox_max)
	real*8	sk1_c4(nhist,nbox_max)
	real*8	sk1_c5(nhist,nbox_max)
	real*8	sk1_c6(nhist,nbox_max)
	real*8	sk1_c7(nhist,nbox_max)

	common/block15/xls1_c1,xls1_c2,xls1_c3,xls1_c4,xls1_c5,xls1_c6,
     $     xls1_c7
	real*8  xls1_c1(nhist,nbox_max)
	real*8  xls1_c2(nhist,nbox_max)
	real*8  xls1_c3(nhist,nbox_max)
	real*8  xls1_c4(nhist,nbox_max)
	real*8  xls1_c5(nhist,nbox_max)
	real*8  xls1_c6(nhist,nbox_max)
	real*8  xls1_c7(nhist,nbox_max)

	common/block16/xln1_c1,xln1_c2,xln1_c3,xln1_c4,xln1_c5,xln1_c6,
     $     xln1_c7
	real*8  xln1_c1(nhist,nbox_max)
	real*8  xln1_c2(nhist,nbox_max)
	real*8  xln1_c3(nhist,nbox_max)
	real*8  xln1_c4(nhist,nbox_max)
	real*8  xln1_c5(nhist,nbox_max)
	real*8  xln1_c6(nhist,nbox_max)
	real*8  xln1_c7(nhist,nbox_max)

	common/block17/xld1_c1,xld1_c2,xld1_c3,xld1_c4,xld1_c5,xld1_c6,
     $     xld1_c7
	real*8  xld1_c1(nhist,nbox_max)
	real*8  xld1_c2(nhist,nbox_max)
	real*8  xld1_c3(nhist,nbox_max)
	real*8  xld1_c4(nhist,nbox_max)
	real*8  xld1_c5(nhist,nbox_max)
	real*8  xld1_c6(nhist,nbox_max)
	real*8  xld1_c7(nhist,nbox_max)

	common/block18/mm_c1,mm_c2,mm_c3,mm_c4,mm_c5,mm_c6,mm_c7
	integer mm_c1
	integer mm_c2
	integer mm_c3
	integer mm_c4
	integer mm_c5
	integer mm_c6
	integer mm_c7

	common/block19/tmin_c1,tmin_c2,tmin_c3,tmin_c4,tmin_c5,tmin_c6,
     $     tmin_c7
	real*8 tmin_c1
	real*8 tmin_c2
	real*8 tmin_c3
	real*8 tmin_c4
	real*8 tmin_c5
	real*8 tmin_c6
	real*8 tmin_c7

	common/block20/tmax_c1,tmax_c2,tmax_c3,tmax_c4,tmax_c5,tmax_c6,
     $     tmax_c7
	real*8 tmax_c1
	real*8 tmax_c2
	real*8 tmax_c3
	real*8 tmax_c4
	real*8 tmax_c5
	real*8 tmax_c6
	real*8 tmax_c7

        common /lor_overlap/ asat_box, i_supersat
	real*8 		asat_box
	integer 	i_supersat


c *** Variables formerly included in nlte_data.h ***
        common /nltedata/ elow, deltanu
        real elow(nisot,nb), deltanu(nisot,nb)

c****************************************************************************
