#######################
##### PLANETOPLOT #####
#######################

### A. Spiga     -- LMD -- 06~09/2011 -- General building and mapping capabilities
### T. Navarro   -- LMD -- 10~11/2011 -- Improved use for GCM and added sections + 1Dplot capabilities 
### A. Colaitis  -- LMD --    11/2011 -- Mostly minor improvements and inter-plot operation capabilities + zrecast interpolation for gcm
### A. Spiga     -- LMD -- 11~12/2011 -- Extended multivar subplot capabilities + cosmetic changes + general cleaning and tests
### A. Colaitis  -- LMD --    12/2011 -- Added movie capability [mencoder must be installed]
### A. Spiga     -- LMD --    12/2011 -- Added HTML animated page capability + general tests of consistency [winds, etc...]

def planetoplot (namefiles,\
           level=0,\
           vertmode=0,\
           proj=None,\
           back=None,\
           target=None,
           stride=3,\
           var=None,\
           colorb="def",\
           winds=False,\
           addchar=None,\
           interv=[0,1],\
           vmin=None,\
           vmax=None,\
           tile=False,\
           zoom=None,\
           display=True,\
           hole=False,\
           save="gui",\
           anomaly=False,\
           var2=None,\
           ndiv=10,\
           mult=1.,\
           zetitle="fill",\
           slon=None,\
           slat=None,\
           svert=None,\
           stime=None,\
           outputname=None,\
           resolution=200,\
           ope=None,\
           fileref=None,\
           minop=0.,\
           maxop=0.,\
           titleref="fill",\
           invert_y=False,\
           xaxis=[None,None],\
           yaxis=[None,None],\
           ylog=False,\
           yintegral=False,\
           blat=None,\
           blon=None,\
           tsat=False,\
           flagnolow=False,\
           mrate=None,\
           mquality=False,\
           trans=1,\
           zarea=None):


    ####################################################################################################################
    ### Colorbars http://www.scipy.org/Cookbook/Matplotlib/Show_colormaps?action=AttachFile&do=get&target=colormaps3.png

    #################################
    ### Load librairies and functions
    from netCDF4 import Dataset
    from myplot import getcoord2d,define_proj,makeplotres,simplinterv,vectorfield,ptitle,latinterv,getproj,wrfinterv,dumpbdy,\
                       fmtvar,definecolorvec,defcolorb,getprefix,putpoints,calculate_bounds,errormess,definesubplot,\
                       zoomset,getcoorddef,getwinddef,whatkindfile,reducefield,bounds,getstralt,getfield,smooth,nolow,\
                       getname,localtime,polarinterv,getsindex,define_axis,determineplot,readslices,bidimfind,getlschar,hole_bounds
    from mymath import deg,max,min,mean,get_tsat,writeascii,fig2data,fig2img
    import matplotlib as mpl
    from matplotlib.pyplot import contour,contourf, subplot, figure, rcParams, savefig, colorbar, pcolor, show, plot, clabel, title, close, legend
    from matplotlib.cm import get_cmap
    import numpy as np
    from numpy.core.defchararray import find
    from videosink import VideoSink
    import subprocess

    ################################
    ### Preliminary stuff
    ################################
    print "********************************************"
    print "********** WELCOME TO PLANETOPLOT **********"
    print "********************************************"
    if not isinstance(namefiles, np.ndarray): namefiles = [namefiles]
    if not isinstance(var, np.ndarray):       var = [var]

    ################################
    ### Which plot needs to be done?
    ################################
    nlon, nlat, nvert, ntime, mapmode, nslices = determineplot(slon, slat, svert, stime)
    vlon = None ; vlat = None
    if slon is not None: vlon = slon[0][0]
    if slat is not None: vlat = slat[0][0]
    if mapmode == 0:       winds=False
    elif mapmode == 1:     
        if svert is None:  svert = readslices(str(level)) ; nvert=1
        if stime is None and mrate is None:
           stime = readslices(str(0)) ; ntime=1 ## this is a default choice
           print "WELL... nothing about time axis. I took default: first time reference stored in file."
    if mrate is not None and len(var) > 1: errormess("multivar not allowed in movies. should be fixed soon!")
    zelen = len(namefiles)*len(var)
    numplot = zelen*nslices
    print "********** FILES, SLICES, VARS, TOTAL PLOTS: ", len(namefiles), nslices, len(var), numplot
    if ope is not None:
        if fileref is not None:       zelen = zelen + 2
        elif "var" in ope:            zelen = zelen + 1
    all_var  = [[]]*zelen ; all_var2  = [[]]*zelen ; all_title = [[]]*zelen ; all_varname = [[]]*zelen ; all_namefile = [[]]*zelen ; all_time = [[]]*zelen ; all_windu = [[]]*zelen ; all_windv = [[]]*zelen
 
    #################################################################################################
    ### Loop over the files + vars initially separated by commas to be plotted on the same figure ###
    #################################################################################################
    k = 0 ; firstfile = True
    for nnn in range(len(namefiles)):
     for vvv in range(len(var)): 

      print "********** LOOP..... THIS IS SUBPLOT NUMBER.....",k

      ######################
      ### Load NETCDF object
      namefile = namefiles[nnn] ; print "********** THE NAMEFILE IS....", namefile 
      nc  = Dataset(namefile)

      ##################################
      ### Initial checks and definitions
      ### ... TYPEFILE
      typefile = whatkindfile(nc)                                  
      if typefile in ['mesoideal']:   mapmode=0;winds=False
      if firstfile: print "********** MAPMODE: ", mapmode
      if firstfile:                 typefile0 = typefile
      elif typefile != typefile0:   errormess("Not the same kind of files !", [typefile0, typefile])
      ### ... VAR
      varname=var[vvv]
      print "********** THE VAR IS....",varname, var2
      if varname not in nc.variables: varname = False
      ### ... WINDS
      if winds:                                                    
         [uchar,vchar,metwind] = getwinddef(nc)             
         if uchar == 'not found': winds = False
      if not varname and not winds: errormess("please set at least winds or var",printvar=nc.variables)
      ### ... COORDINATES, could be moved below
      [lon2d,lat2d] = getcoorddef(nc)
      ### ... PROJECTION
      if ((proj == None) and (typefile not in ['mesoideal'])):   proj = getproj(nc)                 

##########################################################
      if typefile == "gcm":
          lat = nc.variables["latitude"][:] ; lon = nc.variables["longitude"][:]
          if "Time" in nc.variables:      time = nc.variables["Time"][:]
          elif "time" in nc.variables:    time = nc.variables["time"][:]
          else:                           errormess("no time axis found.")
          vert = nc.variables["altitude"][:]
      elif typefile in ['meso','mesoapi','geo','mesoideal']:
          ### the following lines are kind of dirty... not possible to ask for several lats and lons
          if vlon is not None or vlat is not None:   indices = bidimfind(lon2d,lat2d,vlon,vlat) ; print '********** INDICES: ', indices
          if slon is not None: slon[0][0] = indices[0] ; slon[0][1] = indices[0]
          if slat is not None: slat[0][0] = indices[1] ; slat[0][1] = indices[1]
          if varname in ['PHTOT','W']:    vertdim='BOTTOM-TOP_PATCH_END_STAG'
          else:                           vertdim='BOTTOM-TOP_PATCH_END_UNSTAG'
          if (var2 is not None and var2 not in ['PHTOT','W']):
               vertdim='BOTTOM-TOP_PATCH_END_UNSTAG'
               dumped_vert_stag=True
          else: dumped_vert_stag=False
          if varname in ['V']:  latdim='SOUTH-NORTH_PATCH_END_STAG'
          else:                 latdim='SOUTH-NORTH_PATCH_END_UNSTAG'
          if varname in ['U']:  londim='WEST-EAST_PATCH_END_STAG'
          else:                 londim='WEST-EAST_PATCH_END_UNSTAG'
          lon = np.arange(0,getattr(nc,londim),1) ; lat = np.arange(0,getattr(nc,latdim),1)
          if "Times" in nc.variables:time = np.arange(0,len(nc.variables["Times"]),1)
          elif "Time" in nc.variables:time = np.arange(0,len(nc.variables["Time"]),1)
          if typefile in ['geo']:   vert = [0.] ; stime = readslices(str(0))
          else:
              if vertmode is None:  vertmode=0
              if vertmode == 0:     vert = np.arange(0,getattr(nc,vertdim),1)
              else:                 vert = nc.variables["vert"][:]
       #if firstfile:
       #   lat0 = lat
       #elif len(lat0) != len(lat):
       #   errormess("Not the same latitude lengths !", [len(lat0), len(lat)])
       #elif sum((lat == lat0) == False) != 0:
       #   errormess("Not the same latitudes !", [lat,lat0])
       ## Faire d'autre checks sur les compatibilites entre fichiers!!
##########################################################

      if firstfile:
         ##########################
         ### Define plot boundaries
         ### todo: possible areas in latinterv in argument (ex: "Far_South_Pole")
         if proj in ["npstere","spstere"]: [wlon,wlat] = polarinterv(lon2d,lat2d)
         elif proj in ["lcc","laea"]:      [wlon,wlat] = wrfinterv(lon2d,lat2d)
         else:                             [wlon,wlat] = simplinterv(lon2d,lat2d)
         if zoom:                          [wlon,wlat] = zoomset(wlon,wlat,zoom)
         elif zarea is not None: [wlon,wlat] = latinterv(area=zarea) 

      all_varname[k] = varname
      all_namefile[k] = namefile
      all_time[k] = time
      if var2: all_var2[k] = getfield(nc,var2)
      if winds: all_windu[k] = getfield(nc,uchar) ; all_windv[k] = getfield(nc,vchar)
      ##### SPECIFIC
      if varname in ["temp","t","T_nadir_nit","T_nadir_day","temp_day","temp_night"] and tsat:
          tt=getfield(nc,varname) ; print "computing Tsat-T, I ASSUME Z-AXIS IS PRESSURE"
          if type(tt).__name__=='MaskedArray':  tt.set_fill_value([np.NaN]) ; tinput=tt.filled()
          else:                                 tinput=tt
          all_var[k]=get_tsat(vert,tinput,zlon=lon,zlat=lat,zalt=vert,ztime=time)
      else:
      ##### GENERAL STUFF HERE
          all_var[k] = getfield(nc,varname)
      print "********** all_var[k].shape", all_var[k].shape
      k += 1
      firstfile = False
      #### End of for namefile in namefiles

    ##################################
    ### Operation on files
    if ope is not None:
        print ope
        if "var" not in ope:
             if len(var) > 1: errormess("for this operation... please set only one var !")
             if ope in ["-","+","-%"]:
                if fileref is not None:   all_var[k] = getfield(Dataset(fileref),all_varname[k-1]) ; all_varname[k] = all_varname[k-1] ; all_time[k] = all_time[k-1] ; all_namefile[k] = all_namefile[k-1]
                else:                     errormess("fileref is missing!") 
                if ope == "-":     all_var[k+1]= all_var[k-1] - all_var[k]
                elif ope == "+":   all_var[k+1]= all_var[k-1] + all_var[k]
                elif ope == "-%":  all_var[k+1]= 100.*(all_var[k-1] + all_var[k])/all_var[k]
                all_varname[k+1] = all_varname[k] ; all_time[k+1] = all_time[k] ; all_namefile[k+1] = all_namefile[k] ; numplot = numplot+2
             elif ope in ["cat"]:
                tab = all_var[0];k = 1
                if var2: tab2 = all_var2[0]
                while k != len(namefiles):
                    if var2: tab2 = np.append(tab2,all_var2[k],axis=0) 
                    tab = np.append(tab,all_var[k],axis=0) ; k += 1
                all_time[0] = np.arange(0,len(tab),1) ### AS: time reference is too simplistic, should be better
                all_var[0] = np.array(tab) ; numplot = 1
                if var2: all_var2[0] = np.array(tab2)
             else: errormess(ope+" : non-implemented operation. Check pp.py --help")
        else:
             if len(namefiles) > 1: errormess("for this operation... please set only one file !")  
             if len(var) > 2:       errormess("not sure this works for more than 2 vars... please check.")
             if   ope in ["div_var"]: all_var[k] = all_var[k-2] / all_var[k-1] ; insert = '_div_'
             elif ope in ["mul_var"]: all_var[k] = all_var[k-2] * all_var[k-1] ; insert = '_mul_'
             elif ope in ["add_var"]: all_var[k] = all_var[k-2] + all_var[k-1] ; insert = '_add_'
             elif ope in ["sub_var"]: all_var[k] = all_var[k-2] - all_var[k-1] ; insert = '_sub_'
             else:                    errormess(ope+" : non-implemented operation. Check pp.py --help")
             numplot = numplot + 1 ; all_time[k] = all_time[k-1] ; all_namefile[k] = all_namefile[k-1]
             all_varname[k] = all_varname[k-2] + insert + all_varname[k-1] 
    ##################################
    ### Open a figure and set subplots
    fig = figure()
    subv,subh = definesubplot( numplot, fig ) 
    if ope in ['-','-%']: subv,subh = 2,2
 
    #################################
    ### Time loop for plotting device
    nplot = 1 ; error = False 
    print "********************************************"
    while error is False:
     
       print "********** NPLOT", nplot 
       if nplot > numplot: break

       ####################################################################
       ## get all indexes to be taken into account for this subplot and then reduce field
       ## We plot 1) all lon slices 2) all lat slices 3) all vert slices 4) all time slices and then go to the next slice
       indexlon  = getsindex(slon,(nplot-1)%nlon,lon)
       indexlat  = getsindex(slat,((nplot-1)//nlon)%nlat,lat)
       indexvert = getsindex(svert,((nplot-1)//(nlon*nlat))%nvert,vert) 
       if ope is not None:
           if fileref is not None:      index_f = ((nplot-1)//(nlon*nlat*nvert*ntime))%(len(namefiles)+2)  ## OK only 1 var,  see test in the beginning
           elif "var" in ope:           index_f = ((nplot-1)//(nlon*nlat*nvert*ntime))%(len(var)+1)        ## OK only 1 file, see test in the beginning
           elif "cat" in ope:           index_f = 0
       else:                            yeah = len(namefiles)*len(var) ; index_f = ((nplot-1)//(nlon*nlat*nvert*ntime))%yeah
       time = all_time[index_f]
       if stime is not None:
           if stime[0][0] < 0:
               if typefile in ['mesoapi','meso']:
                   for i in range(len(time)):  time[i] = localtime ( interv[0]+time[i]*interv[1], 0.5*(wlon[0]+wlon[1]) )
                   print "OK... WORKING WITH LOCAL TIMES"
               else: errormess("local times not supported. not too hard to modify the code though.")
       if mrate is not None:                 indextime = None 
       else:                                 indextime = getsindex(stime,((nplot-1)//(nlon*nlat*nvert))%ntime,time)
       ltst = None 
       if typefile in ['mesoapi','meso'] and indextime is not None:  ltst = localtime ( interv[0]+indextime*interv[1], 0.5*(wlon[0]+wlon[1]) )  
       print "********** index lon, lat, vert, time ",indexlon,indexlat,indexvert,indextime
       ####################################################################
       error = False
       varname = all_varname[index_f]
       if varname:   ### what is shaded.
           what_I_plot, error = reducefield( all_var[index_f], d4=indextime, d1=indexlon, d2=indexlat, d3=indexvert, \
                                             yint=yintegral, alt=vert, anomaly=anomaly )
           what_I_plot = what_I_plot*mult
       if var2:      ### what is contoured.
           what_I_plot_contour, error = reducefield( all_var2[index_f], d4=indextime, d1=indexlon, d2=indexlat , d3=indexvert, \
                                             yint=yintegral, alt=vert )
       if winds:     ### what is plot as vectors.
           vecx, error = reducefield( all_windu[index_f], d4=indextime, d3=indexvert, yint=yintegral, alt=vert)
           vecy, error = reducefield( all_windv[index_f], d4=indextime, d3=indexvert, yint=yintegral, alt=vert)
       ####################################################################
       ### General plot settings
       changesubplot = (numplot > 1) and (len(what_I_plot.shape) != 1)  ## default for 1D plots: superimposed. to be reworked for better flexibility.
       if changesubplot: subplot(subv,subh,nplot)
       ### Map projection                    
       if mapmode == 1:     m = define_proj(proj,wlon,wlat,back=back,blat=blat,blon=blon) ; x, y = m(lon2d, lat2d)
       elif mapmode ==0:    m = None ; x = None ; y = None
       ####################################################################

       if not error:
               ticks = ndiv + 1 
               fvar = varname 
               if anomaly: fvar = 'anomaly'
               if mapmode == 0:
                   itime=indextime
                   if len(what_I_plot.shape) is 3:itime=[0]
                   what_I_plot, x, y = define_axis(lon,lat,vert,time,indexlon,indexlat,indexvert,\
                         itime,what_I_plot, len(all_var[index_f].shape),vertmode)
                   zxmin, zxmax = xaxis ; zymin, zymax = yaxis
                   if zxmin is not None: mpl.pyplot.xlim(xmin=zxmin)
                   if zxmax is not None: mpl.pyplot.xlim(xmax=zxmax)
                   if zymin is not None: mpl.pyplot.ylim(ymin=zymin)
                   if zymax is not None: mpl.pyplot.ylim(ymax=zymax)
                   if invert_y:     lima,limb = mpl.pyplot.ylim() ; mpl.pyplot.ylim(limb,lima)
                   if ylog:         mpl.pyplot.semilogy()

               if (fileref is not None) and (index_f is numplot-1):    zevmin, zevmax = calculate_bounds(what_I_plot,vmin=minop,vmax=maxop)
               else:                                                   zevmin, zevmax = calculate_bounds(what_I_plot,vmin=vmin,vmax=vmax)
               if colorb in ["def","nobar"]:                           palette = get_cmap(name=defcolorb(fvar.upper()))
               elif (fileref is not None) and (index_f is numplot-1):  palette = get_cmap(name="RdBu_r")
               else:                                                   palette = get_cmap(name=colorb)

               ##### simple 2D field and movies of 2D fields
               if len(what_I_plot.shape) >= 2:
                 if (len(what_I_plot.shape) is 3 and mrate is None):  errormess("3D field. Use --rate RATE for movie or specify --time TIME. Exit.")
                 if mrate is not None: iend=len(time)-1
                 else:                 iend=0
                 imov = 0 
                 if var2:  which = "contour" ## have to start with contours rather than shading
                 else:     which = "regular"
                 while imov <= iend:
                    print "-> frame ",imov+1, which
                    if which == "regular":   
                        if mrate is None:                                   what_I_plot_frame = what_I_plot
                        else:                                               what_I_plot_frame = what_I_plot[imov,:,:]
                        if winds:
                            if mrate is None:                                   vecx_frame = vecx ; vecy_frame = vecy
                            else:                                               vecx_frame = vecx[imov,:,:] ; vecy_frame = vecy[imov,:,:]
                    elif which == "contour":  
                        if mrate is None or what_I_plot_contour.ndim < 3:   what_I_plot_frame = what_I_plot_contour
                        else:                                               what_I_plot_frame = what_I_plot_contour[imov,:,:]
                    if mrate is not None:     
                        if mapmode == 1: 
                            m = define_proj(proj,wlon,wlat,back=back,blat=blat,blon=blon)  ## this is dirty, defined above but out of imov loop
                            x, y = m(lon2d, lat2d)                                         ## this is dirty, defined above but out of imov loop
                    if typefile in ['mesoapi','meso'] and mapmode == 1:   what_I_plot_frame = dumpbdy(what_I_plot_frame,6,condition=True)
#                   if typefile in ['mesoideal']:    what_I_plot_frame = dumpbdy(what_I_plot_frame,0,stag='W',condition=dumped_vert_stag)

                    if imov >= 0:
                        # Renew axis directives for movie frames which are not the first one.
                        zxmin, zxmax = xaxis ; zymin, zymax = yaxis
                        if zxmin is not None: mpl.pyplot.xlim(xmin=zxmin)
                        if zxmax is not None: mpl.pyplot.xlim(xmax=zxmax)
                        if zymin is not None: mpl.pyplot.ylim(ymin=zymin)
                        if zymax is not None: mpl.pyplot.ylim(ymax=zymax)
                        if invert_y:     lima,limb = mpl.pyplot.ylim() ; mpl.pyplot.ylim(limb,lima)
                        if ylog:         mpl.pyplot.semilogy()
                    
                    if which == "regular": 
                        if hole:         what_I_plot_frame = hole_bounds(what_I_plot_frame,zevmin,zevmax)
                        else:            what_I_plot_frame = bounds(what_I_plot_frame,zevmin,zevmax)
                        if flagnolow:    what_I_plot_frame = nolow(what_I_plot_frame)
                        if not tile:
                            #zelevels = np.linspace(zevmin*(1. + 1.e-7),zevmax*(1. - 1.e-7)) #,num=20)
                            zelevels = np.linspace(zevmin,zevmax,num=ticks)
                            if mapmode == 1:       m.contourf( x, y, what_I_plot_frame, zelevels, cmap = palette, alpha=trans)
                            elif mapmode == 0:     contourf( x, y, what_I_plot_frame, zelevels, cmap = palette, alpha=trans)
                        else:
                            if mapmode == 1:       m.pcolor( x, y, what_I_plot_frame, cmap = palette, vmin=zevmin, vmax=zevmax, alpha=trans)
                            elif mapmode == 0:     pcolor( x, y, what_I_plot_frame, cmap = palette, vmin=zevmin, vmax=zevmax, alpha=trans)
                        if colorb != 'nobar':        
                            if (fileref is not None) and (index_f is numplot-1):   daformat = "%.3f"
                            else:                                                  daformat = fmtvar(fvar.upper())
                            colorbar( fraction=0.05,pad=0.03,format=daformat,\
                                      ticks=np.linspace(zevmin,zevmax,num=min([ticks/2+1,20])),extend='neither',spacing='proportional' ) 
                        if winds:
                            if typefile in ['mesoapi','meso']:
                                [vecx_frame,vecy_frame] = [dumpbdy(vecx_frame,6,stag=uchar,condition=True), dumpbdy(vecy_frame,6,stag=vchar,condition=True)]
                                key = True
                            elif typefile in ['gcm']:
                                key = False
                            if metwind:  [vecx_frame,vecy_frame] = m.rotate_vector(vecx_frame, vecy_frame, lon2d, lat2d)
                            if var:       colorvec = definecolorvec(back)
                            else:         colorvec = definecolorvec(colorb)
                            vectorfield(vecx_frame, vecy_frame, x, y, stride=stride, csmooth=2,\
                                             #scale=15., factor=300., color=colorvec, key=key)
                                             scale=20., factor=250., color=colorvec, key=key)
                                                              #200.         ## or csmooth=stride
                    elif which == "contour":
                        zevminc, zevmaxc = calculate_bounds(what_I_plot_frame)
                        zelevels = np.linspace(zevminc,zevmaxc,ticks/2) #20)
                        if var2 == 'HGT': zelevels = np.arange(-10000.,30000.,2000.)
                        if mapmode == 0:    
                            what_I_plot_frame, x, y = define_axis( lon,lat,vert,time,indexlon,indexlat,indexvert,\
                                                              itime,what_I_plot_frame, len(all_var2[index_f].shape),vertmode )
                            cs = contour( x,y,what_I_plot_frame, zelevels, colors='k', linewidths = 1 ) #0.33 colors='w' )# , alpha=0.5)
                        elif mapmode == 1:  cs = m.contour( x,y,what_I_plot_frame, zelevels, colors='k', linewidths = 1 ) #0.33 colors='w' )# , alpha=0.5)


                    if which == "regular":
                        if mrate is not None:
                           ### THIS IS A MENCODER MOVIE
                           if mrate > 0:
                             figframe=mpl.pyplot.gcf()
                             if mquality:   figframe.set_dpi(600.)
                             else:          figframe.set_dpi(200.)
                             mframe=fig2img(figframe)
                             if imov == 0:
                                moviename='movie' ;W,H = figframe.canvas.get_width_height()
                                video = VideoSink((H,W), moviename, rate=mrate, byteorder="rgba")
                             video.run(mframe) ; close()
                             if imov == iend: video.close()                            
                           ### THIS IS A WEBPAGE MOVIE 
                           else:
                             nameframe = "image"+str(1000+imov)
                             makeplotres(nameframe,res=100.,disp=False) ; close()
                             if imov == 0: myfile = open("zepics", 'w')
                             myfile.write("modImages["+str(imov)+"] = '"+nameframe+"_100.png';"+ '\n')
                             if imov == iend:
                                 myfile.write("first_image = 0;"+ '\n')
                                 myfile.write("last_image = "+str(iend)+";"+ '\n')
                                 myfile.close()
                        if var2:  which = "contour"
                        imov = imov+1
                    elif which == "contour":
                        which = "regular"

               ##### 1D field
               elif len(what_I_plot.shape) is 1:
                 lbl = ""
                 if indexlat is not None:  lbl = lbl + " ix" + str(indexlat)
                 if indexlon is not None:  lbl = lbl + " iy" + str(indexlon)
                 if indexvert is not None: lbl = lbl + " iz" + str(indexvert)
                 if indextime is not None: lbl = lbl + " it" + str(indextime)

                 if indexvert is not None:    plot(x,what_I_plot,label=lbl)  ## regular plot
                 else:                        plot(what_I_plot,x,label=lbl)  ## vertical profile
                 legend(loc='best')
                 if save == 'txt':  writeascii(np.transpose(what_I_plot),'profile'+str(nplot)+'.txt')

               #### Other cases: (maybe plot 3-D field one day ??)
               else:
                 print "WARNING!!! ",len(what_I_plot.shape),"-D PLOT NOT SUPPORTED !!! dimensions: ",what_I_plot.shape
                 errormess("Are you sure you did not forget to prescribe a dimension ?")
       else:
               errormess("There is an error in reducing field !")

       ### Next subplot
       basename = getname(var=varname,winds=winds,anomaly=anomaly)
       if len(what_I_plot.shape) > 3:
           basename = basename + getstralt(nc,level) 
       if mrate is not None: basename = "movie_" + basename 
       if typefile in ['mesoapi','meso']:
            if slon is not None: basename = basename + "_lon_" + str(int(lon2d[indices[1],indices[0]]))
            if slat is not None: basename = basename + "_lat_" + str(int(lat2d[indices[1],indices[0]]))
            plottitle = basename
            if addchar:   [addchar,gogol,gogol2] = getlschar ( all_namefile[index_f] )  ;  plottitle = plottitle + addchar
            if ltst is not None and ( (mapmode == 0) or (proj in ["lcc","laea","merc","nsper"]) ):  plottitle = plottitle + "_LT" + str(ltst)
       else:
            if fileref is not None:
                if index_f is numplot-1:     plottitle = basename+' '+"fig(1) "+ope+" fig(2)"
                elif index_f is numplot-2:   plottitle = basename+' '+fileref
                else:                        plottitle = basename+' '+namefiles[0]#index_f]
            else:                            plottitle = basename+' '+namefiles[0]#index_f]
       if mult != 1:                         plottitle = str(mult) + "*" + plottitle
       if zetitle != "fill":                 
          plottitle = zetitle
          if titleref is "fill":             titleref=zetitle
          if fileref is not None:
             if index_f is numplot-2:        plottitle = titleref
             if index_f is numplot-1:        plottitle = "fig(1) "+ope+" fig(2)"
#       if indexlon is not None:      plottitle = plottitle + " lon: " + str(min(lon[indexlon])) +" "+ str(max(lon[indexlon]))
#       if indexlat is not None:      plottitle = plottitle + " lat: " + str(min(lat[indexlat])) +" "+ str(max(lat[indexlat]))
#       if indexvert is not None:     plottitle = plottitle + " vert: " + str(min(vert[indexvert])) +" "+ str(max(vert[indexvert]))
#       if indextime is not None:     plottitle = plottitle + " time: " + str(min(time[indextime])) +" "+ str(max(time[indextime]))
       title( plottitle )
       if nplot >= numplot: error = True
       nplot += 1

  





      
    ##########################################################################
    ### Save the figure in a file in the data folder or an user-defined folder
    if outputname is None:
       if typefile in ['meso','mesoapi']:   prefix = getprefix(nc)
       elif typefile in ['gcm']:            prefix = 'LMD_GCM_'
       else:                                prefix = ''
    ###
       zeplot = prefix + basename 
       if addchar:         zeplot = zeplot + addchar
       if numplot <= 0:    zeplot = zeplot + "_LT"+str(abs(numplot))
    ###
       if not target:      zeplot = namefile[0:find(namefile,'wrfout')] + zeplot
       else:               zeplot = target + "/" + zeplot  
    ###
    else:
       zeplot=outputname

    if mrate is None:
        pad_inches_value = 0.35
        print "********** SAVE ", save
        if save == 'png': 
            if display: makeplotres(zeplot,res=100.,pad_inches_value=pad_inches_value) #,erase=True)  ## a miniature
            makeplotres(zeplot,res=resolution,pad_inches_value=pad_inches_value,disp=False)
        elif save in ['eps','svg','pdf']:     makeplotres(zeplot,pad_inches_value=pad_inches_value,disp=False,ext=save)
        elif save == 'gui':                   show()
        elif save == 'txt':                   print "Saved results in txt file." 
        else: 
            print "INFO: save mode not supported. using gui instead."
            show()

    ###################################
    #### Getting more out of this video -- PROBLEMS WITH CREATED VIDEOS
    #
    #if mrate is not None:
    #    print "Re-encoding movie.. first pass"
    #    video.first_pass(filename=moviename,quality=mquality,rate=mrate)
    #    print "Re-encoding movie.. second pass"
    #    video.second_pass(filename=moviename,quality=mquality,rate=mrate)   

    ###############
    ### Now the end
    return zeplot
