!-----------------------------------------------------------------------
! INCLUDE 'tracer.h'

      character*20  noms(nqmx)  ! name of the tracer
      real mmol(nqmx)           ! mole mass of tracer (g/mol-1) 
      real radius(nqmx)   ! dust and ice particle radius (m)
      real rho_q(nqmx)    ! tracer densities (kg.m-3)
      real qext(nqmx)     ! Single Scat. Extinction coeff at 0.67 um
      real alpha_lift(nqmx) ! saltation vertical flux/horiz flux ratio (m-1)
      real alpha_devil(nqmx) ! lifting coeeficient by dust devil

      real varian      ! Characteristic variance of log-normal distribution
      real r3n_q     ! used to compute r0 from number and mass mixing ratio
      real qextrhor(nqmx) ! Intermediate for computing opt. depth from q
      real rho_dust     ! Mars dust density (kg.m-3)
      real rho_ice     ! Water ice density (kg.m-3)
      real ref_r0        ! for computing reff=ref_r0*r0 (in log.n. distribution)

      real dryness(ngridmx)!"Dryness coefficient" for grnd water ice sublimation
      
! tracer indexes: these are initialized in initracer and should be 0 if the
!                 corresponding tracer does not exist
      ! dust
      integer :: igcm_dustbin(nqmx) ! for dustbin 'dust' tracers
      ! dust, special doubleq case
      integer :: igcm_dust_mass   ! dust mass mixing ratio (for transported dust)
      integer :: igcm_dust_number ! dust number mixing ratio (transported dust)
      ! water
      integer :: igcm_h2o_vap ! water vapour
      integer :: igcm_h2o_ice ! water ice
      ! chemistry:
      integer :: igcm_co2
      integer :: igcm_co
      integer :: igcm_o
      integer :: igcm_o1d
      integer :: igcm_o2
      integer :: igcm_o3
      integer :: igcm_h
      integer :: igcm_h2
      integer :: igcm_oh
      integer :: igcm_ho2
      integer :: igcm_h2o2
      integer :: igcm_n2
      integer :: igcm_ar
      
      ! other tracers
      integer :: igcm_ar_n2 ! for simulations using co2 +neutral gas


! NB: to keep commons aligned: 
!     split them in groups (reals, integers and characters)
      COMMON/tracer/radius,rho_q,qext,alpha_lift,alpha_devil,mmol,      &
     & varian,r3n_q,qextrhor,rho_dust,rho_ice,ref_r0,dryness
      COMMON/tracer2/
     & igcm_dustbin,igcm_dust_mass,igcm_dust_number,                    &
     & igcm_h2o_vap,igcm_h2o_ice,igcm_co2,igcm_co,igcm_o,igcm_o1d,      &
     & igcm_o2,igcm_o3,igcm_h,igcm_h2,igcm_oh,igcm_ho2,igcm_h2o2,       &
     & igcm_n2,igcm_ar,igcm_ar_n2!,nbqchem,niqchem
      COMMON/tracer3/noms
!-----------------------------------------------------------------------
