      SUBROUTINE calldrag_noro(ngrid,nlayer,ptimestep,
     &                 pplay,pplev,pt,pu,pv,pdtgw,pdugw,pdvgw) 



                                                   
       IMPLICIT NONE
c=======================================================================
c   subject:
c   --------
c   Subroutine designed to call SUBROUTINE drag_noro 
c   Interface for sub-grid scale orographic scheme
c
c   author:   
c   ------
c           Christophe Hourdin/ Francois Forget
c
c   changes:
c   -------
c   > J.-B. Madeleine 09W30
c   Removed the variable's splitting, which is now obsolete.
c
c   input:
c   ----- 
c   ngrid                 number of gridpoint of horizontal grid
c   nlayer                Number of layer
c   ptimestep             Physical timestep (s)
c   pplay(ngrid,nlayer)    pressure (Pa) in the middle of each layer
c   pplev(ngrid,nlayer+1)  pressure (Pa) at boundaries of each layer
c   pt(ngrid,nlayer)       atmospheric temperature  (K)
c   pu(ngrid,nlayer)       zonal wind (m s-1)
c   pv(ngrid,nlayer)       meridional wind (m s-1)
c
c   output:
c   -------
c   pdtgw(ngrid,nlayer)    Temperature trend (K.s-1)
c   pdugw(ngrid,nlayer)    zonal wind trend  (m.s-2)
c   pdvgw(ngrid,nlayer)    meridional wind trend  (m.s-2)
c
c
c
c
c
c=======================================================================
c
c    0.  Declarations :
c    ------------------
c
#include "dimensions.h"
#include "dimphys.h"
#include "surfdat.h"

c-----------------------------------------------------------------------
c    Input/Output
c    ------------
      INTEGER ngrid,nlayer  

      real ptimestep

      REAL pplev(ngrid,nlayer+1),pplay(ngrid,nlayer)
      REAL pt(ngrid,nlayer), pu(ngrid,nlayer),pv(ngrid,nlayer)
      REAL pdtgw(ngrid,nlayer), pdugw(ngrid,nlayer),pdvgw(ngrid,nlayer)


c
c    Local variables :
c    -----------------

      REAL sigtest(nlayermx+1)
      INTEGER igwd,igwdim,itest(ngridmx)

      INTEGER l,ig

      REAL zulow(ngridmx),zvlow(ngridmx)
      REAL zustr(ngridmx),zvstr(ngridmx)

      INTEGER zidx(ngridmx)

      logical ll


c   local saved variables
c   ---------------------

      LOGICAL firstcall
      DATA firstcall/.true./
      SAVE firstcall


c----------------------------------------------------------------------

c     Initialisation
c     --------------

      IF (firstcall) THEN
         do l=1,nlayermx+1
           sigtest(l)=pplev(1,l)/pplev(1,1)
         enddo
         call sugwd(nlayermx,sigtest)
         firstcall=.false.
      END IF

c       Detecting points concerned by the scheme
c       ----------------------------------------

        igwd=0
        DO ig=1, ngrid
          itest(ig)=0
          ll=zstd(ig).gt.50.0
          IF(ll) then
            itest(ig)=1
            igwd=igwd+1
            zidx(igwd)=ig
          ENDIF
        ENDDO
        IGWDIM=MAX(1,IGWD)

c       Calling gravity wave and subgrid scale topo parameterization
c       -------------------------------------------------------------

        call drag_noro (ngrid,nlayer,ptimestep,pplay,pplev,
     e            zstd,zsig,zgam,zthe,
     e            igwd,igwdim,zidx,itest,
     e            pt, pu, pv,
     s            zulow,zvlow,zustr,zvstr,
     s            pdtgw,pdugw,pdvgw)


c       Dividing by ptimestep (true tendancies)
c       ---------------------------------------

        do l=1,nlayer
         do ig = 1, ngrid
          pdtgw(ig,l) = pdtgw(ig,l)/ptimestep
          pdugw(ig,l) = pdugw(ig,l)/ptimestep
          pdvgw(ig,l) = pdvgw(ig,l)/ptimestep
         enddo
        enddo


      return
      end 

