      SUBROUTINE callsedim(ngrid,nlay, ptimestep,
     $                pplev,zlev, pt, rnuclei, rice,
     &                pq, pdqfi, pdqsed,pdqs_sed,nq)
      IMPLICIT NONE

c=======================================================================
c      Sedimentation of the  Martian aerosols
c      depending on their density and radius
c
c      F.Forget 1999
c
c=======================================================================

c-----------------------------------------------------------------------
c   declarations:
c   -------------

#include "dimensions.h"
#include "dimphys.h"
#include "comcstfi.h"
#include "tracer.h"
#include "callkeys.h"

c
c   arguments:
c   ----------

      INTEGER ngrid              ! number of horizontal grid points
      INTEGER nlay               ! number of atmospheric layers
      REAL ptimestep             ! physics time step (s)
      REAL pplev(ngrid,nlay+1)   ! pressure at inter-layers (Pa)
      REAL pt(ngrid,nlay)        ! temperature at mid-layer (K)
      REAL zlev(ngrid,nlay+1)    ! altitude at layer boundaries
c    Aerosol radius provided by the water ice microphysical scheme:
      REAL rnuclei(ngrid,nlay)   ! Prescribed dust radius in each layer (m)
      REAL rice(ngrid,nlay)    ! Estimated ice crystal radius (m)

c    Traceurs :
      integer nq             ! number of tracers
      real pq(ngrid,nlay,nq)  ! tracers (kg/kg)
      real pdqfi(ngrid,nlay,nq)  ! tendency before sedimentation (kg/kg.s-1)
      real pdqsed(ngrid,nlay,nq) ! tendency due to sedimentation (kg/kg.s-1)
      real pdqs_sed(ngrid,nq)    ! flux at surface (kg.m-2.s-1)
      
c   local:
c   ------

      INTEGER l,ig, iq

      real zqi(ngridmx,nlayermx) ! to locally store tracers
      real masse (ngridmx,nlayermx) ! Layer mass (kg.m-2)
      real epaisseur (ngridmx,nlayermx) ! Layer thickness (m)
      real wq(ngridmx,nlayermx+1) ! displaced tracer mass (kg.m-2)
c      real dens(ngridmx,nlayermx) ! Mean density of the ice part. accounting for dust core
      real rfall(ngridmx,nlayermx)


      LOGICAL firstcall
      SAVE firstcall
      DATA firstcall/.true./

c    ** un petit test de coherence
c       --------------------------

      IF (firstcall) THEN
         IF(ngrid.NE.ngridmx) THEN
            PRINT*,'STOP dans callsedim'
            PRINT*,'probleme de dimensions :'
            PRINT*,'ngrid  =',ngrid
            PRINT*,'ngridmx  =',ngridmx
            STOP
         ENDIF
      
        firstcall=.false.
      ENDIF ! of IF (firstcall)

c-----------------------------------------------------------------------
c    1. initialisation
c    -----------------
c
c     Calcul preliminaires  de caracteristiques des couches
c     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
c    Masse (kg.m-2), epaisseur(m), temps de traversee (s)  etc...


      do  l=1,nlay
        do ig=1, ngrid
          masse(ig,l)=(pplev(ig,l) - pplev(ig,l+1)) /g 
          epaisseur(ig,l)= zlev(ig,l+1) - zlev(ig,l)
        end do
      end do

      do iq=1,nq
        if(radius(iq).gt.1.e-9) then   ! no sedim for gaz (defined by radius=0)

c         On "update" la valeur de q apres les autres parametrisations
c         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

          do l=1,nlay
            do ig=1,ngrid
              ! store locally updated tracers
              zqi(ig,l)=pq(ig,l,iq)+pdqfi(ig,l,iq)*ptimestep
!              if (iceparty.and.iq.eq.nq-1) then
              if (water.and.(iq.eq.igcm_h2o_ice)) then
c               On affecte un rayon moyen aux poussieres a chaque altitude du type :
c               r(z)=r0*exp(-z/H) avec r0=0.8 micron et H=18 km.
c               ''''''''''''''''''''''''''''''''''''''''''''''''
                rfall(ig,l)=max( rice(ig,l)*1.5,rnuclei(ig,l) )
c modif FranckMM pour ameliorer cycle H2O: rfall= 20 microns
                rfall(ig,l)=min(rfall(ig,l),1.e-4)
!mars commente pour l'instant               rfall(ig,l)=20.e-6
              endif
            enddo
          enddo ! of do l=1,nlay

c         Calcul du transport par sedimentation pour chaque traceur
c         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!          if(iceparty.and.iq.eq.nq-1) then
          if (water.and.(iq.eq.igcm_h2o_ice)) then
            call newsedim(ngrid,nlay,ngrid*nlay,ptimestep,
     &      pplev,masse,epaisseur,pt,rfall,rho_q(iq),zqi,wq)
          else
            call newsedim(ngrid,nlay,1,ptimestep,
     &      pplev,masse,epaisseur,pt,radius(iq),rho_q(iq),zqi,wq)
          endif

c         Calcul des tendances
c         ~~~~~~~~~~~~~~~~~~~~
          do ig=1,ngrid 
!            if(iceparty.and.iq.eq.nq-1) then
!                pdqs_sed(ig,nq) = wq(ig,1)/ptimestep 
!            else
!                pdqs_sed(ig,iq) = wq(ig,1)/ptimestep 
!            endif
! Temporary: surface ice is qsurf(igcm_h2o_vap) ! no more
!            if(iceparty.and.(iq.eq.igcm_h2o_ice)) then
!                pdqs_sed(ig,igcm_h2o_vap) = wq(ig,1)/ptimestep 
!            else
!                pdqs_sed(ig,iq) = wq(ig,1)/ptimestep 
!            endif
! Ehouarn: with new way of tracking tracers by name, it should now simply be
            pdqs_sed(ig,iq)=wq(ig,1)/ptimestep
          end do

          DO l = 1, nlay
            DO ig=1,ngrid
c	      zqi(ig,l)=max(zqi(ig,l), 1.e-10)
              pdqsed(ig,l,iq)=(zqi(ig,l)-
     $        (pq(ig,l,iq) + pdqfi(ig,l,iq)*ptimestep))/ptimestep
            ENDDO
          ENDDO

        endif ! of if(radius(iq).gt.1.e-9)
      enddo ! of do iq=1,nq
 
      RETURN
      END

