      subroutine surfacearea(ngrid, nlay, pplay, pzlay, pt, pq, nq,
     $                       rdust, rice, tau, tauscaling,
     $                       surfdust, surfice)

      implicit none

!==========================================================================
!     calculation of the ice and dust surface area (m2/m3)
!     available for heterogeneous reactions
!
!     Franck Lefevre
!     version 1.0 november 2011
!==========================================================================

#include "dimensions.h"
#include "dimphys.h"
#include "comcstfi.h"
#include "callkeys.h"
#include "tracer.h"
#include "dimradmars.h"
#include "chimiedata.h"
#include "conc.h"

! input

      integer ngrid, nlay
      integer nq                   ! number of tracers
      real pplay(ngrid,nlay)       ! pressure at mid-layers (Pa)
      real pzlay(ngrid,nlay)       ! altitude at mid-layers (m)
      real pt(ngrid,nlay)          ! temperature at mid-layers (K)
      real pq(ngrid,nlay,nq)       ! tracers (kg/kg)
      real rdust(ngrid,nlay)       ! dust geometric mean radius (m)
      real rice(ngrid,nlay)        ! ice mass mean radius (m)
      real tau(ngrid,naerkind)     ! column dust optical depth at each point
      real tauscaling(ngrid)       ! conversion factor for dust amount

! output

      real surfdust(ngrid,nlay)    ! dust surface area (m2/m3)
      real surfice(ngrid,nlay)     ! water-ice surface area (m2/m3)

! local

      integer l, ig
      real rho                     ! density (kg/m3)
      real ccntyp                  ! typical dust number density (#/kg)
                                   ! (microphys = false)
      real rdusttyp                ! typical dust radius (m)
                                   ! (microphys = false)

!==========================================================================

      if (microphys) then ! improvedclouds
         do l = 1,nlay
            do ig = 1,ngrid
               rho = pplay(ig,l)/(rnew(ig,l)*pt(ig,l))
               surfdust(ig,l) = pq(ig,l,igcm_dust_number)*rho
     $                          *tauscaling(ig)
     $                          *4.*pi*rdust(ig,l)**2
               surfice(ig,l)  = pq(ig,l,igcm_ccn_number)*rho
     $                          *tauscaling(ig)
     $                          *4.*pi*rice(ig,l)**2
            end do
         end do
      else            ! simpleclouds
         do l = 1,nlay
            do ig = 1,ngrid
               rho = pplay(ig,l)/(rnew(ig,l)*pt(ig,l))
               rdusttyp = max(.8e-6*exp(-pzlay(ig,l)/18000.),1.e-9)
               ccntyp = 1.3e+8*max(tau(ig,1),0.001)/0.1
     $                  *exp(-pzlay(ig,l)/10000.)
               ccntyp = ccntyp/ccn_factor
               if (rice(ig,l) .gt. rdust(ig,l)) then
                  surfdust(ig,l) = ccntyp*(ccn_factor - 1.)*rho
     $                             *4.*pi*rdusttyp**2
                  surfice(ig,l)  = ccntyp*4.*pi*rice(ig,l)**2
               else
                  surfdust(ig,l) = ccntyp*ccn_factor*rho
     $                             *4.*pi*rdusttyp**2
                  surfice(ig,l)  = 0.
               end if
            end do
         end do
      end if         ! of microphys

! write diagnostics in micron2/cm3

      call wstats(ngrid,"surfdust", "Dust surface area",
     $            "micron2 cm-3",3,surfdust*1.e6)
      call writediagfi(ngrid,"surfdust", "Dust cloud surface area",
     $            "micron2 cm-3",3,surfdust*1.e6)
      call wstats(ngrid,"surfice", "Ice cloud surface area",
     $            "micron2 cm-3",3,surfice*1.e6)
      call writediagfi(ngrid,"surfice", "Ice cloud surface area",
     $            "micron2 cm-3",3,surfice*1.e6)

      return
      end
