**************************************
**************************************
**************************************
    PLANETOPLOT TUTORIAL EXAMPLES
**************************************
         Authors : AC + AS
**************************************
  DON'T FORGET YOUR BEST FRIEND IS
     pp.py -h [or] pp.py --help
**************************************
**************************************
**************************************


*************************************
MAPMODE 1 
MAPPING MODE
SIMPLE EXAMPLES on a SAMPLE GCM FILE
*************************************

Goal: The simplest, most minimal example. Mapping topography.
pp.py -f diagfired.nc

Goal: I would like finer contours.
pp.py -f diagfired.nc --div 30

Goal: I would like wind vectors.
pp.py -f diagfired.nc -W

Goal: I would like more vectors [i.e. lower the stride].
pp.py -f diagfired.nc -W -s 1

Goal: I want to map a given field (surface temperature).
pp.py -f diagfired.nc -v tsurf

Goal: I want to map two fields next to one another (topography and tauice).
pp.py -f diagfired.nc -v phisinit,tauice

Goal: I want to map two fields, tauice shaded, topography contoured, same plot.
pp.py -f diagfired.nc -v tauice -w phisinit

Goal: I want to map a field but projected on the sphere.
pp.py -f diagfired.nc -v tauice -p ortho

Goal: I want to redefine the minimum and maximum values shown.
pp.py -f diagfired.nc -v tauice -m 0.2 -M 0.9

Goal: I want to insert holes wherever values are lower than 0.2 and higher than 0.9
pp.py -f diagfired.nc -v tauice -m 0.2 -M 0.9 -H

Goal: I want to fill holes with an background image of Mars [you have to be connected to Internet]
pp.py -f diagfired.nc -v tauice -m 0.2 -M 0.9 -H -b vishires

Goal: I want the same map, but projected on the sphere
pp.py -f diagfired.nc -v tauice -m 0.2 -M 0.9 -H -b vishires -p ortho

Goal: I want the same map, but projected with north polar stereographic view
pp.py -f diagfired.nc -v tauice -m 0.2 -M 0.9 -H -b vishires -p npstere

Goal: I want to save this in PNG format
pp.py -f diagfired.nc -v tauice -m 0.2 -M 0.9 -H -b vishires -p ortho -S png

Goal: I want to animate this along time axis with fps=12
pp.py -f diagfired.nc -v tauice -m 0.2 -M 0.9 -H -b vishires -p ortho --rate 12

Goal: I want to plot results from two simulation files next to one another
pp.py -f diagfired.nc,diagfired.nc -v tsurf 

Goal: I want to plot results for two different times in the file next to one another
pp.py -f diagfi.nc -v tsurf --time 4 --time 7

Goal: I want to plot averaged results in the file from one time to another time
pp.py -f diagfi.nc -v tsurf --time 4,7

--- mesoscale stuff
Goal: I want to plot results for two different LOCAL times in the file next to one another
pp.py -f wrfout**** -v TSURF --time -4 -- time -7

Goal: The classic mountain GW plot
pp.py -f wrfout_d01_9999-09-09_09:00:00 -v W,tpot --lat 60 --time 15 -i 4 -l 30,130,100 --div 50

***********************************************************************************
Simple 2D plot: Zonal mean.
**********************************************************************************

Goal:

Plot the zonal mean temperature from a netcdf fiel representing one month.

Command:

gcm.py -f POLAR_NIGHT_RUN/diagfi16.nc --var temp --lon 180,-180 --time 0,65

Note:

The --time, --lat, --lon and --vert command takes in input values corresponding to the unit stored in the netcdf file, and not indices ! For example, if the "Time" unit is in sol (which is common for a gcm output), --time 2 means sol 2.0 and not index 2 along the time direction. Consequently, one can ask --time 2.5 for temperatures at 12:00 on sol 2.

Means are easy to perform by specifying a range. Here: --time 0,65 and --lat -180,180.

***********************************************************************************
Vertical interpolation of the field.
***********************************************************************************

Goal: 

Calls to zrecast and api are built-in the python functions. One can call them using -i with the appropriate argument (see meso.py -h or gcm.py -h). Here is an example that re-interpolates data using zrecast before plotting it in a 2D contour.

Command:

gcm.py -f POLAR_NIGHT_RUN/diagfi16.nc --var temp --lon -180,180 --time 0,65 -i 4

Note:

All interpolation modes available in zrecast and api (pressure, AGL, distance from planet center, etc...) are theoretically possible, but may not be coded yet in the routine. See gcm.py -h or meso.py -h.

For this example, the default behavior of zrecast for -i 4 is to interpolate in (m) from the local surface, between 0 and 150 km. The command will generate a reinterpolated netcdf file "POLAR_NIGHT_RUN/diagfi16_S.nc" with only the requested field, which is not deleted afterward.


***********************************************************************************
2D plot of the difference between two files.
***********************************************************************************

Goal:

Comparing two .nc files with similar dimension axis can be done in a single command, by specifying which files to compare and the comparison operator (i.e. is it a difference, an addition, etc...). When comparing data along a vertical axis, it can be wise to also ask for an interpolation of the fields to make sure the comparison is correct.

Command:

gcm.py -f POLAR_NIGHT_RUN/stats16.nc --var temp --lon -180,180 --time 1 -i 4 --fref POLAR_NIGHT_REF/stats16.nc --operation - --mope -2 --Mope 2 --title "Polar temperatures with new parametrizations" --titleref "Reference run"

Note:

The command will output 3 plots: the field from file 1, the field from file 2, and the comparison between the two. One can specify specific names for the title of these plots by using --title and --titleref for the titles of file 1 and file 2, and can specify different plotting range for the normal field (-m -M) and the compared field (--mope --Mope).

One can combine this command with projections and means, so that for example, to compare co2 depletion at the south pole:

gcm.py -f POLAR_NIGHT_RUN/start16.nc --var co2 --vert 0,150 --proj spstere --time 1 -i 4 --fref POLAR_NIGHT_REF/start16.nc --operation - --mope -0.5 --Mope 0.5 --title "Polar co2 with new parametrizations" --titleref "Reference run"

***********************************************************************************
2D plot of data with missing values, along a pressure axis (decreasing with height).
***********************************************************************************

Goal:

By default, python will force the y-axis of a 2D plot to be ordered by increasing values. Here is how to force it otherwise.

Command:

gcm.py -f TES.MappedClimatology.nadir.MY25.nc --var T_nadir_day --lat -76. --time 90 --ymin 500 --ymax 1 -m 128 -M 148 -H

Note:

The axis reversal is done by specifying ymin and ymax in the right order. One can also simply use --inverty and not specify (ymin,ymax). Missing values (out of range values) are replaced by holes by the option "-H".
