def getparseroptions(parser):

    ### I/O
    parser.add_option('-f', '--file',   action='append',dest='file',     type="string",  default=None,  help='[NEEDED] filename. Append: different figures. Comma-separated: same figure (+ possible --operation). Regex tip: -f `echo foo* | sed s+" "+","+g`')
    parser.add_option('-t', '--target', action='store',dest='tgt',       type="string",  default=None,  help='destination folder')
    parser.add_option('-S', '--save',   action='store',dest='save',      type="string",  default="gui", help='save mode (png,eps,svg,pdf,txt or gui) [gui]')
    parser.add_option('-d', '--display',action='store_false',dest='display',             default=True,  help='do not pop up created images')
    parser.add_option('-O','--output',  action='store',dest='out',       type="string",  default=None,  help='output file name')

    ### WHAT I PLOT
    parser.add_option('-v', '--var',    action='append',dest='var',      type="string",  default=None,  help='variable color-shaded (append)')
    parser.add_option('-w', '--with',   action='store',dest='var2',      type="string",  default=None,  help='variable contoured')
    parser.add_option('-a', '--anomaly',action='store_true',dest='anomaly',              default=False, help='compute and plot relative anomaly in %')
    parser.add_option('--mult',         action='store',dest='mult',      type="float",   default=1.,    help='a multiplicative factor to plotted field')
    parser.add_option('-m', '--min',    action='append',dest='vmin',     type="float",   default=None,  help='bounding minimum value (append)')    
    parser.add_option('-M', '--max',    action='append',dest='vmax',     type="float",   default=None,  help='bounding maximum value (append)') 
    parser.add_option('-H', '--hole',   action='store_true',dest='hole',                 default=False, help='holes above max and below min')
    parser.add_option('--nolow',        action='store_true',dest='nolow',                default=False, help='plot only minima and maxima [false]')

    ### VERTICAL INTERPOLATION
    parser.add_option('-l', '--level',  action='store',dest='lvl',       type="string",  default="0",   help='level / start,stop,step (-i 2: p,mb)(-i 3,4: z,km) [0]')
    parser.add_option('-i', '--interp', action='store',dest='itp',       type="int",     default=None,  help='interpolation (2: p, 3: z-amr, 4:z-als)')
    parser.add_option('--intas',        action='store',dest='intas',     type="string",  default=None,  help='specify "mcs" or "tes" for gcm P interpolation grid')
    parser.add_option('-N', '--no-api', action='store_true',dest='nocall',               default=False, help='do not recreate api file')

    ### GENERIC GRAPHICS SETTINGS
    parser.add_option('-c', '--color',  action='store',dest='clb',       type="string",  default="def", help='change colormap (nobar: no colorbar)')
    parser.add_option('--div',          action='store',dest='ndiv',      type="int",     default=10,    help='number of divisions in colorbar [10]')
    parser.add_option('--title',        action='store',dest='zetitle',   type="string",  default="fill",help='customize the whole title')
    parser.add_option('-T', '--tiled',  action='store_true',dest='tile',                 default=False, help='draw a tiled plot (no blank zone)')
    parser.add_option('--res',          action='store',dest='res',       type="float",   default=200.,  help='Resolution for png outputs. --save png needed. [200.]')

    ### SPECIFIC FOR MAPPING [MAPMODE 1]
    parser.add_option('-p', '--proj',   action='store',dest='proj',      type="string",  default=None,  help='projection')
    parser.add_option('-b', '--back',   action='store',dest='back',      type="string",  default=None,  help='background image [None]')
    parser.add_option('-s', '--stride', action='store',dest='ste',       type="int",     default=3,     help='stride vectors [3]')
    parser.add_option('-W', '--winds',  action='store_true',dest='winds',                default=False, help='wind vectors [False]')
    parser.add_option('-z', '--zoom',   action='store',dest='zoom',      type="float",   default=None,  help='zoom factor in %')
    parser.add_option('--blat',         action='store',dest='blat',      type="int",     default=None,  help='bounding latitude for stereographic plots [computed]')

    ### SPECIFIC FOR SLICING [MAPMODE 0]
    parser.add_option('--lat',          action='append',dest='slat',   type="string",  default=None, help='slices along lat. 2 comma-separated values: averaging')
    parser.add_option('--lon',          action='append',dest='slon',   type="string",  default=None, help='slices along lon. 2 comma-separated values: averaging')
    parser.add_option('--vert',         action='append',dest='svert',  type="string",  default=None, help='slices along vert. 2 comma-separated values: averaging') 
    parser.add_option('--column',       action='store_true',dest='column',             default=False,help='changes --vert z1,z2 from MEAN to INTEGRATE along z')
    parser.add_option('--time',         action='append',dest='stime',  type="string",  default=None, help='slices along time. 2 comma-separated values: averaging. negative: local time [meso].') 
    parser.add_option('--xmax',         action='store',dest='xmax',    type="float",   default=None, help='max value for x-axis in contour-plots [max(xaxis)]')
    parser.add_option('--ymax',         action='store',dest='ymax',    type="float",   default=None, help='max value for y-axis in contour-plots [max(yaxis)]')
    parser.add_option('--xmin',         action='store',dest='xmin',    type="float",   default=None, help='min value for x-axis in contour-plots [min(xaxis)]')
    parser.add_option('--ymin',         action='store',dest='ymin',    type="float",   default=None, help='min value for y-axis in contour-plots [min(yaxis)]')
    parser.add_option('--inverty',      action='store_true',dest='inverty',            default=False,help='force decreasing values along y-axis (e.g. p-levels)')
    parser.add_option('--logy',         action='store_true',dest='logy',               default=False,help='set y-axis to logarithmic.')   

    ### OPERATIONS BETWEEN FILES
    parser.add_option('--operation',    action='store',dest='operat',  type="string",  default=None,  help='operation to perform on input files given through -f. "+" or "-" acts on each input file by adding or substracting the ref file specified through --fref. "cat" acts on all input files in-a-row. "add_var" "sub_var" "mul_var" "div_var" acts on two variables.')
    parser.add_option('--fref',         action='store',dest='fref',    type="string",  default=None,  help='reference namefile for the --operation option.')
    parser.add_option('--mope',         action='store',dest='vminope', type="float",   default=0.,  help='bounding minimum value for inter-file operation')
    parser.add_option('--Mope',         action='store',dest='vmaxope', type="float",   default=0.,  help='bounding maximum value for inter-file operation')
    parser.add_option('--titleref',     action='store',dest='titref',  type="string",  default="fill",  help='title for the reference file. [title of fig (1)]')

    ### SPECIAL
    parser.add_option('--tsat',         action='store_true',dest='tsat',               default=False,help='convert temperature field T in Tsat-T using pressure')
    parser.add_option('--rate',         action='store'     ,dest='rate', type="int",   default=None, help='Output is a movie along Time dimension. --time must not be specified. [None]')
    parser.add_option('--quality',      action='store_true',dest='quality',            default=False,help='For movie mode: improves movie quality.(slower)')

    return parser
