MODULE physics
!-----------------------------------------------------------------------
! NAME
!     physics
!
! DESCRIPTION
!     Fundamental constants read from file and used across PEM modules.
!
! AUTHORS & DATE
!     JB Clement, 12/2025
!
! NOTES
!
!-----------------------------------------------------------------------

! DEPENDENCIES
! ------------
use numerics, only: dp

! DECLARATION
! -----------
implicit none

! PARAMETERS
! ----------
real(dp), protected :: g     ! Gravity [m/s2]
real(dp), protected :: r     ! Reduced gas constant,r = 8.314511/[mugaz/1000.0]
real(dp), protected :: mugaz ! Molar mass of the atmosphere [g/mol]
real(dp), protected :: rad   ! Radius of the planet [m]
real(dp), protected :: cpp   ! Cp of the atmosphere
real(dp), protected :: rcp   ! r/cpp (= kappa in the dynamics)

contains
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

!=======================================================================
SUBROUTINE init_physics(rad_in,g_in,mugaz_in,rcp_in)
!-----------------------------------------------------------------------
! NAME
!     init_physics
!
! DESCRIPTION
!     Initialize physical constants.
!
! AUTHORS & DATE
!     JB Clement, 01/2026
!
! NOTES
!
!-----------------------------------------------------------------------

! DECLARATION
! -----------
implicit none

! ARGUMENTS
! ---------
real(dp), intent(in) :: rad_in, g_in, mugaz_in, rcp_in

! CODE
! ----
rad = rad_in
g = g_in
mugaz = mugaz_in
rcp = rcp_in
r = 8.314511_dp*1000._dp/mugaz
cpp = r/rcp

END SUBROUTINE init_physics
!=======================================================================

END MODULE physics
