MODULE writerestart1D_mod

implicit none

contains

SUBROUTINE writerestart1D(filename,psurf,pa,preff,tsurf,nlayer,nslope,temp,u,v,nq,qnames,q)

implicit none

! Arguments
character(*),                intent(in) :: filename
integer,                     intent(in) :: nlayer, nq, nslope
real,                        intent(in) :: psurf, pa, preff
real, dimension(nslope),     intent(in) :: tsurf
real, dimension(nlayer),     intent(in) :: temp, u, v
real, dimension(nlayer,nq),  intent(in) :: q
character(*), dimension(nq), intent(in) :: qnames

! Local variables
integer :: i, j, il

! Write the data needed for a restart in "restart1D.txt"
open(1,file = filename,status = "replace",action = "write")
write(1,*) 'ps', psurf, pa, preff
do i = 1,nq
    write(1,*) qnames(i), (q(il,i), il = 1,nlayer)
enddo
write(1,*) 'u', (u(il), il = 1,nlayer)
write(1,*) 'v', (v(il), il = 1,nlayer)
write(1,*) 'teta', (tsurf(j), j = 1,nslope), (temp(il), il = 1,nlayer)
close(1)

END SUBROUTINE writerestart1D

END MODULE writerestart1D_mod
