MODULE callkeys_mod

IMPLICIT NONE

logical,save :: startphy_file
!$OMP THREADPRIVATE(startphy_file)

logical,save :: callrad,calldifv,calladj,callcond,callsoil
!$OMP THREADPRIVATE(callrad,calldifv,calladj,callcond,callsoil)
logical,save :: season,diurnal,calllott,calllott_nonoro
!$OMP THREADPRIVATE(season,diurnal,calllott,calllott_nonoro)
logical,save :: calleofdump
!$OMP THREADPRIVATE(calleofdump)
logical,save :: callnirco2,callnlte,callthermos,callconduct
!$OMP THREADPRIVATE(callnirco2,callnlte,callthermos,callconduct)
logical,save :: calleuv,callmolvis,callmoldiff,thermochem,thermoswater
!$OMP THREADPRIVATE(calleuv,callmolvis,callmoldiff,thermochem,thermoswater)
logical,save :: calltherm,callrichsl,callslope,tituscap
!$OMP THREADPRIVATE(calltherm,callrichsl,callslope,tituscap)
logical,save :: callyamada4,callatke
!$OMP THREADPRIVATE(callyamada4,callatke)
logical,save :: callemis
logical,save :: callg2d
!$OMP THREADPRIVATE(callemis,callg2d)
logical,save :: linear ! ?!?
!$OMP THREADPRIVATE(linear)
logical,save :: gwd_convective_source
!$OMP THREADPRIVATE(gwd_convective_source)

real,save :: semi ! ?!?
!$OMP THREADPRIVATE(semi)
real,save :: alphan ! ?!?
!$OMP THREADPRIVATE(alphan)
real,save :: fixed_euv_value
!$OMP THREADPRIVATE(fixed_euv_value)
real,save :: euveff
!$OMP THREADPRIVATE(euveff)
real,save :: tke_heat_flux
!$OMP THREADPRIVATE(tke_heat_flux)
real,save :: coeff_injection ! dust injection scheme coefficient
!$OMP THREADPRIVATE(coeff_injection)
real,save :: ti_injection ! local time of beginning injection
real,save :: tf_injection ! local time of end injection
!$OMP THREADPRIVATE(ti_injection,tf_injection)
real,save :: coeff_detrainment ! rocket dust detrainment coefficient
!$OMP THREADPRIVATE(coeff_detrainment)
real,save :: CLFfixval
!$OMP THREADPRIVATE(CLFfixval)

integer,save :: iaervar
!$OMP THREADPRIVATE(iaervar)
integer,save :: iradia
!$OMP THREADPRIVATE(iradia)
integer,save :: ilwd
integer,save :: ilwb
integer,save :: ilwn
!$OMP THREADPRIVATE(ilwd,ilwb,ilwn)
integer,save :: ncouche
!$OMP THREADPRIVATE(ncouche)
integer,save :: solvarmod   ! model for solar EUV variation
!$OMP THREADPRIVATE(solvarmod)
integer,save :: solvaryear  ! mars year for realisticly varying solar EUV 
!$OMP THREADPRIVATE(solvaryear)
integer,save :: dustinjection ! dust injection scheme number 
!$OMP THREADPRIVATE(dustinjection)

logical,save :: rayleigh
!$OMP THREADPRIVATE(rayleigh)
logical,save :: scavenging
!$OMP THREADPRIVATE(scavenging)
logical,save :: rdstorm ! rocket dust storm parametrization
!$OMP THREADPRIVATE(rdstorm)
logical,save :: topflows ! entrainment by mountain top dust flows parametrization
!$OMP THREADPRIVATE(topflows)
logical,save :: coagulation ! coagulation of dust particles
logical,save :: fullcoag ! coagulation of dust particles using full equations instead of lookup tables
logical,save :: kernel_b, kernel_g, kernel_de, kernel_ti ! kernels for different types of dust coagulation
!$OMP THREADPRIVATE(coagulation,fullcoag,kernel_b,kernel_g,kernel_de,kernel_ti)
integer,save :: coal_kg ! mode for coalescence 0,1, or 2 
!$OMP THREADPRIVATE(coal_kg)
logical,save :: latentheat_surfwater ! latent heat release from ground water ice sublimation/condensation
!$OMP THREADPRIVATE(latentheat_surfwater)
logical,save :: cst_cap_albedo ! polar cap albedo remains unchanged by water frost deposition
!$OMP THREADPRIVATE(cst_cap_albedo)
logical,save :: temp_dependent_m ! temperature-dependent water contact parameter
!$OMP THREADPRIVATE(temp_dependent_m)
logical,save :: refill_watercap ! h2o_ice_s is converted to watercap when above threshold
!$OMP THREADPRIVATE(refill_watercap)
logical,save :: cloud_adapt_ts ! adaptative timestep for cloud microphysics
!$OMP THREADPRIVATE(cloud_adapt_ts)
logical,save :: sedimentation
!$OMP THREADPRIVATE(sedimentation)
logical,save :: activice,surfaceice_tifeedback,supersat,caps
!$OMP THREADPRIVATE(activice,surfaceice_tifeedback,supersat,caps)
logical,save :: poreice_tifeedback
!$OMP THREADPRIVATE(poreice_tifeedback)
logical,save :: co2clouds,co2useh2o,meteo_flux,CLFvaryingCO2,satindexco2
!$OMP THREADPRIVATE(co2clouds,co2useh2o,meteo_flux,CLFvaryingCO2,satindexco2)
logical,save :: activeco2ice
!$OMP THREADPRIVATE(activeco2ice)
integer,save :: spantCO2
!$OMP THREADPRIVATE(spantCO2)
logical,save :: CLFvarying
!$OMP THREADPRIVATE(CLFvarying)
logical,save :: water
!$OMP THREADPRIVATE(water)
logical,save :: hdo
logical,save :: hdofrac
!$OMP THREADPRIVATE(hdo,hdofrac)
logical,save :: microphys
!$OMP THREADPRIVATE(microphys)
logical,save :: photochem
!$OMP THREADPRIVATE(photochem)
integer,save :: nltemodel
!$OMP THREADPRIVATE(nltemodel)
integer,save :: nircorr
!$OMP THREADPRIVATE(nircorr)

character(len=100),save :: dustiropacity
!$OMP THREADPRIVATE(dustiropacity)
real,save :: dustrefir 
!$OMP THREADPRIVATE(dustrefir)
  
integer,parameter :: swrtype=2 ! type of short wave (solar wavelength) radiative
      ! transfer to use 1: Fouquart 2: Toon.

END MODULE callkeys_mod
