module comm_wrf

!!
!! This module is useful to output fields in WRF style
!!
!USE only for the mescoscale (comm_HR_SW, comm_HR_LW). OUTPUT
  REAL,SAVE,ALLOCATABLE :: comm_HR_SW(:,:)
  REAL,SAVE,ALLOCATABLE :: comm_HR_LW(:,:)
  REAL,SAVE,ALLOCATABLE :: comm_HR_DYN(:,:)
  REAL,SAVE,ALLOCATABLE :: comm_SWDOWNZ(:)
  REAL,SAVE,ALLOCATABLE :: comm_MTOT(:)
  REAL,SAVE,ALLOCATABLE :: comm_GEOP(:,:)
  REAL,SAVE,ALLOCATABLE :: comm_ALBEQ(:) 
  REAL,SAVE,ALLOCATABLE :: comm_FLUXTOP_DN(:)
  REAL,SAVE,ALLOCATABLE :: comm_FLUXABS_SW(:)
  REAL,SAVE,ALLOCATABLE :: comm_FLUXTOP_LW(:)
  REAL,SAVE,ALLOCATABLE :: comm_FLUXSURF_SW(:)
  REAL,SAVE,ALLOCATABLE :: comm_FLUXSURF_LW(:)
  REAL,SAVE,ALLOCATABLE :: comm_FLXGRD(:)
  REAL,SAVE,ALLOCATABLE :: comm_zqfi_omp(:,:,:)
  REAL,SAVE,ALLOCATABLE :: comm_zdtlc(:,:)
  REAL,SAVE,ALLOCATABLE :: comm_rh_ch4(:,:)

contains

  subroutine allocate_comm_wrf(ngrid,nlayer,nq)
  implicit none
  integer,intent(in) :: ngrid  ! number of atmospheric columns
  integer,intent(in) :: nlayer ! number of atmospheric layers
  integer,intent(in) :: nq     ! number of tracers
  allocate(comm_HR_SW(ngrid,nlayer))
  allocate(comm_HR_LW(ngrid,nlayer))
  allocate(comm_HR_DYN(ngrid,nlayer))
  allocate(comm_SWDOWNZ(ngrid))
  allocate(comm_MTOT(ngrid))
  allocate(comm_GEOP(ngrid,nlayer))
  allocate(comm_ALBEQ(ngrid))
  allocate(comm_FLUXTOP_DN(ngrid))
  allocate(comm_FLUXABS_SW(ngrid))
  allocate(comm_FLUXTOP_LW(ngrid))
  allocate(comm_FLUXSURF_SW(ngrid))
  allocate(comm_FLUXSURF_LW(ngrid))
  allocate(comm_FLXGRD(ngrid))
  allocate(comm_zqfi_omp(ngrid,nlayer,nq))
  allocate(comm_zdtlc(ngrid,nlayer))
  allocate(comm_rh_ch4(ngrid,nlayer))

  end subroutine allocate_comm_wrf

  subroutine deallocate_comm_wrf
  implicit none
  deallocate(comm_HR_SW)
  deallocate(comm_HR_LW)
  deallocate(comm_HR_DYN)
  deallocate(comm_SWDOWNZ)
  deallocate(comm_MTOT)
  deallocate(comm_GEOP)
  deallocate(comm_ALBEQ)
  deallocate(comm_FLUXTOP_DN)
  deallocate(comm_FLUXABS_SW)
  deallocate(comm_FLUXTOP_LW)
  deallocate(comm_FLUXSURF_SW)
  deallocate(comm_FLUXSURF_LW)
  deallocate(comm_FLXGRD)
  deallocate(comm_zqfi_omp)
  deallocate(comm_zdtlc)
  deallocate(comm_rh_ch4)

  end subroutine deallocate_comm_wrf

end module comm_wrf

