MODULE update_outputs_physiq_mod

CONTAINS

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE update_outputs_physiq_surf( &
            ims,ime,jms,jme,&
            ips,ipe,jps,jpe,&
            TRACER_MODE,&
            P_TSURF,P_CO2ICE,&
            P_H2OICE)

   !use surfdat_h, only: tsurf, co2ice, qsurf
   use phys_state_var_mod, only : tsurf,qsurf

   INTEGER, INTENT(IN) :: ims,ime,jms,jme
   INTEGER, INTENT(IN) :: ips,ipe,jps,jpe
   INTEGER, INTENT(IN) :: TRACER_MODE
   INTEGER :: i,j,subs
   REAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT)  :: &
     P_TSURF,P_CO2ICE,P_H2OICE

   DO j = jps,jpe
   DO i = ips,ipe

     !-----------------------------------!
     ! 1D subscript for physics "cursor" !
     !-----------------------------------!
     subs = (j-jps)*(ipe-ips+1)+(i-ips+1)

     !-------------------------------------------------------!
     ! Save key variables for restart and output and nesting !  
     !-------------------------------------------------------!
     P_TSURF(i,j) = tsurf(subs)

   ENDDO
   ENDDO

END SUBROUTINE update_outputs_physiq_surf

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE update_outputs_physiq_soil( &
            ims,ime,jms,jme,&
            ips,ipe,jps,jpe,&
            nsoil,&
            P_TSOIL)

   !use comsoil_h, only: tsoil
    use phys_state_var_mod, only : tsoil

   INTEGER, INTENT(IN) :: ims,ime,jms,jme
   INTEGER, INTENT(IN) :: ips,ipe,jps,jpe,nsoil
   INTEGER :: i,j,subs
   REAL, DIMENSION( ims:ime, nsoil, jms:jme ), INTENT(INOUT)  :: &
     P_TSOIL

   DO j = jps,jpe
   DO i = ips,ipe

     !-----------------------------------!
     ! 1D subscript for physics "cursor" !
     !-----------------------------------!
     subs = (j-jps)*(ipe-ips+1)+(i-ips+1)

     !-------------------------------------------------------!
     ! Save key variables for restart and output and nesting !  
     !-------------------------------------------------------!
     P_TSOIL(i,:,j) = tsoil(subs,:)

   ENDDO
   ENDDO

END SUBROUTINE update_outputs_physiq_soil

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE update_outputs_physiq_rad( &
            ims,ime,jms,jme,&
            ips,ipe,jps,jpe,&
            P_FLUXRAD)

   !use dimradmars_mod, only: fluxrad
   use phys_state_var_mod, only : fluxrad

   INTEGER, INTENT(IN) :: ims,ime,jms,jme
   INTEGER, INTENT(IN) :: ips,ipe,jps,jpe
   INTEGER :: i,j,subs
   REAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT)  :: P_FLUXRAD

   DO j = jps,jpe
   DO i = ips,ipe

     !-----------------------------------!
     ! 1D subscript for physics "cursor" !
     !-----------------------------------!
     subs = (j-jps)*(ipe-ips+1)+(i-ips+1)

     !-------------------------------------------------------!
     ! Save key variables for restart and output and nesting !  
     !-------------------------------------------------------!
     P_FLUXRAD(i,j) = fluxrad(subs)

   ENDDO
   ENDDO

END SUBROUTINE update_outputs_physiq_rad

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE update_outputs_physiq_turb( &
            ims,ime,jms,jme,kms,kme,&
            ips,ipe,jps,jpe,kps,kpe,&
            P_Q2,P_WSTAR,&
            HFMAX,ZMAX,USTM,HFX)

   use turb_mod, only: q2,wstar,ustar,sensibFlux!,&
                        !hfmax_th,zmax_th
   !use phys_state_var_mod, only : q2,sensibFlux

   INTEGER, INTENT(IN) :: ims,ime,jms,jme,kms,kme
   INTEGER, INTENT(IN) :: ips,ipe,jps,jpe
   INTEGER :: i,j,subs    
   REAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT)  :: &
     P_WSTAR,HFMAX,ZMAX,USTM,HFX
   REAL, DIMENSION( ims:ime, kms:kme+1, jms:jme ), INTENT(INOUT) :: P_Q2
  
   DO j = jps,jpe
   DO i = ips,ipe

     !-----------------------------------!
     ! 1D subscript for physics "cursor" !
     !-----------------------------------!
     subs = (j-jps)*(ipe-ips+1)+(i-ips+1)

     !-------------------------------------------------------!
     ! Save key variables for restart and output and nesting !  
     !-------------------------------------------------------!
     P_Q2(i,kps:kpe+1,j) = q2(subs,:)
     P_WSTAR(i,j) = wstar(subs)
     !! output only (arrays already in phys modules)
     !HFMAX(i,j) = HFMAX_TH(subs)
     !ZMAX(i,j) = ZMAX_TH(subs)
     USTM(i,j) = ustar(subs)
     HFX(i,j) = sensibFlux(subs) ! *-1 ?????

   ENDDO
   ENDDO

END SUBROUTINE update_outputs_physiq_turb

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE update_outputs_physiq_diag( &
            ims,ime,jms,jme,kms,kme,&
            ips,ipe,jps,jpe,kps,kpe,&
            HR_SW,HR_LW,HR_DYN,&
            DT_RAD,&
            CLOUDFRAC,TOTCLOUDFRAC,&
            RH,&
            DQICE,DQVAP,&
            REEVAP,SURFRAIN,ALBEQ,FLUXTOP_DN,FLUXABS_SW,FLUXTOP_LW,FLUXSURF_SW,&
            FLUXSURF_LW,FLXGRD,&
            DTLSC,DTRAIN,DT_MOIST,&
            H2OICE_REFF,LATENT_HF,&
            DT_COND,RSAT_CH4)

   USE comm_wrf !! to get fields to be written from physiq

   INTEGER, INTENT(IN) :: ims,ime,jms,jme,kms,kme
   INTEGER, INTENT(IN) :: ips,ipe,jps,jpe,kps,kpe
   REAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: &
     TOTCLOUDFRAC,ALBEQ,FLUXTOP_DN,FLUXABS_SW,FLUXTOP_LW,FLUXSURF_SW,&
     FLUXSURF_LW,FLXGRD,LATENT_HF,REEVAP,SURFRAIN
   REAL, DIMENSION( ims:ime, kms:kme, jms:jme ), INTENT(INOUT ) :: &
     HR_SW,HR_LW,CLOUDFRAC,HR_DYN,DT_RAD,RH,DQICE,DQVAP,&
     DTLSC,DTRAIN,DT_MOIST,H2OICE_REFF,DT_COND,RSAT_CH4
   INTEGER :: i,j,subs

   DO j = jps,jpe
   DO i = ips,ipe

     !-----------------------------------!
     ! 1D subscript for physics "cursor" !
     !-----------------------------------!
     subs = (j-jps)*(ipe-ips+1)+(i-ips+1)

     !! get diagnostics from physics
     HR_SW(i,kps:kpe,j) = comm_HR_SW(subs,kps:kpe)
     HR_LW(i,kps:kpe,j) = comm_HR_LW(subs,kps:kpe)
     DT_RAD(i,kps:kpe,j) = HR_LW(i,kps:kpe,j) + HR_SW(i,kps:kpe,j)
!    CLOUDFRAC(i,kps:kpe,j) = comm_CLOUDFRAC(subs,kps:kpe)
!    TOTCLOUDFRAC(i,j) = comm_TOTCLOUDFRAC(subs)
!    RH(i,kps:kpe,j) = comm_RH(subs,kps:kpe)
!    DQICE(i,kps:kpe,j) = comm_DQICE(subs,kps:kpe)
!    DQVAP(i,kps:kpe,j) = comm_DQVAP(subs,kps:kpe)
     HR_DYN(i,kps:kpe,j) = comm_HR_DYN(subs,kps:kpe)
     ALBEQ(i,j)=comm_ALBEQ(subs)
     FLUXTOP_DN(i,j) = comm_FLUXTOP_DN(subs)
     FLUXABS_SW(i,j) = comm_FLUXABS_SW(subs)
     FLUXTOP_LW(i,j) = comm_FLUXTOP_LW(subs)
     FLUXSURF_SW(i,j) = comm_FLUXSURF_SW(subs)
     FLUXSURF_LW(i,j) = comm_FLUXSURF_LW(subs)
     FLXGRD(i,j) = comm_FLXGRD(subs)
     DT_COND(i,kps:kpe,j) = comm_ZDTLC(subs,kps:kpe)
     RSAT_CH4(i,kps:kpe,j) = comm_rsat_ch4(subs,kps:kpe)
!    DTLSC(i,kps:kpe,j) = comm_DTLSC(subs,kps:kpe)
!    DTRAIN(i,kps:kpe,j) = comm_DTRAIN(subs,kps:kpe)
!    DT_MOIST(i,kps:kpe,j) = DTRAIN(i,kps:kpe,j) + DTLSC(i,kps:kpe,j)
!    H2OICE_REFF(i,kps:kpe,j) = comm_H2OICE_REFF(subs,kps:kpe)
!    LATENT_HF(i,j) = comm_LATENT_HF(subs)
!    REEVAP(i,j) = comm_REEVAP(subs)
!    SURFRAIN(i,j) = comm_SURFRAIN(subs)


   ENDDO
   ENDDO

   CALL deallocate_comm_wrf

END SUBROUTINE update_outputs_physiq_diag

END MODULE update_outputs_physiq_mod



