MODULE time_phylmdz_mod

    IMPLICIT NONE
    REAL,SAVE    :: dtphys     ! physics time step (s)
!$OMP THREADPRIVATE(dtphys)
    INTEGER,SAVE :: nday       ! number of days to run
!$OMP THREADPRIVATE(nday)
    REAL,SAVE    :: daysec     ! length of day (s)
!$OMP THREADPRIVATE(daysec)
    INTEGER,SAVE :: day_ini     ! initial day of the run
!$OMP THREADPRIVATE(day_ini)

    INTEGER,SAVE :: diagfi_output_rate  ! for diagfi.nc outputs, write every diagfi_output_rate physical steps (set via inifis)
    INTEGER,SAVE :: startfi_output_rate ! mainly for debugging
!$OMP THREADPRIVATE(diagfi_output_rate,startfi_output_rate)

    LOGICAL,SAVE :: slow_diagfi ! to handle wether the netcdf file is
                                ! opened/close once or at output frequency
!$OMP THREADPRIVATE(slow_diagfi)

CONTAINS

  SUBROUTINE init_time(day_ini_, daysec_, nday_, dtphys_)
    IMPLICIT NONE
    INTEGER,INTENT(IN) :: day_ini_
    REAL,INTENT(IN) :: daysec_
    INTEGER,INTENT(IN) :: nday_
    REAL,INTENT(IN) :: dtphys_

    day_ini=day_ini_
    daysec=daysec_
    nday=nday_
    dtphys=dtphys_

  END SUBROUTINE init_time

END MODULE time_phylmdz_mod
