module nirdata_mod

implicit none

! Number of pressures in NIR correction table
integer,parameter :: npres=42   

real,save,protected :: pres1d(npres)
real,save,protected :: corgcm(npres)
real,save,protected :: oco21d(npres)
real,save,protected :: alfa(npres)
real,save,protected :: p1999(npres)
!$OMP THREADPRIVATE(pres1d,corgcm,oco21d,alfa,p1999)

contains

  subroutine NIR_leedat 

! 	reads parameters for NIR NLTE calculation    

! 	nov 2011    fgg+malv    first version                
!***********************************************************************

    use datafile_mod, only: datadir
#ifndef MESOSCALE
    USE mod_phys_lmdz_para, ONLY: is_master
    USE mod_phys_lmdz_transfert_para, ONLY: bcast
#endif
    implicit none

! local variables                               

    integer :: ind
#ifndef MESOSCALE
    if (is_master) then
#endif
      open(43,file=trim(datadir)//'/NIRcorrection_feb2011.dat', &
             status='old')
      do ind=1,9
        read(43,*)
      enddo
      
      do ind=1,npres
         read(43,*)pres1d(ind),corgcm(ind),oco21d(ind),p1999(ind), &
              alfa(ind)
         !Tabulated pression to Pa
         pres1d(ind)=pres1d(ind)*100.
      enddo
      close(43)
#ifndef MESOSCALE
    endif !  if(is_master) then
    call bcast(pres1d)
    call bcast(corgcm)
    call bcast(oco21d)
    call bcast(p1999)
    call bcast(alfa)
#endif
  end subroutine NIR_leedat 

end module nirdata_mod
