MODULE stop_pem
!-----------------------------------------------------------------------
! NAME
!     stop_pem
!
! DESCRIPTION
!     Clean stopping utilities for PEM: close outputs and report reason.
!
! AUTHORS & DATE
!     JB Clement, 2025
!
! NOTES
!
!-----------------------------------------------------------------------

! DECLARATION
! -----------
implicit none

contains
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

!=======================================================================
SUBROUTINE stop_clean(modname,message,ierr)
!-----------------------------------------------------------------------
! NAME
!     stop_clean
!
! DESCRIPTION
!     Stop simulation cleanly, closing files and printing diagnostics.
!
! AUTHORS & DATE
!     JB Clement, 2025
!
! NOTES
!     Taken from Mars PCM.
!-----------------------------------------------------------------------

! DEPENDENCIES
! ------------
#ifdef CPP_IOIPSL
    use IOIPSL
#else
    ! If not using IOIPSL, we still need to use (a local version of) getin_dump
    use ioipsl_getincom
#endif
#ifdef CPP_XIOS
    use wxios ! For XIOS outputs
#endif

! DECLARATION
! -----------
implicit none

#include "iniprint.h"

! ARGUMENTS
! ---------
character(*), intent(in) :: modname ! name of calling program
integer,      intent(in) :: ierr    ! severity of situation (= 0 normal)
character(*), intent(in) :: message ! stuff to print

! CODE
! ----
#ifdef CPP_XIOS
    CALL wxios_close() ! Closing XIOS properly
#endif

#ifdef CPP_IOIPSL
    call histclo()
    call restclo()
#endif

call getin_dump()
write(lunout,*) 'stop_pem: stopping in ', modname
write(lunout,*) 'Reason = ', message
if (ierr == 0) then
    write(lunout,*) 'Everything is cool!'
    error stop
else
    write(lunout,*) 'Houston, we have a problem! ierr =', ierr
    error stop 1
endif

END SUBROUTINE stop_clean
!=======================================================================

END MODULE stop_pem
