MODULE evolution
!-----------------------------------------------------------------------
! NAME
!     evolution
!
! DESCRIPTION
!     Contains global parameters used for the evolution flags.
!
! AUTHORS & DATE
!     R. Vandemeulebrouck
!     JB Clement, 2023-2025
!
! NOTES
!
!-----------------------------------------------------------------------

! DECLARATION
! -----------
implicit none

! PARAMETERS
! ----------
real    :: year_bp_ini   ! Initial year (in Planetary years) of the simulation of the PEM defined in run.def (in Earth years)
real    :: dt            ! Time step used by the PEM in Planetary years
real    :: convert_years ! Conversion ratio from Planetary years to Earth years
real    :: nyears_max    ! Maximal number of iterations when converging to a steady state, read in evol.def
logical :: evol_orbit    ! True if we want to follow the orbital parameters of obl_ecc_lsp.asc, read in evol.def
logical :: var_obl       ! True if we want the PEM to follow obl_ecc_lsp.asc parameters for obliquity
logical :: var_ecc       ! True if we want the PEM to follow obl_ecc_lsp.asc parameters for eccenticity
logical :: var_lsp       ! True if we want the PEM to follow obl_ecc_lsp.asc parameters for ls perihelie

END MODULE evolution
