MODULE tracers

implicit none

! Indices for tracers taken from the PCM
integer :: iPCM_qh2o

! Molar masses of tracers
type :: mmol
    real :: h2o
end type mmol

!=======================================================================
contains
!=======================================================================

SUBROUTINE ini_tracers_id(nqtot,noms)

implicit none

! Arguments
!----------
integer,                        intent(in) :: nqtot
character(*), dimension(nqtot), intent(in) :: noms

! Local variables
!----------------
integer :: i

! Code
!-----
! Initialization
iPCM_qh2o = -1

! Getting the index
do i = 1,nqtot
    if (noms(nnq) == "h2o_vap") then
        iPCM_qh2o = nnq
        mmol%h2o = 18.
    endif
enddo

! Checking if everything has been found
if (iPCM_qh2o < 0) error stop 'ini_frost_id: H2O vapour index not found!'

END SUBROUTINE ini_frost_id

END MODULE tracers
