MODULE grid_conversion

implicit none

!=======================================================================
contains
!=======================================================================
SUBROUTINE lonlat2vect(nlon,nlat,ngrid,v_ll,v_vect)
! To convert data from lon x lat grid (where values at the poles are duplicated) into a vector
! /!\ The longitudes -180 and +180 are not duplicated like in the PCM dynamics

implicit none

! Arguments
!----------
integer,                    intent(in) :: nlon, nlat, ngrid
real, dimension(nlon,nlat), intent(in) :: v_ll
real, dimension(ngrid), intent(out) :: v_vect

! Local variables
!----------------
integer :: i, j

! Code
!-----
! 1D case
#ifdef CPP_1D
    v_vect(1) = v_ll(1,1)
    return
#else
    ! Check
    if (ngrid /= nlon*(nlat - 2) + 2) error stop 'lonlat2vect: problem of dimensions!'

    ! Initialization
    v_vect = 0.

    ! Treatment of the poles
    v_vect(1) = v_ll(1,1)
    v_vect(ngrid) = v_ll(1,nlat)

    ! Treatment of regular points
    do j = 2,nlat - 1
        do i = 1,nlon
            v_vect(1 + i + (j - 2)*nlon) = v_ll(i,j)
        enddo
    enddo
#endif

END SUBROUTINE lonlat2vect

!=======================================================================
SUBROUTINE vect2lonlat(nlon,nlat,ngrid,v_vect,v_ll)
! To convert data from a vector into lon x lat grid (where values at the poles are duplicated)
! /!\ The longitudes -180 and +180 are not duplicated like in the PCM dynamics

implicit none

! Arguments
!----------
integer,                intent(in) :: nlon, nlat, ngrid
real, dimension(ngrid), intent(in) :: v_vect
real, dimension(nlon,nlat), intent(out) :: v_ll

! Local variables
!----------------
integer :: i, j

! Code
!-----
! 1D case
#ifdef CPP_1D
    v_ll(1,1) = v_vect(1)
    return
#else
    ! Check
    if (ngrid /= nlon*(nlat - 2) + 2) error stop 'vect2lonlat: problem of dimensions!'

    ! Initialization
    v_ll = 0.

    ! Treatment of the poles
    v_ll(:,1) = v_vect(1)
    v_ll(:,nlat) = v_vect(ngrid)

    ! Treatment of regular points
    do j = 2,nlat - 1
        do i = 1,nlon
            v_ll(i,j) = v_vect(1 + i + (j - 2)*nlon)
        enddo
    enddo
#endif

END SUBROUTINE vect2lonlat

END MODULE grid_conversion
