#!/bin/bash
#########################################################
### Script to clean the folder after a PEM simulation ###
### and reset the initial starting files to prepare a ###
### new simulation                                    ###
#########################################################
# There is no argument, you can just execute it.
################################################

echo "Cleaning..."
# Cleaning of files in the current folder
rm -f Bands*.dat
rm -f data2reshape*
rm -f data_PCM_Y*
rm -f info_PEM.txt
find . -type f -name "PCMrun*.job" ! -name "PCMrun.job" -delete
rm -f *.out
rm -f kill_launchPEM.sh
rm -f *.log
rm -f run.def
rm -f start*.nc
rm -f used_*
rm -f Xdiurnalave.nc
rm -f xios_client_*
rm -f diag*.nc
rm -f restart*.nc
rm -f restart1D*.txt
rm -f start1D*.txt
rm -f profile_temp.out
# Reset the initial starting files to prepare a new simulation
if [ -f "starts/startfi.nc" ]; then
    cp starts/startfi.nc .
fi
if [ -f "starts/start.nc" ]; then
    cp starts/start.nc .
elif [ -f "starts/start1D.txt" ]; then
    cp starts/start1D.txt .
fi
if [ -f "starts/startpem.nc" ]; then
    cp starts/startpem.nc .
fi
# Cleaning of files in the sub-folders
rm -f diags/*
rm -f starts/*
rm -f logs/*
echo "Done!"
