!
! $Id: phys_state_var_mod.F90 1670 2012-10-17 08:42:04Z idelkadi $
!
      MODULE phys_state_var_mod
! Variables sauvegardees pour le startphy.nc
!======================================================================
!
!
!======================================================================
! Declaration des variables
      USE dimphy, only : klon,klev,ndomainsz
      USE comsoil_h, only : nsoilmx
      use comsaison_h, only: mu0, fract
      use radcommon_h, only: glat
      USE radinc_h, only : L_NSPECTI, L_NSPECTV,naerkind
      use surfdat_h, only: phisfi, albedodat, n2frac, &
                        zmea, zstd, zsig, zgam, zthe
      use turb_mod, only: q2,sensibFlux,wstar,ustar,tstar,hfmax_th,zmax_th

      real,allocatable,dimension(:,:),save :: ztprevious ! Previous loop Atmospheric Temperature (K)
! Useful for Dynamical Heating calculation.
      real,allocatable,dimension(:,:),save :: zuprevious
!$OMP THREADPRIVATE(ztprevious,zuprevious)

      real, dimension(:),allocatable,save ::  tsurf                ! Surface temperature (K).
      real, dimension(:,:),allocatable,save ::  tsoil              ! Sub-surface temperatures (K).
      real, dimension(:,:),allocatable,save :: albedo              ! Surface Spectral albedo. By MT2015.
      real, dimension(:),allocatable,save :: albedo_equivalent     ! Spectral Mean albedo.
      real, dimension(:),allocatable,save :: albedo_equivalent1     ! Spectral Mean albedo clear sky.
      real, dimension(:),allocatable,save :: albedo_snow_SPECTV    ! Snow Spectral albedo.
      real, dimension(:),allocatable,save :: albedo_n2_ice_SPECTV ! N2 ice Spectral albedo.
!$OMP THREADPRIVATE(tsurf,tsoil,albedo,albedo_equivalent,albedo_equivalent1,albedo_snow_SPECTV,albedo_n2_ice_SPECTV)

      real,dimension(:),allocatable,save :: albedo_bareground ! Bare Ground Albedo. By MT 2015.
!$OMP THREADPRIVATE(albedo_bareground)

      real,dimension(:),allocatable,save :: emis        ! Thermal IR surface emissivity.
      real,dimension(:,:),allocatable,save :: dtrad     ! Net atmospheric radiative heating rate (K.s-1).
      real,dimension(:),allocatable,save :: fluxrad_sky ! Radiative flux from sky absorbed by surface (W.m-2).
      real,dimension(:),allocatable,save :: fluxrad     ! Net radiative surface flux (W.m-2).
      real,dimension(:),allocatable,save :: capcal      ! Surface heat capacity (J m-2 K-1).
      real,dimension(:),allocatable,save :: fluxgrd     ! Surface conduction flux (W.m-2).
      real,dimension(:,:),allocatable,save :: qsurf     ! Tracer on surface (e.g. kg.m-2).
!$OMP THREADPRIVATE(emis,dtrad,fluxrad_sky,fluxrad,capcal,fluxgrd,qsurf)

      ! FOR DIAGNOSTIC :

      real,dimension(:),allocatable,save :: fluxsurf_lw     ! Incident Long Wave (IR) surface flux (W.m-2).
      real,dimension(:),allocatable,save :: fluxsurf_lw1     ! Incident Long Wave (IR) surface flux (W.m-2) clear sky.
      real,dimension(:),allocatable,save :: fluxsurf_sw     ! Incident Short Wave (stellar) surface flux (W.m-2).
      real,dimension(:),allocatable,save :: fluxsurf_sw1     ! Incident Short Wave (stellar) surface flux (W.m-2) clear sky.
      real,dimension(:),allocatable,save :: fluxsurfabs_sw  ! Absorbed Short Wave (stellar) flux by the surface (W.m-2).
!$OMP THREADPRIVATE(fluxsurf_lw,fluxsurf_lw1,fluxsurf_sw,fluxsurf_sw1,fluxsurfabs_sw)

      real,dimension(:),allocatable,save :: fluxtop_lw      ! Outgoing LW (IR) flux to space (W.m-2).
      real,dimension(:),allocatable,save :: fluxtop_sw      ! Outgoing SW (IR) flux to space (W.m-2).
      real,dimension(:),allocatable,save :: fluxtop_lw1      ! Outgoing LW (IR) flux to space (W.m-2) clear sky.
      real,dimension(:),allocatable,save :: fluxabs_sw      ! Absorbed SW (stellar) flux (W.m-2).
      real,dimension(:),allocatable,save :: fluxabs_sw1      ! Absorbed SW (stellar) flux (W.m-2) clear sky.
      real,dimension(:),allocatable,save :: fluxtop_dn      ! Incoming SW (stellar) radiation at the top of the atmosphere (W.m-2).
      real,dimension(:),allocatable,save :: fluxdyn         ! Horizontal heat transport by dynamics (W.m-2).
!$OMP THREADPRIVATE(fluxtop_lw,fluxtop_sw,fluxtop_lw1,fluxabs_sw,fluxabs_sw1,fluxtop_dn,fluxdyn)

      real,dimension(:,:),allocatable,save :: OLR_nu        ! Outgoing LW radiation in each band (Normalized to the band width (W/m2/cm-1)).
      real,dimension(:,:),allocatable,save :: OSR_nu        ! Outgoing SW radiation in each band (Normalized to the band width (W/m2/cm-1)).
      real,dimension(:,:),allocatable,save :: GSR_nu        ! Surface SW (or 'Ground' SW) radiation in each band (Normalized to the band width (W/m2/cm-1)).
      real,dimension(:,:),allocatable,save :: zdtlw         ! LW heating tendencies (K/s).
      real,dimension(:,:),allocatable,save :: zdtsw         ! SW heating tendencies (K/s).
      !real,dimension(:),allocatable,save :: sensibFlux      ! Turbulent flux given by the atmosphere to the surface (W.m-2).
!$OMP THREADPRIVATE(OLR_nu,OSR_nu,GSR_nu,zdtlw,zdtsw)

      real,dimension(:,:,:),allocatable,save :: int_dtauv   ! VI optical thickness of layers within narrowbands for diags ().
      real,dimension(:,:,:),allocatable,save :: int_dtaui   ! IR optical thickness of layers within narrowbands for diags ().
!$OMP THREADPRIVATE(int_dtaui,int_dtauv)

      real,allocatable,dimension(:),save :: tau_col ! Total Aerosol Optical Depth.
!$OMP THREADPRIVATE(tau_col)

      real,allocatable,dimension(:,:,:),save :: nueffrad ! Aerosol effective radius variance. By RW
      real,allocatable,dimension(:,:,:),save :: reffrad
!$OMP THREADPRIVATE(nueffrad,reffrad)

      real,dimension(:,:),allocatable,save :: dEzdiff   ! Turbulent diffusion heating (W.m-2)
      real,dimension(:),allocatable,save :: dEdiff      ! Integrated turbulent diffusion heating (W.m-2)
      real,dimension(:),allocatable,save :: dEdiffs
      real,dimension(:,:),allocatable,save :: dEzRadsw  ! Radiative heating (W.m-2)
      real,dimension(:,:),allocatable,save :: dEzRadlw  ! Radiative heating (W.m-2)
!$OMP THREADPRIVATE(dEzdiff,dEdiff,dEdiffs,dEzRadsw,dEzRadlw)

      real,dimension(:),allocatable,save :: madjdE      ! Heat from moistadj (W.m-2)
      real,dimension(:,:),allocatable,save :: madjdEz   ! Heat from moistadj (W.m-2)
      real,dimension(:),allocatable,save :: lscaledE    ! Heat from largescale (W.m-2)
      real,dimension(:,:),allocatable,save :: lscaledEz ! Heat from largescale (W.m-2)
!$OMP THREADPRIVATE(madjdE,madjdEz,lscaledE,lscaledEz)

      real,dimension(:),allocatable,save :: genericconddE ! Heat from generic condensation (W.m-2)
!$OMP THREADPRIVATE(genericconddE)

CONTAINS

!======================================================================
SUBROUTINE phys_state_var_init(nqtot)

IMPLICIT NONE

        integer,intent(in) :: nqtot

!  Parametres de l'Orographie a l'Echelle Sous-Maille (OESM):
!
!zmea(:)   ! orographie moyenne
!zstd(:)   ! deviation standard de l'OESM
!zsig(:)   ! pente de l'OESM
!zgam(:)   ! anisotropie de l'OESM
!zthe(:)   ! orientation de l'OESM
!zpic(:)   ! Maximum de l'OESM
!zval(:)   ! Minimum de l'OESM
!rugoro(:) ! longueur de rugosite de l'OESM

        ndomainsz=(klon-1)/20 + 1
        ALLOCATE(phisfi(klon))
        ALLOCATE(tsurf(klon))
        ALLOCATE(tsoil(klon,nsoilmx))
        ALLOCATE(albedo(klon,L_NSPECTV))
        ALLOCATE(albedo_equivalent(klon))
        ALLOCATE(albedo_equivalent1(klon))
        ALLOCATE(albedo_snow_SPECTV(L_NSPECTV))
        ALLOCATE(albedo_n2_ice_SPECTV(L_NSPECTV))
        ALLOCATE(albedo_bareground(klon))
        ALLOCATE(n2frac(klon))
        ALLOCATE(emis(klon))
        ALLOCATE(dtrad(klon,klev))
        ALLOCATE(fluxrad_sky(klon))
        ALLOCATE(fluxrad(klon))
        ALLOCATE(capcal(klon))
        ALLOCATE(fluxgrd(klon))
        ALLOCATE(qsurf(klon,nqtot))
        ALLOCATE(q2(klon,klev+1))
        ALLOCATE(ztprevious(klon,klev))
        ALLOCATE(zuprevious(klon,klev))
        ALLOCATE(reffrad(klon,klev,naerkind))
        ALLOCATE(nueffrad(klon,klev,naerkind))
        ALLOCATE(fluxsurf_lw(klon))
        ALLOCATE(fluxsurf_lw1(klon))
        ALLOCATE(fluxsurf_sw(klon))
        ALLOCATE(fluxsurf_sw1(klon))
        ALLOCATE(fluxsurfabs_sw(klon))
        ALLOCATE(fluxtop_lw(klon))
        ALLOCATE(fluxtop_sw(klon))
        ALLOCATE(fluxtop_lw1(klon))
        ALLOCATE(fluxabs_sw(klon))
        ALLOCATE(fluxabs_sw1(klon))
        ALLOCATE(fluxtop_dn(klon))
        ALLOCATE(fluxdyn(klon))
        ALLOCATE(OLR_nu(klon,L_NSPECTI))
        ALLOCATE(OSR_nu(klon,L_NSPECTV))
        ALLOCATE(GSR_nu(klon,L_NSPECTV))
        ALLOCATE(int_dtaui(klon,klev,L_NSPECTI))
        ALLOCATE(int_dtauv(klon,klev,L_NSPECTV))
        ALLOCATE(sensibFlux(klon))
        ALLOCATE(zdtlw(klon,klev))
        ALLOCATE(zdtsw(klon,klev))
        ALLOCATE(tau_col(klon))
        ALLOCATE(dEzdiff(klon,klev))
        ALLOCATE(dEdiff(klon))
        ALLOCATE(dEdiffs(klon))
        ALLOCATE(dEzRadsw(klon,klev))
        ALLOCATE(dEzRadlw(klon,klev))
        ALLOCATE(madjdE(klon))
        ALLOCATE(madjdEz(klon,klev))
        ALLOCATE(lscaledE(klon))
        ALLOCATE(lscaledEz(klon,klev))
        ALLOCATE(genericconddE(klon))
        ! This is defined in comsaison_h
        ALLOCATE(mu0(klon))
        ALLOCATE(fract(klon))
         ! This is defined in radcommon_h
        ALLOCATE(glat(klon))
        ALLOCATE(albedodat(klon))
        ALLOCATE(zmea(klon))
        ALLOCATE(zstd(klon))
        ALLOCATE(zsig(klon))
        ALLOCATE(zgam(klon))
        ALLOCATE(zthe(klon))
        !allocate(l0(klon))
        allocate(wstar(klon))
        allocate(ustar(klon))
        allocate(tstar(klon))
        allocate(hfmax_th(klon))
        allocate(zmax_th(klon))
END SUBROUTINE phys_state_var_init

!======================================================================
SUBROUTINE phys_state_var_end

IMPLICIT NONE

        DEALLOCATE(tsurf)
        DEALLOCATE(tsoil)
        DEALLOCATE(albedo)
        DEALLOCATE(albedo_equivalent)
        DEALLOCATE(albedo_equivalent1)
        DEALLOCATE(albedo_snow_SPECTV)
        DEALLOCATE(albedo_n2_ice_SPECTV)
        DEALLOCATE(albedo_bareground)
        DEALLOCATE(emis)
        DEALLOCATE(dtrad)
        DEALLOCATE(fluxrad_sky)
        DEALLOCATE(fluxrad)
        DEALLOCATE(capcal)

        DEALLOCATE(fluxgrd)
        DEALLOCATE(qsurf)
        DEALLOCATE(q2)
        DEALLOCATE(ztprevious)
        DEALLOCATE(zuprevious)
        DEALLOCATE(reffrad)
        DEALLOCATE(nueffrad)
        DEALLOCATE(fluxsurf_lw)
        DEALLOCATE(fluxsurf_lw1)
        DEALLOCATE(fluxsurf_sw)
        DEALLOCATE(fluxsurf_sw1)
        DEALLOCATE(fluxsurfabs_sw)
        DEALLOCATE(fluxtop_lw)
        DEALLOCATE(fluxtop_sw)
        DEALLOCATE(fluxtop_lw1)
        DEALLOCATE(fluxabs_sw)
        DEALLOCATE(fluxabs_sw1)
        DEALLOCATE(fluxtop_dn)
        DEALLOCATE(fluxdyn)
        DEALLOCATE(OLR_nu)
        DEALLOCATE(OSR_nu)
        DEALLOCATE(GSR_nu)
        DEALLOCATE(int_dtaui)
        DEALLOCATE(int_dtauv)
        DEALLOCATE(sensibFlux)
        DEALLOCATE(zdtlw)
        DEALLOCATE(zdtsw)
        DEALLOCATE(tau_col)
        DEALLOCATE(dEzdiff)
        DEALLOCATE(dEdiff)
        DEALLOCATE(dEdiffs)
        DEALLOCATE(dEzRadsw)
        DEALLOCATE(dEzRadlw)
        DEALLOCATE(madjdE)
        DEALLOCATE(madjdEz)
        DEALLOCATE(lscaledE)
        DEALLOCATE(lscaledEz)
        DEALLOCATE(genericconddE)
        DEALLOCATE(mu0)
        DEALLOCATE(fract)
        DEALLOCATE(glat)
        DEALLOCATE(phisfi)
        DEALLOCATE(albedodat)
        DEALLOCATE(n2frac)
        DEALLOCATE(zmea)
        DEALLOCATE(zstd)
        DEALLOCATE(zsig)
        DEALLOCATE(zgam)
        DEALLOCATE(zthe)
        !deallocate(l0)
        deallocate(wstar)
        deallocate(ustar)
        deallocate(tstar)
        deallocate(hfmax_th)
        deallocate(zmax_th)

END SUBROUTINE phys_state_var_end

      END MODULE phys_state_var_mod
