MODULE YOMCST_mod
  IMPLICIT NONE

  ! A1.0 Fundamental constants
  REAL, SAVE :: RPI, RCLUM, RHPLA, RKBOL, RNAVO
!$OMP THREADPRIVATE(RPI, RCLUM, RHPLA, RKBOL, RNAVO)

  ! A1.1 Astronomical constants
  REAL, SAVE :: RDAY, REA, REPSM, RSIYEA, RSIDAY, ROMEGA
!$OMP THREADPRIVATE(RDAY, REA, REPSM, RSIYEA, RSIDAY, ROMEGA)

  ! A1.1.bis Constantes concernant l'orbite de la Terre:
  REAL, SAVE :: R_ecc, R_peri, R_incl
!$OMP THREADPRIVATE(R_ecc, R_peri, R_incl)

  ! A1.2 Geoide
  REAL, SAVE :: RA, RG, R1SA
!$OMP THREADPRIVATE(RA, RG, R1SA)

  ! A1.3 Radiation
  REAL, SAVE :: RSIGMA
!$OMP THREADPRIVATE(RSIGMA)

  ! A1.4 Thermodynamic gas phase
  REAL, SAVE :: R, RMD, RMV, RD, RV, RCPD, RCPV, RCVD, RCVV
!$OMP THREADPRIVATE(R, RMD, RMV, RD, RV, RCPD, RCPV, RCVD, RCVV)
  REAL, SAVE :: RKAPPA, RETV
!$OMP THREADPRIVATE(RKAPPA, RETV)

  ! A1.5,6 Thermodynamic liquid,solid phases
  REAL, SAVE :: RCW, RCS
!$OMP THREADPRIVATE(RCW, RCS)

  ! A1.7 Thermodynamic transition of phase
  REAL, SAVE :: RLVTT, RLSTT, RLMLT, RTT, RATM
!$OMP THREADPRIVATE(RLVTT, RLSTT, RLMLT, RTT, RATM)

  ! A1.8 Curve of saturation
  REAL, SAVE :: RESTT, RALPW, RBETW, RGAMW, RALPS, RBETS, RGAMS
!$OMP THREADPRIVATE(RESTT, RALPW, RBETW, RGAMW, RALPS, RBETS, RGAMS)
  REAL, SAVE :: RALPD, RBETD, RGAMD
!$OMP THREADPRIVATE(RALPD, RBETD, RGAMD)

END MODULE YOMCST_mod
