MODULE callkeys_mod
IMPLICIT NONE

      logical,save :: callrad,corrk,calldifv,UseTurbDiff
!$OMP THREADPRIVATE(callrad,corrk,calldifv,UseTurbDiff)
      logical,save :: calladj,calltherm,n2cond,callsoil,calllott
!$OMP THREADPRIVATE(calladj,calltherm,n2cond,callsoil,calllott)
      logical,save :: callconduct,callmolvis,callmoldiff
!$OMP THREADPRIVATE(callconduct,callmolvis,callmoldiff)
      logical,save :: season,diurnal,lwrite
!$OMP THREADPRIVATE(season,diurnal,lwrite)
      logical,save :: callgasvis,continuum,graybody
!$OMP THREADPRIVATE(callgasvis,continuum,graybody)
      logical,save :: strictboundcorrk
!$OMP THREADPRIVATE(strictboundcorrk)
      logical,save :: strictboundcia
!$OMP THREADPRIVATE(strictboundcia)

      logical,save :: enertest
      logical,save :: nonideal
      logical,save :: meanOLR
      logical,save :: specOLR
      logical,save :: kastprof
!$OMP THREADPRIVATE(enertest,nonideal,meanOLR,kastprof)
      logical,save :: newtonian
      logical,save :: force_cpp
      integer,save :: cpp_mugaz_mode
      logical,save :: testradtimes
      logical,save :: rayleigh
!$OMP THREADPRIVATE(newtonian,force_cpp,cpp_mugaz_mode,testradtimes,rayleigh)
      logical,save :: stelbbody
      logical,save :: tracer
      logical,save :: mass_redistrib
!$OMP THREADPRIVATE(stelbbody,tracer,mass_redistrib)
      logical,save :: varactive
      logical,save :: varfixed
      logical,save :: sedimentation
!$OMP THREADPRIVATE(varactive,varfixed,sedimentation)

      logical,save :: nosurf
!$OMP THREADPRIVATE(nosurf)
      logical,save :: albedo_spectral_mode
!$OMP THREADPRIVATE(albedo_spectral_mode)
      logical,save :: photoheat
      logical,save :: jonline
      logical,save :: depos
!$OMP THREADPRIVATE(photoheat,jonline,depos)

!! Pluto-specific variables
      logical,save :: methane,carbox
      !$OMP THREADPRIVATE(methane,carbox)
      logical,save :: haze,haze_proffix,haze_radproffix
!$OMP THREADPRIVATE(haze,haze_proffix,haze_radproffix)
      logical,save :: fasthaze,changeti,changetid,optichaze,fractal
!$OMP THREADPRIVATE(fasthaze,changeti,changetid,optichaze,fractal)
      logical,save :: fast,metcloud,monoxcloud,glaflow,triton,paleo
!$OMP THREADPRIVATE(fast,metcloud,monoxcloud,glaflow,triton,paleo)
      logical,save :: nlte,strobel
!$OMP THREADPRIVATE(nlte,strobel)
      logical,save :: kbo
!$OMP THREADPRIVATE(kbo)
      logical,save :: cooling
!$OMP THREADPRIVATE(cooling)
      logical,save :: source_haze,hazeconservch4,haze_ch4proffix
!$OMP THREADPRIVATE(source_haze,hazeconservch4,haze_ch4proffix)
      logical,save :: ch4lag,tsurfmax
!$OMP THREADPRIVATE(ch4lag,tsurfmax)
      logical,save :: specalb
!$OMP THREADPRIVATE(specalb)
      logical,save :: assymflux
!$OMP THREADPRIVATE(assymflux)
      logical,save :: condmetsurf,condcosurf,vertdiff
!$OMP THREADPRIVATE(condmetsurf,condcosurf,vertdiff)
      logical,save :: convergeps,conservn2,condensn2,no_n2frost,no_ch4frost
!$OMP THREADPRIVATE(convergeps,conservn2,condensn2,no_n2frost,no_ch4frost)
      logical,save :: conservch4
!$OMP THREADPRIVATE(conservch4)
      logical,save :: kmix_proffix
!$OMP THREADPRIVATE(kmix_proffix)
      logical,save :: ch4fix,vmrch4_proffix
!$OMP THREADPRIVATE(ch4fix,vmrch4_proffix)
      integer,save :: nbsub
!$OMP THREADPRIVATE(nbsub)
      integer,save :: mode_n2
!$OMP THREADPRIVATE(mode_n2)
      integer,save :: mode_ch4
!$OMP THREADPRIVATE(mode_ch4)
      integer,save :: mode_tholins
!$OMP THREADPRIVATE(mode_tholins)
      integer,save :: kfix
!$OMP THREADPRIVATE(kfix)
      integer,save :: mode_hs
!$OMP THREADPRIVATE(mode_hs)
      integer,save :: feedback_met
!$OMP THREADPRIVATE(feedback_met)
      integer,save :: patchflux
!$OMP THREADPRIVATE(patchflux)
      integer,save :: nb_monomer
!$OMP THREADPRIVATE(nb_monomer)
      real,save    :: Nmix_co
!$OMP THREADPRIVATE(Nmix_co)
      real,save    :: Nmix_ch4
!$OMP THREADPRIVATE(Nmix_ch4)
      real,save    :: tau_n2
!$OMP THREADPRIVATE(tau_n2)
      real,save    :: tau_ch4
!$OMP THREADPRIVATE(tau_ch4)
      real,save    :: tau_co
!$OMP THREADPRIVATE(tau_co)
      real,save    :: tau_prechaze
!$OMP THREADPRIVATE(tau_prechaze)
      real,save    :: paleoyears
!$OMP THREADPRIVATE(paleoyears)
      real,save    :: dayfrac
!$OMP THREADPRIVATE(dayfrac)
      real,save    :: thresh_non2
!$OMP THREADPRIVATE(thresh_non2)
      real,save    :: vmrch4fix
!$OMP THREADPRIVATE(vmrch4fix)
      real,save    :: fluxgeo
!$OMP THREADPRIVATE(fluxgeo)
      real,save    :: fluxgeo2
!$OMP THREADPRIVATE(fluxgeo2)
      real,save    :: deltab
!$OMP THREADPRIVATE(deltab)
      real,save    :: metlateq
!$OMP THREADPRIVATE(metlateq)
      real,save    :: metls1
!$OMP THREADPRIVATE(metls1)
      real,save    :: metls2
!$OMP THREADPRIVATE(metls2)
      real,save    :: tholateq
!$OMP THREADPRIVATE(tholateq)
      real,save    :: tholatn
!$OMP THREADPRIVATE(tholatn)
      real,save    :: tholats
!$OMP THREADPRIVATE(tholats)
      real,save    :: tholone
!$OMP THREADPRIVATE(tholone)
      real,save    :: tholonw
!$OMP THREADPRIVATE(tholonw)
      real,save    :: spelon1
!$OMP THREADPRIVATE(spelon1)
      real,save    :: spelat2
!$OMP THREADPRIVATE(spelat2)
      real,save    :: spelat1
!$OMP THREADPRIVATE(spelat1)
      real,save    :: spelon2
!$OMP THREADPRIVATE(spelon2)
      real,save    :: latlag
!$OMP THREADPRIVATE(latlag)
      real,save    :: vmrlag
!$OMP THREADPRIVATE(vmrlag)
      real,save    :: albmin_ch4
!$OMP THREADPRIVATE(albmin_ch4)
      real,save    :: fracsource
!$OMP THREADPRIVATE(fracsource)
      real,save    :: latsource
!$OMP THREADPRIVATE(latsource)
      real,save    :: lonsource
!$OMP THREADPRIVATE(lonsource)
      real,save    :: thres_ch4ice
!$OMP THREADPRIVATE(thres_ch4ice)
      real,save    :: thres_n2ice
!$OMP THREADPRIVATE(thres_n2ice)
      real,save    :: thres_coice
!$OMP THREADPRIVATE(thres_coice)
      real,save    :: fdch4_latn
!$OMP THREADPRIVATE(fdch4_latn)
      real,save    :: fdch4_lats
!$OMP THREADPRIVATE(fdch4_lats)
      real,save    :: fdch4_lone
!$OMP THREADPRIVATE(fdch4_lone)
      real,save    :: fdch4_lonw
!$OMP THREADPRIVATE(fdch4_lonw)
      real,save    :: fdch4_maxice
!$OMP THREADPRIVATE(fdch4_maxice)
      real,save    :: fdch4_maxalb
!$OMP THREADPRIVATE(fdch4_maxalb)
      real,save    :: fdch4_ampl
!$OMP THREADPRIVATE(fdch4_ampl)
      real,save    :: fdch4_depalb
!$OMP THREADPRIVATE(fdch4_depalb)
      real,save    :: fdch4_finalb
!$OMP THREADPRIVATE(fdch4_finalb)
      real,save    :: rad_haze
!$OMP THREADPRIVATE(rad_haze)
      logical,save :: oldplutovdifc
!$OMP THREADPRIVATE(oldplutovdifc)
      logical,save :: oldplutocorrk
!$OMP THREADPRIVATE(oldplutocorrk)
      logical,save :: oldplutosedim
!$OMP THREADPRIVATE(oldplutosedim)
      logical,save :: global1d
      real,save    :: szangle
!$OMP THREADPRIVATE(global1d,szangle)
      real,save    :: alpha_top ! cooling constant at top of atmosphere
      real,save    :: pref      ! pressure at mid transition fo alpha_top (Pa)
      real,save    :: deltap    ! width of transition to alpha_top (Pa)
!$OMP THREADPRIVATE(alpha_top,pref,deltap)

!! Microphysics-specific variables
      logical,save :: callmufi, call_haze_prod_pCH4
!$OMP THREADPRIVATE(callmufi,call_haze_prod_pCH4)
      real,save :: haze_p_prod, haze_tx_prod, haze_rc_prod
      real,save :: haze_rm, haze_df, haze_rho
      real,save :: air_rad
!$OMP THREADPRIVATE(haze_p_prod,haze_tx_prod,haze_rc_prod,haze_rm,haze_df,haze_rho,air_rad)

!! Parameter of conversion precursors to haze (hazecloud.F90)
      real,save :: tcon_ch4, k_ch4, ncratio_ch4
!$OMP THREADPRIVATE(tcon_ch4, k_ch4, ncratio_ch4)

!! Variables for aerosol absorption
      real,save :: Fabs_aers_VI, Fabs_aerf_VI, Fabs_aers_IR, Fabs_aerf_IR
!$OMP THREADPRIVATE(Fabs_aers_VI, Fabs_aerf_VI, Fabs_aers_IR, Fabs_aerf_IR)

      integer,save :: iddist
      integer,save :: iaervar
      integer,save :: iradia
      integer,save :: startype
      integer,save :: versH2H2cia
      character(64),save :: H2orthopara_mixture
!$OMP THREADPRIVATE(iddist,iaervar,iradia,startype,versH2H2cia,H2orthopara_mixture)

      real,save :: tplanckmin
      real,save :: tplanckmax
      real,save :: dtplanck
!$OMP THREADPRIVATE(tplanckmin,tplanckmax,dtplanck)
      real,save :: topdustref
      real,save :: dusttau
      real,save :: Fat1AU
      real,save :: stelTbb
!$OMP THREADPRIVATE(topdustref,dusttau,Fat1AU,stelTbb)
      real,save :: Tstrat
      real,save :: tplanet
!$OMP THREADPRIVATE(Tstrat,tplanet)
      real,save :: satval
      real,save :: n2mixratio
!$OMP THREADPRIVATE(satval,n2mixratio)
      real,save :: n2supsat
      real,save :: pceil
      real,save :: albedosnow
      real,save :: albedon2ice
      real,save :: maxicethick
!$OMP THREADPRIVATE(n2supsat,pceil,albedosnow,albedon2ice,maxicethick)
      real,save :: Tsaldiff
      real,save :: tau_relax
      real,save :: icetstep
      real,save :: intheat
!$OMP THREADPRIVATE(Tsaldiff,tau_relax,icetstep,intheat)
      real,save :: surfalbedo
      real,save :: surfemis
!$OMP THREADPRIVATE(surfalbedo,surfemis)
      real,save :: noseason_day
!$OMP THREADPRIVATE(noseason_day)
      real,save :: kmixmin
!$OMP THREADPRIVATE(kmixmin)

      logical,save :: iscallphys=.false.!existence of callphys.def
!$OMP THREADPRIVATE(iscallphys)

      ! do we read a startphy.nc file (default=.true.)
      logical,save :: startphy_file=.true.
!$OMP THREADPRIVATE(startphy_file)

END MODULE callkeys_mod
