#! /usr/bin/env python
from    netCDF4               import    Dataset
from	numpy		      import	*
import  numpy                 as        np
import  matplotlib.pyplot     as        mpl
from matplotlib.cm import get_cmap
import pylab
from matplotlib import ticker
import matplotlib.colors as colors
import datetime
from mpl_toolkits.basemap import Basemap, shiftgrid
from FV3_utils import *

############################
filename1=name+"_S.nc"
var="temperature" #variable
longitude=[-169,-165]
# longitude=-165
latitude=[-19,-15]
latitude=-18

# local time de la longitude consideree a t=0
loct=12
sol0=12
t0=1./24*loct
t1=t0+12
tint=[sol0+t0,sol0+t1] #Time must be as written in the input file
print(tint)
nc1=Dataset(filename1)

lat=getvar(nc1,"latitude")
lon=getvar(nc1,"longitude")
alt=getvar(nc1,"altitude")
tim=getvar(nc1,"Time",times=tint)
############################

mpl.figure(figsize=(18, 10))

myvar=getvar(nc1,var,times=tint,longitudes=longitude,latitudes=latitude)[:,:,0,0]
font=23
print(("tim=",tim))
print(('on prend les premiers indice, shape (tmps, alt, var) =',shape(tim), shape(alt), shape(myvar)))
#pal=get_cmap(name="RdYlBu_r")
pal=get_cmap(name="Spectral_r")
lev=np.linspace(40,50,10)
# xticks=[0,2,4,6,8,10,12,14,16,18,20,22,24] 
#yticks=np.linspace(0,240,9)


CF=mpl.contourf(tim,alt,np.transpose(myvar),lev,cmap=pal,extend='both')
cbar=mpl.colorbar(CF,shrink=1, format="%1.0f")
cbar.ax.set_title("Temp [K]",y=1.04,fontsize=font)
for t in cbar.ax.get_yticklabels():
      t.set_fontsize(font)


vect=lev
CS=mpl.contour(tim,alt,np.transpose(myvar),vect,colors='k',linewidths=0.5)
#inline=1 : values over the line
#mpl.clabel(CS, inline=2, fontsize=10, fmt='%1.1e')
mpl.clabel(CS, inline=1, fontsize=15, fmt='%1.0f',inline_spacing=1)


#mpl.title('Latitude ='+str(tintstr[i]),fontsize=font)
mpl.xlabel('Local Time (h)',labelpad=10,fontsize=font)
mpl.ylabel('Altitude (km)',labelpad=10, fontsize=font)
# mpl.xticks(xticks,fontsize=font)
mpl.xticks(fontsize=font)
#mpl.yticks(yticks,fontsize=font)
mpl.yticks(fontsize=font)
pylab.ylim([0,4])

mpl.savefig('temploctime.eps',dpi=200)
mpl.savefig('temploctime.png',dpi=200)
mpl.show()



