#! /usr/bin/env python
from    netCDF4               import    Dataset
from	numpy		      import	*
import  numpy                 as        np
import matplotlib
import  matplotlib.pyplot     as        mpl
from matplotlib.cm import get_cmap
import pylab
from matplotlib import ticker
import matplotlib.colors as colors
import datetime
from mpl_toolkits.basemap import Basemap, shiftgrid
from FV3_utils import *
from input import *

############################
folder="../"
name=name+'_A.nc'
# filename1=folder+"diagfi_mean_A.nc"
var="temperature" #variable
tint=[30,35] #Time must be as written in the input file
xarea="-180,179"
print(name)
nc1=Dataset(name)

# max altitude in plot (maxed to max of alt)
max_alt = 230 


lat=getvar(nc1,"latitude")
lon=getvar(nc1,"longitude")
alt=getvar(nc1,"altitude")
tim=getvar(nc1,"Time")
############################

mpl.figure(figsize=(20, 10))

myvar=getvar(nc1,var,tint,l_mean=True,t_mean=True)
font=26

pal=get_cmap(name="RdYlBu_r")
# pal=get_cmap(name="cividis")
# pal=get_cmap(name="hot")
# pal=get_cmap(name="gnuplot2")
lev=np.linspace(40,110,11)
newlon=lon+180
xticks=[-90,-60,-30,0,30,60,90]
#yticks=np.linspace(0,240,9)
# alt=alt/1000.

CF=mpl.contourf(lat,alt,myvar,lev,cmap=pal,extend='both')
cbar=mpl.colorbar(CF,shrink=1, format="%1.0f")
cbar.ax.set_title("T [K]",y=1.04,fontsize=font,pad=20)
for t in cbar.ax.get_yticklabels():
      t.set_fontsize(font)

vect=lev
CS=mpl.contour(lat,alt,myvar,vect,colors='k',linewidths=0.5)
#inline=1 : values over the line
#mpl.clabel(CS, inline=2, fontsize=10, fmt='%1.1e')
mpl.clabel(CS, inline=1, fontsize=20, fmt='%1.0f',inline_spacing=1)

mpl.title('Zonal mean temperature',fontsize=font, pad=20)
#mpl.title('Latitude ='+str(tintstr[i]),fontsize=font)
mpl.ylabel('Altitude (km)',labelpad=10,fontsize=font)
mpl.xlabel('Latitude (deg)',labelpad=10, fontsize=font)
mpl.xticks(xticks,fontsize=font)
#mpl.yticks(yticks,fontsize=font)
mpl.yticks(fontsize=font)
if type(ma.getmask(myvar)) in (bool,np.bool_):
    max_alt = min(max_alt,max(alt))
else:
    max_alt = min(max_alt,max(alt[~ma.getmask(myvar)[:,0]][:-1]))
pylab.ylim([-4,max_alt])

mpl.savefig('tempsec.eps',dpi=200)
mpl.savefig('tempsec.png',dpi=200)
# mpl.show()




