MODULE lask_param_mod

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!
!!! Purpose: Define parameters from Laskar et al., 2004 evolution
!!!
!!! Author: RV, JBC
!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

implicit none

real, dimension(:), allocatable :: yearlask   ! year before present from Laskar et al. Tab
real, dimension(:), allocatable :: obllask    ! obliquity    [deg]
real, dimension(:), allocatable :: ecclask    ! eccentricity [deg]
real, dimension(:), allocatable :: lsplask    ! ls perihelie [deg]
integer                         :: last_ilask ! Index of the line in the file year_obl_lask.asc corresponding to the closest lower year to the current year

!=======================================================================
contains
!=======================================================================

SUBROUTINE ini_lask_param_mod

implicit none

integer :: nlask ! number of lines in Laskar files
integer :: ierr

nlask = 0
open(1,file = 'obl_ecc_lsp.asc',status = 'old',action = 'read')
do
    read(1,*,iostat = ierr)
    if (ierr /= 0) exit
    nlask = nlask + 1
enddo
close(1)
allocate(yearlask(nlask),obllask(nlask),ecclask(nlask),lsplask(nlask))

END SUBROUTINE ini_lask_param_mod

!=======================================================================

SUBROUTINE end_lask_param_mod

implicit none

if (allocated(yearlask)) deallocate(yearlask)
if (allocated(obllask)) deallocate(obllask)
if (allocated(ecclask)) deallocate(ecclask)
if (allocated(lsplask)) deallocate(lsplask)

END SUBROUTINE end_lask_param_mod

END MODULE lask_param_mod
