MODULE init_print_control_mod

! init_print_control to initialize print_control_mod variables
! not included there because of circular dependecy issues

IMPLICIT NONE
  
CONTAINS

  SUBROUTINE init_print_control
  USE print_control_mod, ONLY : set_print_control 
  USE ioipsl_getin_p_mod, ONLY : getin_p
  USE mod_phys_lmdz_para, ONLY: is_omp_root, is_master
  IMPLICIT NONE

    INTEGER :: lunout ! default output file identifier (6==screen)
    INTEGER :: prt_level ! Output level (0: none)
    LOGICAL :: debug ! flag to specify if in "debug mode" (i.e. extra outputs)
    LOGICAL :: opened
    INTEGER :: number
    
    prt_level = 0 ! default (0: minimum verbosity)
    CALL getin_p('prt_level',prt_level)

    lunout=6 ! default (i.e. standard output = 6)
    CALL getin_p('lunout', lunout)

    IF (is_omp_root) THEN
      IF (lunout /= 5 .and. lunout /= 6) THEN
         INQUIRE(FILE='lmdz.out_0000',OPENED=opened,NUMBER=number)
         IF (opened) THEN
           lunout=number
         ELSE
           OPEN(UNIT=lunout,FILE='lmdz.out_0000',ACTION='write',  &
                STATUS='unknown',FORM='formatted')
         ENDIF
      ENDIF
    ENDIF

    debug = .FALSE. ! default 
    CALL getin_p('debug',debug)
    
    IF (is_master) THEN
      WRITE(lunout,*)"init_print_control: prt_level=",prt_level
      WRITE(lunout,*)"init_print_control: lunout=",lunout
      WRITE(lunout,*)"init_print_control: debug=",debug      
    ENDIF
    
    CALL set_print_control(lunout,prt_level,debug)

  END SUBROUTINE init_print_control  

END MODULE init_print_control_mod

