!-----------------------------------------------------------------------
      module datafile_mod
!  Address of the directory containing tables of data needed by the GCM
      implicit none

      ! Main directory: 'datadir':
      ! Default (link in the simulation directory) :
      character(len=300),save :: datadir='datagcm'
!$OMP THREADPRIVATE(datadir)
      
      ! Subdirectories of 'datadir':
      
      ! surfdir stores planetary topography, albedo, etc. (surface.nc files)
      character(len=12),parameter :: surfdir="surface_data"
      
      ! aerdir stores aerosol properties files (optprop_*dat files)
      character(LEN=18),parameter :: aerdir="aerosol_properties" 

      ! corrkdir points to the directory that stores correlated-k data
      ! the corrkdir link must be in datagcm/corrk_data/
      character(len=8),parameter :: corrkdir="corrkdir"

      ! also for corrk data: defined in sw_venus_corrk.F90
      ! from NBinfrared and NBvisible hardcoded in radinc_h.F90
      character(len=100),save :: banddir=""
!$OMP THREADPRIVATE(banddir)

      end module datafile_mod
!-----------------------------------------------------------------------
