      SUBROUTINE SUGWD(nlayer,sigtest)
! ==============================================================================
!     Initialize common variables in yoegwd.h to control the orographic
!     gravity wave drag parameterization. That means, all the tunable parameters
!     for oro-GW scheme are in this subroutine.
!     MARTIN MILLER             *ECMWF*               ORIGINAL : 90-01-01  
!     Update:    Jiandong Liu     2022/03/15          Rewirite into .F90 and
!                                                     comment.   
!     REFERENCE.
!     ----------
!     ECMWF Research Department documentation of the IFS
!===============================================================================

      USE yoegwd_h, ONLY: GFRCRIT, GRCRIT, GVCRIT
      USE yoegwd_h, ONLY: GKDRAG, GKDRAGL, GHMAX
      USE yoegwd_h, ONLY: GRAHILO, GSIGCR, GSSEC
      USE yoegwd_h, ONLY: GTSEC, GVSEC, GKWAKE
      USE yoegwd_h, ONLY: NKTOPG

      implicit none

      ! 0.1 Inputs:         
      integer,intent(in):: nlayer                ! Number of model levels
      REAL,intent(in):: sigtest(nlayer+1)        ! Vertical coordinate table

      ! 0.2 Outputs:
      ! None.

      ! 0.3 Local variables
      real zsigt                ! Top of the sigma coordinates?
      real zpr                  ! Reference pressure ?
      real zpm1r                ! Pressure at full layer ?
      integer jk

!-------------------------------------------------------------------------------     
! 1.   Set the values of the parameters 
!-------------------------------------------------------------------------------   
!     PRINT *,' Dans sugwd nlayer=',nlayer,' SIG=',sigtest
      GHMAX=10000.
   
!     old  ZSIGT=0.94
!     old  ZPR=80000.
      ZSIGT=0.85      ! Sigmal levels
      ZPR=100000.     ! Surface (Reference) Pressure?
      
      ! ! Condition to find NKTOPG layer, which NKTOPG is a condition to set
      ! 1*pvar and 2*pvar layers (OROSETUP)
      DO JK=1,nlayer-1
         ZPM1R=0.5*ZPR*(sigtest(JK)+sigtest(JK+1))
         IF((ZPM1R/ZPR).GE.ZSIGT)THEN
            NKTOPG=JK   
         ENDIF
      ENDDO
      WRITE(*,*) 'In sugwd NKTOPG=',NKTOPG
    
      GSIGCR=0.80  ! Sigmal levels to found the top of low level flow height (OROSETUP)  
      GKDRAG= 0.1  ! used to be 0.1 for mcd Version 1 and 2 (before 10/2000) (OROSETUP)
                      
      GFRCRIT=1.0
      GKWAKE=1.0   ! The G in equation (16)
      GRCRIT=0.25  ! Critical value for Mean flow richardson number(OROSETUP)      
      GKDRAGL=4.*GKDRAG
      GRAHILO=1.
      GVCRIT =0.0    
!-------------------------------------------------------------------------------  
! 2.    Set values of security parameters 
!-------------------------------------------------------------------------------  
      GVSEC=0.10      ! Security values for For normal wind (pu^2+pv^2)^0.5(OROSETUP,GWSTRESS)
      GSSEC=1.E-12    ! Security values for Brunt–Väisälä frequency N^2 (OROSETUP)   
      GTSEC=1.E-07    ! Security values for Sub-grid scale anisotropy(OROSETUP,GWSTRESS)

      RETURN
      END
