from __future__ import annotations
import os
import xarray as xr
import geovista as gv
# from geovista.pantry.data import dynamico
import geovista.theme

def open_file(filename="start.nc"):
   file_type=os.path.splitext(filename)[0]
   file = xr.open_dataset(filename)
   # lon lat names
   if file_type.endswith('startfi'):
      lon_name, lat_name = 'bounds_lon', 'bounds_lat'
   elif file_type.endswith('start'):
      lon_name, lat_name = 'bounds_lon_mesh', 'bounds_lat_mesh'
   elif file_type.endswith('Xhistins'):
      lon_name, lat_name = 'lon', 'lat'
   else:
      raise 'ERROR: file_type must be start or startphy or hist'
   return file, lon_name, lat_name


def main(file="start.nc", var="ps") -> None:
    """Plot a DYNAMICO unstructured mesh.

    Notes
    -----
    .. versionadded:: 0.1.0

    """
    # Load the sample data.
    # sample = dynamico()
    data, lon, lat = open_file(file)

    # Create the mesh from the sample data.
    mesh = gv.Transform.from_unstructured(data[lon], data[lat], data=data[var])

    # Plot the unstructured mesh.
    p = gv.GeoPlotter()
    sargs = {"title": f"{var} "}
    p.add_mesh(mesh, scalar_bar_args=sargs)
    p.add_coastlines()
    p.add_graticule()
    p.add_axes()
    p.add_text(
        "DYNAMICO Icosahedral (10m Coastlines)",
        position="upper_left",
        font_size=10,
    )
    p.view_xz(negative=True)
    p.camera.zoom(1.3)
    p.show()
    # (f"{os.path.splitext(file)[0]}_{var}.pdf")


if __name__ == "__main__":
    # main("start.nc", "ps")
    main("startfi.nc", "tsurf")
    # main("startfi.nc", "n2_surf")