module sig_h2o_mod
      
implicit none
      
contains
      
!********************************************************
  double precision function sig_h2o(t)
  implicit none
! this function computes the surface tension (N.m)   *
! between water ice and air as a function of temp.    *
!********************************************************

   real,intent(in) :: t

   sig_h2o = (141. - 0.15 * dble(t)) * 1.e-3

   end function sig_h2o
      
end module sig_h2o_mod

