MODULE optcv_pluto_mod

IMPLICIT NONE

CONTAINS

SUBROUTINE OPTCV_pluto(DTAUV,TAUV,TAUCUMV,PLEV,  &
      QXVAER,QSVAER,GVAER,WBARV,COSBV,      &
      TAURAY,TAUAERO,TMID,PMID,TAUGSURF,QVAR)

  use radinc_h, only: L_NLAYRAD, L_NLEVRAD, L_LEVELS, L_NSPECTV, L_NGAUSS, L_REFVAR, NAERKIND
  use radcommon_h, only: gasv, tlimit, wrefVAR, Cmk, tgasref, pfgasref,wnov,scalep,indv,glat_ig
  use gases_h, only: gfrac, ngasmx, igas_H2, igas_H2O, igas_He, igas_N2, &
                     igas_CH4, igas_N2
  use comcstfi_mod, only: g, r, mugaz
  use callkeys_mod, only: kastprof,continuum,graybody,callgasvis
  use recombin_corrk_mod, only: corrk_recombin, gasv_recomb
  use tpindex_mod, only: tpindex

      implicit none

!==================================================================
!
!     Purpose
!     -------
!     Calculates shortwave optical constants at each level.
!
!     Authors
!     -------
!     Adapted from the NASA Ames code by R. Wordsworth (2009)
!
!==================================================================



!     THIS SUBROUTINE SETS THE OPTICAL CONSTANTS IN THE VISUAL
!     IT CALCUALTES FOR EACH LAYER, FOR EACH SPECRAL INTERVAL IN THE VISUAL
!     LAYER: WBAR, DTAU, COSBAR
!     LEVEL: TAU
!
!     TAUV(L,NW,NG) is the cumulative optical depth at the top of radiation code
!     layer L. NW is spectral wavelength interval, ng the Gauss point index.
!
!     TLEV(L) - Temperature at the layer boundary
!     PLEV(L) - Pressure at the layer boundary (i.e. level)
!     GASV(NT,NPS,NW,NG) - Visual CO2 k-coefficients
!
!----------------------------------------------------------------------C


      real*8 DTAUV(L_NLAYRAD,L_NSPECTV,L_NGAUSS)
      real*8 DTAUKV(L_LEVELS,L_NSPECTV,L_NGAUSS)
      real*8 TAUV(L_NLEVRAD,L_NSPECTV,L_NGAUSS)
      real*8 TAUCUMV(L_LEVELS,L_NSPECTV,L_NGAUSS)
      real*8 PLEV(L_LEVELS)
      real*8 TMID(L_LEVELS), PMID(L_LEVELS)
      real*8 COSBV(L_NLAYRAD,L_NSPECTV,L_NGAUSS)
      real*8 WBARV(L_NLAYRAD,L_NSPECTV,L_NGAUSS)

!     For aerosols
      real*8 QXVAER(L_LEVELS,L_NSPECTV,NAERKIND)
      real*8 QSVAER(L_LEVELS,L_NSPECTV,NAERKIND)
      real*8 GVAER(L_LEVELS,L_NSPECTV,NAERKIND)
      real*8 TAUAERO(L_LEVELS,NAERKIND)
      real*8 TAUAEROLK(L_LEVELS,L_NSPECTV,NAERKIND)
      real*8 TAEROS(L_LEVELS,L_NSPECTV,NAERKIND)

      integer L, NW, NG, K, NG1(L_NSPECTV), LK, IAER
      integer MT(L_LEVELS), MP(L_LEVELS), NP(L_LEVELS)
      real*8  ANS, TAUGAS
      real*8 TAURAY(L_NSPECTV)
      real*8  TRAY(L_LEVELS,L_NSPECTV)
      real*8  DPR(L_LEVELS), U(L_LEVELS)
      real*8  LCOEF(4), LKCOEF(L_LEVELS,4)

      real*8 taugsurf(L_NSPECTV,L_NGAUSS-1), TRAYAER





!     mixing ratio variables
      real*8 QVAR(L_LEVELS), WRATIO(L_LEVELS)
      real*8 KCOEF(4)
      integer NVAR(L_LEVELS)

  ! temporary variables for multiple aerosol calculation
  real*8 atemp(L_NLAYRAD,L_NSPECTV)
  real*8 btemp(L_NLAYRAD,L_NSPECTV)
  real*8 ctemp(L_NLAYRAD,L_NSPECTV)

!     variables for k in units m^-1
      real*8 rho, dz

!=======================================================================
!     Determine the total gas opacity throughout the column, for each
!     spectral interval, NW, and each Gauss point, NG.
!     Calculate the continuum opacities, i.e., those that do not depend on
!     NG, the Gauss index.

taugsurf(:,:) = 0.0

  do K=2,L_LEVELS
         DPR(K) = PLEV(K)-PLEV(K-1)


!         rho  = PLEV(K)/(R*TMID(K))
         rho  = PMID(K)/(R*TMID(K))
         dz   = -DPR(k)/(g*rho)

         U(k)   = Cmk*DPR(k)




         call tpindex(PMID(K),TMID(K),QVAR(K),pfgasref,tgasref,WREFVAR, &
             LCOEF,MT(K),MP(K),NVAR(K),WRATIO(K))

         do LK=1,4
            LKCOEF(K,LK) = LCOEF(LK)
         end do
  end do                    ! levels

  ! Spectral dependance of aerosol absorption
  do iaer=1,naerkind
     do NW=1,L_NSPECTV
        do K=2,L_LEVELS
           TAEROS(K,NW,IAER) = TAUAERO(K,IAER) * QXVAER(K,NW,IAER)
        end do
     end do
  end do

  ! Rayleigh scattering
  do NW=1,L_NSPECTV
     do K=2,L_LEVELS
        TRAY(K,NW)   = TAURAY(NW) * DPR(K)
     end do
  end do

  ! We ignore K = 1... Hope this is ok...
  do K=2,L_LEVELS

     ! JL18: It seems to be good to have aerosols in the first "radiative layer" of the gcm in the IR
     ! but visible does not handle very well diffusion in first layer.
     ! This solves random variations of the sw heating at the model top. 
     if (K < 3) TAEROS(K,:,:) = 0.0

     do NW=1,L_NSPECTV

        TRAYAER = TRAY(K,NW)
        !     TRAYAER is Tau RAYleigh scattering, plus AERosol opacity
        do iaer=1,naerkind
           TRAYAER = TRAYAER + TAEROS(K,NW,IAER)
        end do

        do NG=1,L_NGAUSS-1

           ! Now compute TAUGAS

           ! Interpolate between water mixing ratios
           ! WRATIO = 0.0 if the requested water amount is equal to, or outside the
           ! the water data range

           if (L_REFVAR.eq.1)then ! added by RW for special no variable case

                  KCOEF(1) = GASV(MT(K),MP(K),1,NW,NG)
                  KCOEF(2) = GASV(MT(K),MP(K)+1,1,NW,NG)
                  KCOEF(3) = GASV(MT(K)+1,MP(K)+1,1,NW,NG)
                  KCOEF(4) = GASV(MT(K)+1,MP(K),1,NW,NG)

           else

               KCOEF(1) = GASV(MT(K),MP(K),NVAR(K),NW,NG) + WRATIO(K)*  &
                   (GASV(MT(K),MP(K),NVAR(K)+1,NW,NG) -                 &
                   GASV(MT(K),MP(K),NVAR(K),NW,NG))

               KCOEF(2) = GASV(MT(K),MP(K)+1,NVAR(K),NW,NG) + WRATIO(K)* &
                   (GASV(MT(K),MP(K)+1,NVAR(K)+1,NW,NG) -                &
                   GASV(MT(K),MP(K)+1,NVAR(K),NW,NG))

             KCOEF(3) = GASV(MT(K)+1,MP(K)+1,NVAR(K),NW,NG) + WRATIO(K)* &
                   (GASV(MT(K)+1,MP(K)+1,NVAR(K)+1,NW,NG) -  &
                   GASV(MT(K)+1,MP(K)+1,NVAR(K),NW,NG))

               KCOEF(4) = GASV(MT(K)+1,MP(K),NVAR(K),NW,NG) + WRATIO(K)* &
                   (GASV(MT(K)+1,MP(K),NVAR(K)+1,NW,NG) -  &
                   GASV(MT(K)+1,MP(K),NVAR(K),NW,NG))
           endif

!     Interpolate the gaseous k-coefficients to the requested T,P values

           ANS = LKCOEF(K,1)*KCOEF(1) + LKCOEF(K,2)*KCOEF(2) + &
                   LKCOEF(K,3)*KCOEF(3) + LKCOEF(K,4)*KCOEF(4)

           TAUGAS          = U(k)*ANS

           TAUGSURF(NW,NG) = TAUGSURF(NW,NG) + TAUGAS
           DTAUKV(K,nw,ng) = TAUGAS + TRAYAER
!               write(21,*) 'TB17 taugas',K,NW,ng,TAUGAS


        end do


!     Now fill in the "clear" part of the spectrum (NG = L_NGAUSS),
!     which holds continuum opacity only

        NG = L_NGAUSS
        DTAUKV(K,nw,ng) = TRAYAER ! Scattering

     end do
  end do

!=======================================================================
!     Now the full treatment for the layers, where besides the opacity
!     we need to calculate the scattering albedo and asymmetry factors
      !TAUAEROLK(:,:,:) = 1.e-20 ! TB17

  do iaer=1,naerkind
    DO NW=1,L_NSPECTV
      DO K=2,L_LEVELS
           TAUAEROLK(K,NW,IAER) = TAUAERO(K,IAER) * QSVAER(K,NW,IAER) ! effect of scattering albedo
           !TAUAEROLK(K,NW,IAER) = max(TAUAEROLK(K,NW,IAER),1.e-20) ! TB17
      end do
    ENDDO
  ENDDO
  !print*, 'TBbug  TAUAEROLK =', TAUAEROLK

  DO NW=1,L_NSPECTV
     DO L=1,L_NLAYRAD-1
        K              = 2*L+1
	atemp(L,NW) = SUM(GVAER(K,NW,1:naerkind) * TAUAEROLK(K,NW,1:naerkind))+SUM(GVAER(K+1,NW,1:naerkind) * TAUAEROLK(K+1,NW,1:naerkind))
        btemp(L,NW) = SUM(TAUAEROLK(K,NW,1:naerkind)) + SUM(TAUAEROLK(K+1,NW,1:naerkind))
	ctemp(L,NW) = btemp(L,NW) + 0.9999*(TRAY(K,NW) + TRAY(K+1,NW))  ! JVO 2017 : does this 0.999 is really meaningful ?
	btemp(L,NW) = btemp(L,NW) + TRAY(K,NW) + TRAY(K+1,NW)
	COSBV(L,NW,1:L_NGAUSS) = atemp(L,NW)/btemp(L,NW)
     END DO ! L vertical loop

     ! Last level
     L           = L_NLAYRAD
     K           = 2*L+1
     atemp(L,NW) = SUM(GVAER(K,NW,1:naerkind) * TAUAEROLK(K,NW,1:naerkind))
     btemp(L,NW) = SUM(TAUAEROLK(K,NW,1:naerkind))
     ctemp(L,NW) = btemp(L,NW) + 0.9999*TRAY(K,NW) ! JVO 2017 : does this 0.999 is really meaningful ?
     btemp(L,NW) = btemp(L,NW) + TRAY(K,NW)
     COSBV(L,NW,1:L_NGAUSS) = atemp(L,NW)/btemp(L,NW)


  END DO                    ! NW spectral loop

  DO NG=1,L_NGAUSS
    DO NW=1,L_NSPECTV
     DO L=1,L_NLAYRAD-1

        K              = 2*L+1
        DTAUV(L,nw,ng) = DTAUKV(K,NW,NG) + DTAUKV(K+1,NW,NG)
        WBARV(L,nw,ng) = ctemp(L,NW) / DTAUV(L,nw,ng)

      END DO ! L vertical loop

        ! Last level

        L              = L_NLAYRAD
        K              = 2*L+1
	DTAUV(L,nw,ng) = DTAUKV(K,NW,NG)

        WBARV(L,NW,NG) = ctemp(L,NW) / DTAUV(L,NW,NG)
        !print*, 'TB22 : WBARV(L)=',WBARV(L,NW,NG),NW,NG
        !print*, 'TB22 : ctemp(L)=',ctemp(L,NW),NW
        !print*, 'TB22 : dtauv(L)=',DTAUV(L,NW,NG),NW,NG
     END DO                 ! NW spectral loop
  END DO                    ! NG Gauss loop

  ! Total extinction optical depths

  DO NG=1,L_NGAUSS       ! full gauss loop
     DO NW=1,L_NSPECTV
        TAUV(1,NW,NG)=0.0D0
        DO L=1,L_NLAYRAD
           TAUV(L+1,NW,NG)=TAUV(L,NW,NG)+DTAUV(L,NW,NG)
        END DO

        TAUCUMV(1,NW,NG)=0.0D0
        DO K=2,L_LEVELS
           TAUCUMV(K,NW,NG)=TAUCUMV(K-1,NW,NG)+DTAUKV(K,NW,NG)
        END DO
     END DO
  END DO                 ! end full gauss loop


  return


end subroutine optcv_pluto

END MODULE optcv_pluto_mod
