MODULE callkeys_mod
IMPLICIT NONE  

      logical,save :: callrad,corrk,calldifv,UseTurbDiff
!$OMP THREADPRIVATE(callrad,corrk,calldifv,UseTurbDiff)
      logical,save :: calladj,calltherm,co2cond,callsoil
!$OMP THREADPRIVATE(calladj,calltherm,co2cond,callsoil)

      ! do we have volcanoes (injecting tracers in atmosphere) ?
      logical,save :: callvolcano
!$OMP THREADPRIVATE(callvolcano)

      logical,save :: season,diurnal,tlocked,rings_shadow,lwrite
!$OMP THREADPRIVATE(season,diurnal,tlocked,rings_shadow,lwrite)
      logical,save :: callgasvis,continuum,generic_continuum_database,graybody
!$OMP THREADPRIVATE(callgasvis,continuum,generic_continuum_database,graybody)
      logical,save :: strictboundcorrk                                     
!$OMP THREADPRIVATE(strictboundcorrk)
      logical,save :: strictboundcia                                     
!$OMP THREADPRIVATE(strictboundcia)
      logical,save :: callthermos
      logical,save :: force_conduction
      real,save    :: phitop
      real,save    :: zztop
      real,save    :: a_coeff
      real,save    :: s_coeff
!$OMP THREADPRIVATE(callthermos,phitop,zztop,force_conduction,a_coeff,s_coeff)

      logical,save :: enertest
      logical,save :: nonideal
      logical,save :: meanOLR
      logical,save :: specOLR
      logical,save :: kastprof
      logical,save :: diagdtau
!$OMP THREADPRIVATE(enertest,nonideal,meanOLR,kastprof,diagdtau)
      logical,save :: newtonian
      logical,save :: force_cpp
      integer,save :: cpp_mugaz_mode
      logical,save :: testradtimes
      logical,save :: rayleigh
      logical,save :: varspec
      character(64),save :: varspec_data
      integer,save :: nvarlayer
!$OMP THREADPRIVATE(newtonian,force_cpp,cpp_mugaz_mode,testradtimes,rayleigh,varspec,varspec_data,nvarlayer)
      logical,save :: stelbbody
      logical,save :: nearco2cond
      logical,save :: tracer
      logical,save :: mass_redistrib
!$OMP THREADPRIVATE(stelbbody,nearco2cond,tracer,mass_redistrib)
      logical,save :: varactive
      logical,save :: varfixed
      logical,save :: sedimentation
      logical,save :: generic_condensation
      logical,save :: generic_rain
      logical,save :: virtual_correction
!$OMP THREADPRIVATE(varactive,varfixed,sedimentation,generic_condensation,generic_rain,virtual_correction)
      logical,save :: water ,watercond, waterrain, moistadjustment, moistadjustment_generic, moist_convection_inhibition
!$OMP THREADPRIVATE(water, watercond, waterrain, moistadjustment, moistadjustment_generic, moist_convection_inhibition)
      logical,save :: aeroco2, aeroh2o, aeroh2so4, aeroback2lay
!$OMP THREADPRIVATE(aeroco2, aeroh2o, aeroh2so4, aeroback2lay)
      logical,save :: aeronh3, aeronlay, aeroaurora
!$OMP THREADPRIVATE(aeronh3,aeronlay,aeroaurora)

      logical,save :: aerovenus ! master flag for "Venus-like" aerosol additions
!$OMP THREADPRIVATE(aerovenus)
      ! detailed sub-options when with "Venus-like" aerosol additions
      logical,save :: aerovenus1, aerovenus2, aerovenus2p, aerovenus3, aerovenusUV
!$OMP THREADPRIVATE(aerovenus1, aerovenus2, aerovenus2p, aerovenus3, aerovenusUV)

      logical,save :: aerofixco2, aerofixh2o
!$OMP THREADPRIVATE(aerofixco2, aerofixh2o)
      integer,save :: aerogeneric ! number of aerosols of "generic" kind
!$OMP THREADPRIVATE(aerogeneric)
      logical,save :: hydrology
      logical,save :: CLFvarying
      logical,save :: nosurf
      logical,save :: oblate
!$OMP THREADPRIVATE(hydrology,CLFvarying,nosurf,oblate)
      logical,save :: ok_slab_ocean
      logical,save :: ok_slab_sic
      logical,save :: ok_slab_heat_transp
      logical,save :: albedo_spectral_mode
!$OMP THREADPRIVATE(ok_slab_ocean,ok_slab_sic,ok_slab_heat_transp,albedo_spectral_mode)
      logical,save :: photochem
      logical,save :: photoheat
      logical,save :: jonline
      logical,save :: depos
      logical,save :: haze
      logical,save :: output_writediagspecUV
!$OMP THREADPRIVATE(photochem,photoheat,jonline,depos,output_writediagspecUV)
      logical,save :: calllott_nonoro
!$OMP THREADPRIVATE(calllott_nonoro)
      logical,save :: global1d
      real,save    :: szangle
!$OMP THREADPRIVATE(global1d,szangle)

      integer,save :: iddist
      integer,save :: iaervar
      integer,save :: iradia
      integer,save :: startype
      integer,save :: versH2H2cia
      character(64),save :: H2orthopara_mixture
      integer,save :: nlayaero
!$OMP THREADPRIVATE(iddist,iaervar,iradia,startype,versH2H2cia,H2orthopara_mixture,nlayaero)
      integer,dimension(:),allocatable,save :: aeronlay_choice
!$OMP THREADPRIVATE(aeronlay_choice)

      character(64),save :: optprop_back2lay_vis
      character(64),save :: optprop_back2lay_ir
      character(64),dimension(:),allocatable,save :: optprop_aeronlay_vis
      character(64),dimension(:),allocatable,save :: optprop_aeronlay_ir
!$OMP THREADPRIVATE(optprop_back2lay_vis,optprop_back2lay_ir,optprop_aeronlay_vis,optprop_aeronlay_ir)

      real,save :: tplanckmin
      real,save :: tplanckmax
      real,save :: dtplanck
!$OMP THREADPRIVATE(tplanckmin,tplanckmax,dtplanck)
      real,save :: topdustref
      real,save :: dusttau
      real,save :: Fat1AU
      real,save :: stelTbb
!$OMP THREADPRIVATE(topdustref,dusttau,Fat1AU,stelTbb)
      real,save :: Tstrat
      real,save :: tplanet
      real,save :: obs_tau_col_tropo
      real,save :: obs_tau_col_strato
!$OMP THREADPRIVATE(Tstrat,tplanet,obs_tau_col_tropo,obs_tau_col_strato)
      real,save :: pres_bottom_tropo
      real,save :: pres_top_tropo
      real,save :: pres_bottom_strato
      real,save :: pres_top_strato
!$OMP THREADPRIVATE(pres_bottom_tropo,pres_top_tropo,pres_bottom_strato,pres_top_strato)
      real,save :: size_tropo
      real,save :: size_strato
      real,save :: satval
      real,save :: CLFfixval
      real,save :: n2mixratio
!$OMP THREADPRIVATE(size_tropo,size_strato,satval,CLFfixval,n2mixratio)
      real,save :: size_nh3_cloud
      real,save :: pres_nh3_cloud
      real,save :: tau_nh3_cloud
!$OMP THREADPRIVATE(size_nh3_cloud, pres_nh3_cloud, tau_nh3_cloud)
      real,dimension(:),allocatable,save :: aeronlay_tauref
      real,dimension(:),allocatable,save :: aeronlay_lamref
      real,dimension(:),allocatable,save :: aeronlay_ptop
      real,dimension(:),allocatable,save :: aeronlay_pbot
      real,dimension(:),allocatable,save :: aeronlay_sclhght
      real,dimension(:),allocatable,save :: aeronlay_size
      real,dimension(:),allocatable,save :: aeronlay_nueff
!$OMP THREADPRIVATE(aeronlay_tauref,aeronlay_lamref,aeronlay_ptop,aeronlay_pbot,aeronlay_sclhght,aeronlay_size,aeronlay_nueff)
      real,save :: co2supsat
      real,save :: pceil
      real,save :: albedosnow
      real,save :: alb_ocean
      real,save :: albedoco2ice
      real,save :: maxicethick
!$OMP THREADPRIVATE(co2supsat,pceil,albedosnow,alb_ocean,albedoco2ice,maxicethick)
      real,save :: Tsaldiff
      real,save :: tau_relax
      real,save :: cloudlvl
      real,save :: intheat
!$OMP THREADPRIVATE(Tsaldiff,tau_relax,cloudlvl,intheat)
      real,save :: flatten
      real,save :: Rmean
      real,save :: J2
      real,save :: MassPlanet
!$OMP THREADPRIVATE(flatten,Rmean,J2,MassPlanet)
      real,save :: surfalbedo
      real,save :: surfemis
!$OMP THREADPRIVATE(surfalbedo,surfemis)
      real,save :: noseason_day
!$OMP THREADPRIVATE(noseason_day)
      real,save :: kmixmin
!$OMP THREADPRIVATE(kmixmin)
      
      logical,save :: iscallphys=.false.!existence of callphys.def
!$OMP THREADPRIVATE(iscallphys)

      ! do we read a startphy.nc file (default=.true.)
      logical,save :: startphy_file=.true. 
!$OMP THREADPRIVATE(startphy_file)

END MODULE callkeys_mod
