import exo_k as xk
import numpy as np

### folder with corrk data for each molecule (see 'xsec_to_corrk.py' to convert cross-sections to correlated-k tables)
xk.Settings().set_search_path("datadir/exomol/taurex_R15000/")
# xk.Settings().set_search_path("datadir/corrk_data/R20000_from_dace/")

corrk_dir = "datadir/corrk_data/"
dir_out = corrk_dir+"pluto_ch4_var_co_c2h2_c2h4/"

### molecules for which we have corrk data
gases = [
    "CO",
    "C2H2",
    "C2H4",
    "CH4",
]

### set variable gas and its variance
vgas={"CH4": "background"}
x_array=[
    1.00e-4,
    1.00e-3,
    5.00e-3,
    1.00e-2,
    5.00e-2,
    1.00e-1,
    5.00e-1
]

### set constant gases and their values
bg_gas = {
    "CO":   5e-4,
    "C2H2": 5e-6, # at 100km (Young et al, 2018)
    "C2H4": 6e-7, # at 100km (Young et al, 2018)
    "C2H6": 2e-5, # at 100km (Young et al, 2018)
    "N2":"background"
}

### select your spectral resolution here
IR_grid = np.array([  10.,  100.,  160., 1180., 1273., 1280., 1301., 1308., 1320., 1450., 1520., 1550., 1670., 2080., 2220., 2450., 2750., 2920.])

VI_grid = np.array([ 1670.,  2080.,  2220.,  2450.,  2750.,  2920.,  3200.,  3750., 4000.,  4180.,  4260.,  4460.,  4700.,  5000.,  5400.,  5730., 5930.,  6300.,  6700.,  7700.,  8200.,  8750.,  9250., 35000.])

wnedges = np.unique(np.concatenate([IR_grid,VI_grid]))

### if you'd rather use a resolution R
# R=20
# IR_grid=xk.wavenumber_grid_R(10.,2920.,R)
# VI_grid=xk.wavenumber_grid_R(1670.,35000.,R)

### if you want to use an existing lmdz corrk grid
# corrk=corrk_dir+'pluton_ch4var_COfix/17x23'
# wn_VI = np.loadtxt(corrk+'/narrowbands_VI.in',skiprows=1)
# wn_IR = np.loadtxt(corrk+'/narrowbands_IR.in',skiprows=1)
# IR_grid = np.concatenate([wn_IR[:,0],wn_IR[-1:,1]])
# VI_grid = np.concatenate([wn_VI[:,0],wn_VI[-1:,1]])

### Create new corrk to resolution IR_grid, VI_grid
xk.Settings().set_mks(True)
xk.Settings().set_log_interp(False)
xk.Settings().set_case_sensitive(True)

kdata = xk.Kdatabase(gases)
for gas in kdata.ktables:
    # convert Xtables to Ktables
    if type(kdata.ktables[gas]) is xk.Xtable:
        kdata.ktables[gas] = xk.Ktable(wnedges=wnedges, xtable=kdata.ktables[gas])

mix_var_gas=kdata.create_mix_ktable5d(vgas_comp=vgas,bg_comp=bg_gas,x_array=x_array)

IR_mix_var_gas_ktab=mix_var_gas.copy()
IR_mix_var_gas_ktab.bin_down(IR_grid)

VI_mix_var_gas_ktab=mix_var_gas.copy()
VI_mix_var_gas_ktab.bin_down(VI_grid)

IR_mix_var_gas_ktab.write_LMDZ(dir_out,band='IR')
VI_mix_var_gas_ktab.write_LMDZ(dir_out,band='VI')
xk.finalize_LMDZ_dir(dir_out,IR_mix_var_gas_ktab.Nw,VI_mix_var_gas_ktab.Nw)

### write Q.dat
with open(dir_out+'Q.dat', 'w') as f:
    f.write(f"{len(gases)}\n")
    f.write("\n".join(gases) + "\n")
    f.write(f"{len(x_array)}\n")
    f.write("\n".join(map(str, x_array)) + "\n")