      subroutine lymalpha(pls,pflux)
      use datafile_mod
      use comcstfi_mod, only: pi
      use mod_phys_lmdz_para, only : is_master, bcast

      implicit none

!==================================================================
!     Purpose
!     -------
!     Get the lyman alpha flux according to the solar longitude
!
!     Inputs
!     ------
!     pls                 solar longitude
!
!     Outputs
!     -------
!
!     Both
!     ----
!
!     Authors
!     -------
!     Tanguy Bertrand
!==================================================================

!-----------------------------------------------------------------------
!     Arguments

      REAL,INTENT(IN) :: pls
      REAL,INTENT(OUT) :: pflux
!-----------------------------------------------------------------------
!     Local variables
      REAL :: vectls
      REAL :: vectflux
      LOGICAL,SAVE :: firstcall=.true.
!$OMP THREADPRIVATE(firstcall)

      !!read lyman alpha flux
      integer Nfine
      parameter(Nfine=13281)
      integer ifine
      character(len=100) :: file_path
      real,save :: lsdat(Nfine),fluxdat(Nfine)
!$OMP THREADPRIVATE(lsdat,fluxdat)


!---------------- INPUT ------------------------------------------------

      IF (firstcall) then
        firstcall=.false.
        file_path=trim(datadir)//'/sol_uv_flux.txt'
        if (is_master) print*,file_path
        open(222,file=file_path,form='formatted')

        if (is_master) then
        do ifine=1,Nfine
           read(222,*) lsdat(ifine), fluxdat(ifine)
        enddo
        close(222)
        endif ! is_master

        call bcast(lsdat)
        call bcast(fluxdat)
      ENDIF


      CALL interp_line(lsdat,fluxdat,Nfine,pls*180./pi,pflux,1)
      !if (is_master) write(*,*) 'flux=',pflux


      end subroutine lymalpha

