#!/usr/bin/env python

### A. Spiga

###########################################################################################
###########################################################################################
### What is below relate to running the file as a command line executable (very convenient)
if __name__ == "__main__":
    import sys
    from optparse import OptionParser    ### to be replaced by argparse
    from api_wrapper import api_onelevel
    from netCDF4 import Dataset
    from myplot import getlschar, separatenames, readslices, adjust_length
    from os import system
    from planetoplot import planetoplot
    import numpy as np

    #############################
    ### Get options and variables
    parser = OptionParser()
    parser.add_option('-f', '--file',   action='append',dest='namefile', type="string",  default=None,  help='[NEEDED] name of WRF file (append)')
    parser.add_option('-l', '--level',  action='store',dest='nvert',     type="string",  default="0",   help='level or start,stop,step (def=0)(-i 2: p,mbar)(-i 3,4: z,km)')
    parser.add_option('-p', '--proj',   action='store',dest='proj',      type="string",  default=None,  help='projection')
    parser.add_option('-b', '--back',   action='store',dest='back',      type="string",  default=None,  help='background image (def: None)')
    parser.add_option('-t', '--target', action='store',dest='target',    type="string",  default=None,  help='destination folder')
    parser.add_option('-s', '--stride', action='store',dest='stride',    type="int",     default=3,     help='stride vectors (def=3)')
    parser.add_option('-v', '--var',    action='append',dest='var',      type="string",  default=None,  help='variable color-shaded (append)')
    parser.add_option('-n', '--num',    action='store',dest='numplot',   type="int",     default=None,  help='plot number (def=2)(<0: plot LT -*numplot*)')
    parser.add_option('-i', '--interp', action='store',dest='interp',    type="int",     default=None,  help='interpolation (2: p, 3: z-amr, 4:z-als)')
    parser.add_option('-c', '--color',  action='store',dest='colorb',    type="string",  default="def", help='change colormap (nobar: no colorbar)')
    parser.add_option('-x', '--no-vect',action='store_false',dest='winds',               default=True,  help='no wind vectors')
    parser.add_option('-m', '--min',    action='append',dest='vmin',     type="float",   default=None,  help='bounding minimum value (append)')    
    parser.add_option('-M', '--max',    action='append',dest='vmax',     type="float",   default=None,  help='bounding maximum value (append)') 
    parser.add_option('-T', '--tiled',  action='store_true',dest='tile',                 default=False, help='draw a tiled plot (no blank zone)')
    parser.add_option('-z', '--zoom',   action='store',dest='zoom',      type="float",   default=None,  help='zoom factor in %')
    parser.add_option('-N', '--no-api', action='store_true',dest='nocall',               default=False, help='do not recreate api file')
    parser.add_option('-d', '--display',action='store_false',dest='display',             default=True,  help='do not pop up created images')
    parser.add_option('-e', '--itstep', action='store',dest='itstep',    type="int",     default=None,  help='stride time (def=4)')
    parser.add_option('-H', '--hole',   action='store_true',dest='hole',                 default=False, help='holes above max and below min')
    parser.add_option('-S', '--save',   action='store',dest='save',      type="string",  default="gui", help='save mode (png,eps,svg,pdf or gui)(def=gui)')
    parser.add_option('-a', '--anomaly',action='store_true',dest='anomaly',              default=False, help='compute and plot relative anomaly in %')
    parser.add_option('-w', '--with',   action='store',dest='var2',      type="string",  default=None,  help='variable contoured')
    parser.add_option('--div',          action='store',dest='ndiv',      type="int",     default=10,    help='number of divisions in colorbar (def: 10)')
    parser.add_option('-F', '--first',  action='store',dest='first',     type="int",     default=1,     help='first subscript to plot (def: 1)')
    parser.add_option('--mult',         action='store',dest='mult',      type="float",   default=1.,    help='a multiplicative factor to plotted field')
    parser.add_option('--title',        action='store',dest='zetitle',   type="string",  default="fill",help='customize the whole title')
    #parser.add_option('-V', action='store', dest='comb',        type="float",   default=None,  help='a defined combination of variables')

    ############# T.N. changes
    #parser.add_option('-o','--operation',action='store',dest='operation',type="string",   default=None ,help='matrix of operations between files (for now see code, sorry)')
    parser.add_option('--lat',          action='append',dest='slat',type="string",   default=None, help='slices along latitude. One value, or two values separated by comas for averaging')
    parser.add_option('--lon',          action='append',dest='slon', type="string",   default=None, help='slices along longitude. One value, or two values separated by comas for averaging')
    parser.add_option('--vert',         action='append',dest='svert',type="string",   default=None, help='slices along vertical axis. One value, or two values separated by comas for averaging') # quelles coordonnees ?
    parser.add_option('--time',         action='append',dest='stime',type="string",   default=None, help='slices along time. One value, or two values separated by comas for averaging') # quelles coordonnees ?

    ############# A.C. changes
    parser.add_option('-O','--output',  action='store' ,dest='output',type="string",   default=None, help='Output file name')
    parser.add_option('--res',  action='store' ,dest='res',type="float",   default=200., help='Resolution for png outputs. --save png must be specified. (def=200.)')

    (opt,args) = parser.parse_args()
    if opt.namefile is None: 
        print "I want to eat one file at least ! Use winds.py -f name_of_my_file. Or type winds.py -h"
        exit()
    if opt.var is None and opt.anomaly is True:
        print "Cannot ask to compute anomaly if no variable is set"
        exit()
    print "Options:", opt

    listvar = '' 
    if opt.var is None:
        zerange = [-999999]
    else:
        zelen = len(opt.var)
        zerange = range(zelen)
        #if zelen == 1: listvar = opt.var[0] + ','
        #else         : 
        for jjj in zerange: listvar += opt.var[jjj] + ','
        listvar = listvar[0:len(listvar)-1]
        vmintab = adjust_length (opt.vmin, zelen)  
        vmaxtab = adjust_length (opt.vmax, zelen)

    print "namefile, length", opt.namefile, len(opt.namefile)

    zeslat  = readslices(opt.slat)
    zeslon  = readslices(opt.slon)
    zesvert = readslices(opt.svert)
    zestime = readslices(opt.stime)
    print "slat,zeslat", opt.slat, zeslat
    print "slon,zeslon", opt.slon, zeslon
    print "svert,zesvert", opt.svert, zesvert
    print "stime,zestime", opt.stime, zestime

    for i in range(len(opt.namefile)):

        zefile = opt.namefile[i]
        print zefile    
        #zelevel = opt.nvert   
        stralt = None
        [lschar,zehour,zehourin] = getlschar ( zefile )  ## getlschar from wrfout (or simply return "" if another file)
    
        inputnvert = separatenames(opt.nvert)
        if np.array(inputnvert).size == 1:
            zelevel = float(inputnvert[0])
            ze_interp_levels = [-9999.]
        else:
            zelevel = -99.
            ze_interp_levels = np.linspace(float(inputnvert[0]),float(inputnvert[1]),float(inputnvert[2]))
        print 'level: ', zelevel
        print 'interp_levels: ',ze_interp_levels

        #####################################################
        ### Call Fortran routines for vertical interpolations        
        if opt.interp is not None:
            if zelevel == 0. and opt.interp == 4:  zelevel = 0.010
            ### winds or no winds
            if opt.winds            :  zefields = 'uvmet'
            else                    :  zefields = ''
            ### var or no var
            #if opt.var is None      :  pass
            if zefields == ''       :  zefields = listvar 
            else                    :  zefields = zefields + "," + listvar 
            if opt.var2 is not None : zefields = zefields + "," + opt.var2  
            print zefields
            zefile = api_onelevel (  path_to_input   = '', \
                                     input_name      = zefile, \
                                     fields          = zefields, \
                                     interp_method   = opt.interp, \
                                     interp_level    = ze_interp_levels, \
                                     onelevel        = zelevel, \
                                     nocall          = opt.nocall )
            print zefile
            zelevel = 0 ## so that zelevel could play again the role of nvert

        if opt.var is None: zerange = [-999999]
        else:               zerange = range(zelen) 
        for jjj in zerange:
            if jjj == -999999: 
                argvar  = None
                zevmin = None
                zevmax = None
            else:
                argvar = opt.var[jjj]
                if vmintab[jjj] != -999999:  zevmin = vmintab[jjj]
                else:                        zevmin = None
                if vmaxtab[jjj] != -999999:  zevmax = vmaxtab[jjj] 
                else:                        zevmax = None
            #############
            ### Main call
            name = planetoplot (zefile,level=int(zelevel),vertmode=opt.interp,\
                proj=opt.proj,back=opt.back,target=opt.target,stride=opt.stride,var=argvar,\
                numplot=opt.numplot,colorb=opt.colorb,winds=opt.winds,\
                addchar=lschar,interv=[zehour,zehourin],vmin=zevmin,vmax=zevmax,\
                tile=opt.tile,zoom=opt.zoom,display=opt.display,\
                itstep=opt.itstep,hole=opt.hole,save=opt.save,\
                anomaly=opt.anomaly,var2=opt.var2,ndiv=opt.ndiv,first=opt.first,\
                mult=opt.mult,zetitle=opt.zetitle,\
                slon=zeslon,slat=zeslat,svert=zesvert,stime=zestime,\
                outputname=opt.output,resolution=opt.res)
        print 'Done: '+name
        system("rm -f to_be_erased")
  
    #########################################################
    ### Generate a .sh file with the used command saved in it
    command = ""
    for arg in sys.argv: command = command + arg + ' '
    f = open(name+'.sh', 'w')
    f.write(command)
