MODULE paleoclimate_mod
!=======================================================================
!   subject: Module dedicated to paleoclimates studies
!   --------
!
!   author: LL, 06/2023
!   ------
!
!=======================================================================

implicit none

logical :: paleoclimate ! False by default, is activate  for paleoclimates specific processes (e.g., lag layer) is initialized in conf_phys

!$OMP THREADPRIVATE(paleoclimate)
    real,    allocatable, dimension(:,:) :: h2o_ice_depth         ! Thickness of the lag before H2O ice [m]
    real,    allocatable, dimension(:,:) :: lag_co2_ice           ! Thickness of the lag before CO2 ice [m]
    real,    allocatable, dimension(:,:) :: d_coef                ! Diffusion coefficent
    real, dimension(2)                   :: albedo_perennialco2   ! Albedo for perennial co2 ice [1]
    logical                              :: lag_layer             ! Does lag layer is present?
    logical                              :: include_waterbuoyancy ! Include the effect of water buoyancy when computing the sublimation of water ice ?
!$OMP THREADPRIVATE(h2o_ice_depth,lag_co2_ice,d_coef,albedo_perennialco2,lag_layer,include_waterbuoyancy)

!=======================================================================
contains
!=======================================================================

SUBROUTINE ini_paleoclimate_h(ngrid,nslope)

implicit none

integer, intent(in) :: ngrid  ! number of atmospheric columns
integer, intent(in) :: nslope ! number of slope within a mesh

allocate(h2o_ice_depth(ngrid,nslope))
allocate(lag_co2_ice(ngrid,nslope))
allocate(d_coef(ngrid,nslope))

END SUBROUTINE ini_paleoclimate_h

!=======================================================================
SUBROUTINE end_paleoclimate_h

implicit none

if (allocated(d_coef)) deallocate(d_coef)
if (allocated(h2o_ice_depth)) deallocate(h2o_ice_depth)
if (allocated(lag_co2_ice)) deallocate(lag_co2_ice)

END SUBROUTINE end_paleoclimate_h

END MODULE paleoclimate_mod
