#!/bin/bash
#######################################################################
### Script to modify the value of a variable in a file "startfi.nc" ###
#######################################################################
set -e
trap 'echo -e "\033[31mError: an issue occurred in the script on line $LINENO! Please review the command and try again.\033[0m"' ERR

#######################################################################
# Modify here the parameters for the script
###########################################
# Name of the file
name_file="startfi.nc"

# Name of the variable to be modified
var_name="co2"

# New value for the variable
new_var=8.
#######################################################################


# Update the netCDF file
ncap2 -O -s "$var_name=$new_var" \
         $name_file $name_file

echo "In \"$name_file\":"
echo "New $var_name = $new_var"
echo "Done!"
