## Script to initialize the git repository and link it to the svn.
## The synchronization requires two pushes
## (1st push=svn dcommit, 2nd push=git push)
## WARNING: we assume the svn and the git are up-to-date
## https://lmdz-forge.lmd.jussieu.fr/mediawiki/Planets/index.php/Git-svn

SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
cd ${SCRIPT_DIR}/..

echo "WARNING: this script will setup the git repository."
echo "It will connect the git to the svn (git svn init) and"
echo "install a hook to ensure the synchronization between the two."
echo "The hook (UTIL/pre-push) will be called at each git push."
# echo "or download it in the git-trunk/ folder (and link with git-svn)."

# while true; do
#     read -p "Do you wish to continue? [Y/n] " yn
#     case $yn in
#         [Yy]* ) break;;
#         [Nn]* ) exit;;
#         * ) break;;
#     esac
# done

# URL=git@gitlab.in2p3.fr:la-communaut-des-mod-les-atmosph-riques-plan-taires/git-trunk.git
# LOCAL_URL=`git remote get-url origin 2>/dev/null`
# if [ "${LOCAL_URL}" !=  "${URL}" ];then
#     git clone ${URL}
#     cd git-trunk
# fi

### link svn to git as git-svn branch
### (need git-svn to work)
git svn init https://svn.lmd.jussieu.fr/Planeto/trunk

git update-ref refs/remotes/git-svn refs/remotes/origin/master
# git svn rebase # not used (we assume we're up-to-date)

### install pre-push hook to ensure
### users push only commits in sync with svn

# save users hooks just in case
echo "Saving old hooks in .git/hooks/save ..."
mkdir -p .git/hooks
if [ -d .git/hooks ];then
    mkdir -p .git/hooks/save
    mv .git/hooks/p* .git/hooks/save
fi
echo "Copying lmdz hooks in .git/hooks ..."
cd .git/hooks
for hook in ../../UTIL/hooks/*; do
    file=$(basename $hook)
    echo $file
    ln -s $hook $file
done

