# Script to interpolate a temperature profile (profile.in) from altitudes
# defined in z2sig.def.in on a new altitude grid (z2sig.def)

import numpy as np
import pandas as pd

temperature_in = pd.read_csv("profile.in", header=None).iloc[:,0]
print(len(temperature_in), temperature_in[0])
z2sig_in = pd.read_csv("z2sig.def.in", names=range(40), header=None, skiprows=1, delimiter=" ").iloc[:,0]
print(len(z2sig_in), z2sig_in[0])
z2sig_out = pd.read_csv("z2sig.def", names=range(40), header=None, skiprows=1, delimiter=" ").iloc[:,0]
print(len(z2sig_out), z2sig_out[0])

#add surface
z2sig_in = np.insert(z2sig_in,0,0)
z2sig_out = np.insert(z2sig_out,0,0)

temperature_out = np.interp(z2sig_out, z2sig_in, temperature_in)
np.savetxt("profile", temperature_out, fmt="%f")