MODULE restart1D_mod

    implicit none
        
    contains
        
        SUBROUTINE writerestart1D(filename,nlayer,nsoil,day,time,psurf,temp,tsoil,u,v,nq,q)
        
        use netcdf, only: NF90_CREATE, NF90_NOERR, NF90_NOWRITE, &
                          NF90_UNLIMITED, NF90_DEF_DIM, NF90_PUT_ATT, &
                          NF90_PUT_VAR, NF90_GLOBAL, NF90_ENDDEF, NF90_CLOSE
        use tracer_h, only: noms
        use iostart, only: create_restartphy, close_restartphy, put_var, put_field, length
    
        implicit none
        
        ! Arguments
        character(len = *),                intent(in) :: filename
        integer,                           intent(in) :: nlayer,nq,nsoil
        real,                              intent(in) :: psurf,day,time
        real, dimension(nlayer),           intent(in) :: temp,tsoil,u,v
        real, dimension(nlayer,nq),        intent(in) :: q
        
        ! Local variables
        integer :: i, j, il, iq
        INTEGER :: ierr
        INTEGER :: nid_restart1D,indexid,lonid,latid,nlayerid,nsoilid,Timeid
        INTEGER :: psid,uid,vid,tempid,daystartid,timestartid,tsoilid
        real, dimension(1,nlayer,nq) :: q_table
        real, dimension(1,nlayer) ::    temp_table,u_table,v_table
        real, dimension(length)   :: controle_1D
    
        ! File creation ...................
        call create_restartphy('restart1D.nc',nid_restart1D)
    
        ! Write state variables ...................
        controle_1D(:) = 0.
        controle_1D(1)  = psurf
        controle_1D(2)  = day
        controle_1D(3)  = time
        call put_var(nid_restart1D,'controle','psurf day and time',controle_1D)
        do iq = 1,nq
          q_table(1,:,iq) = q(:,iq)
          call put_field(nid_restart1D,noms(iq),'Tracer mmr',q_table(:,:,iq))
        enddo ! iq = 1,nq
        u_table(1,:) = u(:)
        call put_field(nid_restart1D,'u','Zonal wind',u_table)
        v_table(1,:) = v(:)
        call put_field(nid_restart1D,'v','Meridional wind',v_table)
        temp_table(1,:) = temp(:)
        call put_field(nid_restart1D,'temp','Temperature',temp_table)

        ! Finish ...................
        call close_restartphy(nid_restart1D)
        
        END SUBROUTINE writerestart1D
        
      END MODULE restart1D_mod
        