/*
 * Copyright (c) Jeremie Burgalat (2013-2022)
 * Contributor: Jeremie Burgalat (jeremie.burgalat@univ-reims.fr).
 *
 * This file is part of SWIFT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

 /**
  * @file swift_defined.h
  * @brief CPP macro definitions files
  * @details This header defines few CPP symbols and macros that are used
  * in the library source code.
  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/** @def ASSIGN_DTSTR(in,out)
 *  Performs string assignment
 *
 *  This macro definition depends on compiler's support for allocatable string
 *  in derived type:
 *    - If it actually supports this feature, the macro defines an allocation
 *      statement.
 *    - Otherwise it defines a simple assignment statement.
 */
#if ! HAVE_FTNDTSTR
#define ASSIGN_DTSTR(in,out) out = in
#else
#define ASSIGN_DTSTR(in,out) ALLOCATE(out,source=in)
#endif

/** @def OBJECT(name)
 *  Derived type declaration
 *
 *  This macro definition depends on compiler's support for Bounded procedures
 *  in derived type (more precisely, Fortran 2003 PROCEDURE keyword support):
 *    - If it actually supports this feature, the macro defines derived type
 *      declaration as dummy argument of subroutine/function using CLASS keyword.
 *    - Otherwise, derived type dummy argument are declared using TYPE keyword.
 */
#if ! HAVE_FTNPROC
#define OBJECT(name) TYPE(name)
#else
#define OBJECT(name) CLASS(name)
#endif

/* Defines SSLEN if needed */
#ifndef SSLEN
#define SSLEN 250
#endif

/* Defines SLLEN if needed */
#ifndef SLLEN
#define SLLEN 2500
#endif