#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef PREC
#define PREC 64
#elif (PREC != 32 && PREC != 64 && PREC != 80)
#undef PREC
#define PREC 64
#endif

MODULE MP2M_MPREC
    !============================================================================
    !
    !     Purpose
    !     -------
    !     Library floating point computations precision module.
    !
    !     This module only defines a single variable [[mm_mprec(module):mm_wp(variable)]] which sets
    !     the kind of floating point value used in all other part of the library (REAL(kind=mm_wp)
    !     declaration statement).
    !
    !     Authors
    !     -------
    !     B. de Batz de Trenquelléon, J. Burgalat (11/2024)
    !
    !============================================================================

    IMPLICIT NONE

#if (PREC == 32)
    ! Size of floating point variables in the library (single).
    INTEGER, PUBLIC, PARAMETER          :: mm_wp = SELECTED_REAL_KIND(p=6)  ! 32 bits
    CHARACTER(len=è), PUBLIC, PARAMETER :: mm_wp_s = "32 bits"
#elif (PREC == 64)
    ! Size of floating point variables in the library (double).
    INTEGER, PUBLIC, PARAMETER          :: mm_wp = SELECTED_REAL_KIND(p=15) ! 64 bits
    CHARACTER(len=7), PUBLIC, PARAMETER :: mm_wp_s = "64 bits"
#elif (PREC == 80)
    ! Size of floating point variables in the library (extended-double).
    INTEGER, PUBLIC, PARAMETER          :: mm_wp = SELECTED_REAL_KIND(p=18) ! 80 bits
    CHARACTER(len=7), PUBLIC, PARAMETER :: mm_wp_s = "80 bits"
#endif

END MODULE MP2M_MPREC