!-----------------------------------------------------------------------
      module datafile_mod
!  Address of the directory containing tables of data needed by the GCM
      implicit none

      ! Main directory: 'datadir':
      ! Default for Berserker @ UChicago:
!      character(len=300) :: datadir='/home/rwordsworth/datagcm'
      ! Default for Gnome Idataplex:
!      character(len=300) :: datadir='/san/home/rdword/gcm/datagcm'
      ! Default for LMD machines:
      character(len=300),save :: datadir='datagcm'
!$OMP THREADPRIVATE(datadir)

      ! Subdirectories of 'datadir':

      ! Default directory for microphysics
      ! Set in inifis_mod
      character(LEN=100),save :: config_mufi ='datagcm/microphysics/config.cfg'
!$OMP THREADPRIVATE(config_mufi)

      ! surfdir stores planetary topography, albedo, etc. (surface.nc files)
      character(len=12),parameter :: surfdir="surface_data"

      ! aerdir stores aerosol properties files (optprop_*dat files)
      character(LEN=18),parameter :: aerdir="aerosol_properties"

      ! Data haze properties
      character(len=300),save :: hazeprop_file
      character(len=300),save :: hazerad_file
      character(len=300),save :: hazemmr_file
      character(len=300),save :: hazedens_file

      end module datafile_mod
!-----------------------------------------------------------------------
